# Radiotherapy Device Type - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Radiotherapy Device Type**

## ValueSet: Radiotherapy Device Type 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-radiotherapyDeviceType-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:RadiotherapyDeviceType |

 
Radiotherapy device type this procedure is referring to 

 **References** 

* [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 7 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-radiotherapyDeviceType-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-radiotherapyDeviceType-eu-pcsp",
  "version" : "1.0.0",
  "name" : "RadiotherapyDeviceType",
  "title" : "Radiotherapy Device Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Radiotherapy device type this procedure is referring to",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
        "concept" : [
          {
            "code" : "orthovoltage",
            "display" : "Orthovoltage"
          },
          {
            "code" : "linac-mv",
            "display" : "Linac MV"
          },
          {
            "code" : "linac-el",
            "display" : "Linac electrons"
          },
          {
            "code" : "cobalt",
            "display" : "Cobalt MV"
          },
          {
            "code" : "proton-beam",
            "display" : "Proton Beam"
          }
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-unknownOther-eu-pcsp"
        ]
      }
    ]
  }
}

```
