# Affected Organs (surgery) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Affected Organs (surgery)**

## ValueSet: Affected Organs (surgery) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-affectedOrgan-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:AffectedOrganVs |

 
Affected Organs (surgery) 

 **References** 

* [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* [Not affected Organ](StructureDefinition-procedure-notAffectedOrgan.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 12 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-affectedOrgan-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-affectedOrgan-eu-pcsp",
  "version" : "1.0.0",
  "name" : "AffectedOrganVs",
  "title" : "Affected Organs (surgery)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Affected Organs (surgery)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "32849002",
            "display" : "Oesophagus"
          },
          {
            "code" : "818983003",
            "display" : "Abdomen"
          },
          {
            "code" : "12738006",
            "display" : "Brain"
          },
          {
            "code" : "89545001",
            "display" : "Face"
          },
          {
            "code" : "10200004",
            "display" : "Liver"
          },
          {
            "code" : "421060004",
            "display" : "Spine"
          },
          {
            "code" : "2748008",
            "display" : "Spinal Cord"
          },
          {
            "code" : "90456006",
            "display" : "Sympathetic nerve"
          },
          {
            "code" : "51185008",
            "display" : "Thoracic structure"
          },
          {
            "code" : "12921003",
            "display" : "Pelvis"
          }
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-unknownOther-eu-pcsp"
        ]
      }
    ]
  }
}

```
