# Laterality Qualifier Value Set - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laterality Qualifier Value Set**

## ValueSet: Laterality Qualifier Value Set 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/laterality-qualifier-lrub-vs | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:LeftRightBiUnilateralVS |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Qualifiers to specify laterality. 

 **References** 

* [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)
* [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 6 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "laterality-qualifier-lrub-vs",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/laterality-qualifier-lrub-vs",
  "version" : "1.0.0",
  "name" : "LeftRightBiUnilateralVS",
  "title" : "Laterality Qualifier Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Qualifiers to specify laterality.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "51440002",
            "display" : "Bilateral"
          },
          {
            "code" : "66459002",
            "display" : "Unilateral"
          },
          {
            "code" : "24028007",
            "display" : "Right"
          },
          {
            "code" : "7771000",
            "display" : "Left"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "unknown",
            "display" : "Unknown"
          },
          {
            "code" : "not-applicable",
            "display" : "Not Applicable"
          }
        ]
      }
    ]
  }
}

```
