# Resource related information - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Resource related information**

## Extension: Resource related information 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ResourceRelatedInfo |

This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md), [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md) and [Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md)
* Examples for this Extension: [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [MedicationAdministration/ChemoHulafe-1-Ciclofosfamide](MedicationAdministration-ChemoHulafe-1-Ciclofosfamide.md), [MedicationAdministration/ChemoHulafe-1-Citarabina](MedicationAdministration-ChemoHulafe-1-Citarabina.md), [MedicationAdministration/ChemoHulafe-1-Metotrexato](MedicationAdministration-ChemoHulafe-1-Metotrexato.md)...Show 2 more,[MedicationAdministration/ChemoHulafe-1-Vincristina](MedicationAdministration-ChemoHulafe-1-Vincristina.md)and[Procedure/ProcedureRadio-1](Procedure-ProcedureRadio-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/resource-relatedInfo)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-resource-relatedInfo.csv), [Excel](StructureDefinition-resource-relatedInfo.xlsx), [Schematron](StructureDefinition-resource-relatedInfo.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "resource-relatedInfo",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo",
  "version" : "1.0.0",
  "name" : "ResourceRelatedInfo",
  "title" : "Resource related information",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Resource related information",
        "definition" : "This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/resource-relatedInfo"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      }
    ]
  }
}

```
