# Randomization arm for trial - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Randomization arm for trial**

## Extension: Randomization arm for trial 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:FltArm |

This extension is used to provide a textual description of the randomization arm for trials (FLT).

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PlanDefinition: Front Line Treatment](StructureDefinition-PlanDefinition-flt-eu-pcsp.md)
* Examples for this Extension: [PlanDefinition/3976](PlanDefinition-3976.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/procedure-fltArm)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-procedure-fltArm.csv), [Excel](StructureDefinition-procedure-fltArm.xlsx), [Schematron](StructureDefinition-procedure-fltArm.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "procedure-fltArm",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm",
  "version" : "1.0.0",
  "name" : "FltArm",
  "title" : "Randomization arm for trial",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This extension is used to provide a textual description of the randomization arm for trials (FLT).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "PlanDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Randomization arm for trial",
        "definition" : "This extension is used to provide a textual description of the randomization arm for trials (FLT)."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
