# Observation: Cancer Stage Group - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation: Cancer Stage Group**

## Resource Profile: Observation: Cancer Stage Group 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-cancer-stage-group | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CancerStageGroup |

 
The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/mcode-cancer-stage-group)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-mcode-cancer-stage-group.csv), [Excel](StructureDefinition-mcode-cancer-stage-group.xlsx), [Schematron](StructureDefinition-mcode-cancer-stage-group.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "mcode-cancer-stage-group",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-cancer-stage-group",
  "version" : "1.0.0",
  "name" : "CancerStageGroup",
  "title" : "Observation: Cancer Stage Group",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/mcode-observation-codes-stage-group-vs"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/mcode-cancer-stage-group-vs"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/mcode-cancer-staging-system-vs"
        }
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this.resolve().code"
            }
          ],
          "description" : "Slicing based on referenced resource code attribute.",
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Observation"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.hasMember:tnmPrimaryTumorCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmPrimaryTumorCategory",
        "short" : "TNM Primary Tumor Category",
        "definition" : "Category of the primary tumor, based on its size and extent, and based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-tnm-primary-tumor-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.hasMember:tnmRegionalNodesCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmRegionalNodesCategory",
        "short" : "TNM  Regional Nodes Category",
        "definition" : "Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-tnm-regional-nodes-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.hasMember:tnmDistantMetastasesCategory",
        "path" : "Observation.hasMember",
        "sliceName" : "tnmDistantMetastasesCategory",
        "short" : "TNM  Distant Metastases Category",
        "definition" : "Category describing the presence or absence of metastases in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy.",
        "comment" : "When using this element, the Observation must validate against the specified profile.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-tnm-distant-metastases-category"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      }
    ]
  }
}

```
