# SurPass V2.0 - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SurPass V2.0**

## Logical Model: SurPass V2.0 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/SurPass | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SurPass |

 
Survivorship Passport V2.0 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/SurPass)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SurPass.csv), [Excel](StructureDefinition-SurPass.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SurPass",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/SurPass",
  "version" : "1.0.0",
  "name" : "SurPass",
  "title" : "SurPass V2.0",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Survivorship Passport V2.0",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "SurPass model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/SurPass",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SurPass",
        "path" : "SurPass",
        "short" : "SurPass V2.0",
        "definition" : "Survivorship Passport V2.0",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Bundle.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "SurPass.treatmentSummary",
        "path" : "SurPass.treatmentSummary",
        "short" : "Treatment Summary",
        "definition" : "Treatment Summary",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/TreatmentSummary"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Bundle.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "SurPass.carePlan",
        "path" : "SurPass.carePlan",
        "short" : "Care plan",
        "definition" : "Reccomandation for follow up",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanOfCare"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "CarePlan.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp')"
          }
        ]
      }
    ]
  }
}

```
