# Subject of care - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subject of care**

## Logical Model: Subject of care 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Subject | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:Subject |

 
Subject of care 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Subject)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Subject.csv), [Excel](StructureDefinition-Subject.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Subject",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Subject",
  "version" : "1.0.0",
  "name" : "Subject",
  "title" : "Subject of care",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Subject of care",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Subject model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Subject",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Subject",
        "path" : "Subject",
        "short" : "Subject of care",
        "definition" : "Subject of care",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "Subject.identifier",
        "path" : "Subject.identifier",
        "short" : "ID",
        "definition" : "ID",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "Subject.name",
        "path" : "Subject.name",
        "short" : "Subject Name",
        "definition" : "Subject Name",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name"
          }
        ]
      },
      {
        "id" : "Subject.name.lastname",
        "path" : "Subject.name.lastname",
        "short" : "Lastname",
        "definition" : "Lastname",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.given"
          }
        ]
      },
      {
        "id" : "Subject.name.middleName",
        "path" : "Subject.name.middleName",
        "short" : "Middlename",
        "definition" : "Middlename",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.given"
          }
        ]
      },
      {
        "id" : "Subject.name.firstName",
        "path" : "Subject.name.firstName",
        "short" : "Firstname",
        "definition" : "Firstname",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.family"
          }
        ]
      },
      {
        "id" : "Subject.lastnameAtDiagnosis",
        "path" : "Subject.lastnameAtDiagnosis",
        "short" : "Lastname at diagnosis (if different from the actual one)",
        "definition" : "Lastname at diagnosis (if different from the actual one)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.family"
          }
        ]
      },
      {
        "id" : "Subject.gender",
        "path" : "Subject.gender",
        "short" : "Gender/Sex",
        "definition" : "Gender/Sex",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "Subject.dateOfBirth",
        "path" : "Subject.dateOfBirth",
        "short" : "Date of birth",
        "definition" : "Date of birth",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "Subject.placeOfBirth",
        "path" : "Subject.placeOfBirth",
        "short" : "Place of birth",
        "definition" : "Place of birth",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.extension(http://hl7.org/fhir/StructureDefinition/patient-birthPlace')"
          }
        ]
      },
      {
        "id" : "Subject.contact",
        "path" : "Subject.contact",
        "short" : "Contact - receiver of the passport",
        "definition" : "Contact - receiver of the passport",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.contact (if not the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "Patient.telecom (if the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "DocumentManifest.recipient (if intended recipient)"
          }
        ]
      },
      {
        "id" : "Subject.contact.email",
        "path" : "Subject.contact.email",
        "short" : "E-mail",
        "definition" : "E-mail",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.contact.telecom (if not the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "Patient.telecom (if the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "DocumentManifest.recipient.resolve().telecom (if intended recipient)"
          }
        ]
      },
      {
        "id" : "Subject.contact.mobile",
        "path" : "Subject.contact.mobile",
        "short" : "Mobile phone",
        "definition" : "Mobile phone",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.contact.telecom (if not the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "Patient.telecom (if the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "DocumentManifest.recipient.resolve().telecom (if intended recipient)"
          }
        ]
      },
      {
        "id" : "Subject.contact.relationship",
        "path" : "Subject.contact.relationship",
        "short" : "Relationship with the subject",
        "definition" : "Relationship with the subject",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.contact.relationship (if not the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "N/A (if the patient)"
          },
          {
            "identity" : "fhir",
            "map" : "DocumentManifest.recipient.resolve().relationship (if intended recipient - not patient)"
          }
        ]
      }
    ]
  }
}

```
