# Care Plan - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Plan**

## Logical Model: Care Plan 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanOfCare | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PlanOfCare |

 
Care Plan 

**Usages:**

* Use this Logical Model: [SurPass V2.0](StructureDefinition-SurPass.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/PlanOfCare)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PlanOfCare.csv), [Excel](StructureDefinition-PlanOfCare.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlanOfCare",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanOfCare",
  "version" : "1.0.0",
  "name" : "PlanOfCare",
  "title" : "Care Plan",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Care Plan",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "PlanOfCare model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanOfCare",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PlanOfCare",
        "path" : "PlanOfCare",
        "short" : "Care Plan",
        "definition" : "Care Plan",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "CarePlan.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "PlanOfCare.identifier",
        "path" : "PlanOfCare.identifier",
        "short" : "Care plan Identifier",
        "definition" : "Care plan business identifier",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "PlanOfCare.addressedProblem",
        "path" : "PlanOfCare.addressedProblem",
        "short" : "Problems addressed by this plan",
        "definition" : "Problems (e.g. primary cancer) addressed by this plan",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".addresses"
          }
        ]
      },
      {
        "id" : "PlanOfCare.author",
        "path" : "PlanOfCare.author",
        "short" : "Author",
        "definition" : "Author",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".author"
          }
        ]
      },
      {
        "id" : "PlanOfCare.creationTime",
        "path" : "PlanOfCare.creationTime",
        "short" : "Date the plan was created",
        "definition" : "Date the plan was created",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".created"
          }
        ]
      },
      {
        "id" : "PlanOfCare.note",
        "path" : "PlanOfCare.note",
        "short" : "Plan note",
        "definition" : "Plan note",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".note.where(extension(' http://hl7.eu/fhir/ig/pcsp/StructureDefinition/annotation-type').valueCodeableConcept=CsGenericPcsp#nar-planNotes)"
          }
        ]
      },
      {
        "id" : "PlanOfCare.chronicConditions",
        "path" : "PlanOfCare.chronicConditions",
        "short" : "Chronic condition",
        "definition" : "Chronic condition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".note.where(extension(' http://hl7.eu/fhir/ig/pcsp/StructureDefinition/annotation-type').valueCodeableConcept=CsGenericPcsp#nar-chronicCond)"
          }
        ]
      },
      {
        "id" : "PlanOfCare.reccomandation",
        "path" : "PlanOfCare.reccomandation",
        "short" : "Reccomandation",
        "definition" : "Reccomandation",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".activity.detail"
          }
        ]
      },
      {
        "id" : "PlanOfCare.reccomandation.riskFactor",
        "path" : "PlanOfCare.reccomandation.riskFactor",
        "short" : "Risk factors",
        "definition" : "Risk factors considered for generating this care plan",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".activity.detail.reasonReference"
          }
        ]
      },
      {
        "id" : "PlanOfCare.reccomandation.conditionAtRisk",
        "path" : "PlanOfCare.reccomandation.conditionAtRisk",
        "short" : "Conditions at risk",
        "definition" : "Conditions at risk",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "activity.detail.reasonCode"
          }
        ]
      },
      {
        "id" : "PlanOfCare.reccomandation.reccomandation",
        "path" : "PlanOfCare.reccomandation.reccomandation",
        "short" : "Suggested reccomandation",
        "definition" : "Reccomandation suggested by the algorithm",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "activity.detail.code"
          }
        ]
      },
      {
        "id" : "PlanOfCare.reccomandation.note",
        "path" : "PlanOfCare.reccomandation.note",
        "short" : "Note",
        "definition" : "Note",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "activity.detail.description"
          }
        ]
      }
    ]
  }
}

```
