# PlanDefinition: Front Line Treatment - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlanDefinition: Front Line Treatment**

## Resource Profile: PlanDefinition: Front Line Treatment 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PlanDefinitionFltPcsp |

 
This profile defines how to provide Front Line Treatment protocol infos in FHIR for the scope of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md)
* Examples for this Profile: [PlanDefinition/3976](PlanDefinition-3976.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/PlanDefinition-flt-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PlanDefinition-flt-eu-pcsp.csv), [Excel](StructureDefinition-PlanDefinition-flt-eu-pcsp.xlsx), [Schematron](StructureDefinition-PlanDefinition-flt-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlanDefinition-flt-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp",
  "version" : "1.0.0",
  "name" : "PlanDefinitionFltPcsp",
  "title" : "PlanDefinition: Front Line Treatment",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to provide Front Line Treatment protocol infos in FHIR for the scope of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PlanDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PlanDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PlanDefinition.extension",
        "path" : "PlanDefinition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "PlanDefinition.extension:fltArm",
        "path" : "PlanDefinition.extension",
        "sliceName" : "fltArm",
        "short" : "Randomization arm description",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm"
            ]
          }
        ]
      },
      {
        "id" : "PlanDefinition.name",
        "path" : "PlanDefinition.name",
        "short" : "Name for this FLT plan (computer friendly)"
      },
      {
        "id" : "PlanDefinition.title",
        "path" : "PlanDefinition.title",
        "short" : "Name for this FLT plan (human friendly)"
      },
      {
        "id" : "PlanDefinition.type",
        "path" : "PlanDefinition.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-flt-plan-type-eu-pcsp"
        }
      },
      {
        "id" : "PlanDefinition.description",
        "path" : "PlanDefinition.description",
        "short" : "description of the FLT plan"
      }
    ]
  }
}

```
