# Patient: PCSP - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient: PCSP**

## Resource Profile: Patient: PCSP 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:PatientPcsp |

 
This profile defines how to represent Patient in FHIR for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md), [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md), [Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md), [Condition: Others](StructureDefinition-Condition-otherinfos-eu-pcsp.md)...Show 26 more,[Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[Condition: Severe Toxicity](StructureDefinition-Condition-toxicity-eu-pcsp.md),[DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md),[MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md),[Observation: Blood type/RH](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md),[Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md),[Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md),[Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md),[Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md),[Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md),[Procedure: Cryopreservation](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md),[Procedure: Catheter](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md),[Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md),[Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md),[Procedure: SCT Prophylaxis](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md),[Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md),[Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md),[Procedure: Other Treatments](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.md),[Observation: Cancer Stage Group](StructureDefinition-mcode-cancer-stage-group.md),[Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md),[Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)
* Examples for this Profile: [Patient/PatientCineca](Patient-PatientCineca.md), [Patient/PatientHulafe-1](Patient-PatientHulafe-1.md), [Patient/PatientHulafe](Patient-PatientHulafe.md), [Patient/PatientMainzFischer](Patient-PatientMainzFischer.md)...Show 2 more,[Patient/PatientMainzZeisig](Patient-PatientMainzZeisig.md)and[Patient/PatientVulsk](Patient-PatientVulsk.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Patient-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-eu-pcsp.csv), [Excel](StructureDefinition-Patient-eu-pcsp.xlsx), [Schematron](StructureDefinition-Patient-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp",
  "version" : "1.0.0",
  "name" : "PatientPcsp",
  "title" : "Patient: PCSP",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Patient in FHIR for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Information about an individual receiving health care services",
        "definition" : "Information about an individual receiving health care services"
      },
      {
        "id" : "Patient.extension:patient-birthPlace",
        "path" : "Patient.extension",
        "sliceName" : "patient-birthPlace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-birthPlace|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:patient-mothersMaidenName",
        "path" : "Patient.extension",
        "sliceName" : "patient-mothersMaidenName",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "min" : 1
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "min" : 1
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "min" : 1
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "min" : 1
      },
      {
        "id" : "Patient.gender.extension",
        "path" : "Patient.gender.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.gender.extension:originalText",
        "path" : "Patient.gender.extension",
        "sliceName" : "originalText",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/originalText|5.2.0"]
          }
        ]
      },
      {
        "id" : "Patient.contact.telecom",
        "path" : "Patient.contact.telecom",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "description" : "Slice based on the reference type",
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.generalPractitioner:primaryTreatmentCenter",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "primaryTreatmentCenter",
        "short" : "Primary treatment center",
        "definition" : "Report here the institution in which most of the treatment was given",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner:primaryTreatmentCenter.identifier",
        "path" : "Patient.generalPractitioner.identifier",
        "short" : "Business identifier of the Primary treatment center"
      },
      {
        "id" : "Patient.generalPractitioner:primaryTreatmentCenter.display",
        "path" : "Patient.generalPractitioner.display",
        "short" : "Short textual description of the Primary treatment center"
      }
    ]
  }
}

```
