# Observation: Risk Factor - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation: Risk Factor**

## Resource Profile: Observation: Risk Factor 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ObservationRiskFactor |

 
This profile defines how to represent a Risk Factor in HL7 FHIR as determined by the PCSP platoform. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md)
* Examples for this Profile: [Observation/ObservationRiskFactor-1](Observation-ObservationRiskFactor-1.md), [Observation/ObservationRiskFactor-2](Observation-ObservationRiskFactor-2.md), [Observation/ObservationRiskFactor-3](Observation-ObservationRiskFactor-3.md) and [Observation/ObservationRiskFactor-4](Observation-ObservationRiskFactor-4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Observation-riskfactor-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-riskfactor-eu-pcsp.csv), [Excel](StructureDefinition-Observation-riskfactor-eu-pcsp.xlsx), [Schematron](StructureDefinition-Observation-riskfactor-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-riskfactor-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ObservationRiskFactor",
  "title" : "Observation: Risk Factor",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent a Risk Factor in HL7 FHIR as determined by the PCSP platoform.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "max" : "0"
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "max" : "0"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "patternCode" : "final"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "80943009",
              "display" : "Risk factor"
            }
          ]
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "max" : "0"
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.effective[x]:effectivePeriod",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectivePeriod",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.effective[x]:effectivePeriod.start",
        "path" : "Observation.effective[x].start",
        "min" : 1
      },
      {
        "id" : "Observation.effective[x]:effectivePeriod.end",
        "path" : "Observation.effective[x].end",
        "short" : "required if no more active"
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-riskfactor-eu-pcsp"
        }
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "max" : "0"
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "max" : "0"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "max" : "0"
      }
    ]
  }
}

```
