# Major Surgery - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Major Surgery**

## Logical Model: Major Surgery 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MajorSurgery | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:MajorSurgery |

 
Major Surgery. 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/MajorSurgery)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MajorSurgery.csv), [Excel](StructureDefinition-MajorSurgery.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MajorSurgery",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MajorSurgery",
  "version" : "1.0.0",
  "name" : "MajorSurgery",
  "title" : "Major Surgery",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Major Surgery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "MajorSurgery model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MajorSurgery",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MajorSurgery",
        "path" : "MajorSurgery",
        "short" : "Major Surgery",
        "definition" : "Major Surgery.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "MajorSurgery.relatedDiagnosis",
        "path" : "MajorSurgery.relatedDiagnosis",
        "short" : "Progressive number of diagnosis",
        "definition" : "Progressive number of diagnosis (1=first; 2= second; 3 = third; ?).  \nIn this field must be reported the ordinal number of the tumor diagnosis for which the surgery was performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "MajorSurgery.relatedRelapse",
        "path" : "MajorSurgery.relatedRelapse",
        "short" : "Progressive number of relapse/progression (after FLT)",
        "definition" : "Progressive number of relapse/progression (after FLT)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".reasonReference"
          }
        ]
      },
      {
        "id" : "MajorSurgery.identifier",
        "path" : "MajorSurgery.identifier",
        "short" : "Progressive Surgery number",
        "definition" : "Progressive number of surgeries (1=first; 2= second; 3 = third; ?).\nIn this field must be reported the ordinal number of the surgeries given. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment",
        "path" : "MajorSurgery.istitutionOfTreatment",
        "short" : "Institution of treatment",
        "definition" : "Please Identify the institution were surgery was performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "location.resolve().conformsTo(http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp)"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment.description",
        "path" : "MajorSurgery.istitutionOfTreatment.description",
        "short" : "Institution description",
        "definition" : "Institution description",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.description"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment.name",
        "path" : "MajorSurgery.istitutionOfTreatment.name",
        "short" : "Institution name",
        "definition" : "Institution name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.name"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment.address",
        "path" : "MajorSurgery.istitutionOfTreatment.address",
        "short" : "Institution address",
        "definition" : "Institution address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.city"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment.address.name",
        "path" : "MajorSurgery.istitutionOfTreatment.address.name",
        "short" : "Institution city",
        "definition" : "Institution city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "MajorSurgery.istitutionOfTreatment.address.country",
        "path" : "MajorSurgery.istitutionOfTreatment.address.country",
        "short" : "Institution country",
        "definition" : "Institution country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Location.address.country"
          }
        ]
      },
      {
        "id" : "MajorSurgery.date",
        "path" : "MajorSurgery.date",
        "short" : "Date of surgery",
        "definition" : "Date of surgery (dd/mm/yyyy). If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.performedDateTime"
          }
        ]
      },
      {
        "id" : "MajorSurgery.description",
        "path" : "MajorSurgery.description",
        "short" : "Surgery description",
        "definition" : "Please describe the type of surgery (is a free text section, no coding). In case of surgery on pair organs specify which organ (right or left) was operated.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".text"
          }
        ]
      },
      {
        "id" : "MajorSurgery.affectedOrgan",
        "path" : "MajorSurgery.affectedOrgan",
        "short" : "Affected Organs",
        "definition" : "Was one of these organs involved ? \n(Oesophagus; Abdomen; Brain; Face; Liver; Spine; Spinal Cord; Sympathetic nerves; Chest/thorax; Pelvis)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          },
          {
            "identity" : "fhir",
            "map" : ".code"
          }
        ]
      },
      {
        "id" : "MajorSurgery.sacrifiedOrgan",
        "path" : "MajorSurgery.sacrifiedOrgan",
        "short" : "Sacrified Organs",
        "definition" : "During surgery it is possible that some organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures.\nIn case of partial resection of an organ (e.g. thyroid, kidney), the organ is not 'sacrified', this type of surgery should be then reported only in the 'tumor description' \nFor other organs (e.g. hypothalamus) the only surgical procedure on it may determine some 'sacrifcice' of function, thus in this case, the organ should be coded as 'sacrified'.\n\n(Spleen, Kidney, Eye, Lung, Ovary, Hypothalamus/hypophysis, Thyroid, Bladder, uterus Other)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/surgery-sacrifiedOrgan').valueCodeableConcept"
          },
          {
            "identity" : "fhir",
            "map" : ".code"
          }
        ]
      },
      {
        "id" : "MajorSurgery.shuntApplication",
        "path" : "MajorSurgery.shuntApplication",
        "short" : "Shunt application",
        "definition" : "Please report if a cerebrovascular shunt was inserted ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code.memberOf(ShuntProcedureTypeVs))"
          }
        ]
      },
      {
        "id" : "MajorSurgery.shuntApplication.type",
        "path" : "MajorSurgery.shuntApplication.type",
        "short" : "Type of shunt",
        "definition" : "This is a free text section in which it is possible to specify the type (e.g. ventriculo-peritoneal) of shunt used \n1 => Ventriculo-peritoneal\n2 => Ventriculo atrial\n3 => Subdural_peritoneal\n4 =>  Cisternostomy (III ventricule)\n5 => Other\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".code"
          }
        ]
      },
      {
        "id" : "MajorSurgery.shuntApplication.laterality",
        "path" : "MajorSurgery.shuntApplication.laterality",
        "short" : "Laterality of shunt",
        "definition" : "Please specify the laterality of the shunt\n1 = right\n2= left\n3 = midline\n-9911 = not applicable\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "MajorSurgery.shuntApplication.isRemoved",
        "path" : "MajorSurgery.shuntApplication.isRemoved",
        "short" : "In place or removed ?",
        "definition" : "Define if it is still in place or is already removed \n1 => Still in place\n2 => Removed\n -9911 => NA\n -9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".focalDevice.action"
          }
        ]
      },
      {
        "id" : "MajorSurgery.amputation",
        "path" : "MajorSurgery.amputation",
        "short" : "Amputation",
        "definition" : "Here it is requested only a yes or no. Details should be reported in the surgery description \n1 => Yes\n2 => No\n-9911 => Not applicable\n-9922 => NK ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code.memberOf(AmputationProcedureTypeVs)).exists()"
          }
        ]
      },
      {
        "id" : "MajorSurgery.prothesis",
        "path" : "MajorSurgery.prothesis",
        "short" : "Prothesis",
        "definition" : "Prothesis",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code.memberOf(ProstheticProcedureTypeVs))"
          }
        ]
      },
      {
        "id" : "MajorSurgery.prothesis.status",
        "path" : "MajorSurgery.prothesis.status",
        "short" : "status",
        "definition" : "Please state if the survivor has a prosthesis either internal (e.g. hip replacement) or external (e.g. artificial arm)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "MajorSurgery.prothesis.deviceType",
        "path" : "MajorSurgery.prothesis.deviceType",
        "short" : "device type",
        "definition" : "Please define if prosthesis is internal (e.g. titanium bone) or external (e.g. artificial limb). Also in this case, details should be reported in the surgery description.\n1 => Internal\n2 => External\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "usedCode"
          }
        ]
      },
      {
        "id" : "MajorSurgery.colostomy",
        "path" : "MajorSurgery.colostomy",
        "short" : "Colostomy",
        "definition" : "Colostomy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code.memberOf(ColostomyProcedureTypeVs))"
          }
        ]
      },
      {
        "id" : "MajorSurgery.colostomy.status",
        "path" : "MajorSurgery.colostomy.status",
        "short" : "status",
        "definition" : "State if a colostomy was created. Details should be reported in the surgery section.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "MajorSurgery.colostomy.isRemoved",
        "path" : "MajorSurgery.colostomy.isRemoved",
        "short" : "In place or removed ?",
        "definition" : "State if a colostomy was created. Details should be reported in the surgery section.\n1 => Still in place\n2 => Removed\n-9922 =>NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".focalDevice.action"
          }
        ]
      },
      {
        "id" : "MajorSurgery.gastrostomy",
        "path" : "MajorSurgery.gastrostomy",
        "short" : "Gastrostomy",
        "definition" : "State if a gastrostomy was created. Details should be reported in the surgery section.\n1 => Yes\n2 => No\n-9911 => Not applicable\n-9922 =>NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code.memberOf(GastrostomyProcedureTypeVs)).exists()"
          }
        ]
      }
    ]
  }
}

```
