# Encounter: Treatment Center - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter: Treatment Center**

## Resource Profile: Encounter: Treatment Center 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:EncounterPcsp |

 
This profile defines how to represent data of arrival to the center and Center information in FHIR for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md) and [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)
* Examples for this Profile: [Encounter/EncounterPrimCancerMainzFischer](Encounter-EncounterPrimCancerMainzFischer.md) and [Encounter/EncounterPrimCancerMainzZeisig](Encounter-EncounterPrimCancerMainzZeisig.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Encounter-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Encounter-eu-pcsp.csv), [Excel](StructureDefinition-Encounter-eu-pcsp.xlsx), [Schematron](StructureDefinition-Encounter-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp",
  "version" : "1.0.0",
  "name" : "EncounterPcsp",
  "title" : "Encounter: Treatment Center",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent data of arrival to the center and Center information in FHIR for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.period.start",
        "path" : "Encounter.period.start",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "short" : "Primary treatment center",
        "definition" : "Report here the institution in which most of the treatment was given",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.serviceProvider.identifier",
        "path" : "Encounter.serviceProvider.identifier",
        "short" : "Business identifier of the Primary treatment center"
      },
      {
        "id" : "Encounter.serviceProvider.display",
        "path" : "Encounter.serviceProvider.display",
        "short" : "Short textual description of the Primary treatment center"
      }
    ]
  }
}

```
