# Metadata FSE Italy - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Metadata FSE Italy**

## Logical Model: Metadata FSE Italy 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/DocMetadataFSE | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:DocMetadataFSE |

 
Metadata FSE Italy. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/DocMetadataFSE)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocMetadataFSE.csv), [Excel](StructureDefinition-DocMetadataFSE.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocMetadataFSE",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/DocMetadataFSE",
  "version" : "1.0.0",
  "name" : "DocMetadataFSE",
  "title" : "Metadata FSE Italy",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Metadata FSE Italy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "DocMetadataFSE model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/DocMetadataFSE",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DocMetadataFSE",
        "path" : "DocMetadataFSE",
        "short" : "Metadata FSE Italy",
        "definition" : "Metadata FSE Italy.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationAdministration.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.identifier",
        "path" : "DocMetadataFSE.identifier",
        "short" : "document ID",
        "definition" : "Id documento (dovrebbe essere sull'oid root di regione Liguria) oid root + extension che comincia per nostro standard con le ultime tre cifre del codice azienda (940 per Gaslini) pi� punto pi� id univoco all'interno dell'azienda)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "�DocumentReference.masterIdentifier"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.mimeType",
        "path" : "DocMetadataFSE.mimeType",
        "short" : "MIME type",
        "definition" : "Tipo mime del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.attachment.contentType"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.size",
        "path" : "DocMetadataFSE.size",
        "short" : "size",
        "definition" : "Size del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "unsignedInt"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.attachment.size"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.hash",
        "path" : "DocMetadataFSE.hash",
        "short" : "hash",
        "definition" : "Hash del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.attachment.hash"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.code",
        "path" : "DocMetadataFSE.code",
        "short" : "document code",
        "definition" : "Codice loinc del documento (parliamone)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.type"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.classCode",
        "path" : "DocMetadataFSE.classCode",
        "short" : "Type of document",
        "definition" : "Tipo documento (REF)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.category"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.contentType",
        "path" : "DocMetadataFSE.contentType",
        "short" : "Content Type",
        "definition" : "Content type code (da decidere se consulto o dimissione)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.category (TBC)"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.creationDate",
        "path" : "DocMetadataFSE.creationDate",
        "short" : "creation date",
        "definition" : "Data creazione del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.attachment.creation"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.confidentiality",
        "path" : "DocMetadataFSE.confidentiality",
        "short" : "confidentiality",
        "definition" : "Confidentiality (propendo per V, sarebbe un default))",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.securityLabel"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.mask",
        "path" : "DocMetadataFSE.mask",
        "short" : "mask (oscuramento)",
        "definition" : "Oscuramento (propendo per l'invio come oscurato, sarebbe un default)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.securityLabel"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.replace",
        "path" : "DocMetadataFSE.replace",
        "short" : "replaced document",
        "definition" : "Eventuale documento sostituito (oid + extension)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.relatesTo.where(code = 'replaces').target"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.formatCode",
        "path" : "DocMetadataFSE.formatCode",
        "short" : "Format of document",
        "definition" : "Formato documento (PDF)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.format"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.repositoryId",
        "path" : "DocMetadataFSE.repositoryId",
        "short" : "Repository Id",
        "definition" : "Id repository (Gaslini ne ha uno)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.content.attachment.url"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.indexDate",
        "path" : "DocMetadataFSE.indexDate",
        "short" : "Index Date",
        "definition" : "Data indicizzazione (la aggiunge chi indicizza)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.date (TBC)"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.practiceSettingCode",
        "path" : "DocMetadataFSE.practiceSettingCode",
        "short" : "Practice setting code",
        "definition" : "Practice setting code (da stabilire con Gaslini)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.context.practiceSetting"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.patientFiscalCode",
        "path" : "DocMetadataFSE.patientFiscalCode",
        "short" : "Patient Fiscal Code",
        "definition" : "Codice fiscale paziente soggetto del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.subject.resolve().ofType(Patient).identifier"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.author",
        "path" : "DocMetadataFSE.author",
        "short" : "Author",
        "definition" : "Author",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.author"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.author.fiscalCode",
        "path" : "DocMetadataFSE.author.fiscalCode",
        "short" : "Author Fiscal Code",
        "definition" : "Codice fiscale autore del documento",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.author.resolve().ofType(PractitionerRole).organization.resolve().identifier"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.author.orgCode",
        "path" : "DocMetadataFSE.author.orgCode",
        "short" : "Author Organization (code)",
        "definition" : "Struttura dell'autore (codifica come sopra)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.author.resolve().ofType(PractitionerRole).practitioner.resolve().ofType(Practitioner).identifier"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.author.role",
        "path" : "DocMetadataFSE.author.role",
        "short" : "Author Role (code)",
        "definition" : "Ruolo autore (codifica come sopra)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.author.resolve().ofType(PractitionerRole).organization.resolve().code"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.attesterFiscalCode",
        "path" : "DocMetadataFSE.attesterFiscalCode",
        "short" : "Attester Fiscal Code",
        "definition" : "Firmatario del documento (codice fiscale)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.author.resolve().ofType(Practitioner).identifier"
          }
        ]
      },
      {
        "id" : "DocMetadataFSE.custiodian",
        "path" : "DocMetadataFSE.custiodian",
        "short" : "Custodian",
        "definition" : "Codice azienda custode del documento (070940)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DocumentReference.custodian.resolve().identifier"
          }
        ]
      }
    ]
  }
}

```
