# Diagnosis - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diagnosis**

## Logical Model: Diagnosis 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Diagnosis | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:Diagnosis |

 
Diagnosis 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Diagnosis)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Diagnosis.csv), [Excel](StructureDefinition-Diagnosis.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Diagnosis",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Diagnosis",
  "version" : "1.0.0",
  "name" : "Diagnosis",
  "title" : "Diagnosis",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Diagnosis",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Diagnosis model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Diagnosis",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Diagnosis",
        "path" : "Diagnosis",
        "short" : "Diagnosis",
        "definition" : "Diagnosis",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Diagnosis.identifier",
        "path" : "Diagnosis.identifier",
        "short" : "ID",
        "definition" : "diagnosis identifier",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "Diagnosis.dateOfDiagnosis",
        "path" : "Diagnosis.dateOfDiagnosis",
        "short" : "Date of diagnosis",
        "definition" : "Official date of diagnosis. Please report the date as documented in the clinical record. Differences across institutions may occur in defining this date (either the date of the final test (laboratory, imaging, surgery or pathology report) based on which therapeutic decision was taken. In other cases the date of the pathology report is used to define the date of diagnosis. The system will send an 'error' message if the date of diagnosis is more recent hat the date of start of treatment. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('condition-assertedDate').valueDateTime"
          }
        ]
      },
      {
        "id" : "Diagnosis.centerOfDiagnosis",
        "path" : "Diagnosis.centerOfDiagnosis",
        "short" : "Center of diagnosis",
        "definition" : "Institution in which the diagnosis was made.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp').performer"
          }
        ]
      },
      {
        "id" : "Diagnosis.centerOfDiagnosis.identifier",
        "path" : "Diagnosis.centerOfDiagnosis.identifier",
        "short" : "Center code",
        "definition" : "Code of the institution in which the diagnosis was made.\nIN AIEOP thus information is retrievable from the Mod.1.01 database",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.performer.resolve().identifier"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.performer.identifier"
          }
        ]
      },
      {
        "id" : "Diagnosis.centerOfDiagnosis.name",
        "path" : "Diagnosis.centerOfDiagnosis.name",
        "short" : "Center name",
        "definition" : "Center name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.performer.resolve().name"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.performer.display"
          }
        ]
      },
      {
        "id" : "Diagnosis.centerOfDiagnosis.city",
        "path" : "Diagnosis.centerOfDiagnosis.city",
        "short" : "Center city",
        "definition" : "Center city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.performer.resolve().address.city"
          }
        ]
      },
      {
        "id" : "Diagnosis.centerOfDiagnosis.country",
        "path" : "Diagnosis.centerOfDiagnosis.country",
        "short" : "Center country",
        "definition" : "Center country",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.performer.resolve().address.country"
          }
        ]
      },
      {
        "id" : "Diagnosis.primaryTreatmentCenter",
        "path" : "Diagnosis.primaryTreatmentCenter",
        "short" : "Primary treatment center",
        "definition" : "Report here the institution in which most of the treatment was given",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.generalPractitioner"
          },
          {
            "identity" : "fhir",
            "map" : "Encounter.serviceProvider"
          }
        ]
      },
      {
        "id" : "Diagnosis.primaryTreatmentCenter.name",
        "path" : "Diagnosis.primaryTreatmentCenter.name",
        "short" : "Primary treatment center name",
        "definition" : "Primary treatment center name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.generalPractitioner.display"
          },
          {
            "identity" : "fhir",
            "map" : "Patient.generalPractitioner.resolve().name"
          },
          {
            "identity" : "fhir",
            "map" : "Encounter.serviceProvider.display"
          },
          {
            "identity" : "fhir",
            "map" : "Encounter.serviceProvider.resolve().name"
          }
        ]
      },
      {
        "id" : "Diagnosis.primaryTreatmentCenter.city",
        "path" : "Diagnosis.primaryTreatmentCenter.city",
        "short" : "Primary treatment center city",
        "definition" : "Primary treatment center city",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.generalPractitioner.resolve().address.city"
          },
          {
            "identity" : "fhir",
            "map" : "Encounter.serviceProvider.resolve().address.city"
          }
        ]
      },
      {
        "id" : "Diagnosis.primaryTreatmentCenter.country",
        "path" : "Diagnosis.primaryTreatmentCenter.country",
        "short" : "Primary treatment center country",
        "definition" : "Primary treatment center country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.generalPractitioner.resolve().address.country"
          },
          {
            "identity" : "fhir",
            "map" : "Encounter.serviceProvider.resolve().address.country"
          }
        ]
      },
      {
        "id" : "Diagnosis.dateOfArrivalAtCenter",
        "path" : "Diagnosis.dateOfArrivalAtCenter",
        "short" : "Date of arrival to our institution",
        "definition" : "Date of arrival to our institution",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Encounter.period.start"
          }
        ]
      },
      {
        "id" : "Diagnosis.diagnosticGroup",
        "path" : "Diagnosis.diagnosticGroup",
        "short" : "Diagnostic Group",
        "definition" : "Diagnostic Group. ICCC-3 Classification (Main and Extended classification tables)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.code.coding"
          }
        ]
      },
      {
        "id" : "Diagnosis.morphologyCode",
        "path" : "Diagnosis.morphologyCode",
        "short" : "Diagnosis",
        "definition" : "Report the diagnosis using the ICD-O-3 Morphology coding system (an help tool is built into the system). If also the site of the tumor will be reported (see 'site') using the ICD-O-3 Topography codes, the system will automatically define the tumor according to ICCC-3 classic pediatric classification (see: Cancer category). This field is automatically generated if both ICD-O-3 Morphology and Topography data have been reported",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.extension('mcode-histology-morphology-behavior').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Diagnosis.tumorBehaviour",
        "path" : "Diagnosis.tumorBehaviour",
        "short" : "Tumour behaviour (ICD-O-3 type)",
        "definition" : "Tumour behaviour. Automatically generated by the system for benign tumors",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.extension('mcode-histology-morphology-behavior').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Diagnosis.description",
        "path" : "Diagnosis.description",
        "short" : "Diagnosis description",
        "definition" : "Diagnosis description",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.text"
          },
          {
            "identity" : "fhir",
            "map" : "Condition.code.text"
          }
        ]
      },
      {
        "id" : "Diagnosis.site",
        "path" : "Diagnosis.site",
        "short" : "Site",
        "definition" : "Site of the tumor",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.bodySite"
          }
        ]
      },
      {
        "id" : "Diagnosis.site.code",
        "path" : "Diagnosis.site.code",
        "short" : "Site(ICD-O-3 topography)",
        "definition" : "Site . Report the site of the tumor using the ICD-O-3 Topography (an help tool is built into the system). If also ICD-O-3 Morphology data have been reported, the system will automatically define the tumor also according to ICCC-3 classic pediatric classification (see: Cancer category)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.bodySite.coding"
          }
        ]
      },
      {
        "id" : "Diagnosis.site.description",
        "path" : "Diagnosis.site.description",
        "short" : "Site description",
        "definition" : "Site description . Free text to report the site of the tumor",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.bodySite.text"
          }
        ]
      },
      {
        "id" : "Diagnosis.laterality",
        "path" : "Diagnosis.laterality",
        "short" : "Laterality",
        "definition" : "Laterality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.bodySite.extension('mcode-laterality-qualifier').valueCodeableConcept"
          }
        ]
      },
      {
        "id" : "Diagnosis.metastasis",
        "path" : "Diagnosis.metastasis",
        "short" : "Metastatic",
        "definition" : "Some tumors may be either localized (e.g. stage III neuroblastoma) or metastatic. Please specify.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-secondaryCancer-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "Diagnosis.metastasis.identifier",
        "path" : "Diagnosis.metastasis.identifier",
        "short" : "Metastasis id",
        "definition" : "Number of metastases",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "Diagnosis.metastasis.site",
        "path" : "Diagnosis.metastasis.site",
        "short" : "Metastasis site",
        "definition" : "Please report here the site(s) of metastases detected at diagnosis.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      },
      {
        "id" : "Diagnosis.metastasis.site.code",
        "path" : "Diagnosis.metastasis.site.code",
        "short" : "Metastasis site code",
        "definition" : "Metastases detected at diagnosis (using ICD-O-3 Topography). If site(s) is unknown, code C80.9",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.coding"
          }
        ]
      },
      {
        "id" : "Diagnosis.metastasis.site.description",
        "path" : "Diagnosis.metastasis.site.description",
        "short" : "Additional description of sites of metastatis",
        "definition" : "Additional description of sites of metastatis",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite.text"
          }
        ]
      },
      {
        "id" : "Diagnosis.geneticMarkers",
        "path" : "Diagnosis.geneticMarkers",
        "short" : "Genetic markers(text)",
        "definition" : "Please report here any genetic marker: chromosomal alterations (e.g. translocation, deletions, duplications); or other types of genetic alterations (amplification, deletion, mutation)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.evidence.where(code = http://snomed.info/sct#106221001 'Genetic finding')"
          }
        ]
      },
      {
        "id" : "Diagnosis.stage",
        "path" : "Diagnosis.stage",
        "short" : "Stage/Risk",
        "definition" : "Stage/Risk. Free trext to specify the stage, if applicable, of the tumor at diagnosis. Staging codes may be different across tumor types and eras of treatment. Please report the one used to define the survivors' tumor at the moment of diagnosis.\nIn case of leukemia the 'risk' (e.g. high, standard) could be reported. If the stage is unknown, specifie 'NK'",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.stage"
          }
        ]
      },
      {
        "id" : "Diagnosis.immunology",
        "path" : "Diagnosis.immunology",
        "short" : "Immunology",
        "definition" : "Immunology . This is a free text field. Report here, if applicable (e.g. leukemias) the immunophenotype of the disease (sometimes already reported in the ICD-O-3 Morphology coding). If immunology is unknown, specify 'NK'",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.evidence.where(code = http://snomed.info/sct#365861007 'Finding of immune status')"
          }
        ]
      },
      {
        "id" : "Diagnosis.hereditaryPredisposition",
        "path" : "Diagnosis.hereditaryPredisposition",
        "short" : "Hereditary Cancer Predisposition",
        "definition" : "Hereditary Cancer Predisposition Syndromeor medical condition cancer associated. Report here if the survivor has some Hereditary Cancer Predisposition Syndrome or a medical conditions, cancer associated. The SurPass system provides a list of the most common Hereditary Cancer Predisposition Syndromes or other medical conditions reported to be cancer associated (an help tool is build into the system: when you start writing the computer proposes the syndromes/conditions with similar spelling). If the syndrome is not listed, please mark other and then 'Specify'",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.evidence.where(code = http://snomed.info/sct#32895009 'Hereditary disease')"
          }
        ]
      },
      {
        "id" : "Diagnosis.notes",
        "path" : "Diagnosis.notes",
        "short" : "Notes",
        "definition" : "Notes",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.note"
          }
        ]
      }
    ]
  }
}

```
