# CarePlan: PCSP-generated plan - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CarePlan: PCSP-generated plan**

## Resource Profile: CarePlan: PCSP-generated plan 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CarePlanPcsp |

 
This profile defines how to represent the Care Plan proposed by the PCSP platoform in HL7 FHIR. This profile can be used for both the version generated by the platoform and that curated and validated by Clinicians. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md)
* Examples for this Profile: [CarePlan/CarePlanExample-1](CarePlan-CarePlanExample-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/CarePlan-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarePlan-eu-pcsp.csv), [Excel](StructureDefinition-CarePlan-eu-pcsp.xlsx), [Schematron](StructureDefinition-CarePlan-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlan-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/CarePlan-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CarePlanPcsp",
  "title" : "CarePlan: PCSP-generated plan",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent the Care Plan proposed by the PCSP platoform in HL7 FHIR. This profile can be used for both the version generated by the platoform and that curated and validated by Clinicians.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan.text",
        "path" : "CarePlan.text",
        "min" : 1
      },
      {
        "id" : "CarePlan.identifier",
        "path" : "CarePlan.identifier",
        "short" : "Business Identifier of this Care Plan"
      },
      {
        "id" : "CarePlan.status",
        "path" : "CarePlan.status",
        "short" : "Status (draft when automatically generated)"
      },
      {
        "id" : "CarePlan.intent",
        "path" : "CarePlan.intent",
        "short" : "Intent (proposal when automatically generated)"
      },
      {
        "id" : "CarePlan.subject",
        "path" : "CarePlan.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.created",
        "path" : "CarePlan.created",
        "min" : 1
      },
      {
        "id" : "CarePlan.author",
        "path" : "CarePlan.author",
        "short" : "Who it is attributed to (a Device when automatically generated)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.contributor",
        "path" : "CarePlan.contributor",
        "short" : "Who provided the contents of the care plan.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.addresses",
        "path" : "CarePlan.addresses",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.supportingInfo",
        "path" : "CarePlan.supportingInfo",
        "short" : "Supporting infos, including risk factors",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp",
              "http://hl7.org/fhir/StructureDefinition/Resource"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity",
        "path" : "CarePlan.activity",
        "min" : 1
      },
      {
        "id" : "CarePlan.activity.detail.instantiatesCanonical",
        "path" : "CarePlan.activity.detail.instantiatesCanonical",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/PlanDefinition",
              "http://hl7.org/fhir/StructureDefinition/ActivityDefinition"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.code",
        "path" : "CarePlan.activity.detail.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-recommendation-eu-pcsp"
        }
      },
      {
        "id" : "CarePlan.activity.detail.reasonCode",
        "path" : "CarePlan.activity.detail.reasonCode",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-riskcondition-eu-pcsp"
        }
      },
      {
        "id" : "CarePlan.activity.detail.reasonReference",
        "path" : "CarePlan.activity.detail.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.status",
        "path" : "CarePlan.activity.detail.status",
        "short" : "Progress being made"
      },
      {
        "id" : "CarePlan.activity.detail.scheduled[x]",
        "path" : "CarePlan.activity.detail.scheduled[x]",
        "short" : "Planned for"
      },
      {
        "id" : "CarePlan.activity.detail.description",
        "path" : "CarePlan.activity.detail.description",
        "short" : "Activity to perform"
      },
      {
        "id" : "CarePlan.note",
        "path" : "CarePlan.note",
        "max" : "2"
      },
      {
        "id" : "CarePlan.note.extension:annotationType",
        "path" : "CarePlan.note.extension",
        "sliceName" : "annotationType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/annotation-type"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.note.extension:annotationType.value[x]",
        "path" : "CarePlan.note.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/annotation-type-vs"
        }
      }
    ]
  }
}

```
