# BiologicallyDerivedProduct: Stem Cell - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BiologicallyDerivedProduct: Stem Cell**

## Resource Profile: BiologicallyDerivedProduct: Stem Cell 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:BiologicallyDerivedProductSctPcsp |

 
This profile defines how to represent Stem Cell in FHIR for describing a Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md)
* Examples for this Profile: [BiologicallyDerivedProduct/BiologicallyDerivedProduct-SCT1](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.csv), [Excel](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.xlsx), [Schematron](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BiologicallyDerivedProduct-sct-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/BiologicallyDerivedProduct-sct-eu-pcsp",
  "version" : "1.0.0",
  "name" : "BiologicallyDerivedProductSctPcsp",
  "title" : "BiologicallyDerivedProduct: Stem Cell",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Stem Cell in FHIR for describing a Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "BiologicallyDerivedProduct",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProduct",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "BiologicallyDerivedProduct",
        "path" : "BiologicallyDerivedProduct"
      },
      {
        "id" : "BiologicallyDerivedProduct.extension",
        "path" : "BiologicallyDerivedProduct.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "BiologicallyDerivedProduct.extension:sctDonorType",
        "path" : "BiologicallyDerivedProduct.extension",
        "sliceName" : "sctDonorType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-donor-type"
            ]
          }
        ]
      },
      {
        "id" : "BiologicallyDerivedProduct.extension:sctDonorType.value[x]",
        "path" : "BiologicallyDerivedProduct.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sct-donorType-eu-pcsp"
        }
      },
      {
        "id" : "BiologicallyDerivedProduct.extension:sctSourceType",
        "path" : "BiologicallyDerivedProduct.extension",
        "sliceName" : "sctSourceType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type"
            ]
          }
        ]
      },
      {
        "id" : "BiologicallyDerivedProduct.extension:sctSourceType.value[x]",
        "path" : "BiologicallyDerivedProduct.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sct-sourceType-eu-pcsp"
        }
      },
      {
        "id" : "BiologicallyDerivedProduct.productCategory",
        "path" : "BiologicallyDerivedProduct.productCategory",
        "patternCode" : "cells"
      },
      {
        "id" : "BiologicallyDerivedProduct.collection.source",
        "path" : "BiologicallyDerivedProduct.collection.source",
        "short" : "The patient providing the cells"
      }
    ]
  }
}

```
