# Hulafe - Observation: Risk Factor RT heart - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Observation: Risk Factor RT heart**

## Example Observation: Hulafe - Observation: Risk Factor RT heart

Profile: [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md)

**status**: Final

**code**: Risk factor

**subject**: [APELLIDO1](Patient-PatientHulafe-1.md)

**effective**: 2022-05-12 --> (ongoing)

**value**: RT >= 35 Gy to a vol exposing the heart



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ObservationRiskFactor-3",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-riskfactor-eu-pcsp"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80943009",
        "display" : "Risk factor"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "display" : "APELLIDO1"
  },
  "effectivePeriod" : {
    "start" : "2022-05-12"
  },
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskfactor-eu-pcsp",
        "code" : "3.1",
        "display" : "RT >= 35 Gy to a vol exposing the heart"
      }
    ]
  }
}

```
