# Hulafe - Observation: Chemotherapy Ciclofosfamide Cumulative Dose - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - Observation: Chemotherapy Ciclofosfamide Cumulative Dose**

## Example Observation: Hulafe - Observation: Chemotherapy Ciclofosfamide Cumulative Dose

Profile: [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md)

**status**: Final

**code**: Cumulative dose received by a patient for a specific drug.

**subject**: [NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

**value**: 3000 mg/m2(Details: UCUM codemg/m2 = 'mg/m2')

**method**: Calculation technique



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ChemoHulafe-1-Ciclofosfamide-dose",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-cumulativeDoseChemo-eu-pcsp"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
        "code" : "cumulativeDose"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "type" : "Patient"
  },
  "valueQuantity" : {
    "value" : 3000,
    "unit" : "mg/m2",
    "system" : "http://unitsofmeasure.org",
    "code" : "mg/m2"
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "702873001",
        "display" : "Calculation technique"
      }
    ]
  }
}

```
