# Hulafe - MedicationStatement: Chemotherapy Corticosteroids - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hulafe - MedicationStatement: Chemotherapy Corticosteroids**

## Example MedicationStatement: Hulafe - MedicationStatement: Chemotherapy Corticosteroids

Profile: [MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md)

**status**: Not Taken

**medication**: CORTICOSTEROIDS FOR SYSTEMIC USE

**subject**: [NOMBRE APELLIDO1 APELLIDO2(anonymous) Female, DoB: 2005-07-01 ( urn:oid:2.16.724.4.10.50.200#123456789 (use: official, ))](Patient-PatientHulafe-1.md)

**reasonReference**: [Condition un-encoded](Condition-PrimaryCancerHulafe-1.md)

### Dosages

| | |
| :--- | :--- |
| - | **Timing** |
| * | Once |



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "ChemoHulafe-1-corticosteroids",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationStatement-eu-pcsp"
    ]
  },
  "status" : "not-taken",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.whocc.no/atc",
        "code" : "H02",
        "display" : "CORTICOSTEROIDS FOR SYSTEMIC USE"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/PatientHulafe-1",
    "type" : "Patient"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/PrimaryCancerHulafe-1"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 4,
            "comparator" : ">",
            "unit" : "w",
            "system" : "http://unitsofmeasure.org",
            "code" : "w"
          }
        }
      }
    }
  ]
}

```
