# International Classification of Diseases for Oncology, Third Edition - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Diseases for Oncology, Third Edition**

## CodeSystem: International Classification of Diseases for Oncology, Third Edition (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/icd-o-3 | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ICD_O_3 |

 
The International Classification of Diseases for Oncology, Third Edition (ICD-O-3) is a coding system used primarily for classifying and coding neoplasms (tumors) based on their topography (site) and morphology (histology). It is widely used in cancer registries and epidemiological research. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ICDO3MorphologyVs](ValueSet-vs-icdo3-morphology-eu-pcsp.md)
* [ICDO3TopographyVs](ValueSet-vs-icdo3-topography-eu-pcsp.md)

This case-sensitive code system `http://terminology.hl7.org/CodeSystem/icd-o-3` provides **a fragment** that includes following codes:



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "icd-o-3",
  "url" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
  "version" : "1.0.0",
  "name" : "ICD_O_3",
  "title" : "International Classification of Diseases for Oncology, Third Edition",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "The International Classification of Diseases for Oncology, Third Edition (ICD-O-3) is a coding system used primarily for classifying and coding neoplasms (tumors) based on their topography (site) and morphology (histology). It is widely used in cancer registries and epidemiological research.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "fragment",
  "concept" : [
    {
      "code" : "8260/3",
      "display" : "Papillary adenocarcinoma, NOS"
    },
    {
      "code" : "9181/3",
      "display" : "Hepatoblastoma, NOS"
    },
    {
      "code" : "9186/3",
      "display" : "Hepatocellular carcinoma, fibrolamellar"
    },
    {
      "code" : "9510/3",
      "display" : "Medulloblastoma, NOS"
    }
  ]
}

```
