# PCSP Conditions at risk - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCSP Conditions at risk**

## CodeSystem: PCSP Conditions at risk 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CsRiskConditionPcsp |

 
Condition at risk proposed by the PCSP algorithm 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RiskCondition](ValueSet-vs-riskcondition-eu-pcsp.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-riskcondition-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-riskcondition-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CsRiskConditionPcsp",
  "title" : "PCSP Conditions at risk",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Condition at risk proposed by the PCSP algorithm",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 47,
  "concept" : [
    {
      "code" : "1",
      "display" : "Subsequent thyroid cancer",
      "definition" : "Subsequent thyroid cancer"
    },
    {
      "code" : "2",
      "display" : "Subsequent breast cancer",
      "definition" : "Subsequent breast cancer"
    },
    {
      "code" : "3",
      "display" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)",
      "definition" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
    },
    {
      "code" : "4",
      "display" : "Impaired fertility Impaired spermatogenesis",
      "definition" : "Impaired fertility Impaired spermatogenesis"
    },
    {
      "code" : "5",
      "display" : "Testosterone deficiency",
      "definition" : "Testosterone deficiency"
    },
    {
      "code" : "6",
      "display" : "Physical sexual dysfunction",
      "definition" : "Physical sexual dysfunction"
    },
    {
      "code" : "7",
      "display" : "Premature ovarian insufficiency",
      "definition" : "Premature ovarian insufficiency"
    },
    {
      "code" : "8",
      "display" : "Ear problems",
      "definition" : "Ear problems"
    },
    {
      "code" : "9",
      "display" : "Impaired glucose metabolism and diabetes melitus",
      "definition" : "Impaired glucose metabolism and diabetes melitus"
    },
    {
      "code" : "10",
      "display" : "Dyslipidemia",
      "definition" : "Dyslipidemia"
    },
    {
      "code" : "11",
      "display" : "Overweight and obesity",
      "definition" : "Overweight and obesity"
    },
    {
      "code" : "12",
      "display" : "Hypertension",
      "definition" : "Hypertension"
    },
    {
      "code" : "13",
      "display" : "Reduced bone mineral density",
      "definition" : "Reduced bone mineral density"
    },
    {
      "code" : "14",
      "display" : "Osteonecrosis",
      "definition" : "Osteonecrosis"
    },
    {
      "code" : "15",
      "display" : "Hypothalamic-pituitary (HP) axis problems (High risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)",
      "definition" : "Hypothalamic-pituitary (HP) axis problems (High risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)"
    },
    {
      "code" : "16",
      "display" : "Hypothalamic-pituitary (HP) axis problems (Standard risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)",
      "definition" : "Hypothalamic-pituitary (HP) axis problems (Standard risk) Growth hormone deficiency (GHD) TSH deficiency (TSHD) LH/FSH deficiency (LH/FSHD) ACTH deficiency (ACTHD)"
    },
    {
      "code" : "17",
      "display" : "Central precocious puberty (CPP) For girls with age below 8 years",
      "definition" : "Central precocious puberty (CPP) For girls with age below 8 years"
    },
    {
      "code" : "18",
      "display" : "Central precocious puberty (CPP) For boys with age below 9 yearss",
      "definition" : "Central precocious puberty (CPP) For boys with age below 9 yearss"
    },
    {
      "code" : "19",
      "display" : "Thyroid function problems",
      "definition" : "Thyroid function problems"
    },
    {
      "code" : "20",
      "display" : "Cerebrovascular problem",
      "definition" : "Cerebrovascular problem"
    },
    {
      "code" : "21",
      "display" : "Neurocognitive problems",
      "definition" : "Neurocognitive problems"
    },
    {
      "code" : "22",
      "display" : "Peripheral neuropathy",
      "definition" : "Peripheral neuropathy"
    },
    {
      "code" : "23",
      "display" : "Cataract",
      "definition" : "Cataract"
    },
    {
      "code" : "24",
      "display" : "Eye problems",
      "definition" : "Eye problems"
    },
    {
      "code" : "25",
      "display" : "Craniofacial growth problems",
      "definition" : "Craniofacial growth problems"
    },
    {
      "code" : "26",
      "display" : "Spine scoliosis and kyphosis",
      "definition" : "Spine scoliosis and kyphosis"
    },
    {
      "code" : "27",
      "display" : "Lower urinary tract problems",
      "definition" : "Lower urinary tract problems"
    },
    {
      "code" : "28",
      "display" : "Obstetric problems",
      "definition" : "Obstetric problems"
    },
    {
      "code" : "29",
      "display" : "Dental and oral problems",
      "definition" : "Dental and oral problems"
    },
    {
      "code" : "30",
      "display" : "Gastro-intestinal problems",
      "definition" : "Gastro-intestinal problems"
    },
    {
      "code" : "31",
      "display" : "Arrhythmia",
      "definition" : "Arrhythmia"
    },
    {
      "code" : "32",
      "display" : "Pulmonary problems",
      "definition" : "Pulmonary problems"
    },
    {
      "code" : "33",
      "display" : "Renal problems (Glomerular dysfunction - Tubular dysfunction)",
      "definition" : "Renal problems (Glomerular dysfunction - Tubular dysfunction)"
    },
    {
      "code" : "34",
      "display" : "Liver problems",
      "definition" : "Liver problems"
    },
    {
      "code" : "35",
      "display" : "Iron overload",
      "definition" : "Iron overload"
    },
    {
      "code" : "36",
      "display" : "Spleen problems",
      "definition" : "Spleen problems"
    },
    {
      "code" : "37",
      "display" : "Tumor predisposition",
      "definition" : "Tumor predisposition"
    },
    {
      "code" : "38",
      "display" : "Subsequent melanoma and non-melanoma skin cancer",
      "definition" : "Subsequent melanoma and non-melanoma skin cancer"
    },
    {
      "code" : "39",
      "display" : "Subsequent colorectal cancer",
      "definition" : "Subsequent colorectal cancer"
    },
    {
      "code" : "40",
      "display" : "Subsequent Oral Cancer",
      "definition" : "Subsequent Oral Cancer"
    },
    {
      "code" : "41",
      "display" : "Subsequent acute myeloid leukaemia or myelodysplasia",
      "definition" : "Subsequent acute myeloid leukaemia or myelodysplasia"
    },
    {
      "code" : "42",
      "display" : "Subsequent bladder cancer",
      "definition" : "Subsequent bladder cancer"
    },
    {
      "code" : "43",
      "display" : "Subsequent Bone Cancer",
      "definition" : "Subsequent Bone Cancer"
    },
    {
      "code" : "44",
      "display" : "Subsequent lung cancer",
      "definition" : "Subsequent lung cancer"
    },
    {
      "code" : "45",
      "display" : "Subsequent CNS neoplasms",
      "definition" : "Subsequent CNS neoplasms"
    },
    {
      "code" : "46",
      "display" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)",
      "definition" : "Cardiac problems (Cardiomyopathy and/or Valvular disease and/or Cardiac ischemia)"
    },
    {
      "code" : "47",
      "display" : "Renal problems (Tubular dysfunction)",
      "definition" : "Renal problems (Tubular dysfunction)"
    }
  ]
}

```
