# Radiotherapy sites - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Radiotherapy sites**

## CodeSystem: Radiotherapy sites 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-radiotherapy-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CsRadiotherapy |

 
PancareSurPass radiotherapy sites Code System 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsRadiotherapy](ValueSet-vs-radiotherapy-pcsp.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-radiotherapy-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-radiotherapy-pcsp",
  "version" : "1.0.0",
  "name" : "CsRadiotherapy",
  "title" : "Radiotherapy sites",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "PancareSurPass radiotherapy sites Code System",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "hierarchyMeaning" : "part-of",
  "content" : "complete",
  "count" : 536,
  "concept" : [
    {
      "code" : "1",
      "display" : "Brain",
      "concept" : [
        {
          "code" : "1.1",
          "display" : "Brain: Whole brain"
        },
        {
          "code" : "1.2",
          "display" : "Brain: Frontal lobe",
          "concept" : [
            {
              "code" : "1.2.R",
              "display" : "Brain: Frontal lobe (right)"
            },
            {
              "code" : "1.2.L",
              "display" : "Brain: Frontal lobe (left)"
            },
            {
              "code" : "1.2.B",
              "display" : "Brain: Frontal lobe (bilateral)"
            }
          ]
        },
        {
          "code" : "1.3",
          "display" : "Brain: Temporal lobe",
          "concept" : [
            {
              "code" : "1.3.R",
              "display" : "Brain: Temporal lobe (right)"
            },
            {
              "code" : "1.3.L",
              "display" : "Brain: Temporal lobe (left)"
            },
            {
              "code" : "1.3.B",
              "display" : "Brain: Temporal lobe (bilateral)"
            }
          ]
        },
        {
          "code" : "1.4",
          "display" : "Brain: Occipital lobe",
          "concept" : [
            {
              "code" : "1.4.R",
              "display" : "Brain: Occipital lobe (right)"
            },
            {
              "code" : "1.4.L",
              "display" : "Brain: Occipital lobe (left)"
            },
            {
              "code" : "1.4.B",
              "display" : "Brain: Occipital lobe (bilateral)"
            }
          ]
        },
        {
          "code" : "1.5",
          "display" : "Brain: Left Ventricle"
        },
        {
          "code" : "1.6",
          "display" : "Brain: Right Ventricle"
        },
        {
          "code" : "1.7",
          "display" : "Brain: Pituitary"
        },
        {
          "code" : "1.8",
          "display" : "Brain: Hypothalamus"
        },
        {
          "code" : "1.9",
          "display" : "Brain: III Ventricle"
        },
        {
          "code" : "1.10",
          "display" : "Brain: IV Ventricle"
        },
        {
          "code" : "1.11",
          "display" : "Brain: Cerebellum",
          "concept" : [
            {
              "code" : "1.11.R",
              "display" : "Brain: Cerebellum (right)"
            },
            {
              "code" : "1.11.L",
              "display" : "Brain: Cerebellum (left)"
            },
            {
              "code" : "1.11.B",
              "display" : "Brain: Cerebellum (bilateral)"
            }
          ]
        },
        {
          "code" : "1.12",
          "display" : "Brain: Mesencephalon/midbrain"
        },
        {
          "code" : "1.13",
          "display" : "Brain: Pons"
        },
        {
          "code" : "1.14",
          "display" : "Brain: Medulla"
        },
        {
          "code" : "1.98",
          "display" : "Brain: Other specified"
        },
        {
          "code" : "1.99",
          "display" : "Brain: Unspecified"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Head",
      "concept" : [
        {
          "code" : "2.1",
          "display" : "Head: Orbit/Eye",
          "concept" : [
            {
              "code" : "2.1.R",
              "display" : "Head: Orbit/Eye (right)"
            },
            {
              "code" : "2.1.L",
              "display" : "Head: Orbit/Eye (left)"
            },
            {
              "code" : "2.1.B",
              "display" : "Head: Orbit/Eye (bilateral)"
            }
          ]
        },
        {
          "code" : "2.2",
          "display" : "Head: Ear/Infratemporal area",
          "concept" : [
            {
              "code" : "2.2.R",
              "display" : "Head: Ear/Infratemporal area (right)"
            },
            {
              "code" : "2.2.L",
              "display" : "Head: Ear/Infratemporal area (left)"
            },
            {
              "code" : "2.2.B",
              "display" : "Head: Ear/Infratemporal area (bilateral)"
            }
          ]
        },
        {
          "code" : "2.3",
          "display" : "Head: Nasopharynx",
          "concept" : [
            {
              "code" : "2.3.R",
              "display" : "Head: Nasopharynx (right)"
            },
            {
              "code" : "2.3.L",
              "display" : "Head: Nasopharynx (left)"
            },
            {
              "code" : "2.3.B",
              "display" : "Head: Nasopharynx (bilateral)"
            }
          ]
        },
        {
          "code" : "2.4",
          "display" : "Head: Oropharynx",
          "concept" : [
            {
              "code" : "2.4.R",
              "display" : "Head: Oropharynx (right)"
            },
            {
              "code" : "2.4.L",
              "display" : "Head: Oropharynx (left)"
            },
            {
              "code" : "2.4.B",
              "display" : "Head: Oropharynx (bilateral)"
            }
          ]
        },
        {
          "code" : "2.5",
          "display" : "Head: Waldeyer's Ring = nasopharynx + oropharynx",
          "concept" : [
            {
              "code" : "2.5.R",
              "display" : "Head: Waldeyer's Ring = nasopharynx + oropharynx (right)"
            },
            {
              "code" : "2.5.L",
              "display" : "Head: Waldeyer's Ring = nasopharynx + oropharynx (left)"
            },
            {
              "code" : "2.5.B",
              "display" : "Head: Waldeyer's Ring = nasopharynx + oropharynx (bilateral)"
            }
          ]
        },
        {
          "code" : "2.6",
          "display" : "Head: Oral cavity",
          "concept" : [
            {
              "code" : "2.6.1",
              "display" : "Head: Oral cavity - Tongue"
            },
            {
              "code" : "2.6.2",
              "display" : "Head: Oral cavity - Hard palate"
            }
          ]
        },
        {
          "code" : "2.7",
          "display" : "Head: Hypopharynx"
        },
        {
          "code" : "2.98",
          "display" : "Head: Other specified"
        },
        {
          "code" : "2.99",
          "display" : "Head: Unspecified"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "Neck",
      "concept" : [
        {
          "code" : "3.1",
          "display" : "Neck: Whole neck"
        },
        {
          "code" : "3.2",
          "display" : "Neck: Upper neck",
          "concept" : [
            {
              "code" : "3.2.R",
              "display" : "Neck: Upper neck (right)"
            },
            {
              "code" : "3.2.L",
              "display" : "Neck: Upper neck (left)"
            },
            {
              "code" : "3.2.B",
              "display" : "Neck: Upper neck (bilateral)"
            }
          ]
        },
        {
          "code" : "3.3",
          "display" : "Neck: Supraclavicular area",
          "concept" : [
            {
              "code" : "3.3.R",
              "display" : "Neck: Supraclavicular area (right)"
            },
            {
              "code" : "3.3.L",
              "display" : "Neck: Supraclavicular area (left)"
            },
            {
              "code" : "3.3.B",
              "display" : "Neck: Supraclavicular area (bilateral)"
            }
          ]
        },
        {
          "code" : "3.4",
          "display" : "Neck: Thyroid"
        },
        {
          "code" : "3.5",
          "display" : "Neck: Larinx"
        },
        {
          "code" : "3.6",
          "display" : "Neck: Cervical nodes",
          "concept" : [
            {
              "code" : "3.6.R",
              "display" : "Neck: Cervical nodes (right)"
            },
            {
              "code" : "3.6.L",
              "display" : "Neck: Cervical nodes (left)"
            },
            {
              "code" : "3.6.B",
              "display" : "Neck: Cervical nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "3.7",
          "display" : "Neck: Supraclavicular nodes",
          "concept" : [
            {
              "code" : "3.7.R",
              "display" : "Neck: Supraclavicular nodes (right)"
            },
            {
              "code" : "3.7.L",
              "display" : "Neck: Supraclavicular nodes (left)"
            },
            {
              "code" : "3.7.B",
              "display" : "Neck: Supraclavicular nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "3.98",
          "display" : "Neck: Other specified"
        },
        {
          "code" : "3.99",
          "display" : "Neck: Unspecified"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "Spine",
      "concept" : [
        {
          "code" : "4.1",
          "display" : "Spine: Whole spine"
        },
        {
          "code" : "4.2",
          "display" : "Spine: Cervical spine",
          "concept" : [
            {
              "code" : "4.2.1",
              "display" : "Spine: Cervical spine - Cervical vertebra 1"
            },
            {
              "code" : "4.2.2",
              "display" : "Spine: Cervical spine - Cervical vertebra 2"
            },
            {
              "code" : "4.2.3",
              "display" : "Spine: Cervical spine - Cervical vertebra 3"
            },
            {
              "code" : "4.2.4",
              "display" : "Spine: Cervical spine - Cervical vertebra 4"
            },
            {
              "code" : "4.2.5",
              "display" : "Spine: Cervical spine - Cervical vertebra 5"
            },
            {
              "code" : "4.2.6",
              "display" : "Spine: Cervical spine - Cervical vertebra 6"
            },
            {
              "code" : "4.2.7",
              "display" : "Spine: Cervical spine - Cervical vertebra 7"
            }
          ]
        },
        {
          "code" : "4.3",
          "display" : "Spine: Thoracic / Dorsal spine",
          "concept" : [
            {
              "code" : "4.3.1",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "4.3.2",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "4.3.3",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "4.3.4",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "4.3.5",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "4.3.6",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "4.3.7",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "4.3.8",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "4.3.9",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "4.3.10",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "4.3.11",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "4.3.12",
              "display" : "Spine: Thoracic / Dorsal spine - Thoracic / dorsal vertebra 12"
            }
          ]
        },
        {
          "code" : "4.4",
          "display" : "Spine: Lumbar spine",
          "concept" : [
            {
              "code" : "4.4.1",
              "display" : "Spine: Lumbar spine - Lumbar vertebra 1"
            },
            {
              "code" : "4.4.2",
              "display" : "Spine: Lumbar spine - Lumbar vertebra 2"
            },
            {
              "code" : "4.4.3",
              "display" : "Spine: Lumbar spine - Lumbar vertebra 3"
            },
            {
              "code" : "4.4.4",
              "display" : "Spine: Lumbar spine - Lumbar vertebra 4"
            },
            {
              "code" : "4.4.5",
              "display" : "Spine: Lumbar spine - Lumbar vertebra 5"
            }
          ]
        },
        {
          "code" : "4.5",
          "display" : "Spine: Sacral/cocygeal spine",
          "concept" : [
            {
              "code" : "4.5.1",
              "display" : "Spine: Sacral/cocygeal spine - Sacral vertebra 1"
            },
            {
              "code" : "4.5.2",
              "display" : "Spine: Sacral/cocygeal spine - Sacral vertebra 2"
            },
            {
              "code" : "4.5.3",
              "display" : "Spine: Sacral/cocygeal spine - Sacral vertebra 3"
            },
            {
              "code" : "4.5.4",
              "display" : "Spine: Sacral/cocygeal spine - Sacral vertebra 4"
            },
            {
              "code" : "4.5.5",
              "display" : "Spine: Sacral/cocygeal spine - Sacral vertebra 5"
            },
            {
              "code" : "4.5.6",
              "display" : "Spine: Sacral/cocygeal spine - Cocyx"
            }
          ]
        },
        {
          "code" : "4.6",
          "display" : "Spine: Cervical / Thoracic spine",
          "concept" : [
            {
              "code" : "4.6.1",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 1"
            },
            {
              "code" : "4.6.2",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 2"
            },
            {
              "code" : "4.6.3",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 3"
            },
            {
              "code" : "4.6.4",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 4"
            },
            {
              "code" : "4.6.5",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 5"
            },
            {
              "code" : "4.6.6",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 6"
            },
            {
              "code" : "4.6.7",
              "display" : "Spine: Cervical / Thoracic spine - Cervical vertebra 7"
            },
            {
              "code" : "4.6.8",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "4.6.9",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "4.6.10",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "4.6.11",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "4.6.12",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "4.6.13",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "4.6.14",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "4.6.15",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "4.6.16",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "4.6.17",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "4.6.18",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "4.6.19",
              "display" : "Spine: Cervical / Thoracic spine - Thoracic / dorsal vertebra 12"
            }
          ]
        },
        {
          "code" : "4.7",
          "display" : "Spine: Thoracic / Abdominal spine",
          "concept" : [
            {
              "code" : "4.7.1",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "4.7.2",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "4.7.3",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "4.7.4",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "4.7.5",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "4.7.6",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "4.7.7",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "4.7.8",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "4.7.9",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "4.7.10",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "4.7.11",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "4.7.12",
              "display" : "Spine: Thoracic / Abdominal spine - Thoracic / dorsal vertebra 12"
            },
            {
              "code" : "4.7.13",
              "display" : "Spine: Thoracic / Abdominal spine - Lumbar vertebra 1"
            },
            {
              "code" : "4.7.14",
              "display" : "Spine: Thoracic / Abdominal spine - Lumbar vertebra 2"
            },
            {
              "code" : "4.7.15",
              "display" : "Spine: Thoracic / Abdominal spine - Lumbar vertebra 3"
            },
            {
              "code" : "4.7.16",
              "display" : "Spine: Thoracic / Abdominal spine - Lumbar vertebra 4"
            },
            {
              "code" : "4.7.17",
              "display" : "Spine: Thoracic / Abdominal spine - Lumbar vertebra 5"
            }
          ]
        },
        {
          "code" : "4.8",
          "display" : "Spine: Abdominal / Pelvic spine",
          "concept" : [
            {
              "code" : "4.8.1",
              "display" : "Spine: Abdominal / Pelvic spine - Lumbar vertebra 1"
            },
            {
              "code" : "4.8.2",
              "display" : "Spine: Abdominal / Pelvic spine - Lumbar vertebra 2"
            },
            {
              "code" : "4.8.3",
              "display" : "Spine: Abdominal / Pelvic spine - Lumbar vertebra 3"
            },
            {
              "code" : "4.8.4",
              "display" : "Spine: Abdominal / Pelvic spine - Lumbar vertebra 4"
            },
            {
              "code" : "4.8.5",
              "display" : "Spine: Abdominal / Pelvic spine - Lumbar vertebra 5"
            },
            {
              "code" : "4.8.6",
              "display" : "Spine: Abdominal / Pelvic spine - Sacral vertebra 1"
            },
            {
              "code" : "4.8.7",
              "display" : "Spine: Abdominal / Pelvic spine - Sacral vertebra 2"
            },
            {
              "code" : "4.8.8",
              "display" : "Spine: Abdominal / Pelvic spine - Sacral vertebra 3"
            },
            {
              "code" : "4.8.9",
              "display" : "Spine: Abdominal / Pelvic spine - Sacral vertebra 4"
            },
            {
              "code" : "4.8.10",
              "display" : "Spine: Abdominal / Pelvic spine - Sacral vertebra 5"
            },
            {
              "code" : "4.8.11",
              "display" : "Spine: Abdominal / Pelvic spine - Cocyx"
            }
          ]
        },
        {
          "code" : "4.98",
          "display" : "Spine: Other specified"
        },
        {
          "code" : "4.99",
          "display" : "Spine: Unspecified"
        }
      ]
    },
    {
      "code" : "6",
      "display" : "Cervico-Thoracic (area)",
      "concept" : [
        {
          "code" : "6.1",
          "display" : "Cervico-Thoracic (area): Paraspinal",
          "concept" : [
            {
              "code" : "6.1.R",
              "display" : "Cervico-Thoracic (area): Paraspinal (right)"
            },
            {
              "code" : "6.1.L",
              "display" : "Cervico-Thoracic (area): Paraspinal (left)"
            },
            {
              "code" : "6.1.B",
              "display" : "Cervico-Thoracic (area): Paraspinal (bilateral)"
            },
            {
              "code" : "6.1.1",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 1"
            },
            {
              "code" : "6.1.2",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 2"
            },
            {
              "code" : "6.1.3",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 3"
            },
            {
              "code" : "6.1.4",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 4"
            },
            {
              "code" : "6.1.5",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 5"
            },
            {
              "code" : "6.1.6",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 6"
            },
            {
              "code" : "6.1.7",
              "display" : "Cervico-Thoracic (area): Paraspinal - Cervical vertebra 7"
            },
            {
              "code" : "6.1.8",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "6.1.9",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "6.1.10",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "6.1.11",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "6.1.12",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "6.1.13",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "6.1.14",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "6.1.15",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "6.1.16",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "6.1.17",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "6.1.18",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "6.1.19",
              "display" : "Cervico-Thoracic (area): Paraspinal - Thoracic / dorsal vertebra 12"
            }
          ]
        },
        {
          "code" : "6.98",
          "display" : "Cervico-Thoracic (area): Other specified"
        },
        {
          "code" : "6.99",
          "display" : "Cervico-Thoracic (area): Unspecified"
        }
      ]
    },
    {
      "code" : "7",
      "display" : "Chest (thorax)",
      "concept" : [
        {
          "code" : "7.1",
          "display" : "Chest (thorax): Whole chest (thorax)"
        },
        {
          "code" : "7.2",
          "display" : "Chest (thorax): Ribs",
          "concept" : [
            {
              "code" : "7.2.R",
              "display" : "Chest (thorax): Ribs (right)"
            },
            {
              "code" : "7.2.L",
              "display" : "Chest (thorax): Ribs (left)"
            },
            {
              "code" : "7.2.B",
              "display" : "Chest (thorax): Ribs (bilateral)"
            },
            {
              "code" : "7.2.1",
              "display" : "Chest (thorax): Ribs - Rib 1"
            },
            {
              "code" : "7.2.2",
              "display" : "Chest (thorax): Ribs - Rib 2"
            },
            {
              "code" : "7.2.3",
              "display" : "Chest (thorax): Ribs - Rib 3"
            },
            {
              "code" : "7.2.4",
              "display" : "Chest (thorax): Ribs - Rib 4"
            },
            {
              "code" : "7.2.5",
              "display" : "Chest (thorax): Ribs - Rib 5"
            },
            {
              "code" : "7.2.6",
              "display" : "Chest (thorax): Ribs - Rib 6"
            },
            {
              "code" : "7.2.7",
              "display" : "Chest (thorax): Ribs - Rib 7"
            },
            {
              "code" : "7.2.8",
              "display" : "Chest (thorax): Ribs - Rib 8"
            },
            {
              "code" : "7.2.9",
              "display" : "Chest (thorax): Ribs - Rib 9"
            },
            {
              "code" : "7.2.10",
              "display" : "Chest (thorax): Ribs - Rib 10"
            },
            {
              "code" : "7.2.11",
              "display" : "Chest (thorax): Ribs - Rib 11"
            },
            {
              "code" : "7.2.12",
              "display" : "Chest (thorax): Ribs - Rib 12"
            }
          ]
        },
        {
          "code" : "7.3",
          "display" : "Chest (thorax): Clavicle",
          "concept" : [
            {
              "code" : "7.3.R",
              "display" : "Chest (thorax): Clavicle (right)"
            },
            {
              "code" : "7.3.L",
              "display" : "Chest (thorax): Clavicle (left)"
            },
            {
              "code" : "7.3.B",
              "display" : "Chest (thorax): Clavicle (bilateral)"
            },
            {
              "code" : "7.3.1",
              "display" : "Chest (thorax): Clavicle - Whole clavicle"
            },
            {
              "code" : "7.3.2",
              "display" : "Chest (thorax): Clavicle - Medial clavicle"
            },
            {
              "code" : "7.3.2.R",
              "display" : "Chest (thorax): Clavicle - Medial clavicle (right)"
            },
            {
              "code" : "7.3.2.L",
              "display" : "Chest (thorax): Clavicle - Medial clavicle (left)"
            },
            {
              "code" : "7.3.2.B",
              "display" : "Chest (thorax): Clavicle - Medial clavicle (bilateral)"
            },
            {
              "code" : "7.3.3",
              "display" : "Chest (thorax): Clavicle - Lateral clavicle"
            },
            {
              "code" : "7.3.3.R",
              "display" : "Chest (thorax): Clavicle - Lateral clavicle (right)"
            },
            {
              "code" : "7.3.3.L",
              "display" : "Chest (thorax): Clavicle - Lateral clavicle (left)"
            },
            {
              "code" : "7.3.3.B",
              "display" : "Chest (thorax): Clavicle - Lateral clavicle (bilateral)"
            }
          ]
        },
        {
          "code" : "7.4",
          "display" : "Chest (thorax): Sternum",
          "concept" : [
            {
              "code" : "7.4.1",
              "display" : "Chest (thorax): Sternum - Whole sternum"
            },
            {
              "code" : "7.4.2",
              "display" : "Chest (thorax): Sternum - Upper sternum"
            },
            {
              "code" : "7.4.3",
              "display" : "Chest (thorax): Sternum - Lower sternum"
            },
            {
              "code" : "7.4.98",
              "display" : "Chest (thorax): Sternum - Other specified"
            },
            {
              "code" : "7.4.99",
              "display" : "Chest (thorax): Sternum - Unspecified"
            }
          ]
        },
        {
          "code" : "7.5",
          "display" : "Chest (thorax): Scapula",
          "concept" : [
            {
              "code" : "7.5.R",
              "display" : "Chest (thorax): Scapula (right)"
            },
            {
              "code" : "7.5.L",
              "display" : "Chest (thorax): Scapula (left)"
            },
            {
              "code" : "7.5.B",
              "display" : "Chest (thorax): Scapula (bilateral)"
            },
            {
              "code" : "7.5.1",
              "display" : "Chest (thorax): Scapula - Whole scapula"
            },
            {
              "code" : "7.5.2",
              "display" : "Chest (thorax): Scapula - Upper scapula"
            },
            {
              "code" : "7.5.2.R",
              "display" : "Chest (thorax): Scapula - Upper scapula (right)"
            },
            {
              "code" : "7.5.2.L",
              "display" : "Chest (thorax): Scapula - Upper scapula (left)"
            },
            {
              "code" : "7.5.2.B",
              "display" : "Chest (thorax): Scapula - Upper scapula (bilateral)"
            },
            {
              "code" : "7.5.3",
              "display" : "Chest (thorax): Scapula - Lower scapula"
            },
            {
              "code" : "7.5.3.R",
              "display" : "Chest (thorax): Scapula - Lower scapula (right)"
            },
            {
              "code" : "7.5.3.L",
              "display" : "Chest (thorax): Scapula - Lower scapula (left)"
            },
            {
              "code" : "7.5.3.B",
              "display" : "Chest (thorax): Scapula - Lower scapula (bilateral)"
            },
            {
              "code" : "7.5.98",
              "display" : "Chest (thorax): Scapula - Other specified"
            },
            {
              "code" : "7.5.99",
              "display" : "Chest (thorax): Scapula - Unspecified"
            }
          ]
        },
        {
          "code" : "7.6",
          "display" : "Chest (thorax): Mediastinum",
          "concept" : [
            {
              "code" : "7.6.1",
              "display" : "Chest (thorax): Mediastinum - Whole mediastinum"
            },
            {
              "code" : "7.6.2",
              "display" : "Chest (thorax): Mediastinum - Upper mediastinum"
            },
            {
              "code" : "7.6.2.R",
              "display" : "Chest (thorax): Mediastinum - Upper mediastinum (right)"
            },
            {
              "code" : "7.6.2.L",
              "display" : "Chest (thorax): Mediastinum - Upper mediastinum (left)"
            },
            {
              "code" : "7.6.3",
              "display" : "Chest (thorax): Mediastinum - Lower mediastinum"
            },
            {
              "code" : "7.6.3.R",
              "display" : "Chest (thorax): Mediastinum - Lower mediastinum (right)"
            },
            {
              "code" : "7.6.3.L",
              "display" : "Chest (thorax): Mediastinum - Lower mediastinum (left)"
            },
            {
              "code" : "7.6.98",
              "display" : "Chest (thorax): Mediastinum - Other specified"
            },
            {
              "code" : "7.6.99",
              "display" : "Chest (thorax): Mediastinum - Unspecified"
            }
          ]
        },
        {
          "code" : "7.7",
          "display" : "Chest (thorax): Thymus",
          "concept" : [
            {
              "code" : "7.7.R",
              "display" : "Chest (thorax): Thymus (right)"
            },
            {
              "code" : "7.7.L",
              "display" : "Chest (thorax): Thymus (left)"
            },
            {
              "code" : "7.7.B",
              "display" : "Chest (thorax): Thymus (bilateral)"
            }
          ]
        },
        {
          "code" : "7.8",
          "display" : "Chest (thorax): Oesophagus"
        },
        {
          "code" : "7.9",
          "display" : "Chest (thorax): Trachea"
        },
        {
          "code" : "7.10",
          "display" : "Chest (thorax): Carina"
        },
        {
          "code" : "7.11",
          "display" : "Chest (thorax): Lung",
          "concept" : [
            {
              "code" : "7.11.R",
              "display" : "Chest (thorax): Lung (right)"
            },
            {
              "code" : "7.11.L",
              "display" : "Chest (thorax): Lung (left)"
            },
            {
              "code" : "7.11.B",
              "display" : "Chest (thorax): Lung (bilateral)"
            },
            {
              "code" : "7.11.1",
              "display" : "Chest (thorax): Lung - Whole lung"
            },
            {
              "code" : "7.11.2",
              "display" : "Chest (thorax): Lung - Lung upper zone",
              "concept" : [
                {
                  "code" : "7.11.2.R",
                  "display" : "Chest (thorax): Lung - Lung upper zone (right)"
                },
                {
                  "code" : "7.11.2.L",
                  "display" : "Chest (thorax): Lung - Lung upper zone (left)"
                },
                {
                  "code" : "7.11.2.B",
                  "display" : "Chest (thorax): Lung - Lung upper zone (bilateral)"
                }
              ]
            },
            {
              "code" : "7.11.3",
              "display" : "Chest (thorax): Lung - Lung mid zone",
              "concept" : [
                {
                  "code" : "7.11.3.R",
                  "display" : "Chest (thorax): Lung - Lung mid zone (right)"
                },
                {
                  "code" : "7.11.3.L",
                  "display" : "Chest (thorax): Lung - Lung mid zone (left)"
                },
                {
                  "code" : "7.11.3.B",
                  "display" : "Chest (thorax): Lung - Lung mid zone (bilateral)"
                }
              ]
            },
            {
              "code" : "7.11.4",
              "display" : "Chest (thorax): Lung - Lung lower zone",
              "concept" : [
                {
                  "code" : "7.11.4.R",
                  "display" : "Chest (thorax): Lung - Lung lower zone (right)"
                },
                {
                  "code" : "7.11.4.L",
                  "display" : "Chest (thorax): Lung - Lung lower zone (left)"
                },
                {
                  "code" : "7.11.4.B",
                  "display" : "Chest (thorax): Lung - Lung lower zone (bilateral)"
                }
              ]
            },
            {
              "code" : "7.11.5",
              "display" : "Chest (thorax): Lung - Lung hilum",
              "concept" : [
                {
                  "code" : "7.11.5.R",
                  "display" : "Chest (thorax): Lung - Lung hilum (right)"
                },
                {
                  "code" : "7.11.5.L",
                  "display" : "Chest (thorax): Lung - Lung hilum (left)"
                },
                {
                  "code" : "7.11.5.B",
                  "display" : "Chest (thorax): Lung - Lung hilum (bilateral)"
                }
              ]
            },
            {
              "code" : "7.11.98",
              "display" : "Chest (thorax): Lung - Lung other specified"
            },
            {
              "code" : "7.11.99",
              "display" : "Chest (thorax): Lung - Lung unspecified"
            }
          ]
        },
        {
          "code" : "7.12",
          "display" : "Chest (thorax): Heart",
          "concept" : [
            {
              "code" : "7.12.1",
              "display" : "Chest (thorax): Heart - Whole heart"
            },
            {
              "code" : "7.12.2",
              "display" : "Chest (thorax): Heart - Left ventricle of heart"
            },
            {
              "code" : "7.12.3",
              "display" : "Chest (thorax): Heart - Right ventricle of heart"
            },
            {
              "code" : "7.12.4",
              "display" : "Chest (thorax): Heart - Left atrium of heart,"
            },
            {
              "code" : "7.12.5",
              "display" : "Chest (thorax): Heart - Right atrium of heart"
            },
            {
              "code" : "7.12.6",
              "display" : "Chest (thorax): Heart - Pericardium"
            }
          ]
        },
        {
          "code" : "7.13",
          "display" : "Chest (thorax): Breast",
          "concept" : [
            {
              "code" : "7.13.R",
              "display" : "Chest (thorax): Breast (right)"
            },
            {
              "code" : "7.13.L",
              "display" : "Chest (thorax): Breast (left)"
            },
            {
              "code" : "7.13.B",
              "display" : "Chest (thorax): Breast (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.1",
          "display" : "Chest (thorax): Breast - Whole Breast"
        },
        {
          "code" : "7.13.2",
          "display" : "Chest (thorax): Breast - Nipple",
          "concept" : [
            {
              "code" : "7.13.2.R",
              "display" : "Chest (thorax): Breast - Nipple (right)"
            },
            {
              "code" : "7.13.2.L",
              "display" : "Chest (thorax): Breast - Nipple (left)"
            },
            {
              "code" : "7.13.2.B",
              "display" : "Chest (thorax): Breast - Nipple (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.3",
          "display" : "Chest (thorax): Breast - Areola",
          "concept" : [
            {
              "code" : "7.13.3.R",
              "display" : "Chest (thorax): Breast - Areola (right)"
            },
            {
              "code" : "7.13.3.L",
              "display" : "Chest (thorax): Breast - Areola (left)"
            },
            {
              "code" : "7.13.3.B",
              "display" : "Chest (thorax): Breast - Areola (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.4",
          "display" : "Chest (thorax): Breast - Breast bud (in male or prepubertal female)",
          "concept" : [
            {
              "code" : "7.13.4.R",
              "display" : "Chest (thorax): Breast - Breast bud (in male or prepubertal female) (right)"
            },
            {
              "code" : "7.13.4.L",
              "display" : "Chest (thorax): Breast - Breast bud (in male or prepubertal female) (left)"
            },
            {
              "code" : "7.13.4.B",
              "display" : "Chest (thorax): Breast - Breast bud (in male or prepubertal female) (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.5",
          "display" : "Chest (thorax): Breast - Upper outer quadrant",
          "concept" : [
            {
              "code" : "7.13.5.R",
              "display" : "Chest (thorax): Breast - Upper outer quadrant (right)"
            },
            {
              "code" : "7.13.5.L",
              "display" : "Chest (thorax): Breast - Upper outer quadrant (left)"
            },
            {
              "code" : "7.13.5.B",
              "display" : "Chest (thorax): Breast - Upper outer quadrant (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.6",
          "display" : "Chest (thorax): Breast - Upper inner quadrant",
          "concept" : [
            {
              "code" : "7.13.6.R",
              "display" : "Chest (thorax): Breast - Upper inner quadrant (right)"
            },
            {
              "code" : "7.13.6.L",
              "display" : "Chest (thorax): Breast - Upper inner quadrant (left)"
            },
            {
              "code" : "7.13.6.B",
              "display" : "Chest (thorax): Breast - Upper inner quadrant (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.7",
          "display" : "Chest (thorax): Breast - Lower outer quadrant",
          "concept" : [
            {
              "code" : "7.13.7.R",
              "display" : "Chest (thorax): Breast - Lower outer quadrant (right)"
            },
            {
              "code" : "7.13.7.L",
              "display" : "Chest (thorax): Breast - Lower outer quadrant (left)"
            },
            {
              "code" : "7.13.7.B",
              "display" : "Chest (thorax): Breast - Lower outer quadrant (bilateral)"
            }
          ]
        },
        {
          "code" : "7.13.8",
          "display" : "Chest (thorax): Breast - Lower inner quadrant",
          "concept" : [
            {
              "code" : "7.13.8.R",
              "display" : "Chest (thorax): Breast - Lower inner quadrant (right)"
            },
            {
              "code" : "7.13.8.L",
              "display" : "Chest (thorax): Breast - Lower inner quadrant (left)"
            },
            {
              "code" : "7.13.8.B",
              "display" : "Chest (thorax): Breast - Lower inner quadrant (bilateral)"
            }
          ]
        },
        {
          "code" : "7.14",
          "display" : "Chest (thorax): Aorta",
          "concept" : [
            {
              "code" : "7.14.1",
              "display" : "Chest (thorax): Aorta - Whole aorta above diaphragm"
            },
            {
              "code" : "7.14.2",
              "display" : "Chest (thorax): Aorta - Ascending aorta"
            },
            {
              "code" : "7.14.3",
              "display" : "Chest (thorax): Aorta - Arch of aorta"
            },
            {
              "code" : "7.14.4",
              "display" : "Chest (thorax): Aorta - Descending aorta above diaphragm"
            },
            {
              "code" : "7.15",
              "display" : "Chest (thorax): Axilla",
              "concept" : [
                {
                  "code" : "7.15.R",
                  "display" : "Chest (thorax): Axilla (right)"
                },
                {
                  "code" : "7.15.L",
                  "display" : "Chest (thorax): Axilla (left)"
                },
                {
                  "code" : "7.15.B",
                  "display" : "Chest (thorax): Axilla (bilateral)"
                }
              ]
            }
          ]
        },
        {
          "code" : "7.16",
          "display" : "Chest (thorax): Paraspinal",
          "concept" : [
            {
              "code" : "7.16.R",
              "display" : "Chest (thorax): Paraspinal (right)"
            },
            {
              "code" : "7.16.L",
              "display" : "Chest (thorax): Paraspinal (left)"
            },
            {
              "code" : "7.16.B",
              "display" : "Chest (thorax): Paraspinal (bilateral)"
            },
            {
              "code" : "7.16.1",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "7.16.2",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "7.16.3",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "7.16.4",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "7.16.5",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "7.16.6",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "7.16.7",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "7.16.8",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "7.16.9",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "7.16.10",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "7.16.11",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "7.16.12",
              "display" : "Chest (thorax): Paraspinal - Thoracic / dorsal vertebra 12"
            }
          ]
        },
        {
          "code" : "7.17",
          "display" : "Chest (thorax): Axillary nodes",
          "concept" : [
            {
              "code" : "7.17.R",
              "display" : "Chest (thorax): Axillary nodes (right)"
            },
            {
              "code" : "7.17.L",
              "display" : "Chest (thorax): Axillary nodes (left)"
            },
            {
              "code" : "7.17.B",
              "display" : "Chest (thorax): Axillary nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "7.98",
          "display" : "Chest (thorax): Other specified"
        },
        {
          "code" : "7.99",
          "display" : "Chest (thorax): Unspecified"
        }
      ]
    },
    {
      "code" : "8",
      "display" : "Thoraco-Abdominal (area)",
      "concept" : [
        {
          "code" : "8.1",
          "display" : "Thoraco-Abdominal (area): Paraspinal",
          "concept" : [
            {
              "code" : "8.1.R",
              "display" : "Thoraco-Abdominal (area): Paraspinal (right)"
            },
            {
              "code" : "8.1.L",
              "display" : "Thoraco-Abdominal (area): Paraspinal (left)"
            },
            {
              "code" : "8.1.B",
              "display" : "Thoraco-Abdominal (area): Paraspinal (bilateral)"
            },
            {
              "code" : "8.1.1",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 1"
            },
            {
              "code" : "8.1.2",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 2"
            },
            {
              "code" : "8.1.3",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 3"
            },
            {
              "code" : "8.1.4",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 4"
            },
            {
              "code" : "8.1.5",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 5"
            },
            {
              "code" : "8.1.6",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 6"
            },
            {
              "code" : "8.1.7",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 7"
            },
            {
              "code" : "8.1.8",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 8"
            },
            {
              "code" : "8.1.9",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 9"
            },
            {
              "code" : "8.1.10",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 10"
            },
            {
              "code" : "8.1.11",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 11"
            },
            {
              "code" : "8.1.12",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Thoracic / dorsal vertebra 12"
            },
            {
              "code" : "8.1.13",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 1"
            },
            {
              "code" : "8.1.14",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 2"
            },
            {
              "code" : "8.1.15",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 3"
            },
            {
              "code" : "8.1.16",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 4"
            },
            {
              "code" : "8.1.17",
              "display" : "Thoraco-Abdominal (area): Paraspinal - Lumbar vertebra 5"
            }
          ]
        },
        {
          "code" : "8.98",
          "display" : "Thoraco-Abdominal (area): Other specified"
        },
        {
          "code" : "8.99",
          "display" : "Thoraco-Abdominal (area): Unspecified"
        }
      ]
    },
    {
      "code" : "9",
      "display" : "Abdomen",
      "concept" : [
        {
          "code" : "9.1",
          "display" : "Abdomen: Whole (upper) abdomen (diaphragm to iliac crests)"
        },
        {
          "code" : "9.2",
          "display" : "Abdomen: Upper quadrant",
          "concept" : [
            {
              "code" : "9.2.R",
              "display" : "Abdomen: Upper quadrant (right)"
            },
            {
              "code" : "9.2.L",
              "display" : "Abdomen: Upper quadrant (left)"
            }
          ]
        },
        {
          "code" : "9.3",
          "display" : "Abdomen: Flank / hemiabdomen (top of diaphragm to iliac crest)",
          "concept" : [
            {
              "code" : "9.3.R",
              "display" : "Abdomen: Flank / hemiabdomen (top of diaphragm to iliac crest) (right)"
            },
            {
              "code" : "9.3.L",
              "display" : "Abdomen: Flank / hemiabdomen (top of diaphragm to iliac crest) (left)"
            }
          ]
        },
        {
          "code" : "9.4",
          "display" : "Abdomen: Kidney",
          "concept" : [
            {
              "code" : "9.4.R",
              "display" : "Abdomen: Kidney (right)"
            },
            {
              "code" : "9.4.L",
              "display" : "Abdomen: Kidney (left)"
            },
            {
              "code" : "9.4.B",
              "display" : "Abdomen: Kidney (bilateral)"
            }
          ]
        },
        {
          "code" : "9.5",
          "display" : "Abdomen: Liver",
          "concept" : [
            {
              "code" : "9.5.1",
              "display" : "Abdomen: Liver - Whole liver"
            },
            {
              "code" : "9.5.2",
              "display" : "Abdomen: Liver - Right lobe"
            },
            {
              "code" : "9.5.3",
              "display" : "Abdomen: Liver - Left lobe"
            }
          ]
        },
        {
          "code" : "9.6",
          "display" : "Abdomen: Spleen"
        },
        {
          "code" : "9.7",
          "display" : "Abdomen: Paraaortic area/nodes",
          "concept" : [
            {
              "code" : "9.7.R",
              "display" : "Abdomen: Paraaortic area/nodes (right)"
            },
            {
              "code" : "9.7.L",
              "display" : "Abdomen: Paraaortic area/nodes (left)"
            },
            {
              "code" : "9.7.B",
              "display" : "Abdomen: Paraaortic area/nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "9.8",
          "display" : "Abdomen: Descending aorta below diaphragm"
        },
        {
          "code" : "9.9",
          "display" : "Abdomen: Paraspinal",
          "concept" : [
            {
              "code" : "9.9.R",
              "display" : "Abdomen: Paraspinal (right)"
            },
            {
              "code" : "9.9.L",
              "display" : "Abdomen: Paraspinal (left)"
            },
            {
              "code" : "9.9.B",
              "display" : "Abdomen: Paraspinal (bilateral)"
            },
            {
              "code" : "9.9.1",
              "display" : "Abdomen: Paraspinal - Lumbar vertebra 1"
            },
            {
              "code" : "9.9.2",
              "display" : "Abdomen: Paraspinal - Lumbar vertebra 2"
            },
            {
              "code" : "9.9.3",
              "display" : "Abdomen: Paraspinal - Lumbar vertebra 3"
            },
            {
              "code" : "9.9.4",
              "display" : "Abdomen: Paraspinal - Lumbar vertebra 4"
            },
            {
              "code" : "9.9.5",
              "display" : "Abdomen: Paraspinal - Lumbar vertebra 5"
            }
          ]
        },
        {
          "code" : "9.98",
          "display" : "Abdomen: Other specified"
        },
        {
          "code" : "9.99",
          "display" : "Abdomen: Unspecified"
        }
      ]
    },
    {
      "code" : "10",
      "display" : "Abdomino-Pelvic (area)",
      "concept" : [
        {
          "code" : "10.1",
          "display" : "Abdomino-Pelvic (area): Whole abdomiopelvic field; (top of diaphragm to inferior pubis)"
        },
        {
          "code" : "10.2",
          "display" : "Abdomino-Pelvic (area): Flank / hemiabdomen; (top of diaphragm to inferior pubis)"
        },
        {
          "code" : "10.3",
          "display" : "Abdomino-Pelvic (area): Paraspinal",
          "concept" : [
            {
              "code" : "10.3.R",
              "display" : "Abdomino-Pelvic (area): Paraspinal (right)"
            },
            {
              "code" : "10.3.L",
              "display" : "Abdomino-Pelvic (area): Paraspinal (left)"
            },
            {
              "code" : "10.3.B",
              "display" : "Abdomino-Pelvic (area): Paraspinal (bilateral)"
            },
            {
              "code" : "10.3.1",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Lumbar vertebra 1"
            },
            {
              "code" : "10.3.2",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Lumbar vertebra 2"
            },
            {
              "code" : "10.3.3",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Lumbar vertebra 3"
            },
            {
              "code" : "10.3.4",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Lumbar vertebra 4"
            },
            {
              "code" : "10.3.5",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Lumbar vertebra 5"
            },
            {
              "code" : "10.3.6",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Sacral vertebra 1"
            },
            {
              "code" : "10.3.7",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Sacral vertebra 2"
            },
            {
              "code" : "10.3.8",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Sacral vertebra 3"
            },
            {
              "code" : "10.3.9",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Sacral vertebra 4"
            },
            {
              "code" : "10.3.10",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Sacral vertebra 5"
            },
            {
              "code" : "10.3.11",
              "display" : "Abdomino-Pelvic (area): Paraspinal - Cocyx"
            }
          ]
        },
        {
          "code" : "10.98",
          "display" : "Abdomino-Pelvic (area): Other specified"
        },
        {
          "code" : "10.99",
          "display" : "Abdomino-Pelvic (area): Unspecified"
        }
      ]
    },
    {
      "code" : "11",
      "display" : "Pelvis",
      "concept" : [
        {
          "code" : "11.1",
          "display" : "Pelvis: Whole Pelvis"
        },
        {
          "code" : "11.2",
          "display" : "Pelvis: Hemi Pelvis",
          "concept" : [
            {
              "code" : "11.2.R",
              "display" : "Pelvis: Hemi Pelvis (right)"
            },
            {
              "code" : "11.2.L",
              "display" : "Pelvis: Hemi Pelvis (left)"
            }
          ]
        },
        {
          "code" : "11.3",
          "display" : "Pelvis: Ovaries",
          "concept" : [
            {
              "code" : "11.3.R",
              "display" : "Pelvis: Ovaries (right)"
            },
            {
              "code" : "11.3.L",
              "display" : "Pelvis: Ovaries (left)"
            },
            {
              "code" : "11.3.B",
              "display" : "Pelvis: Ovaries (bilateral)"
            }
          ]
        },
        {
          "code" : "11.4",
          "display" : "Pelvis: Uterus"
        },
        {
          "code" : "11.5",
          "display" : "Pelvis: Vagina"
        },
        {
          "code" : "11.6",
          "display" : "Pelvis: Prostate"
        },
        {
          "code" : "11.7",
          "display" : "Pelvis: Bladder"
        },
        {
          "code" : "11.8",
          "display" : "Pelvis: Iliac area/nodes",
          "concept" : [
            {
              "code" : "11.8.R",
              "display" : "Pelvis: Iliac area/nodes (right)"
            },
            {
              "code" : "11.8.L",
              "display" : "Pelvis: Iliac area/nodes (left)"
            },
            {
              "code" : "11.8.B",
              "display" : "Pelvis: Iliac area/nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "11.9",
          "display" : "Pelvis: Inguinal area/nodes",
          "concept" : [
            {
              "code" : "11.9.R",
              "display" : "Pelvis: Inguinal area/nodes (right)"
            },
            {
              "code" : "11.9.L",
              "display" : "Pelvis: Inguinal area/nodes (left)"
            },
            {
              "code" : "11.9.B",
              "display" : "Pelvis: Inguinal area/nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "11.10",
          "display" : "Pelvis: Femoral area/nodes",
          "concept" : [
            {
              "code" : "11.10.R",
              "display" : "Pelvis: Femoral area/nodes (right)"
            },
            {
              "code" : "11.10.L",
              "display" : "Pelvis: Femoral area/nodes (left)"
            },
            {
              "code" : "11.10.B",
              "display" : "Pelvis: Femoral area/nodes (bilateral)"
            }
          ]
        },
        {
          "code" : "11.11",
          "display" : "Pelvis: Testicle",
          "concept" : [
            {
              "code" : "11.11.R",
              "display" : "Pelvis: Testicle (right)"
            },
            {
              "code" : "11.11.L",
              "display" : "Pelvis: Testicle (left)"
            },
            {
              "code" : "11.11.B",
              "display" : "Pelvis: Testicle (bilateral)"
            }
          ]
        },
        {
          "code" : "11.98",
          "display" : "Pelvis: Other specified"
        },
        {
          "code" : "11.99",
          "display" : "Pelvis: Unspecified"
        }
      ]
    },
    {
      "code" : "13",
      "display" : "Upper limb",
      "concept" : [
        {
          "code" : "13.1",
          "display" : "Upper limb: Whole upper limb",
          "concept" : [
            {
              "code" : "13.1.R",
              "display" : "Upper limb: Whole upper limb (right)"
            },
            {
              "code" : "13.1.L",
              "display" : "Upper limb: Whole upper limb (left)"
            },
            {
              "code" : "13.1.B",
              "display" : "Upper limb: Whole upper limb (bilateral)"
            }
          ]
        },
        {
          "code" : "13.2",
          "display" : "Upper limb: Shoulder",
          "concept" : [
            {
              "code" : "13.2.R",
              "display" : "Upper limb: Shoulder (right)"
            },
            {
              "code" : "13.2.L",
              "display" : "Upper limb: Shoulder (left)"
            },
            {
              "code" : "13.2.B",
              "display" : "Upper limb: Shoulder (bilateral)"
            }
          ]
        },
        {
          "code" : "13.3",
          "display" : "Upper limb: Arm above elbow",
          "concept" : [
            {
              "code" : "13.3.R",
              "display" : "Upper limb: Arm above elbow (right)"
            },
            {
              "code" : "13.3.L",
              "display" : "Upper limb: Arm above elbow (left)"
            },
            {
              "code" : "13.3.B",
              "display" : "Upper limb: Arm above elbow (bilateral)"
            }
          ]
        },
        {
          "code" : "13.4",
          "display" : "Upper limb: Elbow",
          "concept" : [
            {
              "code" : "13.4.R",
              "display" : "Upper limb: Elbow (right)"
            },
            {
              "code" : "13.4.L",
              "display" : "Upper limb: Elbow (left)"
            },
            {
              "code" : "13.4.B",
              "display" : "Upper limb: Elbow (bilateral)"
            }
          ]
        },
        {
          "code" : "13.5",
          "display" : "Upper limb: Forearm",
          "concept" : [
            {
              "code" : "13.5.R",
              "display" : "Upper limb: Forearm (right)"
            },
            {
              "code" : "13.5.L",
              "display" : "Upper limb: Forearm (left)"
            },
            {
              "code" : "13.5.B",
              "display" : "Upper limb: Forearm (bilateral)"
            }
          ]
        },
        {
          "code" : "13.6",
          "display" : "Upper limb: Wrist",
          "concept" : [
            {
              "code" : "13.6.R",
              "display" : "Upper limb: Wrist (right)"
            },
            {
              "code" : "13.6.L",
              "display" : "Upper limb: Wrist (left)"
            },
            {
              "code" : "13.6.B",
              "display" : "Upper limb: Wrist (bilateral)"
            }
          ]
        },
        {
          "code" : "13.7",
          "display" : "Upper limb: Hand",
          "concept" : [
            {
              "code" : "13.7.R",
              "display" : "Upper limb: Hand (right)"
            },
            {
              "code" : "13.7.L",
              "display" : "Upper limb: Hand (left)"
            },
            {
              "code" : "13.7.B",
              "display" : "Upper limb: Hand (bilateral)"
            }
          ]
        },
        {
          "code" : "13.98",
          "display" : "Upper limb: Other specified"
        },
        {
          "code" : "13.99",
          "display" : "Upper limb: Unspecified"
        }
      ]
    },
    {
      "code" : "14",
      "display" : "Lower limb",
      "concept" : [
        {
          "code" : "14.1",
          "display" : "Lower limb: Whole lower limb",
          "concept" : [
            {
              "code" : "14.1.R",
              "display" : "Lower limb: Whole lower limb (right)"
            },
            {
              "code" : "14.1.L",
              "display" : "Lower limb: Whole lower limb (left)"
            },
            {
              "code" : "14.1.B",
              "display" : "Lower limb: Whole lower limb (bilateral)"
            }
          ]
        },
        {
          "code" : "14.2",
          "display" : "Lower limb: Groin",
          "concept" : [
            {
              "code" : "14.2.R",
              "display" : "Lower limb: Groin (right)"
            },
            {
              "code" : "14.2.L",
              "display" : "Lower limb: Groin (left)"
            },
            {
              "code" : "14.2.B",
              "display" : "Lower limb: Groin (bilateral)"
            }
          ]
        },
        {
          "code" : "14.3",
          "display" : "Lower limb: Leg above the knee",
          "concept" : [
            {
              "code" : "14.3.R",
              "display" : "Lower limb: Leg above the knee (right)"
            },
            {
              "code" : "14.3.L",
              "display" : "Lower limb: Leg above the knee (left)"
            },
            {
              "code" : "14.3.B",
              "display" : "Lower limb: Leg above the knee (bilateral)"
            }
          ]
        },
        {
          "code" : "14.4",
          "display" : "Lower limb: Knee",
          "concept" : [
            {
              "code" : "14.4.R",
              "display" : "Lower limb: Knee (right)"
            },
            {
              "code" : "14.4.L",
              "display" : "Lower limb: Knee (left)"
            },
            {
              "code" : "14.4.B",
              "display" : "Lower limb: Knee (bilateral)"
            }
          ]
        },
        {
          "code" : "14.5",
          "display" : "Lower limb: Leg below the knee",
          "concept" : [
            {
              "code" : "14.5.R",
              "display" : "Lower limb: Leg below the knee (right)"
            },
            {
              "code" : "14.5.L",
              "display" : "Lower limb: Leg below the knee (left)"
            },
            {
              "code" : "14.5.B",
              "display" : "Lower limb: Leg below the knee (bilateral)"
            }
          ]
        },
        {
          "code" : "14.6",
          "display" : "Lower limb: Ankle",
          "concept" : [
            {
              "code" : "14.6.R",
              "display" : "Lower limb: Ankle (right)"
            },
            {
              "code" : "14.6.L",
              "display" : "Lower limb: Ankle (left)"
            },
            {
              "code" : "14.6.B",
              "display" : "Lower limb: Ankle (bilateral)"
            }
          ]
        },
        {
          "code" : "14.7",
          "display" : "Lower limb: Foot",
          "concept" : [
            {
              "code" : "14.7.R",
              "display" : "Lower limb: Foot (right)"
            },
            {
              "code" : "14.7.L",
              "display" : "Lower limb: Foot (left)"
            },
            {
              "code" : "14.7.B",
              "display" : "Lower limb: Foot (bilateral)"
            }
          ]
        },
        {
          "code" : "14.98",
          "display" : "Lower limb: Other specified"
        },
        {
          "code" : "14.99",
          "display" : "Lower limb: Unspecified"
        }
      ]
    },
    {
      "code" : "50",
      "display" : "Special sites",
      "concept" : [
        {
          "code" : "50.50",
          "display" : "Special sites: Total body irradiation (TBI) entire body, includes all radiation sites"
        },
        {
          "code" : "50.51",
          "display" : "Special sites: Upper hemi-body includes all radiation sites above the top of the iliac crests/umbilicus"
        },
        {
          "code" : "50.52",
          "display" : "Special sites: Lower hemi-body includes all radiation sites below the top of the iliac crests/umbilicus"
        },
        {
          "code" : "50.53",
          "display" : "Special sites: Total lymphoid irradiation (TLI) includes mantle and inverted Y + splenic fields"
        },
        {
          "code" : "50.54",
          "display" : "Special sites: Subtotal lymphoid irradiation (STLI) mantle + paraaortic+ splenic fields"
        },
        {
          "code" : "50.55",
          "display" : "Special sites: Extended mantle includes mantle and paraaortic fields"
        },
        {
          "code" : "50.56",
          "display" : "Special sites: Mantle includes bilateral cervical (neck), supraclavicular, mediastinal, hilar and axillary fields"
        },
        {
          "code" : "50.57",
          "display" : "Special sites: Mini-mantle includes bilateral cervical (neck) supraclavicular and axillary fields (excludes mediastinal and lung)"
        },
        {
          "code" : "50.58",
          "display" : "Special sites: Inverted Y includes bilateral paraaortic nodes+ iliac nodes +/- splenic fields"
        },
        {
          "code" : "50.59",
          "display" : "Special sites: Whole Central Nervous System /Cranio-Spinal Irradiation, includes the whole brain and the whole spine"
        }
      ]
    }
  ]
}

```
