# PCSP Code System - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCSP Code System**

## CodeSystem: PCSP Code System 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:CsGenericPcsp |

 
Coded concepts specified by the PancareSurPass Project 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AnnotationTypeVS](ValueSet-annotation-type-vs.md)
* [SctAcuteGvhdGrade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md)
* [SctChronicGvhdGrade](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md)
* [SctGvhdType](ValueSet-vs-Gvhd-type-eu-pcsp.md)
* [ProsthesisTypeVs](ValueSet-vs-ProsthesisType-eu-pcsp.md)
* [BrachytherapyType](ValueSet-vs-brachytherapyType-eu-pcsp.md)
* [DocRefDocType](ValueSet-vs-docref-doctype-eu-pcsp.md)
* [FltPlanType](ValueSet-vs-flt-plan-type-eu-pcsp.md)
* [FromToPosteriorAnteriorVs](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md)
* [RadiotherapyDeviceType](ValueSet-vs-radiotherapyDeviceType-eu-pcsp.md)
* [SctDonorTypeVs](ValueSet-vs-sct-donorType-eu-pcsp.md)
* [SctSourceTypeVs](ValueSet-vs-sct-sourceType-eu-pcsp.md)
* [SctTimingEvent](ValueSet-vs-sct-timing-eu-pcsp.md)
* [ShuntProcedureTypeVs](ValueSet-vs-shuntProcedureType-eu-pcsp.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-generic-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
  "version" : "1.0.0",
  "name" : "CsGenericPcsp",
  "title" : "PCSP Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Coded concepts specified by the PancareSurPass Project",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 50,
  "concept" : [
    {
      "code" : "surpass",
      "display" : "Childhood Cancer Survivor Passport",
      "definition" : "Childhood Cancer Survivor Passport. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-sct",
      "display" : "Stem Cell Transplantation",
      "definition" : "Stem Cell Transplantation section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-rt",
      "display" : "Radiotherapy",
      "definition" : "Radiotherapy section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-otherInfos",
      "display" : "Other Medical Information",
      "definition" : "Other Medical Information section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-suggestion",
      "display" : "Medical Suggestions",
      "definition" : "Medical Suggestions section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-otherConditions",
      "display" : "Other Health Conditions",
      "definition" : "Other Health Conditions section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "section-relapseAfterEOT",
      "display" : "Relapse After EOT",
      "definition" : "Relapse After End of Treatment section. Placeholder waiting for a LOINC code"
    },
    {
      "code" : "nar-chronicCond",
      "display" : "Chronic conditions",
      "definition" : "Chronic conditions"
    },
    {
      "code" : "nar-planNotes",
      "display" : "Plan notes",
      "definition" : "Plan additional notes"
    },
    {
      "code" : "cumulativeDose",
      "display" : "Cumulative dose received by a patient for a specific drug."
    },
    {
      "code" : "orthovoltage",
      "display" : "Orthovoltage",
      "definition" : "Orthovoltage / kilovoltage usually 200 - 300kv X rays/photons"
    },
    {
      "code" : "linac-mv",
      "display" : "Linac MV",
      "definition" : "(Linear Accelerator) megavoltage MV X Rays/photons"
    },
    {
      "code" : "linac-el",
      "display" : "Linac electrons",
      "definition" : "Linac (Linear Accelerator) electrons"
    },
    {
      "code" : "cobalt",
      "display" : "Cobalt MV",
      "definition" : "Cobalt - MV gamma rays / photons"
    },
    {
      "code" : "proton-beam",
      "display" : "Proton Beam",
      "definition" : "Proton Beam"
    },
    {
      "code" : "surface-brachytherapy",
      "display" : "Surface brachytherapy",
      "definition" : "Surface brachytherapy"
    },
    {
      "code" : "interstitial-brachytherapy",
      "display" : "Interstitial brachytherapy",
      "definition" : "Interstitial brachytherapy"
    },
    {
      "code" : "intra-brachytherapy",
      "display" : "Intracavitary or intraluminal brachytherapy",
      "definition" : "Intracavitary or intraluminal brachytherapy"
    },
    {
      "code" : "unk-brachytherapy",
      "display" : "Unknown brachytherapy",
      "definition" : "Unknown brachytherapy"
    },
    {
      "code" : "sht-47020004",
      "display" : "Ventriculoperitoneal shunt",
      "definition" : "Ventriculoperitoneal shunt procedure"
    },
    {
      "code" : "sht-4579008",
      "display" : "Ventriculo-atrial shunt",
      "definition" : "Ventriculo-atrial shunt procedure"
    },
    {
      "code" : "sht-280384000",
      "display" : "Subdural-peritoneal shunt",
      "definition" : "Subdural-peritoneal shunt procedure"
    },
    {
      "code" : "sht-265218003",
      "display" : "Cisternostomy (III ventricule)",
      "definition" : "Cisternostomy (III ventricule)"
    },
    {
      "code" : "sht-other",
      "display" : "Other cerebrovascular shunt procedure",
      "definition" : "Other cerebrovascular shunt procedure"
    },
    {
      "code" : "int-prosthesis",
      "display" : "Internal Prosthesis",
      "definition" : "Internal Prosthesis"
    },
    {
      "code" : "ext-prosthesis",
      "display" : "External Prosthesis",
      "definition" : "External Prosthesis"
    },
    {
      "code" : "sct-matched-related",
      "display" : "matched related",
      "definition" : "matched related, unknown or unspecified"
    },
    {
      "code" : "sct-matched-unrelated",
      "display" : "matched unrelated",
      "definition" : "matched unrelated"
    },
    {
      "code" : "sct-mismatch-related",
      "display" : "mismatch related",
      "definition" : "mismatch related"
    },
    {
      "code" : "sct-mismatch-unrelated",
      "display" : "mismatch unrelated",
      "definition" : "mismatch unrelated"
    },
    {
      "code" : "sct-haplo-identical",
      "display" : "haplo-identical",
      "definition" : "haplo-identical"
    },
    {
      "code" : "sct-matched-related–sibling",
      "display" : "matched related – sibling",
      "definition" : "matched related – sibling"
    },
    {
      "code" : "sct-matched-related–parent",
      "display" : "matched related – parent",
      "definition" : "matched related – parent"
    },
    {
      "code" : "sct-matched-related–other",
      "display" : "matched related – other",
      "definition" : "matched related – other (e.g. cousin)"
    },
    {
      "code" : "sct-pbsc",
      "display" : "PBSC",
      "definition" : "PBSC"
    },
    {
      "code" : "sct-bone-marrow",
      "display" : "Bone marrow",
      "definition" : "Bone marrow"
    },
    {
      "code" : "sct-cord",
      "display" : "Cord",
      "definition" : "Cord"
    },
    {
      "code" : "Gvhd-unk",
      "display" : "Gvhd Unknown",
      "definition" : "It is not known if this patient suffers Gvhd"
    },
    {
      "code" : "Gvhd-acute-1",
      "display" : "Grade 1",
      "definition" : "Acute Gvhd: grade 1"
    },
    {
      "code" : "Gvhd-acute-2",
      "display" : "Grade 2",
      "definition" : "Acute Gvhd: grade 2"
    },
    {
      "code" : "Gvhd-acute-3",
      "display" : "Grade 3",
      "definition" : "Acute Gvhd: grade 3"
    },
    {
      "code" : "Gvhd-acute-4",
      "display" : "Grade 4",
      "definition" : "Acute Gvhd: grade 4"
    },
    {
      "code" : "Gvhd-chr-1",
      "display" : "Limited",
      "definition" : "Chronic Gvhd: grade 1 limited"
    },
    {
      "code" : "Gvhd-chr-2",
      "display" : "Extensive",
      "definition" : "Chronic Gvhd: grade 2 extensive"
    },
    {
      "code" : "before-procedure",
      "display" : "Before procedure",
      "definition" : "Before procedure"
    },
    {
      "code" : "after-procedure",
      "display" : "After procedure",
      "definition" : "After procedure"
    },
    {
      "code" : "personalized-plan",
      "display" : "Personalized",
      "definition" : "Personalized Plan"
    },
    {
      "code" : "guidelines-plan",
      "display" : "Guidelines",
      "definition" : "Plan based on guidelines"
    },
    {
      "code" : "to-structure",
      "display" : "To-Structure",
      "definition" : "To-Structure"
    },
    {
      "code" : "other-treatment",
      "display" : "Other oncological treatments",
      "definition" : "Any other treatment (not included in the chemotherapy, surgery or radiotherapy sections) was adminstered to the survivor"
    }
  ]
}

```
