# Austria - Bundle: Example of a Childhood Cancer Survivor Passport - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Austria - Bundle: Example of a Childhood Cancer Survivor Passport**

## Example Bundle: Austria - Bundle: Example of a Childhood Cancer Survivor Passport

**Document Details**

Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)

Preliminary Document at 2025-06-11 07:41:51+0000 by Identifier: test for [Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)](Bundle-54.md#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107) 

-------

**Document Subject**

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)

-------

-------

**Document Content**

## FLT 1

Primary Cancer ...

### Major Surgery

Major Surgery ...

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107

Resource Patient:

> 

Profile: [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md)

Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)
-------

-------

Entry 3 - fullUrl = urn:uuid:64c55208-f9d4-45d1-a4fa-2ce338630536

Resource Condition:

> 

Profile: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md)

**Condition Asserted Date**: 2005-01-01**Histology-Morphology-Behavior Extension**:Zentrales Osteosarkom o.n.A.**identifier**:`http://fhir.ehealth-systems.at/identifier/supaapp/primary-cancer-condition`/1**code**:un-encoded**bodySite**:Bone and articular cartilage, unspecified**subject**:[Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)](Bundle-54.md#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107)**encounter**:[Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2005-01-02 --> (ongoing)](Bundle-54.md#urn-uuid-5785bf99-8454-4bbe-924b-4433e638d075)
> **evidence**

> **evidence**

> **evidence**

-------

Entry 4 - fullUrl = urn:uuid:1613689f-5599-4210-b9ff-ae26be3f7f19

Resource Observation:

> 

Profile: [Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md)

**status**: Final**code**:Diagnosis**subject**:[Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)](Bundle-54.md#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107)**effective**: 2005-01-01**performer**:[Organization St Anna Kinderspital](Bundle-54.md#urn-uuid-57aa2be0-d267-4e5c-a88b-aa14921c35f0)**value**:Zentrales Osteosarkom o.n.A.

-------

Entry 5 - fullUrl = urn:uuid:57aa2be0-d267-4e5c-a88b-aa14921c35f0

Resource Organization:

> 

Profile: [Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md)

**name**: St Anna Kinderspital

### Contacts

| | |
| :--- | :--- |
| - | **Address** |
| * | Wien Österreich |


-------

Entry 6 - fullUrl = urn:uuid:2b20ecab-3277-4c53-b681-156042cc36e8

Resource Organization:

> 

Profile: [Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md)

**name**: St Anna Kinderspital

### Contacts

| | |
| :--- | :--- |
| - | **Address** |
| * | Wien Österreich |


-------

Entry 7 - fullUrl = urn:uuid:5785bf99-8454-4bbe-924b-4433e638d075

Resource Encounter:

> 

Profile: [Encounter: Treatment Center](StructureDefinition-Encounter-eu-pcsp.md)

**status**: completed**class**:ambulatory**serviceProvider**:[Organization St Anna Kinderspital](Bundle-54.md#urn-uuid-2b20ecab-3277-4c53-b681-156042cc36e8)

-------

Entry 8 - fullUrl = urn:uuid:ccb9f2df-2879-4df2-b5c3-027a56151849

Resource Observation:

> 

Profile: [Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md)

**status**: Final**code**:Genetic predisposition**subject**:[Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)](Bundle-54.md#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107)**value**:Hereditary retinoblastoma

-------

Entry 9 - fullUrl = urn:uuid:a2d6d445-41e3-437d-8422-307a40e35329

Resource Procedure:

> 

Profile: [Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md)

**instantiatesCanonical**:`https://fhir.ehealth-systems.at/PlanDefinition/supa-1f7dc934-fb28-43b7-bbc9-952d4af3d0b6`**status**: Completed**category**:First line treatment**subject**:[Test Patient Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)](Bundle-54.md#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107)**outcome**:Inactive

-------

Entry 10 - fullUrl = urn:uuid:567cd26b-ab14-490c-8d51-256edb3ff940

Resource Procedure:

> prox. Tibiaresektion links



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "54",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Bundle-eu-pcsp"
    ]
  },
  "identifier" : {
    "system" : "http://fhir.ehealth-systems.at/identifier/pcsp-bundle",
    "value" : "b32a66ac5fed32e4d8670ba71d8191c24c3bcd63"
  },
  "type" : "document",
  "timestamp" : "2025-06-11T07:41:51.868411+00:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:1cd43b1c-a24f-4118-b351-70c9d904252f",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "composition",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Composition-surpass-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_composition\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition composition</b></p><a name=\"composition\"> </a><a name=\"hccomposition\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Composition-surpass-eu-pcsp.html\">Composition: Survivor Passport</a></p></div><p><b>status</b>: Preliminary</p><p><b>type</b>: <span title=\"Codes:{http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp surpass}\">Childhood Cancer Survivor Passport</span></p><p><b>date</b>: 2025-06-11 07:41:51+0000</p><p><b>author</b>: Identifier: test</p><p><b>title</b>: Childhood Cancer Survivor Passport</p></div>"
        },
        "status" : "preliminary",
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
              "code" : "surpass"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "date" : "2025-06-11T07:41:51.417033+00:00",
        "author" : [
          {
            "identifier" : {
              "value" : "test"
            }
          }
        ],
        "title" : "Childhood Cancer Survivor Passport",
        "section" : [
          {
            "title" : "FLT 1",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "72135-7"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Primary Cancer ...</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:64c55208-f9d4-45d1-a4fa-2ce338630536"
              },
              {
                "reference" : "urn:uuid:a2d6d445-41e3-437d-8422-307a40e35329"
              }
            ],
            "section" : [
              {
                "title" : "Major Surgery",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "8690-0"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Major Surgery ...</p></div>"
                },
                "entry" : [
                  {
                    "reference" : "urn:uuid:567cd26b-ab14-490c-8d51-256edb3ff940"
                  }
                ]
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "new-patient",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_new-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient new-patient</b></p><a name=\"new-patient\"> </a><a name=\"hcnew-patient\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Patient-eu-pcsp.html\">Patient: PCSP</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Test Patient  Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>http://fhir.ehealth-systems.at/identifier/patients/supa-transaction-id</code>/22e6e42b0babdd4226a0 (use: temp, )</td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "temp",
            "system" : "http://fhir.ehealth-systems.at/identifier/patients/supa-transaction-id",
            "value" : "22e6e42b0babdd4226a0"
          },
          {
            "system" : "https://fhir.ehealth-systems.at/kiola/identifier/subject",
            "value" : "k3TaRUeHagAVTwTVZTgvm5"
          }
        ],
        "name" : [
          {
            "family" : "Patient",
            "given" : ["Test"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1995-01-01"
      }
    },
    {
      "fullUrl" : "urn:uuid:64c55208-f9d4-45d1-a4fa-2ce338630536",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "primary-cancer-condition-1-0",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_primary-cancer-condition-1-0\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition primary-cancer-condition-1-0</b></p><a name=\"primary-cancer-condition-1-0\"> </a><a name=\"hcprimary-cancer-condition-1-0\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Condition-primaryCancer-eu-pcsp.html\">Condition: Primary Cancer</a></p></div><p><b>Condition Asserted Date</b>: 2005-01-01</p><p><b>Histology-Morphology-Behavior Extension</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/icd-o-3 9186/3}\">Zentrales Osteosarkom o.n.A.</span></p><p><b>identifier</b>: <code>http://fhir.ehealth-systems.at/identifier/supaapp/primary-cancer-condition</code>/1</p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-NullFlavor UNC}\">un-encoded</span></p><p><b>bodySite</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10 C41.9}\">Bone and articular cartilage, unspecified</span></p><p><b>subject</b>: <a href=\"Bundle-54.html#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107\">Test Patient  Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)</a></p><p><b>encounter</b>: <a href=\"Bundle-54.html#urn-uuid-5785bf99-8454-4bbe-924b-4433e638d075\">Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2005-01-02 --&gt; (ongoing)</a></p><blockquote><p><b>evidence</b></p><p><b>detail</b>: <a href=\"Bundle-54.html#urn-uuid-1613689f-5599-4210-b9ff-ae26be3f7f19\">Observation Diagnosis</a></p></blockquote><blockquote><p><b>evidence</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 32895009}\">Hereditary disease</span></p><p><b>detail</b>: <a href=\"Bundle-54.html#urn-uuid-ccb9f2df-2879-4df2-b5c3-027a56151849\">Observation Genetic predisposition</a></p></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
            "valueDateTime" : "2005-01-01"
          },
          {
            "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
                  "code" : "9186/3",
                  "display" : "Zentrales Osteosarkom o.n.A."
                }
              ]
            }
          }
        ],
        "identifier" : [
          {
            "system" : "http://fhir.ehealth-systems.at/identifier/supaapp/primary-cancer-condition",
            "value" : "1"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "UNC",
              "display" : "un-encoded"
            }
          ]
        },
        "bodySite" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
                      "code" : "not-applicable",
                      "display" : "Not Applicable"
                    }
                  ]
                }
              }
            ],
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/sid/icd-10",
                "code" : "C41.9",
                "display" : "Bone and articular cartilage, unspecified"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "encounter" : {
          "reference" : "urn:uuid:5785bf99-8454-4bbe-924b-4433e638d075"
        },
        "evidence" : [
          {
            "detail" : [
              {
                "reference" : "urn:uuid:1613689f-5599-4210-b9ff-ae26be3f7f19"
              }
            ]
          },
          {
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "32895009",
                    "display" : "Hereditary disease"
                  }
                ]
              }
            ],
            "detail" : [
              {
                "reference" : "urn:uuid:ccb9f2df-2879-4df2-b5c3-027a56151849"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:1613689f-5599-4210-b9ff-ae26be3f7f19",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "diagnosis-observation-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_diagnosis-observation-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation diagnosis-observation-1</b></p><a name=\"diagnosis-observation-1\"> </a><a name=\"hcdiagnosis-observation-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-diagnosis-eu-pcsp.html\">Observation: Diagnosis details</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 29308-4}\">Diagnosis</span></p><p><b>subject</b>: <a href=\"Bundle-54.html#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107\">Test Patient  Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)</a></p><p><b>effective</b>: 2005-01-01</p><p><b>performer</b>: <a href=\"Bundle-54.html#urn-uuid-57aa2be0-d267-4e5c-a88b-aa14921c35f0\">Organization St Anna Kinderspital</a></p><p><b>value</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/icd-o-3 9186/3}\">Zentrales Osteosarkom o.n.A.</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29308-4",
              "display" : "Diagnosis"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "effectiveDateTime" : "2005-01-01",
        "performer" : [
          {
            "reference" : "urn:uuid:57aa2be0-d267-4e5c-a88b-aa14921c35f0"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/icd-o-3",
              "code" : "9186/3",
              "display" : "Zentrales Osteosarkom o.n.A."
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:57aa2be0-d267-4e5c-a88b-aa14921c35f0",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "diagnosis-organization-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_diagnosis-organization-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization diagnosis-organization-1</b></p><a name=\"diagnosis-organization-1\"> </a><a name=\"hcdiagnosis-organization-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Organization-center-eu-pcsp.html\">Organization: Primary Treatment Center / Center of diagnosis</a></p></div><p><b>name</b>: St Anna Kinderspital</p><p><b>address</b>: Wien Österreich </p></div>"
        },
        "name" : "St Anna Kinderspital",
        "address" : [
          {
            "city" : "Wien",
            "country" : "Österreich"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:2b20ecab-3277-4c53-b681-156042cc36e8",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "treatment-organization-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Organization-center-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_treatment-organization-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization treatment-organization-1</b></p><a name=\"treatment-organization-1\"> </a><a name=\"hctreatment-organization-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Organization-center-eu-pcsp.html\">Organization: Primary Treatment Center / Center of diagnosis</a></p></div><p><b>name</b>: St Anna Kinderspital</p><p><b>address</b>: Wien Österreich </p></div>"
        },
        "name" : "St Anna Kinderspital",
        "address" : [
          {
            "city" : "Wien",
            "country" : "Österreich"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:5785bf99-8454-4bbe-924b-4433e638d075",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "diagnosis-encounter-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_diagnosis-encounter-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter diagnosis-encounter-1</b></p><a name=\"diagnosis-encounter-1\"> </a><a name=\"hcdiagnosis-encounter-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Encounter-eu-pcsp.html\">Encounter: Treatment Center</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode AMB</a>: ambulatory</p><p><b>period</b>: 2005-01-02 --&gt; (ongoing)</p><p><b>serviceProvider</b>: <a href=\"Bundle-54.html#urn-uuid-2b20ecab-3277-4c53-b681-156042cc36e8\">Organization St Anna Kinderspital</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB"
        },
        "period" : {
          "start" : "2005-01-02"
        },
        "serviceProvider" : {
          "reference" : "urn:uuid:2b20ecab-3277-4c53-b681-156042cc36e8"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:ccb9f2df-2879-4df2-b5c3-027a56151849",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "diagnosis-hereditary-predisposition-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-predisposition-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_diagnosis-hereditary-predisposition-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation diagnosis-hereditary-predisposition-1</b></p><a name=\"diagnosis-hereditary-predisposition-1\"> </a><a name=\"hcdiagnosis-hereditary-predisposition-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-predisposition-eu-pcsp.html\">Observation: Hereditary Predisposition</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 47708004}\">Genetic predisposition</span></p><p><b>subject</b>: <a href=\"Bundle-54.html#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107\">Test Patient  Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)</a></p><p><b>value</b>: <span title=\"Codes:{https://www.orpha.net 357027}\">Hereditary retinoblastoma</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "47708004",
              "display" : "Genetic predisposition"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://www.orpha.net",
              "code" : "357027",
              "display" : "Hereditary retinoblastoma"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:a2d6d445-41e3-437d-8422-307a40e35329",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "flt-procecure-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_flt-procecure-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure flt-procecure-1</b></p><a name=\"flt-procecure-1\"> </a><a name=\"hcflt-procecure-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Procedure-flt-eu-pcsp.html\">Procedure: Front Line Treatment</a></p></div><p><b>instantiatesCanonical</b>: <code>https://fhir.ehealth-systems.at/PlanDefinition/supa-1f7dc934-fb28-43b7-bbc9-952d4af3d0b6</code></p><p><b>status</b>: Completed</p><p><b>category</b>: <span title=\"Codes:{http://snomed.info/sct 708255002}\">First line treatment</span></p><p><b>subject</b>: <a href=\"Bundle-54.html#urn-uuid-04394254-c137-4ac6-82a8-c4ad2f973107\">Test Patient  Male, DoB: 1995-01-01 ( https://fhir.ehealth-systems.at/kiola/identifier/subject#k3TaRUeHagAVTwTVZTgvm5)</a></p><p><b>performed</b>: ?? --&gt; 2005-09-01</p><p><b>reasonReference</b>: <a href=\"Bundle-54.html#urn-uuid-64c55208-f9d4-45d1-a4fa-2ce338630536\">Condition un-encoded</a></p><p><b>outcome</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical inactive}\">Inactive</span></p></div>"
        },
        "instantiatesCanonical" : [
          "https://fhir.ehealth-systems.at/PlanDefinition/supa-1f7dc934-fb28-43b7-bbc9-952d4af3d0b6"
        ],
        "status" : "completed",
        "category" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "708255002",
              "display" : "First line treatment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "performedPeriod" : {
          "end" : "2005-09-01"
        },
        "reasonReference" : [
          {
            "reference" : "urn:uuid:64c55208-f9d4-45d1-a4fa-2ce338630536"
          }
        ],
        "outcome" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "inactive",
              "display" : "Inactive"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:567cd26b-ab14-490c-8d51-256edb3ff940",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "surgery-procedure-1-0-1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp"
          ]
        },
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_surgery-procedure-1-0-1\"> </a>prox. Tibiaresektion links</div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "32849002"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "818983003"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "12738006"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "89545001"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "10200004"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "421060004"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "2748008"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "90456006"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "51185008"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "12921003"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "53120007"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/surgery-sacrifiedOrgan",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                  "code" : "OTH",
                  "display" : "Other"
                }
              ],
              "text" : "Tibia"
            }
          }
        ],
        "identifier" : [
          {
            "system" : "http://fhir.ehealth-systems.at/identifier/supaapp/major-surgery",
            "value" : "1"
          }
        ],
        "status" : "completed",
        "category" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "387713003",
              "display" : "Surgical procedure"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:04394254-c137-4ac6-82a8-c4ad2f973107"
        },
        "performedDateTime" : "2005-08-01",
        "reasonReference" : [
          {
            "reference" : "urn:uuid:64c55208-f9d4-45d1-a4fa-2ce338630536"
          }
        ],
        "bodySite" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "61685007",
                "display" : "Lower limb structure"
              }
            ]
          }
        ]
      }
    }
  ]
}

```
