# Home - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/mpd-r5/ImplementationGuide/hl7.fhir.eu.mpd-r5 | *Version*:0.1.0-ci-build |
| Draft as of 2025-11-11 | *Computable Name*:Hl7EuMedPrescriptionDispenseIg |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

The scope of this implementation guide is **Medication Prescription and Dispense** in the **European** Context. It is coherent with the [European eHN Guidelines](https://health.ec.europa.eu/ehealth-digital-health-and-care/key-documents_en) and preparatory EHDS work.

This implementation guide is designed to be a flexible basis for national specifications as well as crossborder services.

Additional information can be found in the [Scope and Content](scope.md) section.

### Purpose

The goal of this Implementation Guide is to define the European standard for Medication Prescriptions and Dispense data to facilitate the harmonization among the national initiatives and prepare the ground for the European EHR eXchange Format (EEHRxF).

This project is the result of a cross SDO collaboration with IHE Pharmacy, realized in collaboration with several other European and national organizations and projects.

The aspiration of this guide is that of being used as part of EEHRxF specifications, providing a base that can be adopted by European national guides as well as by MyHealth@EU for the EU cross-border services.

### Background

Medication Prescription and Dispense FHIR implementation guide is an open collaborative work of several projects and initiatives:

* [**IHE**](https://www.ihe.net/): authoring the global MPD profile
* [**HL7 Europe**](https://www.hl7europe.org/): authoring the EU MPD profile and providing platform for EHDS-related collaboration
* [**Xt-EHR**](https://www.xt-ehr.eu): preparing future EHDS implementing acts (WP 6, Task 6.2 "ePrescription and eDispensation")
* [**xShare**](https://xshare-project.eu): implementing EEHRxF in various adoption sites
* [**XpanDH**](https://xpandh-project.iscte-iul.pt): working on proof of concept on European exchange format (EEHRxF) on FHIR

The working group also includes participants from MyHealth@EU, HL7 Pharmacy, several EHR vendors, plus a variety of interested individuals from over 20 countries. 
 Please refer to the [Authors and Contributors](authors.md) page for additional information.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.eu.mpd-r5",
  "url" : "http://hl7.eu/fhir/mpd-r5/ImplementationGuide/hl7.fhir.eu.mpd-r5",
  "version" : "0.1.0-ci-build",
  "name" : "Hl7EuMedPrescriptionDispenseIg",
  "title" : "HL7 Europe Medication Prescription and Dispense",
  "status" : "draft",
  "date" : "2025-11-11T16:16:55+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This guide describes how to represent in HL7 FHIR Prescription and Dispense in the European context",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "packageId" : "hl7.fhir.eu.mpd-r5",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    },
    {
      "id" : "ihe_pharm_mpd",
      "uri" : "https://profiles.ihe.net/PHARM/MPD/ImplementationGuide/ihe.pharm.mpd",
      "packageId" : "ihe.pharm.mpd",
      "version" : "1.0.0-comment-2"
    },
    {
      "id" : "hl7_fhir_eu_base_r5",
      "uri" : "http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5",
      "packageId" : "hl7.fhir.eu.base-r5",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "hl7_fhir_eu_extensions_r5",
      "uri" : "http://hl7.eu/fhir/extensions",
      "packageId" : "hl7.fhir.eu.extensions.r5",
      "version" : "0.1.1-ballot"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.8.0"
      }
    ],
    "grouping" : [
      {
        "id" : "eHNGuidelines",
        "name" : "Data Sets from eHN Guidelines",
        "description" : "eHealth Network Guidelines data sets represented as FHIR logical models. Please note, that eHN data sets do not have explicit information about cardinality and data types. New, fully machine-readable logical information models are being created in Xt-EHR project. See more information about new EHDS logical models work on [Logical Models page](logicalmodels.html)."
      },
      {
        "id" : "FHIRProfiles",
        "name" : "FHIR Profiles",
        "description" : "Profiles for ePrescription and eDispensation use case. Note that there is no single profile for ePrescription, but only for MedicationRequest, which translates to a single line on a prescription (read more in [Implementation Notes](implementationnotes.html)). Profiles for Patient, PractitionerRole, and Organization are published in HL7 Europe Base IG. All profiles are based on [EHDS logical information models](logicalmodels.html) that are being developed by Xt-EHR project."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01A-Cefuroxime1500GenericExplicit"
        },
        "name" : "01A-Cefuroxime1500GenericExplicit",
        "description" : "1A. Cefuroxime 1500mg (1.5g) powder for solution in a vial. Generic product, defined by attributes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01B-Cefuroxime1500GenericConcept"
        },
        "name" : "01B-Cefuroxime1500GenericConcept",
        "description" : "1B. Cefuroxime 1500mg (1.5g) powder for solution in a vial. Generic product, defined by a code system (receiving system is expected to have access to the code system for additional attributes or display names).",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01C-Cefuroxime1500Branded"
        },
        "name" : "01C-Cefuroxime1500Branded",
        "description" : "1C. Cefuroxime 1500mg (1.5g) powder for solution in a vial. Branded packaged product, defined by attributes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01D-Cefuroxime750Branded"
        },
        "name" : "01D-Cefuroxime750Branded",
        "description" : "1D. Cefuroxime 750mg powder for solution in a vial (5 vials per package). Branded packaged product, defined by attributes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/02A-ClotrimazoleCanifugCremolum"
        },
        "name" : "02A-ClotrimazoleCanifugCremolum",
        "description" : "2A. Clotrimazole cream 10mg/g and 6 pessaries 100g. Branded packaged product, consisting of different medication items. Defined by attributes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/02A1-CanifugCremolumCreamItem"
        },
        "name" : "02A1-CanifugCremolumCreamItem",
        "description" : "2A1. Clotrimazole cream (10mg/g, 1 tube of 20g) as part of Canifug Cremolum product (ISO IDMP manufactured item)",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/02A2-CanifugCremolumPessaryItem"
        },
        "name" : "02A2-CanifugCremolumPessaryItem",
        "description" : "2A2. Clotrimazole pessary (6 pessaries of 100mg) as part of Canifug Cremolum product (ISO IDMP manufactured item)",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/03B-VitaminBComplexBranded"
        },
        "name" : "03B-VitaminBComplexBranded",
        "description" : "3B. Milgamma N, B-vitamin complex. Branded packaged product, defined by attributes.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/04A-FirmagonBranded"
        },
        "name" : "04A-FirmagonBranded",
        "description" : "4A. Firmagon. Branded packaged product, defined by attributes, includes administration devices.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/05A-Tilidin-Branded"
        },
        "name" : "05A-Tilidin-Branded",
        "description" : "5A. Tilidin (50mg), Naloxon (4mg) oral drops. Branded packaged product, defined by attributes. Unusual strength.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/100A-multiitem-prescription-with-orchestration"
        },
        "name" : "100A-multiitem-prescription-with-orchestration",
        "description" : "100A. Multiitem prescription with RequestOrchestration (R4 RequestGroup). 42-day cycle treatment consisting of three medications that should start at the same time. Wrapped in a Bundle for better readability.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RequestOrchestration"
          }
        ],
        "reference" : {
          "reference" : "RequestOrchestration/100B-RequestOrchestration"
        },
        "name" : "100B-RequestOrchestration",
        "description" : "100B. A grouper for the lines of a multiitem prescription. It should not be considered the prescription object as such.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/100C-3-medication-prescription-request1"
        },
        "name" : "100C-3-medication-prescription-request1",
        "description" : "100C-1. A prescription item (MedicationRequest) that is a part of a three-item-prescription (42-day treatment cycle). Generic. Thalidomide 50mgx4 once a day before bed for 42 days.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/100C-3-medication-prescription-request2"
        },
        "name" : "100C-3-medication-prescription-request2",
        "description" : "100C-2. A prescription item (MedicationRequest) that is a part of a three-item-prescription (42-day treatment cycle). Generic. Melphalan 2mgx4 once a day for 4 days in the beginning of cycle.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/100C-3-medication-prescription-request3"
        },
        "name" : "100C-3-medication-prescription-request3",
        "description" : "100C-3. A prescription item (MedicationRequest) that is a part of a three-item-prescription (42-day treatment cycle). Generic. Prednisone 50mgx3 once a day for 4 days in the beginning of cycle.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/200A-multiitem-prescription-without-orchestration"
        },
        "name" : "200A-multiitem-prescription-without-orchestration",
        "description" : "200A. Multiitem prescription where items on the same prescription are not interdependent. Kept together by the same groupIdentifier.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/200C-2-medication-prescription-request1"
        },
        "name" : "200C-2-medication-prescription-request1",
        "description" : "200C-1. A prescription item (MedicationRequest) that is a part of a two-item-prescription.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/200C-2-medication-prescription-request2"
        },
        "name" : "200C-2-medication-prescription-request2",
        "description" : "200C-2. A prescription item (MedicationRequest) that is a part of a two-item-prescription.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/300A-multiitem-prescription-with-orchestration"
        },
        "name" : "300A-multiitem-prescription-with-orchestration",
        "description" : "300A. Multiitem prescription with RequestOrchestration. 2 products dispensable as 1 multiitem product.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RequestOrchestration"
          }
        ],
        "reference" : {
          "reference" : "RequestOrchestration/300B-RequestOrchestration"
        },
        "name" : "300B-RequestOrchestration",
        "description" : "300B. A grouper for the lines of a multiitem prescription.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/300C-2-medication-prescription-request1"
        },
        "name" : "300C-2-medication-prescription-request1",
        "description" : "300C-1. A prescription item (MedicationRequest) that is a part of a two-item-prescription. Clotrimazole pessaries.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/300C-2-medication-prescription-request2"
        },
        "name" : "300C-2-medication-prescription-request2",
        "description" : "300C-2. A prescription item (MedicationRequest) that is a part of a two-item-prescription. Clotrimazole cream.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/300D-dispense-for-2-requests"
        },
        "name" : "300D-dispense-for-2-requests",
        "description" : "300D. Medication dispense dispensing one combination product for two prescribed products (multiitem prescription).",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationDispense-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/400C-prescription-cefuroxime-singleline"
        },
        "name" : "400C-prescription-cefuroxime-singleline",
        "description" : "400C. A prescription/request with one medication and changing dosaging. Uses 'actionable' tag. Cefuroxime sodium.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/400D-dispense-1"
        },
        "name" : "400D-dispense-1",
        "description" : "400D-1. Medication dispense fulfilling the first part of the order: 1 package containing 10 vials",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationDispense-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/400D-dispense-2"
        },
        "name" : "400D-dispense-2",
        "description" : "400D-2. Medication dispense fulfilling the second part of the order: 3 packages containing 5 vials each",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationDispense-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/400E-refused-dispense"
        },
        "name" : "400E-refused-dispense",
        "description" : "400E. Refusal of medication dispense",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationDispense-eu-mpd"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Prescription"
        },
        "name" : "A - Prescription",
        "description" : "Prescription. Several Sections of the eHN guideline.",
        "isExample" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Subject"
        },
        "name" : "A.1.1 Patient administrative data",
        "description" : "Patient. Sections A1.1 of the eHN guideline.",
        "isExample" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicinalProduct"
        },
        "name" : "A1.4 Identification of the prescribed product",
        "description" : "Identification of the prescribed product. Section A1.4 of the eHN guideline",
        "isExample" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Dispensation"
        },
        "name" : "B.1 Dispensation information (provided by the dispensing pharmacy)",
        "description" : "Dispensation information (provided by the dispensing pharmacy). Section B1 of the guidelines",
        "isExample" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "name" : "doctor1",
        "description" : "Dr Meryl Ärztin - clinical oncologist. PractitionerRole resource (practitioner working in a specific organisation).",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Medication-eu-mpd"
        },
        "name" : "Medication: MPD",
        "description" : "This profile defines how to represent Medication data on ePrescription and eDispensation",
        "isExample" : false,
        "groupingId" : "FHIRProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispense-eu-mpd"
        },
        "name" : "MedicationDispense: MPD",
        "description" : "MedicationDispense profile for capturing dispensation information based on a medication prescription.",
        "isExample" : false,
        "groupingId" : "FHIRProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationRequest-eu-mpd"
        },
        "name" : "MedicationRequest: MPD",
        "description" : "This profile defines how to represent ePrescription or other medication request.",
        "isExample" : false,
        "groupingId" : "FHIRProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/organization1"
        },
        "name" : "organization1",
        "description" : "An organization: clinic. Organization resource.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/organization2"
        },
        "name" : "organization2",
        "description" : "An organization: pharmacy. Organization resource.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient1"
        },
        "name" : "patient1",
        "description" : "A patient: Thomas, born 1950. Patient resource.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient2"
        },
        "name" : "patient2",
        "description" : "A patient: Emily, born 1990. Patient resource.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/pharmacist1"
        },
        "name" : "pharmacist1",
        "description" : "Mr Moon Farmatseut - pharmacist. PractitionerRole resource (practitioner working in a specific organisation).",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner1"
        },
        "name" : "practitioner1",
        "description" : "Dr Meryl Ärztin. Practitioner resource (not related to a specific organisation).",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner2"
        },
        "name" : "practitioner2",
        "description" : "Mr Moon Farmatseut. Practitioner resource (not related to a specific organisation).",
        "isExample" : true
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "authors.html",
          "name" : "authors.html",
          "title" : "Authors and Contributors",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "background.html",
          "name" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "challenges.html",
          "name" : "challenges.html",
          "title" : "Challenges",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "copyright.html",
          "name" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "crossversionanalysis.html",
          "name" : "crossversionanalysis.html",
          "title" : "Cross-version Analysis",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "dependencies.html",
          "name" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "designchoices.html",
          "name" : "designchoices.html",
          "title" : "Design Choices",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "examples.html",
          "name" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "implementationnotes.html",
          "name" : "implementationnotes.html",
          "title" : "Implementation Considerations",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "knownissues.html",
          "name" : "knownissues.html",
          "title" : "Known Issues",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "logicalmodels.html",
          "name" : "logicalmodels.html",
          "title" : "Logical Models",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "medicationconcepts.html",
          "name" : "medicationconcepts.html",
          "title" : "Medication Concepts",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "profiles.html",
          "name" : "profiles.html",
          "title" : "Mapping to Profiles",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "references.html",
          "name" : "references.html",
          "title" : "Source and Additional Information",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "scope.html",
          "name" : "scope.html",
          "title" : "Scope and Content",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "terminology.html",
          "name" : "terminology.html",
          "title" : "Terminology Considerations",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "usecases.html",
          "name" : "usecases.html",
          "title" : "Use Cases",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2023+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "ci-build"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "http://hl7.eu/fhir/StructureDefinition/package-type"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://hl7.eu/fhir/mpd-r5/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
