# 100A-multiitem-prescription-with-orchestration - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **100A-multiitem-prescription-with-orchestration**

## Example Bundle: 100A-multiitem-prescription-with-orchestration

Bundle 100A-multiitem-prescription-with-orchestration of type collection

-------

Entry 1 - fullUrl = https://example.com/RequestOrchestration/100B-RequestOrchestration

Resource RequestOrchestration:

> **groupIdentifier**: 100**status**: Active**intent**: Order**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)
> **action****resource**:[MedicationRequest: identifier = 100-1/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03](MedicationRequest-100C-3-medication-prescription-request1.md)

> **action****resource**:[MedicationRequest: identifier = 100-2/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03](MedicationRequest-100C-3-medication-prescription-request2.md)

> **action****resource**:[MedicationRequest: identifier = 100-3/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03](MedicationRequest-100C-3-medication-prescription-request3.md)

-------

Entry 2 - fullUrl = https://example.com/MedicationRequest/100C-3-medication-prescription-request1

Resource MedicationRequest:

> 

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 100-1/3**groupIdentifier**: 100**status**: Active**intent**: Option

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | Thalidomide 50 mg oral capsule |

**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)**authoredOn**: 2024-10-03**requester**:[PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Multiple myeloma |

> **dosageInstruction****timing**: Late Evening, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 4 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-03 --> 2024-12-03 | 1 | 168 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


-------

Entry 3 - fullUrl = https://example.com/MedicationRequest/100C-3-medication-prescription-request2

Resource MedicationRequest:

> 

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 100-2/3**groupIdentifier**: 100**status**: Active**intent**: Option

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | Melphalan 2 mg oral tablet |

**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)**authoredOn**: 2024-10-03**requester**:[PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Multiple myeloma |

> **dosageInstruction****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 4 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-03 --> 2024-12-03 | 1 | 16 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


-------

Entry 4 - fullUrl = https://example.com/MedicationRequest/100C-3-medication-prescription-request3

Resource MedicationRequest:

> 

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 100-3/3**groupIdentifier**: 100**status**: Active**intent**: Option

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | Prednisone 50 mg oral tablet |

**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)**authoredOn**: 2024-10-03**requester**:[PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Multiple myeloma |

> **dosageInstruction****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 3 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-03 --> 2024-12-03 | 1 | 12 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


-------

Entry 5 - fullUrl = https://example.com/PractitionerRole/doctor1

Resource PractitionerRole:

> **practitioner**:[Dr Meryl Ärztin](Practitioner-practitioner1.md)**organization**:[Dr Ärztin Private Practice](Organization-organization1.md)**code**:Clinical oncologist

-------

Entry 6 - fullUrl = https://example.com/Patient/patient1

Resource Patient:

> 

Profile: [Patient (EU core)](http://hl7.eu/fhir/base-r5/0.1.0-ballot/StructureDefinition-patient-eu-core.html)

Thomas Engine Male, DoB: 1950-09-15 ( 12345)
-------



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "100A-multiitem-prescription-with-orchestration",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "https://example.com/RequestOrchestration/100B-RequestOrchestration",
      "resource" : {
        "resourceType" : "RequestOrchestration",
        "id" : "100B-RequestOrchestration",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RequestOrchestration_100B-RequestOrchestration\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RequestOrchestration 100B-RequestOrchestration</b></p><a name=\"100B-RequestOrchestration\"> </a><a name=\"hc100B-RequestOrchestration\"> </a><p><b>groupIdentifier</b>: 100</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><blockquote><p><b>action</b></p><p><b>resource</b>: <a href=\"MedicationRequest-100C-3-medication-prescription-request1.html\">MedicationRequest: identifier = 100-1/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03</a></p></blockquote><blockquote><p><b>action</b></p><p><b>resource</b>: <a href=\"MedicationRequest-100C-3-medication-prescription-request2.html\">MedicationRequest: identifier = 100-2/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03</a></p></blockquote><blockquote><p><b>action</b></p><p><b>resource</b>: <a href=\"MedicationRequest-100C-3-medication-prescription-request3.html\">MedicationRequest: identifier = 100-3/3; groupIdentifier = 100; status = active; intent = option; authoredOn = 2024-10-03</a></p></blockquote></div>"
        },
        "groupIdentifier" : {
          "value" : "100"
        },
        "status" : "active",
        "intent" : "order",
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "action" : [
          {
            "resource" : {
              "reference" : "MedicationRequest/100C-3-medication-prescription-request1"
            }
          },
          {
            "resource" : {
              "reference" : "MedicationRequest/100C-3-medication-prescription-request2"
            }
          },
          {
            "resource" : {
              "reference" : "MedicationRequest/100C-3-medication-prescription-request3"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/MedicationRequest/100C-3-medication-prescription-request1",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "100C-3-medication-prescription-request1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_100C-3-medication-prescription-request1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 100C-3-medication-prescription-request1</b></p><a name=\"100C-3-medication-prescription-request1\"> </a><a name=\"hc100C-3-medication-prescription-request1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 100-1/3</p><p><b>groupIdentifier</b>: 100</p><p><b>status</b>: Active</p><p><b>intent</b>: Option</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 376255008}\">Thalidomide 50 mg oral capsule</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-03</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 109989006}\">Multiple myeloma</span></td></tr></table><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: Late Evening, Once per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>4 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-03 --&gt; 2024-12-03</td><td>1</td><td>168 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "100-1/3"
          }
        ],
        "groupIdentifier" : {
          "value" : "100"
        },
        "status" : "active",
        "intent" : "option",
        "medication" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "376255008",
                "display" : "Thalidomide 50 mg oral capsule"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-03",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reason" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "109989006",
                  "display" : "Multiple myeloma"
                }
              ]
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 42,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["EVE.late"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 4,
                  "unit" : "Tablet",
                  "system" : "http://snomed.info/sct",
                  "code" : "732936001"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-03",
            "end" : "2024-12-03"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 168,
            "unit" : "Tablet",
            "system" : "http://snomed.info/sct",
            "code" : "732936001"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/MedicationRequest/100C-3-medication-prescription-request2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "100C-3-medication-prescription-request2",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_100C-3-medication-prescription-request2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 100C-3-medication-prescription-request2</b></p><a name=\"100C-3-medication-prescription-request2\"> </a><a name=\"hc100C-3-medication-prescription-request2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 100-2/3</p><p><b>groupIdentifier</b>: 100</p><p><b>status</b>: Active</p><p><b>intent</b>: Option</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 326766003}\">Melphalan 2 mg oral tablet</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-03</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 109989006}\">Multiple myeloma</span></td></tr></table><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: Once per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>4 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-03 --&gt; 2024-12-03</td><td>1</td><td>16 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "100-2/3"
          }
        ],
        "groupIdentifier" : {
          "value" : "100"
        },
        "status" : "active",
        "intent" : "option",
        "medication" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "326766003",
                "display" : "Melphalan 2 mg oral tablet"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-03",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reason" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "109989006",
                  "display" : "Multiple myeloma"
                }
              ]
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 4,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 4,
                  "unit" : "Tablet",
                  "system" : "http://snomed.info/sct",
                  "code" : "732936001"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-03",
            "end" : "2024-12-03"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 16,
            "unit" : "Tablet",
            "system" : "http://snomed.info/sct",
            "code" : "732936001"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/MedicationRequest/100C-3-medication-prescription-request3",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "100C-3-medication-prescription-request3",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_100C-3-medication-prescription-request3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 100C-3-medication-prescription-request3</b></p><a name=\"100C-3-medication-prescription-request3\"> </a><a name=\"hc100C-3-medication-prescription-request3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 100-3/3</p><p><b>groupIdentifier</b>: 100</p><p><b>status</b>: Active</p><p><b>intent</b>: Option</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 374072009}\">Prednisone 50 mg oral tablet</span></td></tr></table><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-03</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 109989006}\">Multiple myeloma</span></td></tr></table><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: Once per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>3 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-03 --&gt; 2024-12-03</td><td>1</td><td>12 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code732936001 = 'Tablet (unit of presentation)')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "100-3/3"
          }
        ],
        "groupIdentifier" : {
          "value" : "100"
        },
        "status" : "active",
        "intent" : "option",
        "medication" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "374072009",
                "display" : "Prednisone 50 mg oral tablet"
              }
            ]
          }
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-03",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reason" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "109989006",
                  "display" : "Multiple myeloma"
                }
              ]
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 4,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 3,
                  "unit" : "Tablet",
                  "system" : "http://snomed.info/sct",
                  "code" : "732936001"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-03",
            "end" : "2024-12-03"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 12,
            "unit" : "Tablet",
            "system" : "http://snomed.info/sct",
            "code" : "732936001"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/PractitionerRole/doctor1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "doctor1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_doctor1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole doctor1</b></p><a name=\"doctor1\"> </a><a name=\"hcdoctor1\"> </a><p><b>practitioner</b>: <a href=\"Practitioner-practitioner1.html\">Dr Meryl Ärztin</a></p><p><b>organization</b>: <a href=\"Organization-organization1.html\">Dr Ärztin Private Practice</a></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 309295000}\">Clinical oncologist</span></p></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/practitioner1",
          "display" : "Dr Meryl Ärztin"
        },
        "organization" : {
          "reference" : "Organization/organization1",
          "display" : "Dr Ärztin Private Practice"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "309295000",
                "display" : "Clinical oncologist"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/Patient/patient1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient patient1</b></p><a name=\"patient1\"> </a><a name=\"hcpatient1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.eu/fhir/base-r5/0.1.0-ballot/StructureDefinition-patient-eu-core.html\">Patient (EU core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</p><hr/></div>"
        },
        "identifier" : [
          {
            "value" : "12345"
          }
        ],
        "name" : [
          {
            "family" : "Engine",
            "given" : ["Thomas"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1950-09-15"
      }
    }
  ]
}

```
