# Home - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/mpd-r5/ImplementationGuide/hl7.fhir.eu.mpd-r5 | *Version*:0.1.0-ci-build |
| Draft as of 2025-11-11 | *Computable Name*:Hl7EuMedPrescriptionDispenseIg |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

The scope of this implementation guide is **Medication Prescription and Dispense** in the **European** Context. It is coherent with the [European eHN Guidelines](https://health.ec.europa.eu/ehealth-digital-health-and-care/key-documents_en) and preparatory EHDS work.

This implementation guide is designed to be a flexible basis for national specifications as well as crossborder services.

Additional information can be found in the [Scope and Content](scope.md) section.

### Purpose

The goal of this Implementation Guide is to define the European standard for Medication Prescriptions and Dispense data to facilitate the harmonization among the national initiatives and prepare the ground for the European EHR eXchange Format (EEHRxF).

This project is the result of a cross SDO collaboration with IHE Pharmacy, realized in collaboration with several other European and national organizations and projects.

The aspiration of this guide is that of being used as part of EEHRxF specifications, providing a base that can be adopted by European national guides as well as by MyHealth@EU for the EU cross-border services.

### Background

Medication Prescription and Dispense FHIR implementation guide is an open collaborative work of several projects and initiatives:

* [**IHE**](https://www.ihe.net/): authoring the global MPD profile
* [**HL7 Europe**](https://www.hl7europe.org/): authoring the EU MPD profile and providing platform for EHDS-related collaboration
* [**Xt-EHR**](https://www.xt-ehr.eu): preparing future EHDS implementing acts (WP 6, Task 6.2 "ePrescription and eDispensation")
* [**xShare**](https://xshare-project.eu): implementing EEHRxF in various adoption sites
* [**XpanDH**](https://xpandh-project.iscte-iul.pt): working on proof of concept on European exchange format (EEHRxF) on FHIR

The working group also includes participants from MyHealth@EU, HL7 Pharmacy, several EHR vendors, plus a variety of interested individuals from over 20 countries. 
 Please refer to the [Authors and Contributors](authors.md) page for additional information.

