# 200C-2-medication-prescription-request1 - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **200C-2-medication-prescription-request1**

## Example MedicationRequest: 200C-2-medication-prescription-request1

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 200-1/2

**groupIdentifier**: 200

**status**: Active

**intent**: Order

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | Valacyclovir (as valacyclovir hydrochloride) 500 mg oral tablet |

**subject**: [Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)

**authoredOn**: 2024-10-06

**requester**: [PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Herpes simplex type 1 infection |

> **dosageInstruction****timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-06 --> 2024-12-06 | 1 | 10 Tablet(Details: SNOMED CT code732936001 = 'Tablet (unit of presentation)') |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "200C-2-medication-prescription-request1",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
    ]
  },
  "identifier" : [
    {
      "value" : "200-1/2"
    }
  ],
  "groupIdentifier" : {
    "value" : "200"
  },
  "status" : "active",
  "intent" : "order",
  "medication" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "324821004",
          "display" : "Valacyclovir (as valacyclovir hydrochloride) 500 mg oral tablet"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/patient1"
  },
  "authoredOn" : "2024-10-06",
  "requester" : {
    "reference" : "PractitionerRole/doctor1"
  },
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "407451003",
            "display" : "Herpes simplex type 1 infection"
          }
        ]
      }
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 5,
            "unit" : "day",
            "system" : "http://unitsofmeasure.org",
            "code" : "d"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Tablet",
            "system" : "http://snomed.info/sct",
            "code" : "732936001"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2024-10-06",
      "end" : "2024-12-06"
    },
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 10,
      "unit" : "Tablet",
      "system" : "http://snomed.info/sct",
      "code" : "732936001"
    }
  }
}

```
