# 300A-multiitem-prescription-with-orchestration - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **300A-multiitem-prescription-with-orchestration**

## Example Bundle: 300A-multiitem-prescription-with-orchestration

Bundle 300A-multiitem-prescription-with-orchestration of type collection

-------

Entry 1 - fullUrl = https://example.com/RequestOrchestration/300B-RequestOrchestration

Resource RequestOrchestration:

> **groupIdentifier**: 300**status**: Active**intent**: Order**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)
> **action****resource**:[MedicationRequest: identifier = 300-1/2; groupIdentifier = 300; status = active; intent = option; authoredOn = 2024-10-06](MedicationRequest-300C-2-medication-prescription-request1.md)

> **action****resource**:[MedicationRequest: identifier = 300-2/2; groupIdentifier = 300; status = active; intent = option; authoredOn = 2024-10-06](MedicationRequest-300C-2-medication-prescription-request2.md)

-------

Entry 2 - fullUrl = https://example.com/MedicationRequest/300C-2-medication-prescription-request1

Resource MedicationRequest:

> 

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 300-1/2**groupIdentifier**: 300**status**: Active**intent**: Option

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = Pessary; doseForm = Pessary; totalVolume = 6 Pessary](Medication-02A2-CanifugCremolumPessaryItem.md) |

**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)**authoredOn**: 2024-10-06**requester**:[PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Candidiasis of vagina |

> **dosageInstruction****timing**: Late Evening, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Pessary(Details: SNOMED CT code733007009 = 'Pessary (unit of presentation)') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-06 --> 2024-12-06 | 1 | 6 Pessary(Details: SNOMED CT code733007009 = 'Pessary (unit of presentation)') |


-------

Entry 3 - fullUrl = https://example.com/MedicationRequest/300C-2-medication-prescription-request2

Resource MedicationRequest:

> 

Profile: [MedicationRequest: MPD](StructureDefinition-MedicationRequest-eu-mpd.md)

**identifier**: 300-2/2**groupIdentifier**: 300**status**: Active**intent**: Option

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = Tube,20 gram; doseForm = Vaginal cream; totalVolume = 1 Tube](Medication-02A1-CanifugCremolumCreamItem.md) |

**subject**:[Thomas Engine Male, DoB: 1950-09-15 ( 12345)](Patient-patient1.md)**authoredOn**: 2024-10-06**requester**:[PractitionerRole Clinical oncologist](PractitionerRole-doctor1.md)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Candidiasis of vagina |

> **dosageInstruction****timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Application - unit of product usage(Details: SNOMED CT code413568008 = 'Application') |


### DispenseRequests

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ValidityPeriod** | **NumberOfRepeatsAllowed** | **Quantity** |
| * | 2024-10-06 --> 2024-12-06 | 1 | 20 gram(s)(Details: UCUM codeg = 'g') |


-------

Entry 4 - fullUrl = https://example.com/PractitionerRole/doctor1

Resource PractitionerRole:

> **practitioner**:[Dr Meryl Ärztin](Practitioner-practitioner1.md)**organization**:[Dr Ärztin Private Practice](Organization-organization1.md)**code**:Clinical oncologist

-------

Entry 5 - fullUrl = https://example.com/Patient/patient1

Resource Patient:

> 

Profile: [Patient (EU core)](http://hl7.eu/fhir/base-r5/0.1.0-ballot/StructureDefinition-patient-eu-core.html)

Thomas Engine Male, DoB: 1950-09-15 ( 12345)
-------

-------

Entry 6 - fullUrl = https://example.com/Medication/02A2-CanifugCremolumPessaryItem

Resource Medication:

> 

Profile: [Medication: MPD](StructureDefinition-Medication-eu-mpd.md)

**Medication - Unit of presentation**:Pessary**doseForm**:Pessary**totalVolume**: 6 Pessary(Details: EDQM Standard Terms code15039000 = 'Pessary')
> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | Clotrimazole |

**isActive**: true**strength**: 100 milligram(Details: UCUM codemg = 'mg')/1 Pessary(Details: EDQM Standard Terms code15039000 = 'Pessary')

-------

Entry 7 - fullUrl = https://example.com/Medication/02A1-CanifugCremolumCreamItem

Resource Medication:

> 

Profile: [Medication: MPD](StructureDefinition-Medication-eu-mpd.md)

**Medication - Unit of presentation**:Tube**Medication - Size of Item**: 20 gram(Details: UCUM codeg = 'g')**doseForm**:Vaginal cream**totalVolume**: 1 Tube(Details: EDQM Standard Terms code15058000 = 'Tube')
> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | Clotrimazole |

**isActive**: true**strength**: 10 milligram(Details: UCUM codemg = 'mg')/1 gram(Details: UCUM codeg = 'g')



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "300A-multiitem-prescription-with-orchestration",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "https://example.com/RequestOrchestration/300B-RequestOrchestration",
      "resource" : {
        "resourceType" : "RequestOrchestration",
        "id" : "300B-RequestOrchestration",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RequestOrchestration_300B-RequestOrchestration\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RequestOrchestration 300B-RequestOrchestration</b></p><a name=\"300B-RequestOrchestration\"> </a><a name=\"hc300B-RequestOrchestration\"> </a><p><b>groupIdentifier</b>: 300</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><blockquote><p><b>action</b></p><p><b>resource</b>: <a href=\"MedicationRequest-300C-2-medication-prescription-request1.html\">MedicationRequest: identifier = 300-1/2; groupIdentifier = 300; status = active; intent = option; authoredOn = 2024-10-06</a></p></blockquote><blockquote><p><b>action</b></p><p><b>resource</b>: <a href=\"MedicationRequest-300C-2-medication-prescription-request2.html\">MedicationRequest: identifier = 300-2/2; groupIdentifier = 300; status = active; intent = option; authoredOn = 2024-10-06</a></p></blockquote></div>"
        },
        "groupIdentifier" : {
          "value" : "300"
        },
        "status" : "active",
        "intent" : "order",
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "action" : [
          {
            "resource" : {
              "reference" : "MedicationRequest/300C-2-medication-prescription-request1"
            }
          },
          {
            "resource" : {
              "reference" : "MedicationRequest/300C-2-medication-prescription-request2"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/MedicationRequest/300C-2-medication-prescription-request1",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "300C-2-medication-prescription-request1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_300C-2-medication-prescription-request1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 300C-2-medication-prescription-request1</b></p><a name=\"300C-2-medication-prescription-request1\"> </a><a name=\"hc300C-2-medication-prescription-request1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 300-1/2</p><p><b>groupIdentifier</b>: 300</p><p><b>status</b>: Active</p><p><b>intent</b>: Option</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Reference</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Medication-02A2-CanifugCremolumPessaryItem.html\">Medication: extension = Pessary; doseForm = Pessary; totalVolume = 6 Pessary</a></td></tr></table><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-06</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 72934000}\">Candidiasis of vagina</span></td></tr></table><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: Late Evening, Once per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 Pessary<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code733007009 = 'Pessary (unit of presentation)')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-06 --&gt; 2024-12-06</td><td>1</td><td>6 Pessary<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code733007009 = 'Pessary (unit of presentation)')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "300-1/2"
          }
        ],
        "groupIdentifier" : {
          "value" : "300"
        },
        "status" : "active",
        "intent" : "option",
        "medication" : {
          "reference" : {
            "reference" : "Medication/02A2-CanifugCremolumPessaryItem"
          }
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-06",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reason" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "72934000",
                  "display" : "Candidiasis of vagina"
                }
              ]
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 6,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["EVE.late"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Pessary",
                  "system" : "http://snomed.info/sct",
                  "code" : "733007009"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-06",
            "end" : "2024-12-06"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 6,
            "unit" : "Pessary",
            "system" : "http://snomed.info/sct",
            "code" : "733007009"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/MedicationRequest/300C-2-medication-prescription-request2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "300C-2-medication-prescription-request2",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/MedicationRequest-eu-mpd"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_300C-2-medication-prescription-request2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 300C-2-medication-prescription-request2</b></p><a name=\"300C-2-medication-prescription-request2\"> </a><a name=\"hc300C-2-medication-prescription-request2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-eu-mpd.html\">MedicationRequest: MPD</a></p></div><p><b>identifier</b>: 300-2/2</p><p><b>groupIdentifier</b>: 300</p><p><b>status</b>: Active</p><p><b>intent</b>: Option</p><h3>Medications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Reference</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Medication-02A1-CanifugCremolumCreamItem.html\">Medication: extension = Tube,20 gram; doseForm = Vaginal cream; totalVolume = 1 Tube</a></td></tr></table><p><b>subject</b>: <a href=\"Patient-patient1.html\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</a></p><p><b>authoredOn</b>: 2024-10-06</p><p><b>requester</b>: <a href=\"PractitionerRole-doctor1.html\">PractitionerRole Clinical oncologist</a></p><h3>Reasons</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 72934000}\">Candidiasis of vagina</span></td></tr></table><blockquote><p><b>dosageInstruction</b></p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 Application - unit of product usage<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code413568008 = 'Application')</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td><td><b>NumberOfRepeatsAllowed</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-10-06 --&gt; 2024-12-06</td><td>1</td><td>20 gram(s)<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg = 'g')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "300-2/2"
          }
        ],
        "groupIdentifier" : {
          "value" : "300"
        },
        "status" : "active",
        "intent" : "option",
        "medication" : {
          "reference" : {
            "reference" : "Medication/02A1-CanifugCremolumCreamItem"
          }
        },
        "subject" : {
          "reference" : "Patient/patient1"
        },
        "authoredOn" : "2024-10-06",
        "requester" : {
          "reference" : "PractitionerRole/doctor1"
        },
        "reason" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "72934000",
                  "display" : "Candidiasis of vagina"
                }
              ]
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 6,
                  "unit" : "day",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Application - unit of product usage",
                  "system" : "http://snomed.info/sct",
                  "code" : "413568008"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2024-10-06",
            "end" : "2024-12-06"
          },
          "numberOfRepeatsAllowed" : 1,
          "quantity" : {
            "value" : 20,
            "unit" : "gram(s)",
            "system" : "http://unitsofmeasure.org",
            "code" : "g"
          }
        }
      }
    },
    {
      "fullUrl" : "https://example.com/PractitionerRole/doctor1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "doctor1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_doctor1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole doctor1</b></p><a name=\"doctor1\"> </a><a name=\"hcdoctor1\"> </a><p><b>practitioner</b>: <a href=\"Practitioner-practitioner1.html\">Dr Meryl Ärztin</a></p><p><b>organization</b>: <a href=\"Organization-organization1.html\">Dr Ärztin Private Practice</a></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 309295000}\">Clinical oncologist</span></p></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/practitioner1",
          "display" : "Dr Meryl Ärztin"
        },
        "organization" : {
          "reference" : "Organization/organization1",
          "display" : "Dr Ärztin Private Practice"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "309295000",
                "display" : "Clinical oncologist"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/Patient/patient1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient1",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient patient1</b></p><a name=\"patient1\"> </a><a name=\"hcpatient1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.eu/fhir/base-r5/0.1.0-ballot/StructureDefinition-patient-eu-core.html\">Patient (EU core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Thomas Engine  Male, DoB: 1950-09-15 ( 12345)</p><hr/></div>"
        },
        "identifier" : [
          {
            "value" : "12345"
          }
        ],
        "name" : [
          {
            "family" : "Engine",
            "given" : ["Thomas"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1950-09-15"
      }
    },
    {
      "fullUrl" : "https://example.com/Medication/02A2-CanifugCremolumPessaryItem",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "02A2-CanifugCremolumPessaryItem",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_02A2-CanifugCremolumPessaryItem\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 02A2-CanifugCremolumPessaryItem</b></p><a name=\"02A2-CanifugCremolumPessaryItem\"> </a><a name=\"hc02A2-CanifugCremolumPessaryItem\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Medication-eu-mpd.html\">Medication: MPD</a></p></div><p><b>Medication - Unit of presentation</b>: <span title=\"Codes:{http://standardterms.edqm.eu 15039000}\">Pessary</span></p><p><b>doseForm</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10909000}\">Pessary</span></p><p><b>totalVolume</b>: 6 Pessary<span style=\"background: LightGoldenRodYellow\"> (Details: standardterms.edqm.eu  code15039000 = 'Pessary')</span></p><blockquote><p><b>ingredient</b></p><h3>Items</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 387325003}\">Clotrimazole</span></td></tr></table><p><b>isActive</b>: true</p><p><b>strength</b>: 100 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Pessary<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15039000 = 'Pessary')</span></p></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-unitofpresentation",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "15039000",
                  "display" : "Pessary"
                }
              ]
            }
          }
        ],
        "doseForm" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10909000",
              "display" : "Pessary"
            }
          ]
        },
        "totalVolume" : {
          "value" : 6,
          "unit" : "Pessary",
          "system" : "http://standardterms.edqm.eu",
          "code" : "15039000"
        },
        "ingredient" : [
          {
            "item" : {
              "concept" : {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "387325003",
                    "display" : "Clotrimazole"
                  }
                ]
              }
            },
            "isActive" : true,
            "strengthRatio" : {
              "numerator" : {
                "value" : 100,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Pessary",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15039000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://example.com/Medication/02A1-CanifugCremolumCreamItem",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "02A1-CanifugCremolumCreamItem",
        "meta" : {
          "profile" : [
            "http://hl7.eu/fhir/mpd-r5/StructureDefinition/Medication-eu-mpd"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_02A1-CanifugCremolumCreamItem\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 02A1-CanifugCremolumCreamItem</b></p><a name=\"02A1-CanifugCremolumCreamItem\"> </a><a name=\"hc02A1-CanifugCremolumCreamItem\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Medication-eu-mpd.html\">Medication: MPD</a></p></div><p><b>Medication - Unit of presentation</b>: <span title=\"Codes:{http://standardterms.edqm.eu 15058000}\">Tube</span></p><p><b>Medication - Size of Item</b>: 20 gram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg = 'g')</span></p><p><b>doseForm</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10901000}\">Vaginal cream</span></p><p><b>totalVolume</b>: 1 Tube<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15058000 = 'Tube')</span></p><blockquote><p><b>ingredient</b></p><h3>Items</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 387325003}\">Clotrimazole</span></td></tr></table><p><b>isActive</b>: true</p><p><b>strength</b>: 10 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 gram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg = 'g')</span></p></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-unitofpresentation",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "15058000",
                  "display" : "Tube"
                }
              ]
            }
          },
          {
            "url" : "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-sizeofitem",
            "valueQuantity" : {
              "value" : 20,
              "unit" : "gram",
              "system" : "http://unitsofmeasure.org",
              "code" : "g"
            }
          }
        ],
        "doseForm" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10901000",
              "display" : "Vaginal cream"
            }
          ]
        },
        "totalVolume" : {
          "value" : 1,
          "unit" : "Tube",
          "system" : "http://standardterms.edqm.eu",
          "code" : "15058000"
        },
        "ingredient" : [
          {
            "item" : {
              "concept" : {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "387325003",
                    "display" : "Clotrimazole"
                  }
                ]
              }
            },
            "isActive" : true,
            "strengthRatio" : {
              "numerator" : {
                "value" : 10,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "gram",
                "system" : "http://unitsofmeasure.org",
                "code" : "g"
              }
            }
          }
        ]
      }
    }
  ]
}

```
