/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.ComplementInColors2;
import net.sourceforge.plantuml.project.lang.ComplementOpen;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class SubjectDayOfWeek
implements Subject {
    public static final Subject ME = new SubjectDayOfWeek();

    private SubjectDayOfWeek() {
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("SUBJECT", "(" + DayOfWeek.getRegexString() + ")");
    }

    @Override
    public Failable<? extends Object> getMe(GanttDiagram project, RegexResult arg) {
        String s = arg.get("SUBJECT", 0);
        return Failable.ok(DayOfWeek.fromString(s));
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new AreClose(), new AreOpen(), new InColor());
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDayOfWeek.this, Verbs.isOrAre, new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.colorDay(day, color);
            return CommandExecutionResult.ok();
        }
    }

    class AreClose
    extends SentenceSimple {
        public AreClose() {
            super(SubjectDayOfWeek.this, Verbs.are, new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.closeDayOfWeek(day, (String)complement);
            return CommandExecutionResult.ok();
        }
    }

    class AreOpen
    extends SentenceSimple {
        public AreOpen() {
            super(SubjectDayOfWeek.this, Verbs.are, new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.openDayOfWeek(day, (String)complement);
            return CommandExecutionResult.ok();
        }
    }
}

