/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.openiconic.SvgPath;
import net.sourceforge.plantuml.openiconic.data.DummyIcon;
import net.sourceforge.plantuml.security.SFile;

public class OpenIcon {
    private SvgPath svgPath;
    private List<String> rawData = new ArrayList<String>();
    private final String id;

    public static OpenIcon retrieve(String name) {
        InputStream is = OpenIcon.getResource(name);
        if (is == null) {
            return null;
        }
        try {
            return new OpenIcon(is, name);
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    OpenIcon(String name) throws IOException {
        this(OpenIcon.getResource(name), name);
    }

    private static InputStream getResource(String name) {
        return DummyIcon.class.getResourceAsStream(name + ".svg");
    }

    private OpenIcon(InputStream is, String id) throws IOException {
        this.id = id;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String s = null;
            while ((s = br.readLine()) != null) {
                this.rawData.add(s);
                if (!s.contains("<path")) continue;
                int x1 = s.indexOf(34);
                int x2 = s.indexOf(34, x1 + 1);
                this.svgPath = new SvgPath(s.substring(x1 + 1, x2));
            }
        }
        if (this.rawData.size() != 3 && this.rawData.size() != 4) {
            throw new IllegalStateException();
        }
    }

    void saveCopy(SFile fnew) throws IOException {
        try (PrintWriter pw = fnew.createPrintWriter();){
            pw.println(this.rawData.get(0));
            pw.println(this.svgPath.toSvg());
            pw.println(this.rawData.get(this.rawData.size() - 1));
        }
    }

    private XDimension2D getDimension(double factor) {
        String width = this.getNumber(this.rawData.get(0), "width");
        String height = this.getNumber(this.rawData.get(0), "height");
        return new XDimension2D((double)Integer.parseInt(width) * factor, (double)Integer.parseInt(height) * factor);
    }

    private String getNumber(String s, String arg) {
        int x1 = s.indexOf(arg);
        if (x1 == -1) {
            throw new IllegalArgumentException();
        }
        if ((x1 = s.indexOf("\"", x1)) == -1) {
            throw new IllegalArgumentException();
        }
        int x2 = s.indexOf("\"", x1 + 1);
        if (x2 == -1) {
            throw new IllegalArgumentException();
        }
        return s.substring(x1 + 1, x2);
    }

    public TextBlock asTextBlock(final HColor color, final double factor) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                HColor textColor = color.getAppropriateColor(ug.getParam().getBackcolor());
                OpenIcon.this.svgPath.drawMe(ug.apply(textColor), factor);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return OpenIcon.this.getDimension(factor);
            }
        };
    }
}

