# hl7.eu.fhir.gh-ips#0.1.0: Gravitate Health FHIR Implementation Guide (FHIR R4)

## Pages

* [Home](index.md)
* [Use Case Example](use-case-example.md)
* [Connections](connections.md)
* [Terminology](terminology.md)
* [Sample Data](SampleData.md)
* [Copyright](copyright.md)
* [Capability Statement Capability Statement Ema](CapabilityStatement-capability-statement-ema.md)
* [Downloads](downloads.md)
* [E PI Structure](ePI-structure.md)
* [Artifacts Summary](artifacts.md)

## Resources

### CodeSystems

* [EQ-5D-5L Levels](CodeSystem-eq5d-levels-cs.md)
* [Local Literacy Codes](CodeSystem-literacy-cs.md)

### ValueSets

* [EQ-5D Anxiety/Depression VS](ValueSet-eq5d-anxdep-vs.md)
* [EQ-5D-5L Levels VS](ValueSet-eq5d-levels-vs.md)
* [EQ-5D Mobility VS](ValueSet-eq5d-mobility-vs.md)
* [EQ-5D Pain/Discomfort VS](ValueSet-eq5d-pain-vs.md)
* [EQ-5D Self-care VS](ValueSet-eq5d-selfcare-vs.md)
* [EQ-5D Usual activities VS](ValueSet-eq5d-usualactivities-vs.md)
* [Literacy Level (Low/Medium/High)](ValueSet-literacy-level-vs.md)

### ImplementationGuides

* [Gravitate Health FHIR Implementation Guide (FHIR R4)](index.md)

### Examples

* [Ovl-Alicia-medication-allergy (AllergyIntolerance)](AllergyIntolerance-Ovl-Alicia-medication-allergy.md)
* [HIMSS-Alicia (Bundle)](Bundle-HIMSS-Alicia.md)
* [Ovl-gravitate-Alicia (Bundle)](Bundle-Ovl-gravitate-Alicia.md)
* [gravitate-Alicia (Bundle)](Bundle-gravitate-Alicia.md)
* [gravitate-Cecilia (Bundle)](Bundle-gravitate-Cecilia.md)
* [gravitate-Matilda (Bundle)](Bundle-gravitate-Matilda.md)
* [gravitate-Pedro (Bundle)](Bundle-gravitate-Pedro.md)
* [gravitate-Renee (Bundle)](Bundle-gravitate-Renee.md)
* [gravitate-alex-himss (Bundle)](Bundle-gravitate-alex-himss.md)
* [gravitate-example-testing-scenario-bundle (Bundle)](Bundle-gravitate-example-testing-scenario-bundle.md)
* [gravitate-helen (Bundle)](Bundle-gravitate-helen.md)
* [gravitate-ips-1 (Bundle)](Bundle-gravitate-ips-1.md)
* [gravitate-ips-2 (Bundle)](Bundle-gravitate-ips-2.md)
* [gravitate-ips-3 (Bundle)](Bundle-gravitate-ips-3.md)
* [gravitate-ips-4 (Bundle)](Bundle-gravitate-ips-4.md)
* [gravitate-ips-jp (Bundle)](Bundle-gravitate-ips-jp.md)
* [gravitate-maria (Bundle)](Bundle-gravitate-maria.md)
* [gravitate-ole (Bundle)](Bundle-gravitate-ole.md)
* [alcohol-use-example (Observation)](Observation-alcohol-use-example.md)
* [tobacco-use-example (Observation)](Observation-tobacco-use-example.md)
* [EQ-5D-5L (Questionnaire)](Questionnaire-Questionnaire-EQ5D-5L.md)
