# Local Literacy Codes - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Local Literacy Codes**

## CodeSystem: Local Literacy Codes 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/literacy-cs | *Version*:0.1.0 |
| Active as of 2025-12-01 | *Computable Name*:LiteracyCS |

 This Code system is referenced in the content logical definition of the following value sets: 

* [LiteracyLevelVS](ValueSet-literacy-level-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "literacy-cs",
  "url" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/literacy-cs",
  "version" : "0.1.0",
  "name" : "LiteracyCS",
  "title" : "Local Literacy Codes",
  "status" : "active",
  "date" : "2025-12-01T10:57:47+00:00",
  "contact" : [
    {
      "name" : "Gravitate Health Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gravitatehealth.eu/"
        }
      ]
    }
  ],
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "health-literacy",
      "display" : "Health literacy (self-reported)"
    },
    {
      "code" : "digital-literacy",
      "display" : "Digital literacy (self-reported)"
    },
    {
      "code" : "low",
      "display" : "Low"
    },
    {
      "code" : "medium",
      "display" : "Medium"
    },
    {
      "code" : "high",
      "display" : "High"
    },
    {
      "code" : "yes",
      "display" : "Yes"
    },
    {
      "code" : "no",
      "display" : "No"
    }
  ]
}

```
