# Ole Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ole Gravitate's IPS**

## Example Bundle: Ole Gravitate's IPS

**id:**gravitate-ole

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**0101010101

**Name:**Ole Rasmussen

**active:**true

**gender:**unknown

**Birth Date:**1901-01-01

### Sections

#### Medication Summary

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28105044712 [Pinemol]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**1000 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101005764 [Marevan]

*  **System** http://www.whocc.no/atc **Code:** B01AA03 [Warfarin]

**Dose Form:**tabletter

**Ingredient:**WARFARINNATRIUM (https://laegemiddelstyrelsen.dk/LMS30/Substans#WARFARINNATRIUM)

**strength:**2.5 mg/1 tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101921397 [Beclomet Easyhaler]

*  **System** http://www.whocc.no/atc **Code:** R03BA01 [Beclomethason]

**Dose Form:**inhalationspulver

**Ingredient:**BECLOMETASONDIPROPIONAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#BECLOMETASONDIPROPIONAT)

**strength:**200 ug/1 dose

**Route:**Til inhalation

**Medication:**

**status:**on-hold

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28105398114 [Eltroxin]

*  **System** http://www.whocc.no/atc **Code:** H03AA01 [Levothyroxinnatrium]

**Dose Form:**tabletter

**Ingredient:**LEVOTHYROXINNATRIUM (https://laegemiddelstyrelsen.dk/LMS30/Substans#LEVOTHYROXINNATRIUM)

**strength:**100 ug/1 tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**on-hold

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101317587 [Pamol]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**500 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000051 [Cannabidiol]

**Dose Form:**orale dråber

**Route:**Oral anvendelse

**Medication:**

**status:**on-hold

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28105468514 [Betolvex]

*  **System** http://www.whocc.no/atc **Code:** B03BA01 [Cyanocobalamin]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**CYANOCOBALAMIN (https://laegemiddelstyrelsen.dk/LMS30/Substans#CYANOCOBALAMIN)

**strength:**1 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**stopped

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101107682 [Betolvex]

*  **System** http://www.whocc.no/atc **Code:** B03BA01 [Cyanocobalamin]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**CYANOCOBALAMIN (https://laegemiddelstyrelsen.dk/LMS30/Substans#CYANOCOBALAMIN)

**strength:**1 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**completed

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101339688 [Spirocort Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03BA02 [Budesonid]

**Dose Form:**inhalationspulver

**Ingredient:**BUDESONID (https://laegemiddelstyrelsen.dk/LMS30/Substans#BUDESONID)

**strength:**400 ug/1 dose

**Route:**Til inhalation

**Medication:**

**status:**stopped

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101674394 [Panodil]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**1000 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101807196 [Cabaser]

*  **System** http://www.whocc.no/atc **Code:** N04BC06 [Cabergolin]

**Dose Form:**tabletter

**Ingredient:**CABERGOLIN (https://laegemiddelstyrelsen.dk/LMS30/Substans#CABERGOLIN)

**strength:**1 mg/1 tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28105484214 [Abasaglar KwikPen]

*  **System** http://www.whocc.no/atc **Code:** A10AE04 [Insulin glargin]

**Dose Form:**injektionsvæske, opløsning i fyldt pen

**Ingredient:**Insulin glargin (https://laegemiddelstyrelsen.dk/LMS30/Substans#Insulin glargin)

**Route:**Subkutan anvendelse

**Medication:**

**status:**stopped

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101674394 [Panodil]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**1000 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000250 [Røde morfindråber]

*  **System** http://www.whocc.no/atc **Code:** N02AA01 [Morphin]

**Dose Form:**orale dråber

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101891697 [Telfast]

*  **System** http://www.whocc.no/atc **Code:** R06AX26 [Fexofenadin]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**FEXOFENADINHYDROCHLORID (https://laegemiddelstyrelsen.dk/LMS30/Substans#FEXOFENADINHYDROCHLORID)

**strength:**120 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000053 [Cannabidiol]

**Dose Form:**orale dråber

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28105051112 [Asubtela]

*  **System** http://www.whocc.no/atc **Code:** G03AA12 [Drospirenon og ethinylestradiol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**DROSPIRENON (https://laegemiddelstyrelsen.dk/LMS30/Substans#DROSPIRENON)

**Ingredient:**Ethinylestradiol (https://laegemiddelstyrelsen.dk/LMS30/Substans#Ethinylestradiol)

**Route:**Oral anvendelse

**Medication:**

**status:**completed

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019685388 [Cannabidiol/dronabinol ]

*  **System** http://www.whocc.no/atc **Code:** N02BG10 [Cannabinoider]

**Dose Form:**orale dråber

**Route:**Dental anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28102960614 [Abacavir/Lamivudin "Mylan"]

*  **System** http://www.whocc.no/atc **Code:** J05AR02 [Lamivudin og abacavir]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**Abacavirhydrochlorid (https://laegemiddelstyrelsen.dk/LMS30/Substans#Abacavirhydrochlorid)

**Ingredient:**LAMIVUDIN (https://laegemiddelstyrelsen.dk/LMS30/Substans#LAMIVUDIN)

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28100902676 [Primcillin]

*  **System** http://www.whocc.no/atc **Code:** J01CE02 [Phenoxymethylpenicillin]

**Dose Form:**granulat til oral suspension

**Ingredient:**Phenoxymethylpenicillinkalium (https://laegemiddelstyrelsen.dk/LMS30/Substans#Phenoxymethylpenicillinkalium)

**strength:**50 mg/1 milliliter

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28103253401 [Actrapid Penfill]

*  **System** http://www.whocc.no/atc **Code:** A10AB01 [Insulin (human)]

**Dose Form:**injektionsvæske, opløsning i cylinderampul

**Ingredient:**Insulin, humant (rDNA) (https://laegemiddelstyrelsen.dk/LMS30/Substans#Insulin, humant (rDNA))

**strength:**100 [iU]/1 milliliter

**Route:**Subkutan anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28100736376 [Morfin "DAK"]

*  **System** http://www.whocc.no/atc **Code:** N02AA01 [Morphin]

**Dose Form:**injektionsvæske, opløsning

**Ingredient:**MORPHINHYDROCHLORID (trihydrate) (https://laegemiddelstyrelsen.dk/LMS30/Substans#MORPHINHYDROCHLORID (trihydrate))

**strength:**20 mg/1 milliliter

**Route:**Intramuskulær anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28100902676 [Primcillin]

*  **System** http://www.whocc.no/atc **Code:** J01CE02 [Phenoxymethylpenicillin]

**Dose Form:**granulat til oral suspension

**Ingredient:**Phenoxymethylpenicillinkalium (https://laegemiddelstyrelsen.dk/LMS30/Substans#Phenoxymethylpenicillinkalium)

**strength:**50 mg/1 milliliter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101492592 [Bricanyl Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03AC03 [Terbutalin]

**Dose Form:**inhalationspulver

**Ingredient:**TERBUTALINSULFAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#TERBUTALINSULFAT)

**strength:**0.25 mg/1 dose

**Route:**Til inhalation

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101497692 [Risperdal]

*  **System** http://www.whocc.no/atc **Code:** N05AX08 [Risperidon]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**RISPERIDON (https://laegemiddelstyrelsen.dk/LMS30/Substans#RISPERIDON)

**strength:**1 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101492592 [Bricanyl Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03AC03 [Terbutalin]

**Dose Form:**inhalationspulver

**Ingredient:**TERBUTALINSULFAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#TERBUTALINSULFAT)

**strength:**0.25 mg/1 dose

**Route:**Til inhalation

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Local **Code:** 87000042004 [Vioxx]

*  **System** http://www.whocc.no/atc **Code:** M01AH02 [Rofecoxib]

**Dose Form:**oral opløsning

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101317587 [Pamol]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**500 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101492592 [Bricanyl Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03AC03 [Terbutalin]

**Dose Form:**inhalationspulver

**Ingredient:**TERBUTALINSULFAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#TERBUTALINSULFAT)

**strength:**0.25 mg/1 dose

**Route:**Til inhalation

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101195484 [Pinex]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**brusetabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**500 mg/1 brusetabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28103176800 [Panodil]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**tabletter med modificeret udløsning

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**665 mg/1 tabletter med modificeret udløsning

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28100485165 [Celeston]

*  **System** http://www.whocc.no/atc **Code:** H02AB01 [Betamethason]

**Dose Form:**injektionsvæske, suspension

**Ingredient:**BETAMETHASONDINATRIUMPHOSPHAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#BETAMETHASONDINATRIUMPHOSPHAT)

**Ingredient:**BETAMETHASONACETAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#BETAMETHASONACETAT)

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101492592 [Bricanyl Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03AC03 [Terbutalin]

**Dose Form:**inhalationspulver

**Ingredient:**TERBUTALINSULFAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#TERBUTALINSULFAT)

**strength:**0.25 mg/1 dose

**Route:**Til inhalation

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28103606003 [Alendronat "Mylan"]

*  **System** http://www.whocc.no/atc **Code:** M05BA04 [Alendronsyre]

**Dose Form:**tabletter

**Ingredient:**Natriumalendronattrihydrat (https://laegemiddelstyrelsen.dk/LMS30/Substans#Natriumalendronattrihydrat)

**strength:**70 mg/1 tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28104061107 [Cyklonova]

*  **System** http://www.whocc.no/atc **Code:** B02AA02 [Tranexamsyre]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**TRANEXAMSYRE (https://laegemiddelstyrelsen.dk/LMS30/Substans#TRANEXAMSYRE)

**strength:**500 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28100636073 [Panodil]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [Paracetamol]

**Dose Form:**filmovertrukne tabletter

**Ingredient:**PARACETAMOL (https://laegemiddelstyrelsen.dk/LMS30/Substans#PARACETAMOL)

**strength:**500 mg/1 filmovertrukne tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28104249507 [Amlodipin "Teva"]

*  **System** http://www.whocc.no/atc **Code:** C08CA01 [Amlodipin]

**Dose Form:**tabletter

**Ingredient:**AMLODIPINBESILAT (https://laegemiddelstyrelsen.dk/LMS30/Substans#AMLODIPINBESILAT)

**strength:**10 mg/1 tabletter

**Route:**Oral anvendelse

**Medication:**

**status:**stopped

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000071 [Kokain]

*  **System** http://www.whocc.no/atc **Code:** S01HA01 [Cocain]

**Dose Form:**øjendråber

**Route:**Intrabronkial anvendelse

**Medication:**

**status:**completed

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000052 [Cannabidiol]

**Dose Form:**orale dråber

**Route:**Oral anvendelse

**Medication:**

**status:**active

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019000331 [Morfin u. stabilisering]

*  **System** http://www.whocc.no/atc **Code:** N02AA01 [Morphin]

**Dose Form:**injektionsvæske

**Route:**Endotrakeopulmonar anvendelse

**Medication:**

**status:**unknown

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101697994 [Sevorane]

*  **System** http://www.whocc.no/atc **Code:** N01AB08 [Sevofluran]

**Dose Form:**væske til inhalationsdamp

**Ingredient:**SEVOFLURAN (https://laegemiddelstyrelsen.dk/LMS30/Substans#SEVOFLURAN)

**Route:**Til inhalation

**Medication:**

**status:**active

**Medication Detail:**

*  **System** https://laegemiddelstyrelsen.dk/LMS01/DrugID **Code:** 28101339688 [Spirocort Turbuhaler]

*  **System** http://www.whocc.no/atc **Code:** R03BA02 [Budesonid]

**Dose Form:**inhalationspulver

**Ingredient:**BUDESONID (https://laegemiddelstyrelsen.dk/LMS30/Substans#BUDESONID)

**strength:**400 ug/1 dose

**Route:**Til inhalation

**Medication:**

**status:**stopped

**Medication Detail:**

*  **System** http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel **Code:** 73019685346 [Nikotinsyre]

*  **System** http://www.whocc.no/atc **Code:** C04AC01 [Nicotinsyre]

**Dose Form:**tabletter

**Route:**Vaginal anvendelse

#### Immunizations



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-ole",
  "meta" : {
    "lastUpdated" : "2023-04-24T10:16:22.325+00:00",
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "urn:oid:2.16.724.4.8.10.200.10",
    "value" : "5ab49a42-aa43-48f7-bef3-9696dff3a57e"
  },
  "type" : "document",
  "timestamp" : "2023-04-24T10:16:22.325+00:00",
  "entry" : [
    {
      "fullUrl" : "8bfd271e-0f35-4650-8a1c-9f1391caafb2",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "8bfd271e-0f35-4650-8a1c-9f1391caafb2",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_8bfd271e-0f35-4650-8a1c-9f1391caafb2\"> </a>\n  \n\n    \n      <b>Id:</b>\n      8bfd271e-0f35-4650-8a1c-9f1391caafb2\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a/>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Immunizations\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "date" : "2023-04-24T10:16:22+00:00",
        "author" : [
          {
            "reference" : "Practitioner/b469dcd5-3746-35d5-868f-09c7ebf1f460"
          },
          {
            "reference" : "Practitioner/f81e478b-a8dd-3f68-a9c3-1b857ea2472e"
          },
          {
            "reference" : "Practitioner/0bf711af-c78d-3709-b87a-00d31a48c740"
          },
          {
            "reference" : "Practitioner/323724ff-ee66-352c-a0fc-48b55a248355"
          },
          {
            "reference" : "Practitioner/55aa2345-b156-3218-b706-d9a4e4fb3d63"
          }
        ],
        "title" : "Patient Summary as of Mon Apr 24 10:16:22 GMT 2023",
        "section" : [
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "History of Medication use Narrative"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/a18f7f27-c090-3d56-86c1-54cca1c03f06"
              },
              {
                "reference" : "MedicationStatement/c671283e-e5b3-3be9-8beb-aae3b6039f42"
              },
              {
                "reference" : "MedicationStatement/29ca7193-20f1-3ea5-afb6-0d14b25fb6d8"
              },
              {
                "reference" : "MedicationStatement/5e812dea-3694-39a9-b1db-95313c0f7370"
              },
              {
                "reference" : "MedicationStatement/126017c0-15ed-3923-a275-83c253328a15"
              },
              {
                "reference" : "MedicationStatement/97ad406d-c5ea-32af-a227-a8fa2fff5d63"
              },
              {
                "reference" : "MedicationStatement/7c6b53a1-c6a9-3419-b39c-e7c349069970"
              },
              {
                "reference" : "MedicationStatement/ed84c82a-1514-3846-9952-ee16e8cdc90e"
              },
              {
                "reference" : "MedicationStatement/d41d4adb-4a3a-3edd-8e53-b327ffc464f3"
              },
              {
                "reference" : "MedicationStatement/ed992839-8337-3905-8a02-63dcc31a84b8"
              },
              {
                "reference" : "MedicationStatement/430260fe-9968-3f16-a014-f1ec6cbb17db"
              },
              {
                "reference" : "MedicationStatement/29613fa2-7540-32ee-a8c6-aa29e3ee740a"
              },
              {
                "reference" : "MedicationStatement/8799c036-c040-379f-8d6d-65e0832c6b8a"
              },
              {
                "reference" : "MedicationStatement/0f0b4fd9-3242-3ce3-92bd-b01a154690a7"
              },
              {
                "reference" : "MedicationStatement/73500385-0fd9-3360-b08e-c1822c27f9de"
              },
              {
                "reference" : "MedicationStatement/c9f70b9f-56d0-3536-b633-1db74bd59eda"
              },
              {
                "reference" : "MedicationStatement/0b4b6770-dfa1-3fc2-bc65-8f243d7b4769"
              },
              {
                "reference" : "MedicationStatement/c7462be0-c86a-343a-9368-2c066d78d7f9"
              },
              {
                "reference" : "MedicationStatement/d8b76b5f-56d7-375b-831f-6c1cbe68f05d"
              },
              {
                "reference" : "MedicationStatement/f45b2d67-423c-3349-88e2-c466c71d490f"
              },
              {
                "reference" : "MedicationStatement/7863fbda-ca31-3476-9dc8-3a6f4bb03714"
              },
              {
                "reference" : "MedicationStatement/833630b2-364a-3321-9077-e51231e69721"
              },
              {
                "reference" : "MedicationStatement/48e3280c-2e8f-32e4-b3b7-b51dddb33e81"
              },
              {
                "reference" : "MedicationStatement/18f1c247-23de-3199-aca2-37d07219c084"
              },
              {
                "reference" : "MedicationStatement/2aa08a5e-756b-39cc-b25f-59c74d052cc1"
              },
              {
                "reference" : "MedicationStatement/b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb"
              },
              {
                "reference" : "MedicationStatement/41a4dc8a-4d2f-33be-b177-1ef85735a0a0"
              },
              {
                "reference" : "MedicationStatement/9aa00a63-3642-38b2-a1c7-b52f45e9331c"
              },
              {
                "reference" : "MedicationStatement/a8fdda68-f49b-3740-afd4-162cad3fb03f"
              },
              {
                "reference" : "MedicationStatement/d43d7b68-9fe5-3cab-aecb-2a07016fff38"
              },
              {
                "reference" : "MedicationStatement/92ae5b23-7a6b-3d55-8c0d-19a8c8020052"
              },
              {
                "reference" : "MedicationStatement/a7662443-a0ba-3e8a-964e-bee66d20c378"
              },
              {
                "reference" : "MedicationStatement/4c0fbdcf-7609-32c2-8765-49101520daa2"
              },
              {
                "reference" : "MedicationStatement/81319f72-c944-3dcf-842d-f64db3428477"
              },
              {
                "reference" : "MedicationStatement/ce7c63a6-e267-3d28-a7e8-ae4b921f0197"
              },
              {
                "reference" : "MedicationStatement/72714030-938b-3932-a3df-6e1720f14603"
              },
              {
                "reference" : "MedicationStatement/d8e5b781-d88b-320e-86de-1dfa20956c76"
              },
              {
                "reference" : "MedicationStatement/d6203e62-5980-364c-8611-8fd0f91f907c"
              },
              {
                "reference" : "MedicationStatement/4ab65861-515c-38f6-a0d7-a713c49de130"
              },
              {
                "reference" : "MedicationStatement/f3760a41-1066-3632-aaca-2c68b0248ace"
              },
              {
                "reference" : "MedicationStatement/bbad992c-5506-3c12-b4fd-45991aa55d6f"
              },
              {
                "reference" : "MedicationStatement/646a07df-4e85-3ae6-b33e-f15930b97cc7"
              },
              {
                "reference" : "MedicationStatement/c31bc5f6-1160-3618-a706-e66e1b6e02ef"
              }
            ]
          },
          {
            "title" : "Immunizations",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11369-6",
                  "display" : "History of Immunization Narrative"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Immunization/a02bd4c3-0912-33a9-aa44-2012d24540cf"
              },
              {
                "reference" : "Immunization/96e5efee-a9c7-3331-9a91-71001db79e3a"
              },
              {
                "reference" : "Immunization/5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5"
              },
              {
                "reference" : "Immunization/0a77a697-1b3c-3b7f-85b4-4ff779290b07"
              },
              {
                "reference" : "Immunization/2d55c34d-acc9-3070-828a-b5426b8e50e5"
              },
              {
                "reference" : "Immunization/924ce259-decd-33ca-8969-e632a45c47f0"
              },
              {
                "reference" : "Immunization/139ad53a-217f-3e19-9540-d0d47a834174"
              },
              {
                "reference" : "Immunization/312445f3-900b-3f77-aa81-854000a700cd"
              },
              {
                "reference" : "Immunization/e15164fc-8238-35e1-a56c-31f5f5d7c6b3"
              },
              {
                "reference" : "Immunization/d35d99ba-32af-373a-97e3-e2a9efc8ba1b"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "06520e16-88df-3e2c-8a39-2d57f59375aa",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "06520e16-88df-3e2c-8a39-2d57f59375aa",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_06520e16-88df-3e2c-8a39-2d57f59375aa\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 06520e16-88df-3e2c-8a39-2d57f59375aa</b></p><a name=\"06520e16-88df-3e2c-8a39-2d57f59375aa\"> </a><a name=\"hc06520e16-88df-3e2c-8a39-2d57f59375aa\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28105044712, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28105044712}, {http://www.whocc.no/atc N02BE01}\">Pinemol</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>1000 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28105044712"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28105044712",
              "display" : "Pinemol"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "e5a8c48b-7ddc-3350-9388-36afc8702356",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "e5a8c48b-7ddc-3350-9388-36afc8702356",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_e5a8c48b-7ddc-3350-9388-36afc8702356\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication e5a8c48b-7ddc-3350-9388-36afc8702356</b></p><a name=\"e5a8c48b-7ddc-3350-9388-36afc8702356\"> </a><a name=\"hce5a8c48b-7ddc-3350-9388-36afc8702356\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101005764, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/B01AA03</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101005764}, {http://www.whocc.no/atc B01AA03}\">Marevan</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TAB}\">tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans WARFARINNATRIUM}\">WARFARINNATRIUM</span></td><td>true</td><td>2.5 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter} = '{tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101005764"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "B01AA03"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101005764",
              "display" : "Marevan"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "B01AA03",
              "display" : "Warfarin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "WARFARINNATRIUM",
                  "display" : "WARFARINNATRIUM"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 2.5,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "93f4b432-06f7-3d23-8e17-35ca143e4951",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "93f4b432-06f7-3d23-8e17-35ca143e4951",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_93f4b432-06f7-3d23-8e17-35ca143e4951\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 93f4b432-06f7-3d23-8e17-35ca143e4951</b></p><a name=\"93f4b432-06f7-3d23-8e17-35ca143e4951\"> </a><a name=\"hc93f4b432-06f7-3d23-8e17-35ca143e4951\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101921397, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/R03BA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101921397}, {http://www.whocc.no/atc R03BA01}\">Beclomet Easyhaler</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INHPUL}\">inhalationspulver</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans BECLOMETASONDIPROPIONAT}\">BECLOMETASONDIPROPIONAT</span></td><td>true</td><td>200 microgram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeug = 'ug')</span>/1 dose<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{Dose} = '{Dose}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101921397"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "R03BA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101921397",
              "display" : "Beclomet Easyhaler"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R03BA01",
              "display" : "Beclomethason"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INHPUL",
              "display" : "inhalationspulver"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "BECLOMETASONDIPROPIONAT",
                  "display" : "BECLOMETASONDIPROPIONAT"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 200,
                "unit" : "microgram",
                "system" : "http://unitsofmeasure.org",
                "code" : "ug"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "dose",
                "system" : "http://unitsofmeasure.org",
                "code" : "{Dose}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "91939311-86b6-3bfc-8640-d1ec357b0369",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "91939311-86b6-3bfc-8640-d1ec357b0369",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_91939311-86b6-3bfc-8640-d1ec357b0369\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 91939311-86b6-3bfc-8640-d1ec357b0369</b></p><a name=\"91939311-86b6-3bfc-8640-d1ec357b0369\"> </a><a name=\"hc91939311-86b6-3bfc-8640-d1ec357b0369\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28105398114, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/H03AA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28105398114}, {http://www.whocc.no/atc H03AA01}\">Eltroxin</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TAB}\">tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans LEVOTHYROXINNATRIUM}\">LEVOTHYROXINNATRIUM</span></td><td>true</td><td>100 microgram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeug = 'ug')</span>/1 tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter} = '{tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28105398114"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "H03AA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28105398114",
              "display" : "Eltroxin"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "H03AA01",
              "display" : "Levothyroxinnatrium"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "LEVOTHYROXINNATRIUM",
                  "display" : "LEVOTHYROXINNATRIUM"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 100,
                "unit" : "microgram",
                "system" : "http://unitsofmeasure.org",
                "code" : "ug"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "c4c89eca-0b66-3773-97cf-99c519051f8e",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "c4c89eca-0b66-3773-97cf-99c519051f8e",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_c4c89eca-0b66-3773-97cf-99c519051f8e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication c4c89eca-0b66-3773-97cf-99c519051f8e</b></p><a name=\"c4c89eca-0b66-3773-97cf-99c519051f8e\"> </a><a name=\"hcc4c89eca-0b66-3773-97cf-99c519051f8e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101317587, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101317587}, {http://www.whocc.no/atc N02BE01}\">Pamol</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>500 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101317587"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101317587",
              "display" : "Pamol"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "bf718851-946b-3156-9abf-f7985d912d62",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "bf718851-946b-3156-9abf-f7985d912d62",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_bf718851-946b-3156-9abf-f7985d912d62\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication bf718851-946b-3156-9abf-f7985d912d62</b></p><a name=\"bf718851-946b-3156-9abf-f7985d912d62\"> </a><a name=\"hcbf718851-946b-3156-9abf-f7985d912d62\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000051</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000051}\">Cannabidiol</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel ORALDRB}\">orale dråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000051"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000051",
              "display" : "Cannabidiol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "ORALDRB",
              "display" : "orale dråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "8b6b1af6-be30-3aab-bc03-1806cddaef86",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "8b6b1af6-be30-3aab-bc03-1806cddaef86",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_8b6b1af6-be30-3aab-bc03-1806cddaef86\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 8b6b1af6-be30-3aab-bc03-1806cddaef86</b></p><a name=\"8b6b1af6-be30-3aab-bc03-1806cddaef86\"> </a><a name=\"hc8b6b1af6-be30-3aab-bc03-1806cddaef86\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28105468514, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/B03BA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28105468514}, {http://www.whocc.no/atc B03BA01}\">Betolvex</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans CYANOCOBALAMIN}\">CYANOCOBALAMIN</span></td><td>true</td><td>1 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28105468514"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "B03BA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28105468514",
              "display" : "Betolvex"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "B03BA01",
              "display" : "Cyanocobalamin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "CYANOCOBALAMIN",
                  "display" : "CYANOCOBALAMIN"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "a5c53c39-570e-3b46-9161-7ba1aae2dc59",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "a5c53c39-570e-3b46-9161-7ba1aae2dc59",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_a5c53c39-570e-3b46-9161-7ba1aae2dc59\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication a5c53c39-570e-3b46-9161-7ba1aae2dc59</b></p><a name=\"a5c53c39-570e-3b46-9161-7ba1aae2dc59\"> </a><a name=\"hca5c53c39-570e-3b46-9161-7ba1aae2dc59\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101107682, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/B03BA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101107682}, {http://www.whocc.no/atc B03BA01}\">Betolvex</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans CYANOCOBALAMIN}\">CYANOCOBALAMIN</span></td><td>true</td><td>1 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101107682"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "B03BA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101107682",
              "display" : "Betolvex"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "B03BA01",
              "display" : "Cyanocobalamin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "CYANOCOBALAMIN",
                  "display" : "CYANOCOBALAMIN"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "6c10a690-7099-3185-b46c-29b17c77f135",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6c10a690-7099-3185-b46c-29b17c77f135",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6c10a690-7099-3185-b46c-29b17c77f135\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6c10a690-7099-3185-b46c-29b17c77f135</b></p><a name=\"6c10a690-7099-3185-b46c-29b17c77f135\"> </a><a name=\"hc6c10a690-7099-3185-b46c-29b17c77f135\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101339688, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/R03BA02</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101339688}, {http://www.whocc.no/atc R03BA02}\">Spirocort Turbuhaler</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INHPUL}\">inhalationspulver</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans BUDESONID}\">BUDESONID</span></td><td>true</td><td>400 microgram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeug = 'ug')</span>/1 dose<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{Dose} = '{Dose}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101339688"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "R03BA02"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101339688",
              "display" : "Spirocort Turbuhaler"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R03BA02",
              "display" : "Budesonid"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INHPUL",
              "display" : "inhalationspulver"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "BUDESONID",
                  "display" : "BUDESONID"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 400,
                "unit" : "microgram",
                "system" : "http://unitsofmeasure.org",
                "code" : "ug"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "dose",
                "system" : "http://unitsofmeasure.org",
                "code" : "{Dose}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "4471ece3-f761-3b48-a2c3-e9785eea95ac",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "4471ece3-f761-3b48-a2c3-e9785eea95ac",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_4471ece3-f761-3b48-a2c3-e9785eea95ac\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 4471ece3-f761-3b48-a2c3-e9785eea95ac</b></p><a name=\"4471ece3-f761-3b48-a2c3-e9785eea95ac\"> </a><a name=\"hc4471ece3-f761-3b48-a2c3-e9785eea95ac\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101674394, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101674394}, {http://www.whocc.no/atc N02BE01}\">Panodil</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>1000 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101674394"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101674394",
              "display" : "Panodil"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "3df02ba7-025a-3ce0-b4f4-cf34c7d4036d",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "3df02ba7-025a-3ce0-b4f4-cf34c7d4036d",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_3df02ba7-025a-3ce0-b4f4-cf34c7d4036d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 3df02ba7-025a-3ce0-b4f4-cf34c7d4036d</b></p><a name=\"3df02ba7-025a-3ce0-b4f4-cf34c7d4036d\"> </a><a name=\"hc3df02ba7-025a-3ce0-b4f4-cf34c7d4036d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101807196, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N04BC06</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101807196}, {http://www.whocc.no/atc N04BC06}\">Cabaser</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TAB}\">tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans CABERGOLIN}\">CABERGOLIN</span></td><td>true</td><td>1 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter} = '{tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101807196"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N04BC06"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101807196",
              "display" : "Cabaser"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N04BC06",
              "display" : "Cabergolin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "CABERGOLIN",
                  "display" : "CABERGOLIN"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "acd71632-fc3f-3f65-8dab-7ef1e213ec9b",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "acd71632-fc3f-3f65-8dab-7ef1e213ec9b",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_acd71632-fc3f-3f65-8dab-7ef1e213ec9b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication acd71632-fc3f-3f65-8dab-7ef1e213ec9b</b></p><a name=\"acd71632-fc3f-3f65-8dab-7ef1e213ec9b\"> </a><a name=\"hcacd71632-fc3f-3f65-8dab-7ef1e213ec9b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28105484214, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/A10AE04</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28105484214}, {http://www.whocc.no/atc A10AE04}\">Abasaglar KwikPen</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INJVOP}\">injektionsvæske, opløsning i fyldt pen</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Insulin glargin}\">Insulin glargin</span></td><td>true</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28105484214"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "A10AE04"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28105484214",
              "display" : "Abasaglar KwikPen"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A10AE04",
              "display" : "Insulin glargin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INJVOP",
              "display" : "injektionsvæske, opløsning i fyldt pen"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Insulin glargin",
                  "display" : "Insulin glargin"
                }
              ]
            },
            "isActive" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "748dfcbf-fcde-3c1e-9fb9-798641608296",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "748dfcbf-fcde-3c1e-9fb9-798641608296",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_748dfcbf-fcde-3c1e-9fb9-798641608296\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 748dfcbf-fcde-3c1e-9fb9-798641608296</b></p><a name=\"748dfcbf-fcde-3c1e-9fb9-798641608296\"> </a><a name=\"hc748dfcbf-fcde-3c1e-9fb9-798641608296\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000250, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02AA01</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000250}, {http://www.whocc.no/atc N02AA01}\">Røde morfindråber</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel ORALDRB}\">orale dråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000250"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02AA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000250",
              "display" : "Røde morfindråber"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02AA01",
              "display" : "Morphin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "ORALDRB",
              "display" : "orale dråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "4dc06f2b-af82-3fad-be2f-85c751829380",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "4dc06f2b-af82-3fad-be2f-85c751829380",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_4dc06f2b-af82-3fad-be2f-85c751829380\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 4dc06f2b-af82-3fad-be2f-85c751829380</b></p><a name=\"4dc06f2b-af82-3fad-be2f-85c751829380\"> </a><a name=\"hc4dc06f2b-af82-3fad-be2f-85c751829380\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101891697, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/R06AX26</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101891697}, {http://www.whocc.no/atc R06AX26}\">Telfast</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans FEXOFENADINHYDROCHLORID}\">FEXOFENADINHYDROCHLORID</span></td><td>true</td><td>120 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101891697"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "R06AX26"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101891697",
              "display" : "Telfast"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R06AX26",
              "display" : "Fexofenadin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "FEXOFENADINHYDROCHLORID",
                  "display" : "FEXOFENADINHYDROCHLORID"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 120,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "107d658d-ed47-35c5-9f26-8e9af5e338df",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "107d658d-ed47-35c5-9f26-8e9af5e338df",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_107d658d-ed47-35c5-9f26-8e9af5e338df\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 107d658d-ed47-35c5-9f26-8e9af5e338df</b></p><a name=\"107d658d-ed47-35c5-9f26-8e9af5e338df\"> </a><a name=\"hc107d658d-ed47-35c5-9f26-8e9af5e338df\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000053</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000053}\">Cannabidiol</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel ORALDRB}\">orale dråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000053"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000053",
              "display" : "Cannabidiol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "ORALDRB",
              "display" : "orale dråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "0d5c4680-cde4-3d3e-a8cc-7921d92c7318",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "0d5c4680-cde4-3d3e-a8cc-7921d92c7318",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_0d5c4680-cde4-3d3e-a8cc-7921d92c7318\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 0d5c4680-cde4-3d3e-a8cc-7921d92c7318</b></p><a name=\"0d5c4680-cde4-3d3e-a8cc-7921d92c7318\"> </a><a name=\"hc0d5c4680-cde4-3d3e-a8cc-7921d92c7318\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28105051112, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/G03AA12</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28105051112}, {http://www.whocc.no/atc G03AA12}\">Asubtela</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans DROSPIRENON}\">DROSPIRENON</span></p><p><b>isActive</b>: true</p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Ethinylestradiol}\">Ethinylestradiol</span></p><p><b>isActive</b>: true</p></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28105051112"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "G03AA12"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28105051112",
              "display" : "Asubtela"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "G03AA12",
              "display" : "Drospirenon og ethinylestradiol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "DROSPIRENON",
                  "display" : "DROSPIRENON"
                }
              ]
            },
            "isActive" : true
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Ethinylestradiol",
                  "display" : "Ethinylestradiol"
                }
              ]
            },
            "isActive" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "d875b59e-95cb-3393-af74-e8d2ee67a2c8",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "d875b59e-95cb-3393-af74-e8d2ee67a2c8",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_d875b59e-95cb-3393-af74-e8d2ee67a2c8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication d875b59e-95cb-3393-af74-e8d2ee67a2c8</b></p><a name=\"d875b59e-95cb-3393-af74-e8d2ee67a2c8\"> </a><a name=\"hcd875b59e-95cb-3393-af74-e8d2ee67a2c8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019685388, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BG10</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019685388}, {http://www.whocc.no/atc N02BG10}\">Cannabidiol/dronabinol </span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel ORALDRB}\">orale dråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019685388"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BG10"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019685388",
              "display" : "Cannabidiol/dronabinol "
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BG10",
              "display" : "Cannabinoider"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "ORALDRB",
              "display" : "orale dråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "dd56c4fe-aa05-3074-84c3-04e4f0306c11",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "dd56c4fe-aa05-3074-84c3-04e4f0306c11",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_dd56c4fe-aa05-3074-84c3-04e4f0306c11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication dd56c4fe-aa05-3074-84c3-04e4f0306c11</b></p><a name=\"dd56c4fe-aa05-3074-84c3-04e4f0306c11\"> </a><a name=\"hcdd56c4fe-aa05-3074-84c3-04e4f0306c11\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28102960614, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/J05AR02</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28102960614}, {http://www.whocc.no/atc J05AR02}\">Abacavir/Lamivudin &quot;Mylan&quot;</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Abacavirhydrochlorid}\">Abacavirhydrochlorid</span></p><p><b>isActive</b>: true</p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans LAMIVUDIN}\">LAMIVUDIN</span></p><p><b>isActive</b>: true</p></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28102960614"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "J05AR02"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28102960614",
              "display" : "Abacavir/Lamivudin \"Mylan\""
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J05AR02",
              "display" : "Lamivudin og abacavir"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Abacavirhydrochlorid",
                  "display" : "Abacavirhydrochlorid"
                }
              ]
            },
            "isActive" : true
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "LAMIVUDIN",
                  "display" : "LAMIVUDIN"
                }
              ]
            },
            "isActive" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "f6a544c5-067d-3472-9842-9ba0a234141d",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "f6a544c5-067d-3472-9842-9ba0a234141d",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_f6a544c5-067d-3472-9842-9ba0a234141d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication f6a544c5-067d-3472-9842-9ba0a234141d</b></p><a name=\"f6a544c5-067d-3472-9842-9ba0a234141d\"> </a><a name=\"hcf6a544c5-067d-3472-9842-9ba0a234141d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28100902676, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/J01CE02</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28100902676}, {http://www.whocc.no/atc J01CE02}\">Primcillin</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode ORAGRAS}\">granulat til oral suspension</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Phenoxymethylpenicillinkalium}\">Phenoxymethylpenicillinkalium</span></td><td>true</td><td>50 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 milliliter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28100902676"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "J01CE02"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28100902676",
              "display" : "Primcillin"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J01CE02",
              "display" : "Phenoxymethylpenicillin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "ORAGRAS",
              "display" : "granulat til oral suspension"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Phenoxymethylpenicillinkalium",
                  "display" : "Phenoxymethylpenicillinkalium"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 50,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "milliliter",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "0f2266d9-47b8-32d4-a457-8c1cdf1aa76a",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "0f2266d9-47b8-32d4-a457-8c1cdf1aa76a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_0f2266d9-47b8-32d4-a457-8c1cdf1aa76a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 0f2266d9-47b8-32d4-a457-8c1cdf1aa76a</b></p><a name=\"0f2266d9-47b8-32d4-a457-8c1cdf1aa76a\"> </a><a name=\"hc0f2266d9-47b8-32d4-a457-8c1cdf1aa76a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28103253401, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/A10AB01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28103253401}, {http://www.whocc.no/atc A10AB01}\">Actrapid Penfill</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INJOCYL}\">injektionsvæske, opløsning i cylinderampul</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Insulin, humant (rDNA)}\">Insulin, humant (rDNA)</span></td><td>true</td><td>100 international unit<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code[iU] = '[iU]')</span>/1 milliliter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28103253401"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "A10AB01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28103253401",
              "display" : "Actrapid Penfill"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A10AB01",
              "display" : "Insulin (human)"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INJOCYL",
              "display" : "injektionsvæske, opløsning i cylinderampul"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Insulin, humant (rDNA)",
                  "display" : "Insulin, humant (rDNA)"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 100,
                "unit" : "international unit",
                "system" : "http://unitsofmeasure.org",
                "code" : "[iU]"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "milliliter",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "791c3eec-4133-32b6-82be-631edafcdacc",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "791c3eec-4133-32b6-82be-631edafcdacc",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_791c3eec-4133-32b6-82be-631edafcdacc\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 791c3eec-4133-32b6-82be-631edafcdacc</b></p><a name=\"791c3eec-4133-32b6-82be-631edafcdacc\"> </a><a name=\"hc791c3eec-4133-32b6-82be-631edafcdacc\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28100736376, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02AA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28100736376}, {http://www.whocc.no/atc N02AA01}\">Morfin &quot;DAK&quot;</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INJVSKO}\">injektionsvæske, opløsning</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans MORPHINHYDROCHLORID (trihydrate)}\">MORPHINHYDROCHLORID (trihydrate)</span></td><td>true</td><td>20 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 milliliter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28100736376"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02AA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28100736376",
              "display" : "Morfin \"DAK\""
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02AA01",
              "display" : "Morphin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INJVSKO",
              "display" : "injektionsvæske, opløsning"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "MORPHINHYDROCHLORID (trihydrate)",
                  "display" : "MORPHINHYDROCHLORID (trihydrate)"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 20,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "milliliter",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "71e4e5e5-0bdc-3ace-8629-d49a790a9f8d",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "71e4e5e5-0bdc-3ace-8629-d49a790a9f8d",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 71e4e5e5-0bdc-3ace-8629-d49a790a9f8d</b></p><a name=\"71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\"> </a><a name=\"hc71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101492592, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/R03AC03</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101492592}, {http://www.whocc.no/atc R03AC03}\">Bricanyl Turbuhaler</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INHPUL}\">inhalationspulver</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans TERBUTALINSULFAT}\">TERBUTALINSULFAT</span></td><td>true</td><td>0.25 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 dose<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{Dose} = '{Dose}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101492592"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "R03AC03"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101492592",
              "display" : "Bricanyl Turbuhaler"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R03AC03",
              "display" : "Terbutalin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INHPUL",
              "display" : "inhalationspulver"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "TERBUTALINSULFAT",
                  "display" : "TERBUTALINSULFAT"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 0.25,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "dose",
                "system" : "http://unitsofmeasure.org",
                "code" : "{Dose}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "0599fc68-abff-37e1-a5c2-f272291c5f8a",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "0599fc68-abff-37e1-a5c2-f272291c5f8a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_0599fc68-abff-37e1-a5c2-f272291c5f8a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 0599fc68-abff-37e1-a5c2-f272291c5f8a</b></p><a name=\"0599fc68-abff-37e1-a5c2-f272291c5f8a\"> </a><a name=\"hc0599fc68-abff-37e1-a5c2-f272291c5f8a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101497692, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N05AX08</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101497692}, {http://www.whocc.no/atc N05AX08}\">Risperdal</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans RISPERIDON}\">RISPERIDON</span></td><td>true</td><td>1 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101497692"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N05AX08"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101497692",
              "display" : "Risperdal"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N05AX08",
              "display" : "Risperidon"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "RISPERIDON",
                  "display" : "RISPERIDON"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 1,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "f15ebc61-e708-3bf8-8530-45c221f79e0f",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "f15ebc61-e708-3bf8-8530-45c221f79e0f",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_f15ebc61-e708-3bf8-8530-45c221f79e0f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication f15ebc61-e708-3bf8-8530-45c221f79e0f</b></p><a name=\"f15ebc61-e708-3bf8-8530-45c221f79e0f\"> </a><a name=\"hcf15ebc61-e708-3bf8-8530-45c221f79e0f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Local</code>/87000042004, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/M01AH02</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Local 87000042004}, {http://www.whocc.no/atc M01AH02}\">Vioxx</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode ORALOPL}\">oral opløsning</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Local",
            "value" : "87000042004"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "M01AH02"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Local",
              "code" : "87000042004",
              "display" : "Vioxx"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "M01AH02",
              "display" : "Rofecoxib"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "ORALOPL",
              "display" : "oral opløsning"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "393e5c51-1641-385b-9a18-069b597106a8",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "393e5c51-1641-385b-9a18-069b597106a8",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_393e5c51-1641-385b-9a18-069b597106a8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 393e5c51-1641-385b-9a18-069b597106a8</b></p><a name=\"393e5c51-1641-385b-9a18-069b597106a8\"> </a><a name=\"hc393e5c51-1641-385b-9a18-069b597106a8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101195484, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101195484}, {http://www.whocc.no/atc N02BE01}\">Pinex</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode BRUTAB}\">brusetabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>500 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 brusetabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{brusetabletter} = '{brusetabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101195484"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101195484",
              "display" : "Pinex"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "BRUTAB",
              "display" : "brusetabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "brusetabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{brusetabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "f4e4d9b4-25b4-3808-b970-8ac1fe41b088",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "f4e4d9b4-25b4-3808-b970-8ac1fe41b088",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_f4e4d9b4-25b4-3808-b970-8ac1fe41b088\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication f4e4d9b4-25b4-3808-b970-8ac1fe41b088</b></p><a name=\"f4e4d9b4-25b4-3808-b970-8ac1fe41b088\"> </a><a name=\"hcf4e4d9b4-25b4-3808-b970-8ac1fe41b088\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28103176800, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28103176800}, {http://www.whocc.no/atc N02BE01}\">Panodil</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABMOD}\">tabletter med modificeret udløsning</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>665 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 tabletter med modificeret udløsning<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter med modificeret udløsning} = '{tabletter med modificeret udløsning}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28103176800"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28103176800",
              "display" : "Panodil"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABMOD",
              "display" : "tabletter med modificeret udløsning"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 665,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter med modificeret udløsning",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter med modificeret udløsning}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "a5228734-6734-3d2a-b0d2-b6f45b23210e",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "a5228734-6734-3d2a-b0d2-b6f45b23210e",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_a5228734-6734-3d2a-b0d2-b6f45b23210e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication a5228734-6734-3d2a-b0d2-b6f45b23210e</b></p><a name=\"a5228734-6734-3d2a-b0d2-b6f45b23210e\"> </a><a name=\"hca5228734-6734-3d2a-b0d2-b6f45b23210e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28100485165, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/H02AB01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28100485165}, {http://www.whocc.no/atc H02AB01}\">Celeston</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INJVSKS}\">injektionsvæske, suspension</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans BETAMETHASONDINATRIUMPHOSPHAT}\">BETAMETHASONDINATRIUMPHOSPHAT</span></p><p><b>isActive</b>: true</p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans BETAMETHASONACETAT}\">BETAMETHASONACETAT</span></p><p><b>isActive</b>: true</p></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28100485165"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "H02AB01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28100485165",
              "display" : "Celeston"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "H02AB01",
              "display" : "Betamethason"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INJVSKS",
              "display" : "injektionsvæske, suspension"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "BETAMETHASONDINATRIUMPHOSPHAT",
                  "display" : "BETAMETHASONDINATRIUMPHOSPHAT"
                }
              ]
            },
            "isActive" : true
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "BETAMETHASONACETAT",
                  "display" : "BETAMETHASONACETAT"
                }
              ]
            },
            "isActive" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "a85e2b7a-7c23-3292-9c81-f4d37c4656bd",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "a85e2b7a-7c23-3292-9c81-f4d37c4656bd",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_a85e2b7a-7c23-3292-9c81-f4d37c4656bd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication a85e2b7a-7c23-3292-9c81-f4d37c4656bd</b></p><a name=\"a85e2b7a-7c23-3292-9c81-f4d37c4656bd\"> </a><a name=\"hca85e2b7a-7c23-3292-9c81-f4d37c4656bd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28103606003, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/M05BA04</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28103606003}, {http://www.whocc.no/atc M05BA04}\">Alendronat &quot;Mylan&quot;</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TAB}\">tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans Natriumalendronattrihydrat}\">Natriumalendronattrihydrat</span></td><td>true</td><td>70 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter} = '{tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28103606003"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "M05BA04"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28103606003",
              "display" : "Alendronat \"Mylan\""
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "M05BA04",
              "display" : "Alendronsyre"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "Natriumalendronattrihydrat",
                  "display" : "Natriumalendronattrihydrat"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 70,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "08b7dcd1-4bf1-3c00-b857-997232599b3a",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "08b7dcd1-4bf1-3c00-b857-997232599b3a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_08b7dcd1-4bf1-3c00-b857-997232599b3a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 08b7dcd1-4bf1-3c00-b857-997232599b3a</b></p><a name=\"08b7dcd1-4bf1-3c00-b857-997232599b3a\"> </a><a name=\"hc08b7dcd1-4bf1-3c00-b857-997232599b3a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28104061107, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/B02AA02</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28104061107}, {http://www.whocc.no/atc B02AA02}\">Cyklonova</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans TRANEXAMSYRE}\">TRANEXAMSYRE</span></td><td>true</td><td>500 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28104061107"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "B02AA02"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28104061107",
              "display" : "Cyklonova"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "B02AA02",
              "display" : "Tranexamsyre"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "TRANEXAMSYRE",
                  "display" : "TRANEXAMSYRE"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "7c1c59a6-c198-3b04-8130-c721aab665d0",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "7c1c59a6-c198-3b04-8130-c721aab665d0",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_7c1c59a6-c198-3b04-8130-c721aab665d0\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 7c1c59a6-c198-3b04-8130-c721aab665d0</b></p><a name=\"7c1c59a6-c198-3b04-8130-c721aab665d0\"> </a><a name=\"hc7c1c59a6-c198-3b04-8130-c721aab665d0\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28100636073, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02BE01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28100636073}, {http://www.whocc.no/atc N02BE01}\">Panodil</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TABFILM}\">filmovertrukne tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans PARACETAMOL}\">PARACETAMOL</span></td><td>true</td><td>500 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 filmovertrukne tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{filmovertrukne tabletter} = '{filmovertrukne tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28100636073"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02BE01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28100636073",
              "display" : "Panodil"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "Paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TABFILM",
              "display" : "filmovertrukne tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "PARACETAMOL",
                  "display" : "PARACETAMOL"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "filmovertrukne tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{filmovertrukne tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "51b4d793-c635-3e47-b9b9-e37b6a391e61",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "51b4d793-c635-3e47-b9b9-e37b6a391e61",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_51b4d793-c635-3e47-b9b9-e37b6a391e61\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 51b4d793-c635-3e47-b9b9-e37b6a391e61</b></p><a name=\"51b4d793-c635-3e47-b9b9-e37b6a391e61\"> </a><a name=\"hc51b4d793-c635-3e47-b9b9-e37b6a391e61\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28104249507, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/C08CA01</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28104249507}, {http://www.whocc.no/atc C08CA01}\">Amlodipin &quot;Teva&quot;</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode TAB}\">tabletter</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans AMLODIPINBESILAT}\">AMLODIPINBESILAT</span></td><td>true</td><td>10 milligram<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 tabletter<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tabletter} = '{tabletter}')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28104249507"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "C08CA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28104249507",
              "display" : "Amlodipin \"Teva\""
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C08CA01",
              "display" : "Amlodipin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "AMLODIPINBESILAT",
                  "display" : "AMLODIPINBESILAT"
                }
              ]
            },
            "isActive" : true,
            "strength" : {
              "numerator" : {
                "value" : 10,
                "unit" : "milligram",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "tabletter",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tabletter}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "0b6b9668-11f0-3b81-a4b6-8a93edc8d29b",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "0b6b9668-11f0-3b81-a4b6-8a93edc8d29b",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_0b6b9668-11f0-3b81-a4b6-8a93edc8d29b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 0b6b9668-11f0-3b81-a4b6-8a93edc8d29b</b></p><a name=\"0b6b9668-11f0-3b81-a4b6-8a93edc8d29b\"> </a><a name=\"hc0b6b9668-11f0-3b81-a4b6-8a93edc8d29b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000071, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/S01HA01</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000071}, {http://www.whocc.no/atc S01HA01}\">Kokain</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel OJDRB}\">øjendråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000071"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "S01HA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000071",
              "display" : "Kokain"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "S01HA01",
              "display" : "Cocain"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "OJDRB",
              "display" : "øjendråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "6e4ef1e0-96ec-3161-9b63-db07588fb514",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6e4ef1e0-96ec-3161-9b63-db07588fb514",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6e4ef1e0-96ec-3161-9b63-db07588fb514\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6e4ef1e0-96ec-3161-9b63-db07588fb514</b></p><a name=\"6e4ef1e0-96ec-3161-9b63-db07588fb514\"> </a><a name=\"hc6e4ef1e0-96ec-3161-9b63-db07588fb514\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000052</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000052}\">Cannabidiol</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel ORALDRB}\">orale dråber</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000052"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000052",
              "display" : "Cannabidiol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "ORALDRB",
              "display" : "orale dråber"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "108abb8c-6a45-3d46-90fe-2a6c23eb5f90",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "108abb8c-6a45-3d46-90fe-2a6c23eb5f90",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_108abb8c-6a45-3d46-90fe-2a6c23eb5f90\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 108abb8c-6a45-3d46-90fe-2a6c23eb5f90</b></p><a name=\"108abb8c-6a45-3d46-90fe-2a6c23eb5f90\"> </a><a name=\"hc108abb8c-6a45-3d46-90fe-2a6c23eb5f90\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019000331, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N02AA01</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019000331}, {http://www.whocc.no/atc N02AA01}\">Morfin u. stabilisering</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel INJVSK}\">injektionsvæske</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019000331"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N02AA01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019000331",
              "display" : "Morfin u. stabilisering"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02AA01",
              "display" : "Morphin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "INJVSK",
              "display" : "injektionsvæske"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "e05a2437-83d7-3421-9b6f-3ef09ba87ce0",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "e05a2437-83d7-3421-9b6f-3ef09ba87ce0",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_e05a2437-83d7-3421-9b6f-3ef09ba87ce0\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication e05a2437-83d7-3421-9b6f-3ef09ba87ce0</b></p><a name=\"e05a2437-83d7-3421-9b6f-3ef09ba87ce0\"> </a><a name=\"hce05a2437-83d7-3421-9b6f-3ef09ba87ce0\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>https://laegemiddelstyrelsen.dk/LMS01/DrugID</code>/28101697994, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/N01AB08</p><p><b>code</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS01/DrugID 28101697994}, {http://www.whocc.no/atc N01AB08}\">Sevorane</span></p><p><b>form</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS22/Kode INHDVSK}\">væske til inhalationsdamp</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>IsActive</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS30/Substans SEVOFLURAN}\">SEVOFLURAN</span></td><td>true</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
            "value" : "28101697994"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "N01AB08"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS01/DrugID",
              "code" : "28101697994",
              "display" : "Sevorane"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N01AB08",
              "display" : "Sevofluran"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://laegemiddelstyrelsen.dk/LMS22/Kode",
              "code" : "INHDVSK",
              "display" : "væske til inhalationsdamp"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS30/Substans",
                  "code" : "SEVOFLURAN",
                  "display" : "SEVOFLURAN"
                }
              ]
            },
            "isActive" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "b8065c87-dec6-36a4-8605-ca213a0c533a",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b8065c87-dec6-36a4-8605-ca213a0c533a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medication",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b8065c87-dec6-36a4-8605-ca213a0c533a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b8065c87-dec6-36a4-8605-ca213a0c533a</b></p><a name=\"b8065c87-dec6-36a4-8605-ca213a0c533a\"> </a><a name=\"hcb8065c87-dec6-36a4-8605-ca213a0c533a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medication.html\">IPA-Medication</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel</code>/73019685346, <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-v3-WC.html\" title=\"WHO ATC\">WHO ATC</a>/C04AC01</p><p><b>code</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel 73019685346}, {http://www.whocc.no/atc C04AC01}\">Nikotinsyre</span></p><p><b>form</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel TAB}\">tabletter</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
            "value" : "73019685346"
          },
          {
            "system" : "http://www.whocc.no/atc",
            "value" : "C04AC01"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugIdentifierPredefinedSourceType/Magistrel",
              "code" : "73019685346",
              "display" : "Nikotinsyre"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C04AC01",
              "display" : "Nicotinsyre"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugFormCodePredefinedSourceType/Magistrel",
              "code" : "TAB",
              "display" : "tabletter"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "a18f7f27-c090-3d56-86c1-54cca1c03f06",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "a18f7f27-c090-3d56-86c1-54cca1c03f06",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_a18f7f27-c090-3d56-86c1-54cca1c03f06\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement a18f7f27-c090-3d56-86c1-54cca1c03f06</b></p><a name=\"a18f7f27-c090-3d56-86c1-54cca1c03f06\"> </a><a name=\"hca18f7f27-c090-3d56-86c1-54cca1c03f06\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8518401</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_06520e16-88df-3e2c-8a39-2d57f59375aa\">Medication Pinemol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-04-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. apr. 2021:\n1 tablet 3 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 3 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8518401"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/06520e16-88df-3e2c-8a39-2d57f59375aa"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2021-04-07T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. apr. 2021:\n1 tablet 3 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-04-07T00:00:00+00:00"
                },
                "frequency" : 3,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "c671283e-e5b3-3be9-8beb-aae3b6039f42",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "c671283e-e5b3-3be9-8beb-aae3b6039f42",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_c671283e-e5b3-3be9-8beb-aae3b6039f42\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement c671283e-e5b3-3be9-8beb-aae3b6039f42</b></p><a name=\"c671283e-e5b3-3be9-8beb-aae3b6039f42\"> </a><a name=\"hcc671283e-e5b3-3be9-8beb-aae3b6039f42\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3317874</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_e5a8c48b-7ddc-3350-9388-36afc8702356\">Medication Marevan</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-03 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 10. mar. 2020:\n13,6 tabletter morgen og 13,6 tabletter middag - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Noon, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>13.6 tabletter</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3317874"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/e5a8c48b-7ddc-3350-9388-36afc8702356"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2018-10-03T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 10. mar. 2020:\n13,6 tabletter morgen og 13,6 tabletter middag - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-03-10T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 13.6,
                  "unit" : "tabletter"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "29ca7193-20f1-3ea5-afb6-0d14b25fb6d8",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29ca7193-20f1-3ea5-afb6-0d14b25fb6d8",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29ca7193-20f1-3ea5-afb6-0d14b25fb6d8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 29ca7193-20f1-3ea5-afb6-0d14b25fb6d8</b></p><a name=\"29ca7193-20f1-3ea5-afb6-0d14b25fb6d8\"> </a><a name=\"hc29ca7193-20f1-3ea5-afb6-0d14b25fb6d8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/5077007</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_93f4b432-06f7-3d23-8e17-35ca143e4951\">Medication Beclomet Easyhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-10-08 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 8. okt. 2019:\n2 sug 2 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 2 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>2 sug</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "5077007"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/93f4b432-06f7-3d23-8e17-35ca143e4951"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-10-08T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 8. okt. 2019:\n2 sug 2 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2019-10-08T00:00:00+00:00"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 2,
                  "unit" : "sug"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "5e812dea-3694-39a9-b1db-95313c0f7370",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "5e812dea-3694-39a9-b1db-95313c0f7370",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_5e812dea-3694-39a9-b1db-95313c0f7370\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 5e812dea-3694-39a9-b1db-95313c0f7370</b></p><a name=\"5e812dea-3694-39a9-b1db-95313c0f7370\"> </a><a name=\"hc5e812dea-3694-39a9-b1db-95313c0f7370\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3317878</p><p><b>status</b>: On Hold</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_91939311-86b6-3bfc-8640-d1ec357b0369\">Medication Eltroxin</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>Bombombom</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3317878"
          }
        ],
        "status" : "on-hold",
        "medicationReference" : {
          "reference" : "Medication/91939311-86b6-3bfc-8640-d1ec357b0369"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2018-10-02T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Bombombom",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "126017c0-15ed-3923-a275-83c253328a15",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "126017c0-15ed-3923-a275-83c253328a15",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_126017c0-15ed-3923-a275-83c253328a15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 126017c0-15ed-3923-a275-83c253328a15</b></p><a name=\"126017c0-15ed-3923-a275-83c253328a15\"> </a><a name=\"hc126017c0-15ed-3923-a275-83c253328a15\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3317879</p><p><b>status</b>: On Hold</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_c4c89eca-0b66-3773-97cf-99c519051f8e\">Medication Pamol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>rtherhqehr</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3317879"
          }
        ],
        "status" : "on-hold",
        "medicationReference" : {
          "reference" : "Medication/c4c89eca-0b66-3773-97cf-99c519051f8e"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2018-10-02T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "rtherhqehr",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "97ad406d-c5ea-32af-a227-a8fa2fff5d63",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "97ad406d-c5ea-32af-a227-a8fa2fff5d63",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_97ad406d-c5ea-32af-a227-a8fa2fff5d63\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 97ad406d-c5ea-32af-a227-a8fa2fff5d63</b></p><a name=\"97ad406d-c5ea-32af-a227-a8fa2fff5d63\"> </a><a name=\"hc97ad406d-c5ea-32af-a227-a8fa2fff5d63\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8552836</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_bf718851-946b-3156-9abf-f7985d912d62\">Medication Cannabidiol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-12-02 00:00:00+0000 --&gt; 2023-12-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>11 dråber</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>timing</b>: Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 dråbe</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8552836"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/bf718851-946b-3156-9abf-f7985d912d62"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2021-12-02T00:00:00+00:00",
          "end" : "2023-12-02T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-12-02T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 11,
                  "unit" : "dråber"
                }
              }
            ]
          },
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-12-02T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "dråbe"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "7c6b53a1-c6a9-3419-b39c-e7c349069970",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "7c6b53a1-c6a9-3419-b39c-e7c349069970",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_7c6b53a1-c6a9-3419-b39c-e7c349069970\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 7c6b53a1-c6a9-3419-b39c-e7c349069970</b></p><a name=\"7c6b53a1-c6a9-3419-b39c-e7c349069970\"> </a><a name=\"hc7c6b53a1-c6a9-3419-b39c-e7c349069970\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3317876</p><p><b>status</b>: On Hold</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_8b6b1af6-be30-3aab-bc03-1806cddaef86\">Medication Betolvex</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>5 gange i ugen...</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3317876"
          }
        ],
        "status" : "on-hold",
        "medicationReference" : {
          "reference" : "Medication/8b6b1af6-be30-3aab-bc03-1806cddaef86"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2018-10-02T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "5 gange i ugen...",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "ed84c82a-1514-3846-9952-ee16e8cdc90e",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "ed84c82a-1514-3846-9952-ee16e8cdc90e",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_ed84c82a-1514-3846-9952-ee16e8cdc90e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement ed84c82a-1514-3846-9952-ee16e8cdc90e</b></p><a name=\"ed84c82a-1514-3846-9952-ee16e8cdc90e\"> </a><a name=\"hced84c82a-1514-3846-9952-ee16e8cdc90e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3317877</p><p><b>status</b>: Stopped</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_a5c53c39-570e-3b46-9161-7ba1aae2dc59\">Medication Betolvex</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-02 00:00:00+0000 --&gt; 2021-12-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>Fritekst nr 2</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3317877"
          }
        ],
        "status" : "stopped",
        "medicationReference" : {
          "reference" : "Medication/a5c53c39-570e-3b46-9161-7ba1aae2dc59"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2018-10-02T00:00:00+00:00",
          "end" : "2021-12-02T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Fritekst nr 2",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "d41d4adb-4a3a-3edd-8e53-b327ffc464f3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "d41d4adb-4a3a-3edd-8e53-b327ffc464f3",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_d41d4adb-4a3a-3edd-8e53-b327ffc464f3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement d41d4adb-4a3a-3edd-8e53-b327ffc464f3</b></p><a name=\"d41d4adb-4a3a-3edd-8e53-b327ffc464f3\"> </a><a name=\"hcd41d4adb-4a3a-3edd-8e53-b327ffc464f3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8518601</p><p><b>status</b>: Completed</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_6c10a690-7099-3185-b46c-29b17c77f135\">Medication Spirocort Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-05-10 00:00:00+0000 --&gt; 2021-05-17 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. apr. 2021:\n1 sug 2 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 2 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 sug</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8518601"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/6c10a690-7099-3185-b46c-29b17c77f135"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2021-05-10T00:00:00+00:00",
          "end" : "2021-05-17T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. apr. 2021:\n1 sug 2 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-04-07T00:00:00+00:00"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "sug"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "ed992839-8337-3905-8a02-63dcc31a84b8",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "ed992839-8337-3905-8a02-63dcc31a84b8",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_ed992839-8337-3905-8a02-63dcc31a84b8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement ed992839-8337-3905-8a02-63dcc31a84b8</b></p><a name=\"ed992839-8337-3905-8a02-63dcc31a84b8\"> </a><a name=\"hced992839-8337-3905-8a02-63dcc31a84b8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8517001</p><p><b>status</b>: Stopped</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_4471ece3-f761-3b48-a2c3-e9785eea95ac\">Medication Panodil</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-03-26 00:00:00+0000 --&gt; 2022-07-06 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>AsNeeded[x]</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>Dette er en fritekst</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType EFTER_BEHOV}\">efter behov</span></td><td>true</td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8517001"
          }
        ],
        "status" : "stopped",
        "medicationReference" : {
          "reference" : "Medication/4471ece3-f761-3b48-a2c3-e9785eea95ac"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2021-03-26T00:00:00+00:00",
          "end" : "2022-07-06T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dette er en fritekst",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "EFTER_BEHOV",
                    "display" : "efter behov"
                  }
                ]
              }
            ],
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "430260fe-9968-3f16-a014-f1ec6cbb17db",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "430260fe-9968-3f16-a014-f1ec6cbb17db",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_430260fe-9968-3f16-a014-f1ec6cbb17db\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 430260fe-9968-3f16-a014-f1ec6cbb17db</b></p><a name=\"430260fe-9968-3f16-a014-f1ec6cbb17db\"> </a><a name=\"hc430260fe-9968-3f16-a014-f1ec6cbb17db\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8517002</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_3df02ba7-025a-3ce0-b4f4-cf34c7d4036d\">Medication Cabaser</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-03-26 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: Struktureret test</p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 injektionspen</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: Struktureret test</p><p><b>timing</b>: Noon, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>2 injektionspenne</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: Struktureret test</p><p><b>timing</b>: Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>3 injektionspenne</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: Struktureret test</p><p><b>timing</b>: Night, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>4 injektionspenne</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 26. mar. 2021 til d. 31. mar. 2021:\n3 injektionspenne efter behov, højst 2 gange dagligt\nBemærk: Struktureret test</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: Struktureret test</p><p><b>timing</b>: 2 per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>3 injektionspenne</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8517002"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/3df02ba7-025a-3ce0-b4f4-cf34c7d4036d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2021-03-26T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "Struktureret test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-03-26T00:00:00+00:00",
                  "end" : "2021-03-31T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "injektionspen"
                }
              }
            ]
          },
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "Struktureret test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-03-26T00:00:00+00:00",
                  "end" : "2021-03-31T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["NOON"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 2,
                  "unit" : "injektionspenne"
                }
              }
            ]
          },
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "Struktureret test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-03-26T00:00:00+00:00",
                  "end" : "2021-03-31T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 3,
                  "unit" : "injektionspenne"
                }
              }
            ]
          },
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "Struktureret test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-03-26T00:00:00+00:00",
                  "end" : "2021-03-31T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["NIGHT"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 4,
                  "unit" : "injektionspenne"
                }
              }
            ]
          },
          {
            "text" : "Dosering fra d. 26. mar. 2021 til d. 31. mar. 2021:\n3 injektionspenne efter behov, højst 2 gange dagligt\nBemærk: Struktureret test",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "Struktureret test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-03-26T00:00:00+00:00",
                  "end" : "2021-03-31T00:00:00+00:00"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 3,
                  "unit" : "injektionspenne"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "29613fa2-7540-32ee-a8c6-aa29e3ee740a",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29613fa2-7540-32ee-a8c6-aa29e3ee740a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29613fa2-7540-32ee-a8c6-aa29e3ee740a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 29613fa2-7540-32ee-a8c6-aa29e3ee740a</b></p><a name=\"29613fa2-7540-32ee-a8c6-aa29e3ee740a\"> </a><a name=\"hc29613fa2-7540-32ee-a8c6-aa29e3ee740a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8621005</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_acd71632-fc3f-3f65-8dab-7ef1e213ec9b\">Medication Abasaglar KwikPen</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-03-07 00:00:00+0000 --&gt; 2025-03-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. mar. 2023:\n40 enheder hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode SC}\">Subkutan anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>40 enheder</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8621005"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/acd71632-fc3f-3f65-8dab-7ef1e213ec9b"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2023-03-07T00:00:00+00:00",
          "end" : "2025-03-07T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. mar. 2023:\n40 enheder hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-03-07T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "SC",
                  "display" : "Subkutan anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 40,
                  "unit" : "enheder"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "8799c036-c040-379f-8d6d-65e0832c6b8a",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "8799c036-c040-379f-8d6d-65e0832c6b8a",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_8799c036-c040-379f-8d6d-65e0832c6b8a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 8799c036-c040-379f-8d6d-65e0832c6b8a</b></p><a name=\"8799c036-c040-379f-8d6d-65e0832c6b8a\"> </a><a name=\"hc8799c036-c040-379f-8d6d-65e0832c6b8a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8520204</p><p><b>status</b>: Stopped</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_4471ece3-f761-3b48-a2c3-e9785eea95ac\">Medication Panodil</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-04-15 00:00:00+0000 --&gt; 2022-07-06 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 15. apr. 2021 til d. 6. juli 2022:\n1 tablet 3 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 3 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8520204"
          }
        ],
        "status" : "stopped",
        "medicationReference" : {
          "reference" : "Medication/4471ece3-f761-3b48-a2c3-e9785eea95ac"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2021-04-15T00:00:00+00:00",
          "end" : "2022-07-06T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 15. apr. 2021 til d. 6. juli 2022:\n1 tablet 3 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-04-15T00:00:00+00:00",
                  "end" : "2022-07-06T00:00:00+00:00"
                },
                "frequency" : 3,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "0f0b4fd9-3242-3ce3-92bd-b01a154690a7",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "0f0b4fd9-3242-3ce3-92bd-b01a154690a7",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_0f0b4fd9-3242-3ce3-92bd-b01a154690a7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 0f0b4fd9-3242-3ce3-92bd-b01a154690a7</b></p><a name=\"0f0b4fd9-3242-3ce3-92bd-b01a154690a7\"> </a><a name=\"hc0f0b4fd9-3242-3ce3-92bd-b01a154690a7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8621004</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_748dfcbf-fcde-3c1e-9fb9-798641608296\">Medication Røde morfindråber</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-03-07 00:00:00+0000 --&gt; 2025-03-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. mar. 2023:\n6 dråber hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>6 dråber</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8621004"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/748dfcbf-fcde-3c1e-9fb9-798641608296"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2023-03-07T00:00:00+00:00",
          "end" : "2025-03-07T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. mar. 2023:\n6 dråber hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-03-07T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 6,
                  "unit" : "dråber"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "73500385-0fd9-3360-b08e-c1822c27f9de",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "73500385-0fd9-3360-b08e-c1822c27f9de",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_73500385-0fd9-3360-b08e-c1822c27f9de\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 73500385-0fd9-3360-b08e-c1822c27f9de</b></p><a name=\"73500385-0fd9-3360-b08e-c1822c27f9de\"> </a><a name=\"hc73500385-0fd9-3360-b08e-c1822c27f9de\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/7161983</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_4dc06f2b-af82-3fad-be2f-85c751829380\">Medication Telfast</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-07-14 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 14. juli 2020:\n1 tablet hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "7161983"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/4dc06f2b-af82-3fad-be2f-85c751829380"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-07-14T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 14. juli 2020:\n1 tablet hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-07-14T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "c9f70b9f-56d0-3536-b633-1db74bd59eda",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "c9f70b9f-56d0-3536-b633-1db74bd59eda",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_c9f70b9f-56d0-3536-b633-1db74bd59eda\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement c9f70b9f-56d0-3536-b633-1db74bd59eda</b></p><a name=\"c9f70b9f-56d0-3536-b633-1db74bd59eda\"> </a><a name=\"hcc9f70b9f-56d0-3536-b633-1db74bd59eda\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8490203</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_107d658d-ed47-35c5-9f26-8e9af5e338df\">Medication Cannabidiol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-01-29 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 29. jan. 2021 til d. 12. mar. 2021:\n1 dråbe efter behov, højst 1 gang dagligt\nBemærk: test</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></p><p><b>patientInstruction</b>: test</p><p><b>timing</b>: Once per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 dråbe</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8490203"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/107d658d-ed47-35c5-9f26-8e9af5e338df"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2021-01-29T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 29. jan. 2021 til d. 12. mar. 2021:\n1 dråbe efter behov, højst 1 gang dagligt\nBemærk: test",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "patientInstruction" : "test",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-01-29T00:00:00+00:00",
                  "end" : "2021-03-12T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "dråbe"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "0b4b6770-dfa1-3fc2-bc65-8f243d7b4769",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "0b4b6770-dfa1-3fc2-bc65-8f243d7b4769",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_0b4b6770-dfa1-3fc2-bc65-8f243d7b4769\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 0b4b6770-dfa1-3fc2-bc65-8f243d7b4769</b></p><a name=\"0b4b6770-dfa1-3fc2-bc65-8f243d7b4769\"> </a><a name=\"hc0b4b6770-dfa1-3fc2-bc65-8f243d7b4769\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8619224</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_0d5c4680-cde4-3d3e-a8cc-7921d92c7318\">Medication Asubtela</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-02-13 00:00:00+0000 --&gt; 2025-02-13 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 13. feb. 2023:\n1 tablet hver dag\nBemærk: efter skema</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>patientInstruction</b>: efter skema</p><p><b>timing</b>: Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8619224"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/0d5c4680-cde4-3d3e-a8cc-7921d92c7318"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2023-02-13T00:00:00+00:00",
          "end" : "2025-02-13T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 13. feb. 2023:\n1 tablet hver dag\nBemærk: efter skema",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "patientInstruction" : "efter skema",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-02-13T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "c7462be0-c86a-343a-9368-2c066d78d7f9",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "c7462be0-c86a-343a-9368-2c066d78d7f9",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_c7462be0-c86a-343a-9368-2c066d78d7f9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement c7462be0-c86a-343a-9368-2c066d78d7f9</b></p><a name=\"c7462be0-c86a-343a-9368-2c066d78d7f9\"> </a><a name=\"hcc7462be0-c86a-343a-9368-2c066d78d7f9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8490205</p><p><b>status</b>: Completed</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_d875b59e-95cb-3393-af74-e8d2ee67a2c8\">Medication Cannabidiol/dronabinol </a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2021-01-29 00:00:00+0000 --&gt; 2021-09-16 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>efter behov</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode DE}\">Dental anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8490205"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/d875b59e-95cb-3393-af74-e8d2ee67a2c8"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2021-01-29T00:00:00+00:00",
          "end" : "2021-09-16T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "efter behov",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "DE",
                  "display" : "Dental anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "d8b76b5f-56d7-375b-831f-6c1cbe68f05d",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "d8b76b5f-56d7-375b-831f-6c1cbe68f05d",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_d8b76b5f-56d7-375b-831f-6c1cbe68f05d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement d8b76b5f-56d7-375b-831f-6c1cbe68f05d</b></p><a name=\"d8b76b5f-56d7-375b-831f-6c1cbe68f05d\"> </a><a name=\"hcd8b76b5f-56d7-375b-831f-6c1cbe68f05d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8620446</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_dd56c4fe-aa05-3074-84c3-04e4f0306c11\">Medication Abacavir/Lamivudin &quot;Mylan&quot;</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-03-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. mar. 2023:\n8 tabletter hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>8 tabletter</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8620446"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/dd56c4fe-aa05-3074-84c3-04e4f0306c11"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2023-03-07T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. mar. 2023:\n8 tabletter hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-03-07T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 8,
                  "unit" : "tabletter"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "f45b2d67-423c-3349-88e2-c466c71d490f",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f45b2d67-423c-3349-88e2-c466c71d490f",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f45b2d67-423c-3349-88e2-c466c71d490f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f45b2d67-423c-3349-88e2-c466c71d490f</b></p><a name=\"f45b2d67-423c-3349-88e2-c466c71d490f\"> </a><a name=\"hcf45b2d67-423c-3349-88e2-c466c71d490f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8493404</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_f6a544c5-067d-3472-9842-9ba0a234141d\">Medication Primcillin</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-12-01 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 1. dec. 2020 til d. 1. jan. 2021:\n1 tablet morgen og 1 tablet aften - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8493404"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/f6a544c5-067d-3472-9842-9ba0a234141d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-12-01T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 1. dec. 2020 til d. 1. jan. 2021:\n1 tablet morgen og 1 tablet aften - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-12-01T00:00:00+00:00",
                  "end" : "2021-01-01T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "7863fbda-ca31-3476-9dc8-3a6f4bb03714",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "7863fbda-ca31-3476-9dc8-3a6f4bb03714",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_7863fbda-ca31-3476-9dc8-3a6f4bb03714\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 7863fbda-ca31-3476-9dc8-3a6f4bb03714</b></p><a name=\"7863fbda-ca31-3476-9dc8-3a6f4bb03714\"> </a><a name=\"hc7863fbda-ca31-3476-9dc8-3a6f4bb03714\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8620445</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_0f2266d9-47b8-32d4-a457-8c1cdf1aa76a\">Medication Actrapid Penfill</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-03-07 00:00:00+0000 --&gt; 2025-03-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. mar. 2023 til d. 14. maj 2025:\n5 IE efter behov, højst 25 gange dagligt</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType EFTER_BEHOV}\">efter behov</span></p><p><b>timing</b>: 25 per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode SC}\">Subkutan anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>5 IE</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8620445"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/0f2266d9-47b8-32d4-a457-8c1cdf1aa76a"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2023-03-07T00:00:00+00:00",
          "end" : "2025-03-07T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. mar. 2023 til d. 14. maj 2025:\n5 IE efter behov, højst 25 gange dagligt",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "EFTER_BEHOV",
                    "display" : "efter behov"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-03-07T00:00:00+00:00",
                  "end" : "2025-05-14T00:00:00+00:00"
                },
                "frequency" : 25,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "SC",
                  "display" : "Subkutan anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 5,
                  "unit" : "IE"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "833630b2-364a-3321-9077-e51231e69721",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "833630b2-364a-3321-9077-e51231e69721",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_833630b2-364a-3321-9077-e51231e69721\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 833630b2-364a-3321-9077-e51231e69721</b></p><a name=\"833630b2-364a-3321-9077-e51231e69721\"> </a><a name=\"hc833630b2-364a-3321-9077-e51231e69721\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8620444</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_791c3eec-4133-32b6-82be-631edafcdacc\">Medication Morfin &quot;DAK&quot;</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2023-03-07 00:00:00+0000 --&gt; 2025-03-07 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 7. mar. 2023 til d. 3. feb. 2025:\n5 ml efter behov, højst 4 gange dagligt</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType EFTER_BEHOV}\">efter behov</span></p><p><b>timing</b>: 4 per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IM}\">Intramuskulær anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>5 ml</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8620444"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/791c3eec-4133-32b6-82be-631edafcdacc"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2023-03-07T00:00:00+00:00",
          "end" : "2025-03-07T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 7. mar. 2023 til d. 3. feb. 2025:\n5 ml efter behov, højst 4 gange dagligt",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "EFTER_BEHOV",
                    "display" : "efter behov"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2023-03-07T00:00:00+00:00",
                  "end" : "2025-02-03T00:00:00+00:00"
                },
                "frequency" : 4,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IM",
                  "display" : "Intramuskulær anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 5,
                  "unit" : "ml"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "48e3280c-2e8f-32e4-b3b7-b51dddb33e81",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "48e3280c-2e8f-32e4-b3b7-b51dddb33e81",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_48e3280c-2e8f-32e4-b3b7-b51dddb33e81\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 48e3280c-2e8f-32e4-b3b7-b51dddb33e81</b></p><a name=\"48e3280c-2e8f-32e4-b3b7-b51dddb33e81\"> </a><a name=\"hc48e3280c-2e8f-32e4-b3b7-b51dddb33e81\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8493406</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_f6a544c5-067d-3472-9842-9ba0a234141d\">Medication Primcillin</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-12-01 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote><blockquote><p><b>dosage</b></p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>222 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8493406"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/f6a544c5-067d-3472-9842-9ba0a234141d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-12-01T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-01-21T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          },
          {
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-01-21T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 222,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "18f1c247-23de-3199-aca2-37d07219c084",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "18f1c247-23de-3199-aca2-37d07219c084",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_18f1c247-23de-3199-aca2-37d07219c084\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 18f1c247-23de-3199-aca2-37d07219c084</b></p><a name=\"18f1c247-23de-3199-aca2-37d07219c084\"> </a><a name=\"hc18f1c247-23de-3199-aca2-37d07219c084\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6734148</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\">Medication Bricanyl Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-11 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 12. maj 2020:\n25 mg morgen og 25 mg middag - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Noon, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>25 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6734148"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/71e4e5e5-0bdc-3ace-8629-d49a790a9f8d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-11T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 12. maj 2020:\n25 mg morgen og 25 mg middag - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-12T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 25,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "2aa08a5e-756b-39cc-b25f-59c74d052cc1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "2aa08a5e-756b-39cc-b25f-59c74d052cc1",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_2aa08a5e-756b-39cc-b25f-59c74d052cc1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 2aa08a5e-756b-39cc-b25f-59c74d052cc1</b></p><a name=\"2aa08a5e-756b-39cc-b25f-59c74d052cc1\"> </a><a name=\"hc2aa08a5e-756b-39cc-b25f-59c74d052cc1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3319952</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_0599fc68-abff-37e1-a5c2-f272291c5f8a\">Medication Risperdal</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2018-10-03 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>TestTest</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3319952"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/0599fc68-abff-37e1-a5c2-f272291c5f8a"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2018-10-03T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "TestTest",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb</b></p><a name=\"b54e1fb4-6d4d-3ab4-a41b-5010252c9eeb\"> </a><a name=\"hcb54e1fb4-6d4d-3ab4-a41b-5010252c9eeb\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6734146</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\">Medication Bricanyl Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-11 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 12. maj 2020:\n25 mg hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>25 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6734146"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/71e4e5e5-0bdc-3ace-8629-d49a790a9f8d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-11T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 12. maj 2020:\n25 mg hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-12T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 25,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "41a4dc8a-4d2f-33be-b177-1ef85735a0a0",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "41a4dc8a-4d2f-33be-b177-1ef85735a0a0",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_41a4dc8a-4d2f-33be-b177-1ef85735a0a0\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 41a4dc8a-4d2f-33be-b177-1ef85735a0a0</b></p><a name=\"41a4dc8a-4d2f-33be-b177-1ef85735a0a0\"> </a><a name=\"hc41a4dc8a-4d2f-33be-b177-1ef85735a0a0\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6691843</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_f15ebc61-e708-3bf8-8530-45c221f79e0f\">Medication Vioxx</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-04 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 5. maj 2020:\n25 ml hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>25 ml</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6691843"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/f15ebc61-e708-3bf8-8530-45c221f79e0f"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-04T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 5. maj 2020:\n25 ml hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-05T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 25,
                  "unit" : "ml"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "9aa00a63-3642-38b2-a1c7-b52f45e9331c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "9aa00a63-3642-38b2-a1c7-b52f45e9331c",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_9aa00a63-3642-38b2-a1c7-b52f45e9331c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 9aa00a63-3642-38b2-a1c7-b52f45e9331c</b></p><a name=\"9aa00a63-3642-38b2-a1c7-b52f45e9331c\"> </a><a name=\"hc9aa00a63-3642-38b2-a1c7-b52f45e9331c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/4903264</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_c4c89eca-0b66-3773-97cf-99c519051f8e\">Medication Pamol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-09-18 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 18. sep. 2019:\n1 tablet morgen, 1 tablet middag og 1 tablet aften - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Noon, Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "4903264"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/c4c89eca-0b66-3773-97cf-99c519051f8e"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-09-18T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 18. sep. 2019:\n1 tablet morgen, 1 tablet middag og 1 tablet aften - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2019-09-18T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON", "EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "a8fdda68-f49b-3740-afd4-162cad3fb03f",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "a8fdda68-f49b-3740-afd4-162cad3fb03f",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_a8fdda68-f49b-3740-afd4-162cad3fb03f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement a8fdda68-f49b-3740-afd4-162cad3fb03f</b></p><a name=\"a8fdda68-f49b-3740-afd4-162cad3fb03f\"> </a><a name=\"hca8fdda68-f49b-3740-afd4-162cad3fb03f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6733965</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\">Medication Bricanyl Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-11 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 12. maj 2020:\n25 mg morgen og 25 mg middag - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Noon, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>25 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6733965"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/71e4e5e5-0bdc-3ace-8629-d49a790a9f8d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-11T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 12. maj 2020:\n25 mg morgen og 25 mg middag - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-12T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 25,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "d43d7b68-9fe5-3cab-aecb-2a07016fff38",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "d43d7b68-9fe5-3cab-aecb-2a07016fff38",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_d43d7b68-9fe5-3cab-aecb-2a07016fff38\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement d43d7b68-9fe5-3cab-aecb-2a07016fff38</b></p><a name=\"d43d7b68-9fe5-3cab-aecb-2a07016fff38\"> </a><a name=\"hcd43d7b68-9fe5-3cab-aecb-2a07016fff38\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8566831</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_393e5c51-1641-385b-9a18-069b597106a8\">Medication Pinex</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-08-09 00:00:00+0000 --&gt; 2024-08-09 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 9. mar. 2022:\n1 brusetablet 3 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 3 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 brusetablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8566831"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/393e5c51-1641-385b-9a18-069b597106a8"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-08-09T00:00:00+00:00",
          "end" : "2024-08-09T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 9. mar. 2022:\n1 brusetablet 3 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2022-03-09T00:00:00+00:00"
                },
                "frequency" : 3,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "brusetablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "92ae5b23-7a6b-3d55-8c0d-19a8c8020052",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "92ae5b23-7a6b-3d55-8c0d-19a8c8020052",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_92ae5b23-7a6b-3d55-8c0d-19a8c8020052\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 92ae5b23-7a6b-3d55-8c0d-19a8c8020052</b></p><a name=\"92ae5b23-7a6b-3d55-8c0d-19a8c8020052\"> </a><a name=\"hc92ae5b23-7a6b-3d55-8c0d-19a8c8020052\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/7808473</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_f4e4d9b4-25b4-3808-b970-8ac1fe41b088\">Medication Panodil</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-10-21 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 21. okt. 2020:\n2 tabletter 3 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 3 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>2 tabletter</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "7808473"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/f4e4d9b4-25b4-3808-b970-8ac1fe41b088"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-10-21T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 21. okt. 2020:\n2 tabletter 3 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-10-21T00:00:00+00:00"
                },
                "frequency" : 3,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 2,
                  "unit" : "tabletter"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "a7662443-a0ba-3e8a-964e-bee66d20c378",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "a7662443-a0ba-3e8a-964e-bee66d20c378",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_a7662443-a0ba-3e8a-964e-bee66d20c378\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement a7662443-a0ba-3e8a-964e-bee66d20c378</b></p><a name=\"a7662443-a0ba-3e8a-964e-bee66d20c378\"> </a><a name=\"hca7662443-a0ba-3e8a-964e-bee66d20c378\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6690901</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_a5228734-6734-3d2a-b0d2-b6f45b23210e\">Medication Celeston</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-04 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 5. maj 2020:\n1 stk hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 stk</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6690901"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/a5228734-6734-3d2a-b0d2-b6f45b23210e"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-04T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 5. maj 2020:\n1 stk hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-05T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "stk"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "4c0fbdcf-7609-32c2-8765-49101520daa2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "4c0fbdcf-7609-32c2-8765-49101520daa2",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_4c0fbdcf-7609-32c2-8765-49101520daa2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 4c0fbdcf-7609-32c2-8765-49101520daa2</b></p><a name=\"4c0fbdcf-7609-32c2-8765-49101520daa2\"> </a><a name=\"hc4c0fbdcf-7609-32c2-8765-49101520daa2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/5418401</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_71e4e5e5-0bdc-3ace-8629-d49a790a9f8d\">Medication Bricanyl Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-11-13 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 13. nov. 2019:\n1 sug morgen, 1 sug middag, 1 sug aften og 1 sug nat - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Noon, Evening, Night, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 sug</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "5418401"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/71e4e5e5-0bdc-3ace-8629-d49a790a9f8d"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-11-13T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 13. nov. 2019:\n1 sug morgen, 1 sug middag, 1 sug aften og 1 sug nat - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2019-11-13T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON", "EVE", "NIGHT"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "sug"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "81319f72-c944-3dcf-842d-f64db3428477",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "81319f72-c944-3dcf-842d-f64db3428477",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_81319f72-c944-3dcf-842d-f64db3428477\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 81319f72-c944-3dcf-842d-f64db3428477</b></p><a name=\"81319f72-c944-3dcf-842d-f64db3428477\"> </a><a name=\"hc81319f72-c944-3dcf-842d-f64db3428477\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/4548401</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_a85e2b7a-7c23-3292-9c81-f4d37c4656bd\">Medication Alendronat &quot;Mylan&quot;</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-08-08 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 8. aug. 2019:\n23 mg morgen og 23 mg aften - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>23 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "4548401"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/a85e2b7a-7c23-3292-9c81-f4d37c4656bd"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-08-08T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 8. aug. 2019:\n23 mg morgen og 23 mg aften - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2019-08-08T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 23,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "ce7c63a6-e267-3d28-a7e8-ae4b921f0197",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "ce7c63a6-e267-3d28-a7e8-ae4b921f0197",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_ce7c63a6-e267-3d28-a7e8-ae4b921f0197\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement ce7c63a6-e267-3d28-a7e8-ae4b921f0197</b></p><a name=\"ce7c63a6-e267-3d28-a7e8-ae4b921f0197\"> </a><a name=\"hcce7c63a6-e267-3d28-a7e8-ae4b921f0197\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/4548403</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_08b7dcd1-4bf1-3c00-b857-997232599b3a\">Medication Cyklonova</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-08-02 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 10. mar. 2020:\n0,028 tablet morgen, 0,028 tablet aften og 0,028 tablet nat - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Evening, Night, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>0.028 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "4548403"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/08b7dcd1-4bf1-3c00-b857-997232599b3a"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-08-02T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 10. mar. 2020:\n0,028 tablet morgen, 0,028 tablet aften og 0,028 tablet nat - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-03-10T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE", "NIGHT"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 0.028,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "72714030-938b-3932-a3df-6e1720f14603",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "72714030-938b-3932-a3df-6e1720f14603",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_72714030-938b-3932-a3df-6e1720f14603\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 72714030-938b-3932-a3df-6e1720f14603</b></p><a name=\"72714030-938b-3932-a3df-6e1720f14603\"> </a><a name=\"hc72714030-938b-3932-a3df-6e1720f14603\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/3596096</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_7c1c59a6-c198-3b04-8130-c721aab665d0\">Medication Panodil</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-01-29 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 29. jan. 2019:\n1 tablet 3 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 3 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "3596096"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/7c1c59a6-c198-3b04-8130-c721aab665d0"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-01-29T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 29. jan. 2019:\n1 tablet 3 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2019-01-29T00:00:00+00:00"
                },
                "frequency" : 3,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "d8e5b781-d88b-320e-86de-1dfa20956c76",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "d8e5b781-d88b-320e-86de-1dfa20956c76",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_d8e5b781-d88b-320e-86de-1dfa20956c76\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement d8e5b781-d88b-320e-86de-1dfa20956c76</b></p><a name=\"d8e5b781-d88b-320e-86de-1dfa20956c76\"> </a><a name=\"hcd8e5b781-d88b-320e-86de-1dfa20956c76\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/4548402</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_51b4d793-c635-3e47-b9b9-e37b6a391e61\">Medication Amlodipin &quot;Teva&quot;</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2019-08-05 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 10. mar. 2020:\n1 tablet morgen og 1 tablet aften - hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Evening, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 tablet</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "4548402"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/51b4d793-c635-3e47-b9b9-e37b6a391e61"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2019-08-05T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 10. mar. 2020:\n1 tablet morgen og 1 tablet aften - hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-03-10T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "tablet"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "d6203e62-5980-364c-8611-8fd0f91f907c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "d6203e62-5980-364c-8611-8fd0f91f907c",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_d6203e62-5980-364c-8611-8fd0f91f907c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement d6203e62-5980-364c-8611-8fd0f91f907c</b></p><a name=\"d6203e62-5980-364c-8611-8fd0f91f907c\"> </a><a name=\"hcd6203e62-5980-364c-8611-8fd0f91f907c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8577211</p><p><b>status</b>: Stopped</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_0b6b9668-11f0-3b81-a4b6-8a93edc8d29b\">Medication Kokain</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-07-06 00:00:00+0000 --&gt; 2022-07-06 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering kun d. 6. juli 2022:\n1 dråbe efter behov, højst 1 gang dagligt</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType EFTER_BEHOV}\">efter behov</span></p><p><b>timing</b>: Once per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode BR}\">Intrabronkial anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 dråbe</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8577211"
          }
        ],
        "status" : "stopped",
        "medicationReference" : {
          "reference" : "Medication/0b6b9668-11f0-3b81-a4b6-8a93edc8d29b"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-07-06T00:00:00+00:00",
          "end" : "2022-07-06T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering kun d. 6. juli 2022:\n1 dråbe efter behov, højst 1 gang dagligt",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "EFTER_BEHOV",
                    "display" : "efter behov"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2022-07-06T00:00:00+00:00",
                  "end" : "2022-07-06T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "BR",
                  "display" : "Intrabronkial anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "dråbe"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "4ab65861-515c-38f6-a0d7-a713c49de130",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "4ab65861-515c-38f6-a0d7-a713c49de130",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_4ab65861-515c-38f6-a0d7-a713c49de130\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 4ab65861-515c-38f6-a0d7-a713c49de130</b></p><a name=\"4ab65861-515c-38f6-a0d7-a713c49de130\"> </a><a name=\"hc4ab65861-515c-38f6-a0d7-a713c49de130\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8571003</p><p><b>status</b>: Completed</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_6e4ef1e0-96ec-3161-9b63-db07588fb514\">Medication Cannabidiol</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-04-13 00:00:00+0000 --&gt; 2022-04-13 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering kun d. 13. apr. 2022:\n1 dråbe morgen, 1 dråbe middag, 1 dråbe aften og 1 dråbe nat\nBemærk: sdfsdfsdf</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>patientInstruction</b>: sdfsdfsdf</p><p><b>timing</b>: Morning, Noon, Evening, Night, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode OR}\">Oral anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 dråbe</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8571003"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/6e4ef1e0-96ec-3161-9b63-db07588fb514"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-04-13T00:00:00+00:00",
          "end" : "2022-04-13T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering kun d. 13. apr. 2022:\n1 dråbe morgen, 1 dråbe middag, 1 dråbe aften og 1 dråbe nat\nBemærk: sdfsdfsdf",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "patientInstruction" : "sdfsdfsdf",
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2022-04-13T00:00:00+00:00",
                  "end" : "2022-04-13T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "NOON", "EVE", "NIGHT"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "OR",
                  "display" : "Oral anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "dråbe"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "f3760a41-1066-3632-aaca-2c68b0248ace",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f3760a41-1066-3632-aaca-2c68b0248ace",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f3760a41-1066-3632-aaca-2c68b0248ace\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f3760a41-1066-3632-aaca-2c68b0248ace</b></p><a name=\"f3760a41-1066-3632-aaca-2c68b0248ace\"> </a><a name=\"hcf3760a41-1066-3632-aaca-2c68b0248ace\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/7494027</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_108abb8c-6a45-3d46-90fe-2a6c23eb5f90\">Medication Morfin u. stabilisering</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-08-09 00:00:00+0000 --&gt; 2024-08-09 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 10. sep. 2020:\n1 dråbe efter behov, højst 1 gang dagligt</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType EFTER_BEHOV}\">efter behov</span></p><p><b>timing</b>: Once per 1 day</p><p><b>asNeeded</b>: true</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode ET}\">Endotrakeopulmonar anvendelse</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 dråbe</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "7494027"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/108abb8c-6a45-3d46-90fe-2a6c23eb5f90"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-08-09T00:00:00+00:00",
          "end" : "2024-08-09T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 10. sep. 2020:\n1 dråbe efter behov, højst 1 gang dagligt",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "EFTER_BEHOV",
                    "display" : "efter behov"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-09-10T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "asNeededBoolean" : true,
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "ET",
                  "display" : "Endotrakeopulmonar anvendelse"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "dråbe"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "bbad992c-5506-3c12-b4fd-45991aa55d6f",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "bbad992c-5506-3c12-b4fd-45991aa55d6f",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_bbad992c-5506-3c12-b4fd-45991aa55d6f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement bbad992c-5506-3c12-b4fd-45991aa55d6f</b></p><a name=\"bbad992c-5506-3c12-b4fd-45991aa55d6f\"> </a><a name=\"hcbbad992c-5506-3c12-b4fd-45991aa55d6f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/6691615</p><p><b>status</b>: Unknown</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_e05a2437-83d7-3421-9b6f-3ef09ba87ce0\">Medication Sevorane</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2020-05-04 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 5. maj 2020:\n45 ml hver morgen</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: Morning, Once per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>45 ml</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "6691615"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/e05a2437-83d7-3421-9b6f-3ef09ba87ce0"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectiveDateTime" : "2020-05-04T00:00:00+00:00",
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 5. maj 2020:\n45 ml hver morgen",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2020-05-05T00:00:00+00:00"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 45,
                  "unit" : "ml"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "646a07df-4e85-3ae6-b33e-f15930b97cc7",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "646a07df-4e85-3ae6-b33e-f15930b97cc7",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_646a07df-4e85-3ae6-b33e-f15930b97cc7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 646a07df-4e85-3ae6-b33e-f15930b97cc7</b></p><a name=\"646a07df-4e85-3ae6-b33e-f15930b97cc7\"> </a><a name=\"hc646a07df-4e85-3ae6-b33e-f15930b97cc7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8535864</p><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_6c10a690-7099-3185-b46c-29b17c77f135\">Medication Spirocort Turbuhaler</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-08-09 00:00:00+0000 --&gt; 2024-08-09 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Dosering fra d. 1. juni 2021:\n1 sug 2 gange hver dag</p><p><b>additionalInstruction</b>: <span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType FAST}\">fast</span></p><p><b>timing</b>: 2 per 1 day</p><p><b>route</b>: <span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode IH}\">Til inhalation</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1 sug</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8535864"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6c10a690-7099-3185-b46c-29b17c77f135"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-08-09T00:00:00+00:00",
          "end" : "2024-08-09T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "Dosering fra d. 1. juni 2021:\n1 sug 2 gange hver dag",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "FAST",
                    "display" : "fast"
                  }
                ]
              }
            ],
            "timing" : {
              "repeat" : {
                "boundsPeriod" : {
                  "start" : "2021-06-01T00:00:00+00:00"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "IH",
                  "display" : "Til inhalation"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "sug"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "c31bc5f6-1160-3618-a706-e66e1b6e02ef",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "c31bc5f6-1160-3618-a706-e66e1b6e02ef",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-medicationstatement",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_c31bc5f6-1160-3618-a706-e66e1b6e02ef\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement c31bc5f6-1160-3618-a706-e66e1b6e02ef</b></p><a name=\"c31bc5f6-1160-3618-a706-e66e1b6e02ef\"> </a><a name=\"hcc31bc5f6-1160-3618-a706-e66e1b6e02ef\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-medicationstatement.html\">IPA-MedicationStatement</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>identifier</b>: <code>http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType</code>/8577209</p><p><b>status</b>: Stopped</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ole.html#Medication_b8065c87-dec6-36a4-8605-ca213a0c533a\">Medication Nikotinsyre</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>effective</b>: 2022-07-06 00:00:00+0000 --&gt; 2022-07-06 00:00:00+0000</p><p><b>informationSource</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td><td><b>AdditionalInstruction</b></td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td>sdfsdfsdf</td><td><span title=\"Codes:{http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType KOMBINERET}\">kombineret</span></td><td><span title=\"Codes:{https://laegemiddelstyrelsen.dk/LMS11/Kode VA}\">Vaginal anvendelse</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DrugMedicationIdentifierType",
            "value" : "8577209"
          }
        ],
        "status" : "stopped",
        "medicationReference" : {
          "reference" : "Medication/b8065c87-dec6-36a4-8605-ca213a0c533a"
        },
        "subject" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "effectivePeriod" : {
          "start" : "2022-07-06T00:00:00+00:00",
          "end" : "2022-07-06T00:00:00+00:00"
        },
        "informationSource" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "dosage" : [
          {
            "text" : "sdfsdfsdf",
            "additionalInstruction" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.dkma.dk/medicinecard/xml.schema/2015/01/01/DosageTypeType",
                    "code" : "KOMBINERET",
                    "display" : "kombineret"
                  }
                ]
              }
            ],
            "route" : {
              "coding" : [
                {
                  "system" : "https://laegemiddelstyrelsen.dk/LMS11/Kode",
                  "code" : "VA",
                  "display" : "Vaginal anvendelse"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "a02bd4c3-0912-33a9-aa44-2012d24540cf",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "a02bd4c3-0912-33a9-aa44-2012d24540cf",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_a02bd4c3-0912-33a9-aa44-2012d24540cf\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization a02bd4c3-0912-33a9-aa44-2012d24540cf</b></p><a name=\"a02bd4c3-0912-33a9-aa44-2012d24540cf\"> </a><a name=\"hca02bd4c3-0912-33a9-aa44-2012d24540cf\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115381738</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07AF01}, {https://www.ssi.dk/drugid 32115313006}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617206217}\">Difteri toxoid</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2018-12-17 23:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115381738"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07AF01",
              "display" : "Difteri toxoid"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115313006",
              "display" : "Difterivaccine \"SSI\""
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617206217",
              "display" : "Difteri"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2018-12-17T23:00:00+00:00"
      }
    },
    {
      "fullUrl" : "96e5efee-a9c7-3331-9a91-71001db79e3a",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "96e5efee-a9c7-3331-9a91-71001db79e3a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_96e5efee-a9c7-3331-9a91-71001db79e3a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 96e5efee-a9c7-3331-9a91-71001db79e3a</b></p><a name=\"96e5efee-a9c7-3331-9a91-71001db79e3a\"> </a><a name=\"hc96e5efee-a9c7-3331-9a91-71001db79e3a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115386535</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07CA02}, {https://www.ssi.dk/drugid 170641}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617151439}\">Difteri-pertussis-poliomyelitis-tetanus</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-02-07 23:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115386535"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07CA02",
              "display" : "Difteri-pertussis-poliomyelitis-tetanus"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "170641",
              "display" : "DiTeKiPol"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617151439",
              "display" : "Di-Te-Ki-Pol"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-02-07T23:00:00+00:00"
      }
    },
    {
      "fullUrl" : "5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5</b></p><a name=\"5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5\"> </a><a name=\"hc5d62e413-e1e2-33cc-bbc7-c7377fdf2bb5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115386536</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07CA02}, {https://www.ssi.dk/drugid 32115313025}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617151439}\">Difteri-pertussis-poliomyelitis-tetanus</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-01-31 23:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115386536"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07CA02",
              "display" : "Difteri-pertussis-poliomyelitis-tetanus"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115313025",
              "display" : "DiTeKiPol Booster"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617151439",
              "display" : "Di-Te-Ki-Pol"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-01-31T23:00:00+00:00"
      }
    },
    {
      "fullUrl" : "0a77a697-1b3c-3b7f-85b4-4ff779290b07",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "0a77a697-1b3c-3b7f-85b4-4ff779290b07",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_0a77a697-1b3c-3b7f-85b4-4ff779290b07\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 0a77a697-1b3c-3b7f-85b4-4ff779290b07</b></p><a name=\"0a77a697-1b3c-3b7f-85b4-4ff779290b07\"> </a><a name=\"hc0a77a697-1b3c-3b7f-85b4-4ff779290b07\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115412537</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07CA12}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617151408}\">Difteri-pertussis-polio-tetanus-hepatitis b</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-01-03 23:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115412537"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07CA12",
              "display" : "Difteri-pertussis-polio-tetanus-hepatitis b"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617151408",
              "display" : "Di-Te-Ki-Pol-HepB"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-01-03T23:00:00+00:00"
      }
    },
    {
      "fullUrl" : "2d55c34d-acc9-3070-828a-b5426b8e50e5",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "2d55c34d-acc9-3070-828a-b5426b8e50e5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_2d55c34d-acc9-3070-828a-b5426b8e50e5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 2d55c34d-acc9-3070-828a-b5426b8e50e5</b></p><a name=\"2d55c34d-acc9-3070-828a-b5426b8e50e5\"> </a><a name=\"hc2d55c34d-acc9-3070-828a-b5426b8e50e5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115459335</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07AH04}, {https://www.ssi.dk/drugid 191336}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617204292}\">Meningococcus, tetraval. purified polysacc.antigen</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-10-23 22:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115459335"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07AH04",
              "display" : "Meningococcus, tetraval. purified polysacc.antigen"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "191336",
              "display" : "Mencevax ACWY"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617204292",
              "display" : "Meningokok gruppe ACWY polysakkarid"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-10-23T22:00:00+00:00"
      }
    },
    {
      "fullUrl" : "6df37577-c943-35fd-bad0-",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "6df37577-c943-35fd-bad0-",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_6df37577-c943-35fd-bad0-\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 6df37577-c943-35fd-bad0-</b></p><a name=\"6df37577-c943-35fd-bad0-\"> </a><a name=\"hc6df37577-c943-35fd-bad0-\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115412737</p><p><b>status</b>: Entered in Error</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07CA12}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617151408}\">Difteri-pertussis-polio-tetanus-hepatitis b</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-06-19 14:57:39+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115412737"
          }
        ],
        "status" : "entered-in-error",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07CA12",
              "display" : "Difteri-pertussis-polio-tetanus-hepatitis b"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617151408",
              "display" : "Di-Te-Ki-Pol-HepB"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-06-19T14:57:39+00:00"
      }
    },
    {
      "fullUrl" : "924ce259-decd-33ca-8969-e632a45c47f0",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "924ce259-decd-33ca-8969-e632a45c47f0",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_924ce259-decd-33ca-8969-e632a45c47f0\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 924ce259-decd-33ca-8969-e632a45c47f0</b></p><a name=\"924ce259-decd-33ca-8969-e632a45c47f0\"> </a><a name=\"hc924ce259-decd-33ca-8969-e632a45c47f0\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115412536</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07AG01}, {https://www.ssi.dk/drugid 32115313002}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617205256}\">Hemophilus influenzae b, purif. antig. conjugated</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-06-18 22:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115412536"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07AG01",
              "display" : "Hemophilus influenzae b, purif. antig. conjugated"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115313002",
              "display" : "Act-hib"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617205256",
              "display" : "Hæmophilus influenza type B"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-06-18T22:00:00+00:00"
      }
    },
    {
      "fullUrl" : "139ad53a-217f-3e19-9540-d0d47a834174",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "139ad53a-217f-3e19-9540-d0d47a834174",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_139ad53a-217f-3e19-9540-d0d47a834174\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 139ad53a-217f-3e19-9540-d0d47a834174</b></p><a name=\"139ad53a-217f-3e19-9540-d0d47a834174\"> </a><a name=\"hc139ad53a-217f-3e19-9540-d0d47a834174\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115412736</p><p><b>status</b>: Entered in Error</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07CA02}, {https://www.ssi.dk/drugid 170641}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 1617151439}\">Difteri-pertussis-poliomyelitis-tetanus</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2019-06-18 22:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115412736"
          }
        ],
        "status" : "entered-in-error",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07CA02",
              "display" : "Difteri-pertussis-poliomyelitis-tetanus"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "170641",
              "display" : "DiTeKiPol"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "1617151439",
              "display" : "Di-Te-Ki-Pol"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2019-06-18T22:00:00+00:00"
      }
    },
    {
      "fullUrl" : "312445f3-900b-3f77-aa81-854000a700cd",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "312445f3-900b-3f77-aa81-854000a700cd",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_312445f3-900b-3f77-aa81-854000a700cd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization 312445f3-900b-3f77-aa81-854000a700cd</b></p><a name=\"312445f3-900b-3f77-aa81-854000a700cd\"> </a><a name=\"hc312445f3-900b-3f77-aa81-854000a700cd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115651052</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07BN02}, {https://www.ssi.dk/drugid 32115548735}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 32115548736}\">Covid-19, virusvektor, non-replikerende</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2021-05-27 10:35:39+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115651052"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BN02",
              "display" : "Covid-19, virusvektor, non-replikerende"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115548735",
              "display" : "Janssen COVID-19 vaccine"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "32115548736",
              "display" : "Janssen COVID-19 vaccine"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2021-05-27T10:35:39+00:00"
      }
    },
    {
      "fullUrl" : "e15164fc-8238-35e1-a56c-31f5f5d7c6b3",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "e15164fc-8238-35e1-a56c-31f5f5d7c6b3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_e15164fc-8238-35e1-a56c-31f5f5d7c6b3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization e15164fc-8238-35e1-a56c-31f5f5d7c6b3</b></p><a name=\"e15164fc-8238-35e1-a56c-31f5f5d7c6b3\"> </a><a name=\"hce15164fc-8238-35e1-a56c-31f5f5d7c6b3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115719736</p><p><b>status</b>: Entered in Error</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07BN01}, {https://www.ssi.dk/drugid 32115514735}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 32115515736}\">Covid-19, rna-baseret vaccine</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2022-01-03 23:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115719736"
          }
        ],
        "status" : "entered-in-error",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BN01",
              "display" : "Covid-19, rna-baseret vaccine"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115514735",
              "display" : "Pfizer BioNTech COVID-19 Vacc"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "32115515736",
              "display" : "Pfizer BioNTech Covid-19 vacc"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2022-01-03T23:00:00+00:00"
      }
    },
    {
      "fullUrl" : "d35d99ba-32af-373a-97e3-e2a9efc8ba1b",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "d35d99ba-32af-373a-97e3-e2a9efc8ba1b",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-immunization",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_d35d99ba-32af-373a-97e3-e2a9efc8ba1b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization d35d99ba-32af-373a-97e3-e2a9efc8ba1b</b></p><a name=\"d35d99ba-32af-373a-97e3-e2a9efc8ba1b\"> </a><a name=\"hcd35d99ba-32af-373a-97e3-e2a9efc8ba1b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-immunization.html\">IPA-Immunization</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>identifier</b>: <code>http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType</code>/32115719739</p><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://www.whocc.no/atc J07BN01}, {https://www.ssi.dk/drugid 32115514735}, {http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType 32115515736}\">Covid-19, rna-baseret vaccine</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ole.html#Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</a></p><p><b>occurrence</b>: 2022-01-04 21:06:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccinationIdentifierType",
            "value" : "32115719739"
          }
        ],
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J07BN01",
              "display" : "Covid-19, rna-baseret vaccine"
            },
            {
              "system" : "https://www.ssi.dk/drugid",
              "code" : "32115514735",
              "display" : "Pfizer BioNTech COVID-19 Vacc"
            },
            {
              "system" : "http://vaccinationsregister.dk/schemas/2013/12/01/VaccineIdentifierType",
              "code" : "32115515736",
              "display" : "Pfizer BioNTech Covid-19 vacc"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/f7ab35b2-cbaf-3e6c-8913-f046f50f7e33"
        },
        "occurrenceDateTime" : "2022-01-04T21:06:00+00:00"
      }
    },
    {
      "fullUrl" : "b469dcd5-3746-35d5-868f-09c7ebf1f460",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "b469dcd5-3746-35d5-868f-09c7ebf1f460",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-practitioner",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_b469dcd5-3746-35d5-868f-09c7ebf1f460\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner b469dcd5-3746-35d5-868f-09c7ebf1f460</b></p><a name=\"b469dcd5-3746-35d5-868f-09c7ebf1f460\"> </a><a name=\"hcb469dcd5-3746-35d5-868f-09c7ebf1f460\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html\">IPA-Practitioner</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner</code></p></div><p><b>identifier</b>: <code>https://autregweb.sst.dk</code>/J0184 (use: official, )</p><p><b>active</b>: true</p><p><b>name</b>: Lars Larsen </p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><code>https://autregweb.sst.dk</code>/J0184 (use: official, )</td><td><span title=\"Codes:{http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes 7170}\">Læge</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://autregweb.sst.dk",
            "value" : "J0184"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Larsen",
            "given" : ["Lars"]
          }
        ],
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "system" : "https://autregweb.sst.dk",
                "value" : "J0184"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes",
                  "code" : "7170",
                  "display" : "Læge"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "f81e478b-a8dd-3f68-a9c3-1b857ea2472e",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "f81e478b-a8dd-3f68-a9c3-1b857ea2472e",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-practitioner",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_f81e478b-a8dd-3f68-a9c3-1b857ea2472e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner f81e478b-a8dd-3f68-a9c3-1b857ea2472e</b></p><a name=\"f81e478b-a8dd-3f68-a9c3-1b857ea2472e\"> </a><a name=\"hcf81e478b-a8dd-3f68-a9c3-1b857ea2472e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html\">IPA-Practitioner</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner</code></p></div><p><b>identifier</b>: <code>https://autregweb.sst.dk</code>/05087 (use: official, )</p><p><b>active</b>: true</p><p><b>name</b>: Emma Andersen </p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><code>https://autregweb.sst.dk</code>/05087 (use: official, )</td><td><span title=\"Codes:{http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes 7170}\">Læge</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://autregweb.sst.dk",
            "value" : "05087"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Andersen",
            "given" : ["Emma"]
          }
        ],
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "system" : "https://autregweb.sst.dk",
                "value" : "05087"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes",
                  "code" : "7170",
                  "display" : "Læge"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "0bf711af-c78d-3709-b87a-00d31a48c740",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "0bf711af-c78d-3709-b87a-00d31a48c740",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-practitioner",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_0bf711af-c78d-3709-b87a-00d31a48c740\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 0bf711af-c78d-3709-b87a-00d31a48c740</b></p><a name=\"0bf711af-c78d-3709-b87a-00d31a48c740\"> </a><a name=\"hc0bf711af-c78d-3709-b87a-00d31a48c740\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html\">IPA-Practitioner</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner</code></p></div><p><b>identifier</b>: <code>https://autregweb.sst.dk</code>/NS189 (use: official, )</p><p><b>active</b>: true</p><p><b>name</b>: Andreas Bach </p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><code>https://autregweb.sst.dk</code>/NS189 (use: official, )</td><td><span title=\"Codes:{http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes 7170}\">Læge</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://autregweb.sst.dk",
            "value" : "NS189"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Bach",
            "given" : ["Andreas"]
          }
        ],
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "system" : "https://autregweb.sst.dk",
                "value" : "NS189"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes",
                  "code" : "7170",
                  "display" : "Læge"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "323724ff-ee66-352c-a0fc-48b55a248355",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "323724ff-ee66-352c-a0fc-48b55a248355",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-practitioner",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_323724ff-ee66-352c-a0fc-48b55a248355\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 323724ff-ee66-352c-a0fc-48b55a248355</b></p><a name=\"323724ff-ee66-352c-a0fc-48b55a248355\"> </a><a name=\"hc323724ff-ee66-352c-a0fc-48b55a248355\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html\">IPA-Practitioner</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner</code></p></div><p><b>identifier</b>: <code>https://autregweb.sst.dk</code>/FMK04 (use: official, )</p><p><b>active</b>: true</p><p><b>name</b>: Trine Larsen </p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><code>https://autregweb.sst.dk</code>/FMK04 (use: official, )</td><td><span title=\"Codes:{http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes 7170}\">Læge</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://autregweb.sst.dk",
            "value" : "FMK04"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Larsen",
            "given" : ["Trine"]
          }
        ],
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "system" : "https://autregweb.sst.dk",
                "value" : "FMK04"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes",
                  "code" : "7170",
                  "display" : "Læge"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "55aa2345-b156-3218-b706-d9a4e4fb3d63",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "55aa2345-b156-3218-b706-d9a4e4fb3d63",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-practitioner",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_55aa2345-b156-3218-b706-d9a4e4fb3d63\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 55aa2345-b156-3218-b706-d9a4e4fb3d63</b></p><a name=\"55aa2345-b156-3218-b706-d9a4e4fb3d63\"> </a><a name=\"hc55aa2345-b156-3218-b706-d9a4e4fb3d63\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-practitioner.html\">IPA-Practitioner</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-practitioner</code></p></div><p><b>identifier</b>: <code>https://autregweb.sst.dk</code>/NRD40 (use: official, )</p><p><b>active</b>: true</p><p><b>name</b>: Allan Pedersen </p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td><code>https://autregweb.sst.dk</code>/NRD40 (use: official, )</td><td><span title=\"Codes:{http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes 7170}\">Læge</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://autregweb.sst.dk",
            "value" : "NRD40"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Pedersen",
            "given" : ["Allan"]
          }
        ],
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "system" : "https://autregweb.sst.dk",
                "value" : "NRD40"
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.dk/fhir/core/CodeSystem/DkCoreProfessionGroupCodes",
                  "code" : "7170",
                  "display" : "Læge"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "f7ab35b2-cbaf-3e6c-8913-f046f50f7e33",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "f7ab35b2-cbaf-3e6c-8913-f046f50f7e33",
        "meta" : {
          "source" : "https://services.nsi.dk/en/Services/FMK",
          "profile" : [
            "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-patient",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips",
            "http://hl7.dk/fhir/core/StructureDefinition/dk-core-patient"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient f7ab35b2-cbaf-3e6c-8913-f046f50f7e33</b></p><a name=\"f7ab35b2-cbaf-3e6c-8913-f046f50f7e33\"> </a><a name=\"hcf7ab35b2-cbaf-3e6c-8913-f046f50f7e33\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Information Source: <a href=\"https://services.nsi.dk/en/Services/FMK\">https://services.nsi.dk/en/Services/FMK</a></p><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ipa/STU1.1/StructureDefinition-ipa-patient.html\">IPA-Patient</a>, <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Patient-uv-ips.html\">Patient (IPS)</a>, <code>http://hl7.dk/fhir/core/StructureDefinition/dk-core-patient</code></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Ole Rasmussen (official) Unknown, DoB: 1901-01-01 ( urn:oid:1.2.208.176.1.2#0101010101 (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\">Strandvejen 218, 3. tv 6300 </td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "urn:oid:1.2.208.176.1.2",
            "value" : "0101010101"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "family" : "Rasmussen",
            "given" : ["Ole"]
          }
        ],
        "gender" : "unknown",
        "birthDate" : "1901-01-01",
        "address" : [
          {
            "type" : "both",
            "line" : ["Strandvejen 218, 3. tv"],
            "district" : "Gråsten",
            "postalCode" : "6300"
          }
        ]
      }
    }
  ]
}

```
