# Maria Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Maria Gravitate's IPS**

## Example Bundle: Maria Gravitate's IPS

**id:**gravitate-maria

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**maria-1

**Name:**Maria Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Allergies and Intolerances

**Allergy:**Pollen (256259004)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Reaction:**Allergic rhinitis caused by pollen (21719001)

#### Problem List

**Condition:**Psoriasis (9014002)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**Condition:**Congestive heart failure (42343007)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**onsetDateTime:**2015

**Condition:**Hypertension (38341003)

**clinicalStatus:**active

**onsetDateTime:**1993

#### Medication Summary

**Medication:**Dimethyl fumarate 30 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/17/1201/002 [Skilarence 120 mg gastro-resistant tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x9982CA8A825D4561506CE808982E3B9D [dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet]

*  **System** http://www.whocc.no/atc **Code:** L04AX07 [dimethyl fumarate]

**Dose Form:**Gastro-resistant tablet

**Ingredient:**dimethyl fumarate (http://fdasis.nlm.nih.gov#FO2303MNI2)

**strength:**30 mg/1 Tablet

**Route:**Oral use

**Medication:**Irbesartan 75 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/97/049/001 [Karvea 75 mg/ 1 tablet, Tablet]

*  **System** https://www.who-umc.org/phpid **Code:** 0x8DFB446EDB3B8AE508AE493827A704E4 [Irbesartan, 75 mg/ 1 tablet, Tablet]

*  **System** http://www.whocc.no/atc **Code:** C09DA04 [irbesartan and diuretics]

**Dose Form:**Tablet

**Ingredient:**irbesartan (http://fdasis.nlm.nih.gov#J0E2756Z7N)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Oxymetazoline hydrochloride 0.05 mg / 1 ml Spray

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 16028/0671 [Boots Decongestant 0.05% w/v Nasal spray]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E88901 [Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution]

*  **System** http://www.whocc.no/atc **Code:** R01AA05 [oxymetazoline]

**Dose Form:**

**Ingredient:**oxymetazoline hydrochloride (http://fdasis.nlm.nih.gov#K89MJ0S5VY)

**strength:**0.05 mg/1 ml

**Route:**Nasal use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-maria",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "maria-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/2fa5b223-ebce-4f39-9c66-5dc014f73572",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-maria",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-maria\"> </a>\n  \n\n    \n      <b>Id:</b>\n      gravitate-maria\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Maria Gravitate</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Hay fever (pollen)\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Psoriasis\n\n            </li>\n          \n\n            <li>\n\n              Hypertension\n\n            </li>\n          \n\n            <li>\n\n              Congestive heart failure\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Dimethyl fumarate 30 mg Gastro-resistant tablet\n\n            </li>\n          \n\n            <li>\n\n              Irbesartan 75 mg Tablet\n\n            </li>\n          \n\n            <li>\n\n              Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d8",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (Maria Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Hay fever (pollen)</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf07",
                "display" : "Hay fever (pollen)"
              }
            ]
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Psoriasis</li><li>Hypertension</li><li>Congestive heart failure</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "Condition/bcc79261-142c-48ec-b032-f3f9af49ec58",
                "display" : "Psoriasis"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5130",
                "display" : "Hypertension"
              },
              {
                "reference" : "Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6256",
                "display" : "Congestive heart failure"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Skilarence</td><td>EU/1/17/1201/001</td><td>dimethyl fumarate (FO2303MNI2)</td><td>dimethyl fumarate</td><td>L04AX07</td><td>30 mg</td><td>Gastro-resistant tablet</td><td>Oral use</td></tr><tr><td>Karvea</td><td>EMEA/H/C/000142</td><td>irbesartan (J0E2756Z7N)</td><td>irbesartan</td><td>C09DA04</td><td>75 mg</td><td>Tablet</td><td>Oral use</td></tr><tr><td>Boots Decongestant 0.05% w/v Nasal spray</td><td>PL 16028/0049</td><td>oxymetazoline hydrochloride (K89MJ0S5VY)</td><td>oxymetazoline hydrochloride</td><td>R01AA05</td><td>0.05 mg / 1 ml</td><td>Nasal spray, solution</td><td>Nasal use</td></tr></tbody></table></div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a899",
                "display" : "Dimethyl fumarate 30 mg Gastro-resistant tablet"
              },
              {
                "reference" : "MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78fd",
                "display" : "Irbesartan 75 mg Tablet"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87ba",
                "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "c154158f-6a43-4ab7-8443-e7f4bf915dd5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd5\"> </a>Maria Gravitate, Female, 75 years old (1946-05-05)</div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "NO",
                      "display" : "Norway"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "maria-1"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Maria"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d8",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "1ece89c5-fda3-4db9-ace6-decbe6c603d8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d8\"> </a>Dr. Anne Karlsson</div>"
        },
        "name" : [
          {
            "family" : "Karlsson",
            "given" : ["Anne"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf07",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "1dff4474-fa08-4f45-8260-dbb23094bf07",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_1dff4474-fa08-4f45-8260-dbb23094bf07\"> </a>Hay fever</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "256259004",
              "display" : "Pollen"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21719001",
                    "display" : "Allergic rhinitis caused by pollen"
                  }
                ],
                "text" : "Hay fever"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/bcc79261-142c-48ec-b032-f3f9af49ec58",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "bcc79261-142c-48ec-b032-f3f9af49ec58",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_bcc79261-142c-48ec-b032-f3f9af49ec58\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition bcc79261-142c-48ec-b032-f3f9af49ec58</b></p><a name=\"bcc79261-142c-48ec-b032-f3f9af49ec58\"> </a><a name=\"hcbcc79261-142c-48ec-b032-f3f9af49ec58\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 9014002}\">Psoriasis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-maria.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd5\">Maria Gravitate</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-maria.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d8\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "9014002",
              "display" : "Psoriasis"
            }
          ],
          "text" : "Psoriasis"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d8",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6256",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a4a9d90a-d1b0-4d60-82f0-c52343dc6256",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a4a9d90a-d1b0-4d60-82f0-c52343dc6256\"> </a>Congestive heart failure (2015)</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "42343007",
              "display" : "Congestive heart failure"
            }
          ],
          "text" : "Congestive heart failure"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d8",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5130",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e5130",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e5130\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e5130</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e5130\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e5130\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-maria.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd5\">Maria Gravitate</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a899",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29074ca4-efcb-4ff4-8446-feed2399a899",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29074ca4-efcb-4ff4-8446-feed2399a899\"> </a><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Skilarence</td><td>EU/1/17/1201/001</td><td>dimethyl fumarate (FO2303MNI2)</td><td>dimethyl fumarate</td><td>L04AX07</td><td>30 mg</td><td>Gastro-resistant tablet</td><td>Oral use</td></tr></tbody></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe36b",
          "display" : "Dimethyl fumarate 30 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78fd",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f6cb1218-f81c-4338-80d8-3c10910f78fd",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f6cb1218-f81c-4338-80d8-3c10910f78fd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f6cb1218-f81c-4338-80d8-3c10910f78fd</b></p><a name=\"f6cb1218-f81c-4338-80d8-3c10910f78fd\"> </a><a name=\"hcf6cb1218-f81c-4338-80d8-3c10910f78fd\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-maria.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c7\">Irbesartan 75 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-maria.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd5\">Maria Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c7",
          "display" : "Irbesartan 75 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87ba",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade87ba",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade87ba\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade87ba</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade87ba\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade87ba\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-maria.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef10\">Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-maria.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd5\">Maria Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20049000}\">Nasal use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef10",
          "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd5",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20049000",
                  "display" : "Nasal use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe36b",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe36b",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe36b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe36b</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe36b\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe36b\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/17/1201/002}, {https://www.who-umc.org/phpid 0x9982CA8A825D4561506CE808982E3B9D}, {http://www.whocc.no/atc L04AX07}\">Skilarence 120 mg gastro-resistant tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10225000}\">Gastro-resistant tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov FO2303MNI2}\">dimethyl fumarate</span></td><td>30 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/17/1201/002",
              "display" : "Skilarence 120 mg gastro-resistant tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x9982CA8A825D4561506CE808982E3B9D",
              "display" : "dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L04AX07",
              "display" : "dimethyl fumarate"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10225000",
              "display" : "Gastro-resistant tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "FO2303MNI2",
                  "display" : "dimethyl fumarate"
                }
              ],
              "text" : "dimethyl fumarate"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c7",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c7</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c7\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c7\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/97/049/001}, {https://www.who-umc.org/phpid 0x8DFB446EDB3B8AE508AE493827A704E4}, {http://www.whocc.no/atc C09DA04}\">Karvea 75 mg/ 1 tablet, Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov J0E2756Z7N}\">irbesartan</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/97/049/001",
              "display" : "Karvea 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x8DFB446EDB3B8AE508AE493827A704E4",
              "display" : "Irbesartan, 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C09DA04",
              "display" : "irbesartan and diuretics"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "J0E2756Z7N",
                  "display" : "irbesartan"
                }
              ],
              "text" : "irbesartan"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef10",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef10</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef10\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef10\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 16028/0671}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E88901}, {http://www.whocc.no/atc R01AA05}\">Boots Decongestant 0.05% w/v Nasal spray</span></p><p><b>form</b>: <span title=\"Codes:\">Nasal spray, solution</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov K89MJ0S5VY}\">oxymetazoline hydrochloride</span></td><td>0.05 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "16028/0671",
              "display" : "Boots Decongestant 0.05% w/v Nasal spray"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E88901",
              "display" : "Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R01AA05",
              "display" : "oxymetazoline"
            }
          ]
        },
        "form" : {
          "text" : "Nasal spray, solution"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "K89MJ0S5VY",
                  "display" : "oxymetazoline hydrochloride"
                }
              ],
              "text" : "oxymetazoline hydrochloride"
            },
            "strength" : {
              "numerator" : {
                "value" : 0.05,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "ml",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    }
  ]
}

```
