# IPS Example 4 - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IPS Example 4**

## Example Bundle: IPS Example 4

**id:**gravitate-ips-4

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**ips-4

**Name:**IPS 4 example Gravitate

**active:**true

**gender:**female

**Birth Date:**1989-05-05

### Sections

#### Allergies and Intolerances

**Allergy:**Pollen (256259004)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Reaction:**Allergic rhinitis caused by pollen (21719001)

**Allergy:**Intolerance to lactose (782415009)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Reaction:**Abdominal pain (21522001)

#### Problem List

**Condition:**Psoriasis (9014002)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**Condition:**Congestive heart failure (42343007)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**onsetDateTime:**2015

**Condition:**Hypertension (38341003)

**clinicalStatus:**active

**onsetDateTime:**1993

#### Medication Summary

**Medication:**Remsima 100 mg powder for concentrate for solution for infusion

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/13/853/001 [Remsima 100 mg powder for concentrate for solution for infusion]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82718 [Infliximab 100 mg powder for concentrate for solution for infusion]

**Dose Form:**Powder for concentrate for solution for injection/infusion

**Ingredient:**INFLIXIMAB (http://fdasis.nlm.nih.gov#B72HH48FLU)

**strength:**100 mg/1 Vial

**Route:**Intravenous use

**Medication:**Karvea 75 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/97/049/001 [Karvea 75 mg/ 1 tablet, Tablet]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82719 [Irbesartan, 75 mg/ 1 tablet, Tablet]

*  **System** http://www.whocc.no/atc **Code:** C09DA04 [irbesartan and diuretics]

**Dose Form:**Tablet

**Ingredient:**irbesartan (http://fdasis.nlm.nih.gov#J0E2756Z7N)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Humalog 100 U/ml 5 pre-filled pen

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/96/007/035 [Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82717 [Insulin Lispro 100 U/ml 5 pre-filled pen]

**Dose Form:**Suspension for injection

**Ingredient:**Insulin Lispro (http://fdasis.nlm.nih.gov#GFX7QIS1II)

**strength:**100 U/1 ml

**Route:**Subcutaneous use

**Medication:**citalopram

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 204447 [Citalopram Aurovitas 10 mg tablet]

**Route:**Subcutaneous use

**Medication:**Amlodipine Italy

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** AMLODIPINA-DOC-GENERICI-tablet-10mg--71-ITA-MPD [AMLODIPINA DOC GENERICI compresse 10 mg]

**Route:**Oral use

**Medication:**Amlodipine Norway

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** AMLODIPINA-SANDOZ-tablet-10mg--3-NO-MPD [Amlodipin sandoz 10 mg TABLETTER]

**Route:**Oral use

#### Vital Signs

#### Results

#### Pregnancy History

#### Social History



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-ips-4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "ips-4"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/2fa5b223-ebce-4f39-9c66-5dc014f73579",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "ips-example-4",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_ips-example-4\"> </a>\n  \n\n    \n      <b>Id:</b>\n      ips-example-4\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Example 4 Gravitate</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Hay fever (pollen)\n\n            </li>\n          \n\n            <li>\n\n              Lactose Intolerance\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Psoriasis\n\n            </li>\n          \n\n            <li>\n\n              Hypertension\n\n            </li>\n          \n\n            <li>\n\n              Congestive heart failure\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Remsima 100 mg powder for concentrate for solution for infusion\n\n            </li>\n          \n\n            <li>\n\n              Irbesartan 75 mg Tablet\n\n            </li>\n          \n\n            <li>\n\n              Pentasa Slow Release Tablets 1g\n\n            </li>\n          \n\n            <li>\n\n              citalopram statement\n\n            </li>\n          \n\n            <li>\n\n              Amlodipine Italy statement\n\n            </li>\n          \n\n            <li>\n\n              Amlodipine Norway statement\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Vital Signs\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Body weight\n\n            </li>\n          \n\n            <li>\n\n              Body height\n\n            </li>\n          \n\n            <li>\n\n              Blood pressure\n\n            </li>\n          \n\n            <li>\n\n              eGFR\n\n            </li>\n          \n\n            <li>\n\n              potassium\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Results\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              glucose\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Pregnancy History\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Pregrancy Status\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Social History\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Physical Activity\n\n            </li>\n          \n\n            <li>\n\n              Health Literacy\n\n            </li>\n          \n\n            <li>\n\n              Digital Literacy\n\n            </li>\n          \n\n            <li>\n\n              EQ-5D-5L\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "Example 4 Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d2",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (IPS Example 4 Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf02",
                "display" : "Hay fever (pollen)"
              },
              {
                "reference" : "AllergyIntolerance/9d18cddb-8e58-4fbb-82ec-09cc561ac802",
                "display" : "Lactose Intolerance"
              }
            ]
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/bcc79261-142c-48ec-b032-f3f9af49ec52",
                "display" : "Psoriasis"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5132",
                "display" : "Hypertension"
              },
              {
                "reference" : "Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6252",
                "display" : "Congestive heart failure"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a892",
                "display" : "Remsima 100 mg powder for concentrate for solution for infusion"
              },
              {
                "reference" : "MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f2",
                "display" : "Irbesartan 75 mg Tablet"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b2",
                "display" : "Pentasa Slow Release Tablets 1g"
              },
              {
                "reference" : "MedicationStatement/citalopram-statement",
                "display" : "citalopram statement"
              },
              {
                "reference" : "MedicationStatement/amlo-italy-statement",
                "display" : "Amlodipine Italy statement"
              },
              {
                "reference" : "MedicationStatement/amlo-norway-statement",
                "display" : "Amlodipine Norway statement"
              }
            ]
          },
          {
            "title" : "Vital Signs",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8716-3",
                  "display" : "Vital Signs"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/bw",
                "display" : "Body weight"
              },
              {
                "reference" : "Observation/bh",
                "display" : "Body height"
              },
              {
                "reference" : "Observation/ips4-bp",
                "display" : "Blood pressure"
              },
              {
                "reference" : "Observation/egfr",
                "display" : "eGFR"
              },
              {
                "reference" : "Observation/potassium",
                "display" : "potassium"
              }
            ]
          },
          {
            "title" : "Results",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "30954-2",
                  "display" : "Relevant diagnostic tests/laboratory data Narrative"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/glucose",
                "display" : "glucose"
              }
            ]
          },
          {
            "title" : "Pregnancy History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "Pregnancies Hx"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/e06e43a1-38d4-468f-8c35-f7f12da91062",
                "display" : "Pregrancy Status"
              }
            ]
          },
          {
            "title" : "Social History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "29762-2",
                  "display" : "Social History"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/physical-activity",
                "display" : "Physical Activity"
              },
              {
                "reference" : "Observation/Obs-Health-Literacy-YesNo",
                "display" : "Health Literacy"
              },
              {
                "reference" : "Observation/Obs-Digital-Literacy-Scale",
                "display" : "Digital Literacy"
              },
              {
                "reference" : "QuestionnaireResponse/QR-EQ5D-5L-Example",
                "display" : "EQ-5D-5L"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "c154158f-6a43-4ab7-8443-e7f4bf915dd2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient c154158f-6a43-4ab7-8443-e7f4bf915dd2</b></p><a name=\"c154158f-6a43-4ab7-8443-e7f4bf915dd2\"> </a><a name=\"hcc154158f-6a43-4ab7-8443-e7f4bf915dd2\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">IPS 4 example Gravitate  Female, DoB: 1989-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-4)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>keycloak-id</code>/370887cf-f2c5-4e07-971a-827397d4ea45</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 NO}\">Norway</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "NO",
                      "display" : "Norway"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/individual-occupation",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ilo.org/public/english/bureau/stat/isco",
                  "code" : "3421",
                  "display" : "Athletes and sports players"
                }
              ]
            }
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "ips-4"
          },
          {
            "system" : "keycloak-id",
            "value" : "370887cf-f2c5-4e07-971a-827397d4ea45"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["IPS 4 example"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1989-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d2",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "1ece89c5-fda3-4db9-ace6-decbe6c603d2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 1ece89c5-fda3-4db9-ace6-decbe6c603d2</b></p><a name=\"1ece89c5-fda3-4db9-ace6-decbe6c603d2\"> </a><a name=\"hc1ece89c5-fda3-4db9-ace6-decbe6c603d2\"> </a><p><b>name</b>: Anne Karlsson </p></div>"
        },
        "name" : [
          {
            "family" : "Karlsson",
            "given" : ["Anne"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf02",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "1dff4474-fa08-4f45-8260-dbb23094bf02",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_1dff4474-fa08-4f45-8260-dbb23094bf02\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 1dff4474-fa08-4f45-8260-dbb23094bf02</b></p><a name=\"1dff4474-fa08-4f45-8260-dbb23094bf02\"> </a><a name=\"hc1dff4474-fa08-4f45-8260-dbb23094bf02\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>type</b>: Allergy</p><p><b>category</b>: Environment</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 256259004}\">Pollen</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 21719001}\">Hay fever</span></td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "type" : "allergy",
        "category" : ["environment"],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "256259004",
              "display" : "Pollen"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21719001",
                    "display" : "Allergic rhinitis caused by pollen"
                  }
                ],
                "text" : "Hay fever"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/9d18cddb-8e58-4fbb-82ec-09cc561ac802",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "9d18cddb-8e58-4fbb-82ec-09cc561ac802",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_9d18cddb-8e58-4fbb-82ec-09cc561ac802\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 9d18cddb-8e58-4fbb-82ec-09cc561ac802</b></p><a name=\"9d18cddb-8e58-4fbb-82ec-09cc561ac802\"> </a><a name=\"hc9d18cddb-8e58-4fbb-82ec-09cc561ac802\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>type</b>: Intolerance</p><p><b>category</b>: Food</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 782415009}\">Intolerance to lactose</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>onset</b>: 1 year<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codea = 'a')</span></p><p><b>recordedDate</b>: 2009-10-09</p><blockquote><p><b>reaction</b></p><p><b>substance</b>: <span title=\"Codes:{http://snomed.info/sct 47703008}\">lactose</span></p><p><b>manifestation</b>: <span title=\"Codes:{http://snomed.info/sct 21522001}\">Abdominal pain</span>, <span title=\"Codes:{http://snomed.info/sct 116289008}\">Abdominal bloating</span>, <span title=\"Codes:{http://snomed.info/sct 62315008}\">Diarrhea</span></p></blockquote></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "type" : "intolerance",
        "category" : ["food"],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "782415009",
              "display" : "Intolerance to lactose"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "onsetAge" : {
          "value" : 1,
          "unit" : "year",
          "system" : "http://unitsofmeasure.org",
          "code" : "a"
        },
        "recordedDate" : "2009-10-09",
        "reaction" : [
          {
            "substance" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "47703008",
                  "display" : "lactose"
                }
              ]
            },
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21522001",
                    "display" : "Abdominal pain"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "116289008",
                    "display" : "Abdominal bloating"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "62315008",
                    "display" : "Diarrhea"
                  }
                ]
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/bcc79261-142c-48ec-b032-f3f9af49ec52",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "bcc79261-142c-48ec-b032-f3f9af49ec52",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_bcc79261-142c-48ec-b032-f3f9af49ec52\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition bcc79261-142c-48ec-b032-f3f9af49ec52</b></p><a name=\"bcc79261-142c-48ec-b032-f3f9af49ec52\"> </a><a name=\"hcbcc79261-142c-48ec-b032-f3f9af49ec52\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 9014002}\">Psoriasis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-4.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d2\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "9014002",
              "display" : "Psoriasis"
            }
          ],
          "text" : "Psoriasis"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d2",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6252",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a4a9d90a-d1b0-4d60-82f0-c52343dc6252",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a4a9d90a-d1b0-4d60-82f0-c52343dc6252\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition a4a9d90a-d1b0-4d60-82f0-c52343dc6252</b></p><a name=\"a4a9d90a-d1b0-4d60-82f0-c52343dc6252\"> </a><a name=\"hca4a9d90a-d1b0-4d60-82f0-c52343dc6252\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 42343007}\">Congestive heart failure</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>onset</b>: 2015</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-4.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d2\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "42343007",
              "display" : "Congestive heart failure"
            }
          ],
          "text" : "Congestive heart failure"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d2",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5132",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e5132",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e5132\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e5132</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e5132\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e5132\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a892",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29074ca4-efcb-4ff4-8446-feed2399a892",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29074ca4-efcb-4ff4-8446-feed2399a892\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 29074ca4-efcb-4ff4-8446-feed2399a892</b></p><a name=\"29074ca4-efcb-4ff4-8446-feed2399a892\"> </a><a name=\"hc29074ca4-efcb-4ff4-8446-feed2399a892\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_b50ae644-e0b7-4007-809f-26f493cbe362\">Remsima 100 mg powder for concentrate for solution for infusion</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20045000}\">Intravenous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe362",
          "display" : "Remsima 100 mg powder for concentrate for solution for infusion"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20045000",
                  "display" : "Intravenous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f6cb1218-f81c-4338-80d8-3c10910f78f2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f6cb1218-f81c-4338-80d8-3c10910f78f2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f6cb1218-f81c-4338-80d8-3c10910f78f2</b></p><a name=\"f6cb1218-f81c-4338-80d8-3c10910f78f2\"> </a><a name=\"hcf6cb1218-f81c-4338-80d8-3c10910f78f2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c2\">Karvea 75 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c2",
          "display" : "Karvea 75 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade87b2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade87b2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade87b2</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade87b2\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade87b2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef12\">Humalog 100 U/ml 5 pre-filled pen</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20066000}\">Subcutaneous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef12",
          "display" : "Humalog 100 U/ml 5 pre-filled pen"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/citalopram-statement",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "citalopram-statement",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_citalopram-statement\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement citalopram-statement</b></p><a name=\"citalopram-statement\"> </a><a name=\"hccitalopram-statement\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_citalopram\">citalopram</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20066000}\">Subcutaneous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/citalopram",
          "display" : "citalopram"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/amlo-italy-statement",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "amlo-italy-statement",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_amlo-italy-statement\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement amlo-italy-statement</b></p><a name=\"amlo-italy-statement\"> </a><a name=\"hcamlo-italy-statement\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_amlo-italy\">Amlodipine Italy</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/amlo-italy",
          "display" : "Amlodipine Italy"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/amlo-norway-statement",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "amlo-norway-statement",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_amlo-norway-statement\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement amlo-norway-statement</b></p><a name=\"amlo-norway-statement\"> </a><a name=\"hcamlo-norway-statement\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_amlo-norway\">Amlodipine Norway</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/amlo-norway",
          "display" : "Amlodipine Norway"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe362",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe362",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe362\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe362</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe362\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe362\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/13/853/001}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82718}\">Remsima 100 mg powder for concentrate for solution for infusion</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 50049250}\">Powder for concentrate for solution for injection/infusion</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov B72HH48FLU}\">INFLIXIMAB</span></td><td>100 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Vial<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{vial} = '{vial}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/13/853/001",
              "display" : "Remsima 100 mg powder for concentrate for solution for infusion"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82718",
              "display" : "Infliximab 100 mg powder for concentrate for solution for infusion"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "50049250",
              "display" : "Powder for concentrate for solution for injection/infusion"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "B72HH48FLU",
                  "display" : "INFLIXIMAB"
                }
              ],
              "text" : "INFLIXIMAB"
            },
            "strength" : {
              "numerator" : {
                "value" : 100,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Vial",
                "system" : "http://unitsofmeasure.org",
                "code" : "{vial}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c2",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c2</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c2\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c2\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/97/049/001}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82719}, {http://www.whocc.no/atc C09DA04}\">Karvea 75 mg/ 1 tablet, Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov J0E2756Z7N}\">irbesartan</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/97/049/001",
              "display" : "Karvea 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82719",
              "display" : "Irbesartan, 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C09DA04",
              "display" : "irbesartan and diuretics"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "J0E2756Z7N",
                  "display" : "irbesartan"
                }
              ],
              "text" : "irbesartan"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef12",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef12</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef12\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef12\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/96/007/035}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82717}\">Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 11202000}\">Suspension for injection</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov GFX7QIS1II}\">Insulin Lispro</span></td><td>100 U<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeU = 'U')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/96/007/035",
              "display" : "Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82717",
              "display" : "Insulin Lispro 100 U/ml 5 pre-filled pen"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "11202000",
              "display" : "Suspension for injection"
            }
          ],
          "text" : "Suspension for injection"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "GFX7QIS1II",
                  "display" : "Insulin Lispro"
                }
              ],
              "text" : "Insulin Lispro"
            },
            "strength" : {
              "numerator" : {
                "value" : 100,
                "unit" : "U",
                "system" : "http://unitsofmeasure.org",
                "code" : "U"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "ml",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/citalopram",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "citalopram",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_citalopram\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication citalopram</b></p><a name=\"citalopram\"> </a><a name=\"hccitalopram\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 204447}\">Citalopram Aurovitas 10 mg\ttablet</span></p></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "204447",
              "display" : "Citalopram Aurovitas 10 mg\ttablet"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/amlo-italy",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "amlo-italy",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_amlo-italy\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication amlo-italy</b></p><a name=\"amlo-italy\"> </a><a name=\"hcamlo-italy\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi AMLODIPINA-DOC-GENERICI-tablet-10mg--71-ITA-MPD}\">AMLODIPINA DOC GENERICI compresse 10 mg</span></p></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "AMLODIPINA-DOC-GENERICI-tablet-10mg--71-ITA-MPD",
              "display" : "AMLODIPINA DOC GENERICI compresse 10 mg"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/amlo-norway",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "amlo-norway",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_amlo-norway\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication amlo-norway</b></p><a name=\"amlo-norway\"> </a><a name=\"hcamlo-norway\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi AMLODIPINA-SANDOZ-tablet-10mg--3-NO-MPD}\">Amlodipin sandoz 10 mg TABLETTER</span></p></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "AMLODIPINA-SANDOZ-tablet-10mg--3-NO-MPD",
              "display" : "Amlodipin sandoz 10 mg TABLETTER"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/e06e43a1-38d4-468f-8c35-f7f12da91062",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "e06e43a1-38d4-468f-8c35-f7f12da91062",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_e06e43a1-38d4-468f-8c35-f7f12da91062\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation e06e43a1-38d4-468f-8c35-f7f12da91062</b></p><a name=\"e06e43a1-38d4-468f-8c35-f7f12da91062\"> </a><a name=\"hce06e43a1-38d4-468f-8c35-f7f12da91062\"> </a><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82810-3}\">Pregnancy status</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2020-01-10</p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA15173-0}\">Pregnant</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3",
              "display" : "Pregnancy status"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2020-01-10",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA15173-0",
              "display" : "Pregnant"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/bw",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "bw",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_bw\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation bw</b></p><a name=\"bw\"> </a><a name=\"hcbw\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 29463-7}\">Body weight</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><p><b>value</b>: 70 kg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg = 'kg')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29463-7",
              "display" : "Body weight"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "valueQuantity" : {
          "value" : 70,
          "system" : "http://unitsofmeasure.org",
          "code" : "kg"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/bh",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "bh",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_bh\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation bh</b></p><a name=\"bh\"> </a><a name=\"hcbh\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8302-2}\">Body height</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><p><b>value</b>: 170 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2",
              "display" : "Body height"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "valueQuantity" : {
          "value" : 170,
          "system" : "http://unitsofmeasure.org",
          "code" : "cm"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/ips4-bp",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ips4-bp",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ips4-bp\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ips4-bp</b></p><a name=\"ips4-bp\"> </a><a name=\"hcips4-bp\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}\">Blood pressure panel with all children optional</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}\">Diastolic blood pressure</span></p><p><b>value</b>: 80 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}\">Systolic blood pressure</span></p><p><b>value</b>: 120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood pressure panel with all children optional"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 80,
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 120,
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/glucose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "glucose",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_glucose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation glucose</b></p><a name=\"glucose\"> </a><a name=\"hcglucose\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 15074-8}\">Glucose [Moles/volume] in Blood</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 6.3 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td></tr><tr><td style=\"display: none\">*</td><td>3.1 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td><td>6.2 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "15074-8",
              "display" : "Glucose [Moles/volume] in Blood"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 6.3,
          "unit" : "mmol/l",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H",
                "display" : "High"
              }
            ]
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 3.1,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            },
            "high" : {
              "value" : 6.2,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/egfr",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "egfr",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_egfr\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation egfr</b></p><a name=\"egfr\"> </a><a name=\"hcegfr\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48643-1}\">Glomerular filtration rate [Volume Rate/Area] in Serum, Plasma or Blood by Creatinine-based formula (MDRD)/1.73 sq M among black population</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 29 mL/min/1.73m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemL/min/1.73m2 = 'mL/min/1.73m2')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48643-1",
              "display" : "Glomerular filtration rate [Volume Rate/Area] in Serum, Plasma or Blood by Creatinine-based formula (MDRD)/1.73 sq M among black population"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 29,
          "unit" : "mL/min/1.73m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mL/min/1.73m2"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/potassium",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "potassium",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_potassium\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation potassium</b></p><a name=\"potassium\"> </a><a name=\"hcpotassium\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 6298-4}\">Potassium [Moles/volume] in Blood</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 2.5 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "6298-4",
              "display" : "Potassium [Moles/volume] in Blood"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 2.5,
          "unit" : "mmol/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/QR-EQ5D-5L-Example",
      "resource" : {
        "resourceType" : "QuestionnaireResponse",
        "id" : "QR-EQ5D-5L-Example",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"QuestionnaireResponse_QR-EQ5D-5L-Example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: QuestionnaireResponse QR-EQ5D-5L-Example</b></p><a name=\"QR-EQ5D-5L-Example\"> </a><a name=\"hcQR-EQ5D-5L-Example\"> </a><table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border: 1px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top;\"><tr style=\"border: 2px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top\"><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"The linkID for the item\">LinkID</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Text for the item\">Text</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Minimum and Maximum # of times the item can appear in the instance\">Definition</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"The type of the item\">Answer</a><span style=\"float: right\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Legend for this format\"><img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC\" alt=\"doco\" style=\"background-color: inherit\"/></a></span></th></tr><tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck1.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon_q_root.gif\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"QuestionnaireResponseRoot\" class=\"hierarchy\"/> QR-EQ5D-5L-Example</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\">Questionnaire:<a href=\"Questionnaire-Questionnaire-EQ5D-5L.html\">EQ-5D-5L</a></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d1</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-2\">EQ-5D-5L Levels: 2</a> (Slight problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d2</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-1\">EQ-5D-5L Levels: 1</a> (No problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d3</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-3\">EQ-5D-5L Levels: 3</a> (Moderate problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d4</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-2\">EQ-5D-5L Levels: 2</a> (Slight problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d5</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-1\">EQ-5D-5L Levels: 1</a> (No problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck00.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin_end.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> vas</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\">78</td></tr>\r\n<tr><td colspan=\"4\" class=\"hierarchy\"><br/><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Legend for this format\"><img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC\" alt=\"doco\" style=\"background-color: inherit\"/> Documentation for this format</a></td></tr></table></div>"
        },
        "questionnaire" : "http://hl7.eu/fhir/ig/gravitate-health-ips/Questionnaire/Questionnaire-EQ5D-5L",
        "status" : "completed",
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "authored" : "2025-10-08T10:35:00Z",
        "item" : [
          {
            "linkId" : "d1",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "2",
                  "display" : "Slight problems"
                }
              }
            ]
          },
          {
            "linkId" : "d2",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "1",
                  "display" : "No problems"
                }
              }
            ]
          },
          {
            "linkId" : "d3",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "3",
                  "display" : "Moderate problems"
                }
              }
            ]
          },
          {
            "linkId" : "d4",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "2",
                  "display" : "Slight problems"
                }
              }
            ]
          },
          {
            "linkId" : "d5",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "1",
                  "display" : "No problems"
                }
              }
            ]
          },
          {
            "linkId" : "vas",
            "answer" : [
              {
                "valueInteger" : 78
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Obs-Health-Literacy-YesNo",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Obs-Health-Literacy-YesNo",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Obs-Health-Literacy-YesNo\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Obs-Health-Literacy-YesNo</b></p><a name=\"Obs-Health-Literacy-YesNo\"> </a><a name=\"hcObs-Health-Literacy-YesNo\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy health-literacy}\">Health literacy (self-reported)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2025-10-08</p><p><b>value</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy yes}\">Yes</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "health-literacy",
              "display" : "Health literacy (self-reported)"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2025-10-08",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "yes",
              "display" : "Yes"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Obs-Digital-Literacy-Scale",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Obs-Digital-Literacy-Scale",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Obs-Digital-Literacy-Scale\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Obs-Digital-Literacy-Scale</b></p><a name=\"Obs-Digital-Literacy-Scale\"> </a><a name=\"hcObs-Digital-Literacy-Scale\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy digital-literacy}\">Digital literacy (self-reported)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2025-10-08</p><p><b>value</b>: 2</p><p><b>interpretation</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy medium}\">Medium</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "digital-literacy",
              "display" : "Digital literacy (self-reported)"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2025-10-08",
        "valueInteger" : 2,
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/fhir/CodeSystem/literacy",
                "code" : "medium",
                "display" : "Medium"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/physical-activity",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "physical-activity",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_physical-activity\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation physical-activity</b></p><a name=\"physical-activity\"> </a><a name=\"hcphysical-activity\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category activity}\">Activity</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 89555-7}\">Physical activity level</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 228400000}\">Moderately active physical exercise level</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "activity",
                "display" : "Activity"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "89555-7",
              "display" : "Physical activity level"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "228400000",
              "display" : "Moderately active physical exercise level"
            }
          ]
        }
      }
    }
  ]
}

```
