# Helen Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Helen Gravitate's IPS**

## Example Bundle: Helen Gravitate's IPS

**id:**gravitate-helen

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**helen-1

**Name:**Helen Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Allergies and Intolerances

**Allergy:**Lactose (47703008)

**clinicalStatus:**active

**verificationStatus:**confirmed

#### Problem List

**Condition:**Diabetes type 1 (46635009)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**onsetDateTime:**2015

#### Medication Summary

**Medication:**Humalog Mix50 Insulin KwikPen, 3ml pre-fill

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/96/007/035 [Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82717 [Insulin Lispro 100 U/ml 5 pre-filled pen]

*  **System** http://snomed.info/sct **Code:** 388454007 [Product containing insulin lispro (medicinal product)]

*  **System** http://www.whocc.no/atc **Code:** A10AD04 [insulin lispro]

**Dose Form:**Suspension for injection

**Ingredient:**insulin lispro (http://fdasis.nlm.nih.gov#GFX7QIS1II)

**strength:**100 U/1 ml

**Route:**Subcutaneous use

**Medication:**Monuril 3g granules for oral solution

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** PL31654/0087 [Monuril]

*  **System** https://www.who-umc.org/phpid **Code:** 0xE857DA811B4A6F3BD57810C45D2EA1RF [Fosfomycin, 3g, Granules for oral solution]

*  **System** http://www.whocc.no/atc **Code:** J01XX01 [fosfomycin]

**Dose Form:**Granules for oral solution

**Ingredient:**FOSFOMYCIN TROMETHAMINE (http://fdasis.nlm.nih.gov#7FXW6U30GY)

**strength:**5.631 g/1 Sachet

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-helen",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "helen-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/5702fd1d-dd26-402e-a7c0-7629a5d9bba1",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-helen",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-helen\"> </a>\n  \n\n    \n      <b>Id:</b>\n      gravitate-helen\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Helen Gravitate</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Lactose Intolerance\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Diabetes type 1\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Humalog Mix50 Insulin KwikPen, 3ml pre-fill\n\n            </li>\n          \n\n            <li>\n\n              Monuril 3 g granules for oral solution\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50",
          "display" : "Helen Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/45cd0bd4-f685-4117-a9f0-5c53fffb7266",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (Helen Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Hay fever (pollen)</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/cb6e84fa-4302-4569-ac1c-6b1b32507d16",
                "display" : "Lactose Intolerance"
              }
            ]
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Diabetes type 1</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "Condition/de06df6b-0967-4b01-822b-7cfeea970aa7",
                "display" : "Diabetes type 1"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Humalog Mix50 Insulin KwikPen, 3ml pre-fill</td><td>EU/1/96/007/035</td><td>insulin lispro (GFX7QIS1II)</td><td>insulin lispro</td><td>A10AD04</td><td>100 U/ml</td><td>Suspension for injection</td><td>Subcutaneous use</td></tr><tr><td>Monuril 3 g granules for oral solution</td><td>PL31654/0006</td><td>FOSFOMYCIN (2N81MY12TE)</td><td>fosfomycin</td><td>J01XX01</td><td>3 g (as trometamol: 5.631g/sachet)</td><td>Granules for oral solution</td><td>Oral use</td></tr></tbody></table></div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/18eb9898-dea7-4c5e-b097-e507e011747b",
                "display" : "Humalog Mix50 Insulin KwikPen, 3ml pre-fill"
              },
              {
                "reference" : "MedicationStatement/c90b943a-3d8e-4f14-b56d-5c5c208b2065",
                "display" : "Monuril 3 g granules for oral solution"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/be61951b-44fc-4853-8822-f9d398193c50",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "be61951b-44fc-4853-8822-f9d398193c50",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_be61951b-44fc-4853-8822-f9d398193c50\"> </a>Helen Gravitate, Female, 75 years old (1946-05-05)</div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "GB",
                      "display" : "United Kingdom of Great Britain and Northern Ireland"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "helen-1"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Helen"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/45cd0bd4-f685-4117-a9f0-5c53fffb7266",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "45cd0bd4-f685-4117-a9f0-5c53fffb7266",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_45cd0bd4-f685-4117-a9f0-5c53fffb7266\"> </a>Dr. Anne Karlsson</div>"
        },
        "name" : [
          {
            "family" : "Karlsson",
            "given" : ["Anne"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/cb6e84fa-4302-4569-ac1c-6b1b32507d16",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "cb6e84fa-4302-4569-ac1c-6b1b32507d16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_cb6e84fa-4302-4569-ac1c-6b1b32507d16\"> </a>Lactose Intolerance</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "47703008",
              "display" : "Lactose"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50",
          "display" : "Helen Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/de06df6b-0967-4b01-822b-7cfeea970aa7",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "de06df6b-0967-4b01-822b-7cfeea970aa7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_de06df6b-0967-4b01-822b-7cfeea970aa7\"> </a>Diabetes mellitus type 1 (2015)</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "46635009",
              "display" : "Diabetes mellitus type 1"
            }
          ],
          "text" : "Diabetes type 1"
        },
        "subject" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50",
          "display" : "Helen Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/45cd0bd4-f685-4117-a9f0-5c53fffb7266",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/18eb9898-dea7-4c5e-b097-e507e011747b",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "18eb9898-dea7-4c5e-b097-e507e011747b",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_18eb9898-dea7-4c5e-b097-e507e011747b\"> </a><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Humalog Mix50 Insulin KwikPen, 3ml pre-fill</td><td>EU/1/96/007/035</td><td>insulin lispro (GFX7QIS1II)</td><td>insulin lispro</td><td>A10AD04</td><td>100 U/ml</td><td>Suspension for injection</td><td>Subcutaneous use</td></tr></tbody></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92e50",
          "display" : "Humalog Mix50 Insulin KwikPen, 3ml pre-fill"
        },
        "subject" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50",
          "display" : "Helen Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/c90b943a-3d8e-4f14-b56d-5c5c208b2065",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "c90b943a-3d8e-4f14-b56d-5c5c208b2065",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_c90b943a-3d8e-4f14-b56d-5c5c208b2065\"> </a><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Monuril 3 g granules for oral solution</td><td>PL31654/0006</td><td>FOSFOMYCIN (2N81MY12TE)</td><td>fosfomycin</td><td>J01XX01</td><td>3 g (as trometamol: 5.631g/sachet)</td><td>Granules for oral solution</td><td>Oral use</td></tr></tbody></table></div>"
        },
        "basedOn" : [
          {
            "reference" : "MedicationRequest/c872135e-f219-4f32-8fd6-7099009abf42"
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3",
          "display" : "Monuril 3g granules for oral solution"
        },
        "subject" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50",
          "display" : "Helen Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationRequest/c872135e-f219-4f32-8fd6-7099009abf42",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "c872135e-f219-4f32-8fd6-7099009abf42",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_c872135e-f219-4f32-8fd6-7099009abf42\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest c872135e-f219-4f32-8fd6-7099009abf42</b></p><a name=\"c872135e-f219-4f32-8fd6-7099009abf42\"> </a><a name=\"hcc872135e-f219-4f32-8fd6-7099009abf42\"> </a><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>medication</b>: <a href=\"Bundle-gravitate-helen.html#Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3\">Monuril</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-helen.html#Patient_be61951b-44fc-4853-8822-f9d398193c50\">Helen Gravitate  Female, DoB: 1946-05-05 ( https://www.gravitatehealth.eu/sid/doc#helen-1)</a></p></div>"
        },
        "status" : "active",
        "intent" : "order",
        "medicationReference" : {
          "reference" : "Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3",
          "display" : "Monuril"
        },
        "subject" : {
          "reference" : "Patient/be61951b-44fc-4853-8822-f9d398193c50"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9d7be868-8264-4d94-ad04-ef04ecc92e50",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9d7be868-8264-4d94-ad04-ef04ecc92e50",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9d7be868-8264-4d94-ad04-ef04ecc92e50\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9d7be868-8264-4d94-ad04-ef04ecc92e50</b></p><a name=\"9d7be868-8264-4d94-ad04-ef04ecc92e50\"> </a><a name=\"hc9d7be868-8264-4d94-ad04-ef04ecc92e50\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/96/007/035}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82717}, {http://snomed.info/sct 388454007}, {http://www.whocc.no/atc A10AD04}\">Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 11202000}\">Suspension for injection</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov GFX7QIS1II}\">insulin lispro</span></td><td>100 units<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeU = 'U')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/96/007/035",
              "display" : "Humalog Mix50 KwikPen 100 U/ml 5 pre-filled pen"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82717",
              "display" : "Insulin Lispro 100 U/ml 5 pre-filled pen"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "388454007",
              "display" : "Product containing insulin lispro (medicinal product)"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A10AD04",
              "display" : "insulin lispro"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "11202000",
              "display" : "Suspension for injection"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "GFX7QIS1II",
                  "display" : "insulin lispro"
                }
              ],
              "text" : "insulin lispro"
            },
            "strength" : {
              "numerator" : {
                "value" : 100,
                "unit" : "units",
                "system" : "http://unitsofmeasure.org",
                "code" : "U"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "ml",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3</b></p><a name=\"fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3\"> </a><a name=\"hcfdb5c97f-0a46-41ba-bc34-2efd2ef2f7e3\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi PL31654/0087}, {https://www.who-umc.org/phpid 0xE857DA811B4A6F3BD57810C45D2EA1RF}, {http://www.whocc.no/atc J01XX01}\">Monuril</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10112000}\">Granules for oral solution</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 7FXW6U30GY}\">FOSFOMYCIN TROMETAMOL</span></td><td>5.631 g<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg = 'g')</span>/1 Sachet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{sachet} = '{sachet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "PL31654/0087",
              "display" : "Monuril"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xE857DA811B4A6F3BD57810C45D2EA1RF",
              "display" : "Fosfomycin, 3g, Granules for oral solution"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J01XX01",
              "display" : "fosfomycin"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10112000",
              "display" : "Granules for oral solution"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "7FXW6U30GY",
                  "display" : "FOSFOMYCIN TROMETHAMINE"
                }
              ],
              "text" : "FOSFOMYCIN TROMETAMOL"
            },
            "strength" : {
              "numerator" : {
                "value" : 5.631,
                "unit" : "g",
                "system" : "http://unitsofmeasure.org",
                "code" : "g"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Sachet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{sachet}"
              }
            }
          }
        ]
      }
    }
  ]
}

```
