# Example Test Scenario Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Test Scenario Gravitate's IPS**

## Example Bundle: Example Test Scenario Gravitate's IPS

**id:**gravitate-example-testing-scenario-bundle

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**example-test-scenario-1

**Name:**Example Test Scenario Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Medication Summary

**Medication:**Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets

**status:**active

**Route:**Oral use

**Medication:**BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD

**status:**active

**Route:**Oral use

#### Allergies and Intolerances

#### Problem List



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-example-testing-scenario-bundle",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "example-test-scenario-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/gravitate-example-testing-scenario-composition",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-example-test-scenario",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-example-test-scenario\"> </a>\n  \n\n    \n      <b>Id:</b>\n      gravitate-example-test-scenario\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a/>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Humalog Mix50 Insulin KwikPen, 3ml pre-fill\n\n            </li>\n          \n\n            <li>\n\n              Monuril 3 g granules for oral solution\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/gravitate-example-testing-scenario-patient"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "display" : "Gravitate-Health"
          }
        ],
        "title" : "International Patient Summary",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Humalog Mix50 Insulin KwikPen, 3ml pre-fill</td><td>EU/1/96/007/035</td><td>insulin lispro (GFX7QIS1II)</td><td>insulin lispro</td><td>A10AD04</td><td>100 U/ml</td><td>Suspension for injection</td><td>Subcutaneous use</td></tr><tr><td>Monuril 3 g granules for oral solution</td><td>PL31654/0006</td><td>FOSFOMYCIN (2N81MY12TE)</td><td>fosfomycin</td><td>J01XX01</td><td>3 g (as trometamol: 5.631g/sachet)</td><td>Granules for oral solution</td><td>Oral use</td></tr></tbody></table></div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/gravitate-example-testing-scenario-medstat1",
                "display" : "Humalog Mix50 Insulin KwikPen, 3ml pre-fill"
              },
              {
                "reference" : "MedicationStatement/gravitate-example-testing-scenario-medstat2",
                "display" : "Monuril 3 g granules for oral solution"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xml:lang=\"en-NZ\" xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en-NZ\">There is no information available regarding the subject's allergy conditions.</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "unavailable",
                  "display" : "Unavailable"
                }
              ],
              "text" : "No information available"
            }
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list - Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xml:lang=\"en-NZ\" xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en-NZ\">There is no information available about the subject's health problems or disabilities.</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "unavailable",
                  "display" : "Unavailable"
                }
              ],
              "text" : "No information available"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/gravitate-example-testing-scenario-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "gravitate-example-testing-scenario-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_gravitate-example-testing-scenario-patient\"> </a>Example Test Scenario Gravitate, Female, 75 years old (1946-05-05)</div>"
        },
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "example-test-scenario-1"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Example Test Scenario"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/gravitate-example-testing-scenario-medstat1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "gravitate-example-testing-scenario-medstat1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_gravitate-example-testing-scenario-medstat1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement gravitate-example-testing-scenario-medstat1</b></p><a name=\"gravitate-example-testing-scenario-medstat1\"> </a><a name=\"hcgravitate-example-testing-scenario-medstat1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_9d7be868-8264-4d94-ad04-ef04ecc92e52\">Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-example-testing-scenario-bundle.html#Patient_gravitate-example-testing-scenario-patient\">Example Test Scenario Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92e52",
          "display" : "Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets"
        },
        "subject" : {
          "reference" : "Patient/gravitate-example-testing-scenario-patient",
          "display" : "Example Test Scenario Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/gravitate-example-testing-scenario-medstat2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "gravitate-example-testing-scenario-medstat2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_gravitate-example-testing-scenario-medstat2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement gravitate-example-testing-scenario-medstat2</b></p><a name=\"gravitate-example-testing-scenario-medstat2\"> </a><a name=\"hcgravitate-example-testing-scenario-medstat2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Alicia.html#Medication_9d7be868-8264-4d94-ad04-ef04ecc92i99\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-example-testing-scenario-bundle.html#Patient_gravitate-example-testing-scenario-patient\">Example Test Scenario Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92i99",
          "display" : "BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD"
        },
        "subject" : {
          "reference" : "Patient/gravitate-example-testing-scenario-patient",
          "display" : "Example Test Scenario Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    }
  ]
}

```
