# Cecilia Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cecilia Gravitate's IPS**

## Example Bundle: Cecilia Gravitate's IPS

**id:**gravitate-Cecilia

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**Cecilia-1

**Name:**Cecilia Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Problem List

**Condition:**COPD - Chronic obstructive pulmonary disease (13645005)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**Condition:**Congestive heart failure (42343007)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**onsetDateTime:**2015

**Condition:**Osteoporosis (64859006)

**clinicalStatus:**active

**onsetDateTime:**1993

**Condition:**Diabetes mellitus type 2 (44054006)

**clinicalStatus:**active

#### Medication Summary

**Medication:**Dimethyl fumarate 30 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/17/1201/002 [Skilarence 120 mg gastro-resistant tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x9982CA8A825D4561506CE808982E3B9D [dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet]

*  **System** http://www.whocc.no/atc **Code:** L04AX07 [dimethyl fumarate]

**Dose Form:**Gastro-resistant tablet

**Ingredient:**dimethyl fumarate (http://fdasis.nlm.nih.gov#FO2303MNI2)

**strength:**30 mg/1 Tablet

**Route:**Oral use

**Medication:**Irbesartan 75 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/97/049/001 [Karvea 75 mg/ 1 tablet, Tablet]

*  **System** http://www.whocc.no/atc **Code:** C09DA04 [irbesartan and diuretics]

**Dose Form:**Tablet

**Ingredient:**irbesartan (http://fdasis.nlm.nih.gov#J0E2756Z7N)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Oxymetazoline hydrochloride 0.05 mg / 1 ml Spray

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 16028/0340 [Boots Decongestant 0.05% w/v Nasal spray]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82234 [Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution]

*  **System** http://www.whocc.no/atc **Code:** R01AA05 [oxymetazoline]

**Dose Form:**Nasal spray, solution

**Ingredient:**oxymetazoline hydrochloride (http://fdasis.nlm.nih.gov#K89MJ0S5VY)

**strength:**0.05 mg/1

**Route:**Nasal use

**Medication:**Oxymetazoline hydrochloride 0.05 mg / 1 ml Spray

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 16028/0340 [Boots Decongestant 0.05% w/v Nasal spray]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82234 [Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution]

*  **System** http://www.whocc.no/atc **Code:** R01AA05 [oxymetazoline]

**Dose Form:**Nasal spray, solution

**Ingredient:**oxymetazoline hydrochloride (http://fdasis.nlm.nih.gov#K89MJ0S5VY)

**strength:**0.05 mg/1

**Route:**Nasal use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-Cecilia",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "Cecilia-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/cecilia-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Cecilia",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Cecilia\"> </a><b>Id:</b> gravitate-Cecilia<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> Cecilia Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-cecilia-cond-1.html\">COPD</a></li><br/><li><b>Entry:</b> <a href=\"Condition-cecilia-cond-2.html\">Diabetese Type 2</a></li><br/><li><b>Entry:</b> <a href=\"Condition-cecilia-cond-3.html\">Osteoporosis</a></li><br/><li><b>Entry:</b> <a href=\"Condition-cecilia-cond-4.html\">Congestive Heart Failure</a></li><br/></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-cecilia-med-stat-1.html\">Fosamax 70 mg tablets</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-cecilia-med-stat-2.html\">Metformine + sitagliptine</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-cecilia-med-stat-3.html\">Fluticasone 92mcg + vilanterol 22mcg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-cecilia-med-stat-4.html\">Digoxin</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/cecilia-pract",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (Cecilia Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/cecilia-cond-1",
                "display" : "COPD"
              },
              {
                "reference" : "Condition/cecilia-cond-2",
                "display" : "Congestive Heart Failure"
              },
              {
                "reference" : "Condition/cecilia-cond-3",
                "display" : "Osteoporosis"
              },
              {
                "reference" : "Condition/cecilia-cond-4",
                "display" : "Diabetese Type 2"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/cecilia-med-stat-1",
                "display" : "Fosamax 70 mg tablets"
              },
              {
                "reference" : "MedicationStatement/cecilia-med-stat-2",
                "display" : "Metformine + sitagliptine"
              },
              {
                "reference" : "MedicationStatement/cecilia-med-stat-3",
                "display" : "Fluticasone 92mcg + vilanterol 22mcg"
              },
              {
                "reference" : "MedicationStatement/cecilia-med-stat-4",
                "display" : "Digoxin"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/cecilia-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "cecilia-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_cecilia-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient cecilia-patient</b></p><a name=\"cecilia-patient\"> </a><a name=\"hccecilia-patient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Cecilia Gravitate  Female, DoB: 1946-05-05 ( https://www.gravitatehealth.eu/sid/doc#Cecilia-1)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 SWE}\">Sweden</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "SWE",
                      "display" : "Sweden"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Cecilia-1"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Cecilia"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/cecilia-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "cecilia-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_cecilia-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner cecilia-pract</b></p><a name=\"cecilia-pract\"> </a><a name=\"hccecilia-pract\"> </a><p><b>name</b>: Anne Karlsson </p></div>"
        },
        "name" : [
          {
            "family" : "Karlsson",
            "given" : ["Anne"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/cecilia-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "cecilia-cond-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_cecilia-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition cecilia-cond-1</b></p><a name=\"cecilia-cond-1\"> </a><a name=\"hccecilia-cond-1\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 13645005}\">COPD - Chronic obstructive pulmonary disease</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Cecilia.html#Practitioner_cecilia-pract\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "13645005",
              "display" : "Chronic obstructive lung disease"
            }
          ],
          "text" : "COPD - Chronic obstructive pulmonary disease"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "asserter" : {
          "reference" : "Practitioner/cecilia-pract",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/cecilia-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "cecilia-cond-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_cecilia-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition cecilia-cond-2</b></p><a name=\"cecilia-cond-2\"> </a><a name=\"hccecilia-cond-2\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 42343007}\">Congestive heart failure</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><p><b>onset</b>: 2015</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Cecilia.html#Practitioner_cecilia-pract\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "42343007",
              "display" : "Congestive heart failure"
            }
          ],
          "text" : "Congestive heart failure"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/cecilia-pract",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/cecilia-cond-3",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "cecilia-cond-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_cecilia-cond-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition cecilia-cond-3</b></p><a name=\"cecilia-cond-3\"> </a><a name=\"hccecilia-cond-3\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 64859006}\">Osteoporosis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "64859006",
              "display" : "Osteoporosis"
            }
          ],
          "text" : "Osteoporosis"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/cecilia-cond-4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "cecilia-cond-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_cecilia-cond-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition cecilia-cond-4</b></p><a name=\"cecilia-cond-4\"> </a><a name=\"hccecilia-cond-4\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 44054006}\">Diabetes mellitus type 2</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "44054006",
              "display" : "Diabetes mellitus type 2"
            }
          ],
          "text" : "Diabetes mellitus type 2"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/cecilia-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "cecilia-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_cecilia-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement cecilia-med-stat-1</b></p><a name=\"cecilia-med-stat-1\"> </a><a name=\"hccecilia-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Cecilia.html#Medication_b50ae644-e0b7-4007-809f-26f493cbe36c\">Dimethyl fumarate 30 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe36c",
          "display" : "Dimethyl fumarate 30 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/cecilia-med-stat-2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "cecilia-med-stat-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_cecilia-med-stat-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement cecilia-med-stat-2</b></p><a name=\"cecilia-med-stat-2\"> </a><a name=\"hccecilia-med-stat-2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Cecilia.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c4\">Irbesartan 75 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c4",
          "display" : "Irbesartan 75 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/cecilia-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "cecilia-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_cecilia-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement cecilia-med-stat-3</b></p><a name=\"cecilia-med-stat-3\"> </a><a name=\"hccecilia-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Cecilia.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef19\">Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20049000}\">Nasal use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef19",
          "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20049000",
                  "display" : "Nasal use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/cecilia-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "cecilia-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_cecilia-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement cecilia-med-stat-4</b></p><a name=\"cecilia-med-stat-4\"> </a><a name=\"hccecilia-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Cecilia.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef19\">Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Cecilia.html#Patient_cecilia-patient\">Cecilia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20049000}\">Nasal use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef19",
          "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
        },
        "subject" : {
          "reference" : "Patient/cecilia-patient",
          "display" : "Cecilia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20049000",
                  "display" : "Nasal use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe36c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe36c",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe36c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe36c</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe36c\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe36c\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/17/1201/002}, {https://www.who-umc.org/phpid 0x9982CA8A825D4561506CE808982E3B9D}, {http://www.whocc.no/atc L04AX07}\">Skilarence 120 mg gastro-resistant tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10225000}\">Gastro-resistant tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov FO2303MNI2}\">dimethyl fumarate</span></td><td>30 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/17/1201/002",
              "display" : "Skilarence 120 mg gastro-resistant tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x9982CA8A825D4561506CE808982E3B9D",
              "display" : "dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L04AX07",
              "display" : "dimethyl fumarate"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10225000",
              "display" : "Gastro-resistant tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "FO2303MNI2",
                  "display" : "dimethyl fumarate"
                }
              ],
              "text" : "dimethyl fumarate"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c4",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c4</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c4\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c4\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/97/049/001}, {http://www.whocc.no/atc C09DA04}\">Karvea 75 mg/ 1 tablet, Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov J0E2756Z7N}\">irbesartan</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/97/049/001",
              "display" : "Karvea 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C09DA04",
              "display" : "irbesartan and diuretics"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "J0E2756Z7N",
                  "display" : "irbesartan"
                }
              ],
              "text" : "irbesartan"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef19",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef19</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef19\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef19\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 16028/0340}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82234}, {http://www.whocc.no/atc R01AA05}\">Boots Decongestant 0.05% w/v Nasal spray</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10808000}\">Nasal spray, solution</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov K89MJ0S5VY}\">oxymetazoline hydrochloride</span></td><td>0.05 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "16028/0340",
              "display" : "Boots Decongestant 0.05% w/v Nasal spray"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82234",
              "display" : "Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R01AA05",
              "display" : "oxymetazoline"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10808000",
              "display" : "Nasal spray, solution"
            }
          ],
          "text" : "Nasal spray, solution"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "K89MJ0S5VY",
                  "display" : "oxymetazoline hydrochloride"
                }
              ],
              "text" : "oxymetazoline hydrochloride"
            },
            "strength" : {
              "numerator" : {
                "value" : 0.05,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    }
  ]
}

```
