# Alicia Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alicia Gravitate's IPS**

## Example Bundle: Alicia Gravitate's IPS

**id:**gravitate-Alicia

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**alicia-1

**Name:**Alicia Gravitate

**active:**true

**gender:**female

**Birth Date:**1998-10-05

### Sections

#### Problem List

**Condition:**Depressive disorder (disorder) (35489007)

**clinicalStatus:**active

**Condition:**Human immunodeficiency virus infection (86406008)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Trigeminal neuralgia (disorder) (31681005)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Overweight (finding) (238131007)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

#### Medication Summary

**Medication:**BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/18/1289/001 [Biktarvy 30 mg/120 mg/15 mg film-coated tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x073AF2E5B92AE19E8B67635AFFB3D9nq [Biktarvy 30 mg/120 mg/15 mg film-coated tablets]

*  **System** http://snomed.info/sct **Code:** 774856007 [Product containing only bictegravir and emtricitabine and tenofovir (medicinal product)]

*  **System** http://www.whocc.no/atc **Code:** J05AR20 [emtricitabine, tenofovir alafenamide and bictegravir]

**Dose Form:**Coated tablet

**Ingredient:**bictegravir (http://fdasis.nlm.nih.gov#8GB79LOJ07)

**strength:**30 mg/1 Tablet

**Ingredient:**emtricitabine (http://fdasis.nlm.nih.gov#G70B4ETF4S)

**strength:**120 mg/1 Tablet

**Ingredient:**tenofovir alafenamida (http://fdasis.nlm.nih.gov#EL9943AG5J)

**strength:**15 mg/1 Tablet

**Route:**Oral use

**Medication:**CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 68290 [CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Calcium Vitamin D]

**Dose Form:**Effervescent tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**1000 mg/1 Tablet

**Ingredient:**cholecalciferol (http://fdasis.nlm.nih.gov#1C6V77QF41)

**strength:**880 {UI}/1 Tablet

**Route:**Oral use

**Medication:**Carbamazepine 1 t TID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 39.955 [Tegretol (Carbamazepine) 200 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x6e5dd079852edc5c3b8efce075c80a2e [Carbamazepine 200 mg tablets]

**Dose Form:**Tablet

**Ingredient:**CARBAMAZEPINE (http://fdasis.nlm.nih.gov#33CM23913M)

**strength:**200 mg/1 Tablet

**Route:**Oral use

**Medication:**Orlistat 1 cp TID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/98/071/004 [Xenical (Orlistat) 60 mg capsule]

*  **System** https://www.who-umc.org/phpid **Code:** 0xc805ef896d1c2f5f17f84f34c909a9db [Xenical (Orlistat) 60 mg capsule]

**Dose Form:**Capsule, hard

**Ingredient:**ORLISTAT (http://fdasis.nlm.nih.gov#95M8R751W8)

**strength:**60 mg/1 Tablet

**Route:**Oral use

**Medication:**St. John’s Wort 2 cp BID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 79963 [HIPÉRICO ARKOPHARMA cápsulas duras]

*  **System** https://www.who-umc.org/phpid **Code:** 0xbb82cd10ab2add752b2b9224931099j1 [St. John's Wort (HIPÉRICO ARKOPHARMA) hard tablet]

*  **System** http://www.whocc.no/atc **Code:** A03FA02 [HYPERICUM PERFORATUM WHOLE]

**Dose Form:**Tablet

**Ingredient:**HYPERICUM PERFORATUM WHOLE (http://fdasis.nlm.nih.gov#XK4IUX8MNB)

**strength:**175 mg/1 Tablet

**Route:**Oral use

**Medication:**Flucelvax

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/18/1326/001 [Flucelvax]

*  **System** https://www.who-umc.org/phpid **Code:** 0xbb82cd10ab2add752b2b9224931000k2 [Flucelvax]

*  **System** http://www.whocc.no/atc **Code:** A03ku92 [Flucelvax]

**Dose Form:**suspension for injection in pre-filled syringe

**Ingredient:**INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE (http://fdasis.nlm.nih.gov#TU2UN5CG9C)

**strength:**15 mcg/1 suspension for injection in pre-filled syringe

**Route:**Intramuscular use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-Alicia",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "alicia-ips-1"
  },
  "type" : "document",
  "timestamp" : "2023-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/alicia-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Alicia",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Alicia\"> </a><b>Id:</b> gravitate-alicia<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> alicia Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-alicia-cond-1.html\">HIV</a></li><br/><li><b>Entry:</b> <a href=\"Condition-alicia-cond-2.html\">Trigeminal neuralgia</a></li><br/><li><b>Entry:</b> <a href=\"Condition-alicia-cond-3.html\">Depression</a></li><br/><li><b>Entry:</b> <a href=\"Condition-alicia-cond-4.html\">Overweight</a></li></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-1.html\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-2.html\">Calcium/Vit D</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-3.html\">Folic Acid + Cyanocobalamin + Iodur 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-4.html\">Carbamazepine 1 t TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-5.html\">Orlistat 1 cp TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-6.html\">St. John’s Wort 2 cp BID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-alicia-med-stat-7.html\">Collagen and magnesium supplements</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/alicia-pract",
            "display" : "Dr. Walter Waltz"
          }
        ],
        "title" : "Patient Summary (Alicia Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/alicia-cond-1",
                "display" : "Depression"
              },
              {
                "reference" : "Condition/alicia-cond-2",
                "display" : "HIV"
              },
              {
                "reference" : "Condition/alicia-cond-3",
                "display" : "Trigeminal neuralgia"
              },
              {
                "reference" : "Condition/alicia-cond-4",
                "display" : "Overweight"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Medication list Reported</div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/alicia-med-stat-1",
                "display" : "BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-3",
                "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-4",
                "display" : "Carbamazepine  1 t TID"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-5",
                "display" : "Orlistat 1 cp TID"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-6",
                "display" : "St. John’s Wort 2 cp BID"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-8",
                "display" : "Flucelvax"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/alicia-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "alicia-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_alicia-patient\"> </a>Age: 28 years. I live with my boyfriend. PhD Student Interests: I love reading and walking outdoors with my dog. I also love art and photography. Health Conditions: HIV (diagnosed with 25 years) Trigeminal neuralgia Depression Overweight</div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "ES",
                      "display" : "Spain"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "alicia-1"
          },
          {
            "system" : "keycloak-id",
            "value" : "31297ad1-cb3c-4138-a132-e64016170e1d"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Alicia"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1998-10-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/alicia-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "alicia-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_alicia-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner alicia-pract</b></p><a name=\"alicia-pract\"> </a><a name=\"hcalicia-pract\"> </a><p><b>name</b>: Walter Waltz </p></div>"
        },
        "name" : [
          {
            "family" : "Waltz",
            "given" : ["Walter"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-1</b></p><a name=\"alicia-cond-1\"> </a><a name=\"hcalicia-cond-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 35489007}\">Depressive disorder (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">alicia Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "35489007",
              "display" : "Depressive disorder (disorder)"
            }
          ],
          "text" : "Depressive disorder (disorder)"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "alicia Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-2</b></p><a name=\"alicia-cond-2\"> </a><a name=\"hcalicia-cond-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 86406008}\">Human immunodeficiency virus infection</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">alicia Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Alicia.html#Practitioner_alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "86406008",
              "display" : "Human immunodeficiency virus infection"
            }
          ],
          "text" : "Human immunodeficiency virus infection"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "alicia Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-3",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-3</b></p><a name=\"alicia-cond-3\"> </a><a name=\"hcalicia-cond-3\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 31681005}\">Trigeminal neuralgia (disorder)</span></p><p><b>subject</b>: Identifier: <code>https://www.gravitatehealth.eu/sid/doc</code>/alicia-1</p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Alicia.html#Practitioner_alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "31681005",
              "display" : "Trigeminal neuralgia (disorder)"
            }
          ],
          "text" : "Trigeminal neuralgia (disorder)"
        },
        "subject" : {
          "identifier" : {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "alicia-1"
          }
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-4</b></p><a name=\"alicia-cond-4\"> </a><a name=\"hcalicia-cond-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 238131007}\">Overweight (finding)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Alicia.html#Practitioner_alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "238131007",
              "display" : "Overweight (finding)"
            }
          ],
          "text" : "Overweight (finding)"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-1</b></p><a name=\"alicia-med-stat-1\"> </a><a name=\"hcalicia-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Alicia.html#Medication_9d7be868-8264-4d94-ad04-ef04ecc92i99\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92i99",
          "display" : "BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-3</b></p><a name=\"alicia-med-stat-3\"> </a><a name=\"hcalicia-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda7785h\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
          "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-4</b></p><a name=\"alicia-med-stat-4\"> </a><a name=\"hcalicia-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Alicia.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78356\">Carbamazepine  1 t TID</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78356",
          "display" : "Carbamazepine  1 t TID"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-5",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-5</b></p><a name=\"alicia-med-stat-5\"> </a><a name=\"hcalicia-med-stat-5\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Alicia.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78333\">Orlistat 1 cp TID</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78333",
          "display" : "Orlistat 1 cp TID"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-6",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-6</b></p><a name=\"alicia-med-stat-6\"> </a><a name=\"hcalicia-med-stat-6\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda79261\">St. John’s Wort 2 cp BID</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda79261",
          "display" : "St. John’s Wort 2 cp BID"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-8",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-8</b></p><a name=\"alicia-med-stat-8\"> </a><a name=\"hcalicia-med-stat-8\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78367\">Flucelvax</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Alicia.html#Patient_alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20035000}\">Intramuscular use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78367",
          "display" : "Flucelvax"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20035000",
                  "display" : "Intramuscular use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78367",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda78367",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda78367</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/18/1326/001}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931000k2}, {http://www.whocc.no/atc A03ku92}\">Flucelvax</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219999}\">suspension for injection in pre-filled syringe</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov TU2UN5CG9C}\">INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE</span></td><td>15 mcg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemcg = 'mcg')</span>/1 suspension for injection in pre-filled syringe<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/18/1326/001",
              "display" : "Flucelvax"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931000k2",
              "display" : "Flucelvax"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03ku92",
              "display" : "Flucelvax"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219999",
              "display" : "suspension for injection in pre-filled syringe"
            }
          ],
          "text" : "suspension for injection in pre-filled syringe"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "TU2UN5CG9C",
                  "display" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
                }
              ],
              "text" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 15,
                "system" : "http://unitsofmeasure.org",
                "code" : "mcg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "suspension for injection in pre-filled syringe",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda79261",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda79261",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda79261</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 79963}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931099j1}, {http://www.whocc.no/atc A03FA02}\">HIPÉRICO ARKOPHARMA cápsulas duras</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov XK4IUX8MNB}\">HYPERICUM PERFORATUM WHOLE</span></td><td>175 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "79963",
              "display" : "HIPÉRICO ARKOPHARMA cápsulas duras"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931099j1",
              "display" : "St. John's Wort (HIPÉRICO ARKOPHARMA) hard tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03FA02",
              "display" : "HYPERICUM PERFORATUM WHOLE"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "XK4IUX8MNB",
                  "display" : "HYPERICUM PERFORATUM WHOLE"
                }
              ],
              "text" : "HYPERICUM PERFORATUM WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 175,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda7785h</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 68290}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></p><p><b>strength</b>: 1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 1C6V77QF41}\">cholecalciferol</span></p><p><b>strength</b>: 880 {UI}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{UI} = '{UI}')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "68290",
              "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Calcium Vitamin D"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "1C6V77QF41",
                  "display" : "cholecalciferol"
                }
              ],
              "text" : "cholecalciferol"
            },
            "strength" : {
              "numerator" : {
                "value" : 880,
                "system" : "http://unitsofmeasure.org",
                "code" : "{UI}"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9d7be868-8264-4d94-ad04-ef04ecc92i99",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9d7be868-8264-4d94-ad04-ef04ecc92i99",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9d7be868-8264-4d94-ad04-ef04ecc92i99</b></p><a name=\"9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><a name=\"hc9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/18/1289/001}, {https://www.who-umc.org/phpid 0x073AF2E5B92AE19E8B67635AFFB3D9nq}, {http://snomed.info/sct 774856007}, {http://www.whocc.no/atc J05AR20}\">Biktarvy 30 mg/120 mg/15 mg film-coated tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 8GB79LOJ07}\">bictegravir</span></p><p><b>strength</b>: 30 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov G70B4ETF4S}\">emtricitabine</span></p><p><b>strength</b>: 120 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov EL9943AG5J}\">tenofovir alafenamida</span></p><p><b>strength</b>: 15 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/18/1289/001",
              "display" : "Biktarvy 30 mg/120 mg/15 mg film-coated tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x073AF2E5B92AE19E8B67635AFFB3D9nq",
              "display" : "Biktarvy 30 mg/120 mg/15 mg film-coated tablets"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "774856007",
              "display" : "Product containing only bictegravir and emtricitabine and tenofovir (medicinal product)"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J05AR20",
              "display" : "emtricitabine, tenofovir alafenamide and bictegravir"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "8GB79LOJ07",
                  "display" : "bictegravir"
                }
              ],
              "text" : "bictegravir"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "G70B4ETF4S",
                  "display" : "emtricitabine"
                }
              ],
              "text" : "emtricitabine"
            },
            "strength" : {
              "numerator" : {
                "value" : 120,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "EL9943AG5J",
                  "display" : "tenofovir alafenamida"
                }
              ],
              "text" : "tenofovir alafenamida"
            },
            "strength" : {
              "numerator" : {
                "value" : 15,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78356",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda78356",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda78356</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 39.955}, {https://www.who-umc.org/phpid 0x6e5dd079852edc5c3b8efce075c80a2e}\">Tegretol (Carbamazepine) 200 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 33CM23913M}\">CARBAMAZEPINE</span></td><td>200 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "39.955",
              "display" : "Tegretol (Carbamazepine) 200 mg tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x6e5dd079852edc5c3b8efce075c80a2e",
              "display" : "Carbamazepine 200 mg tablets"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "33CM23913M",
                  "display" : "CARBAMAZEPINE"
                }
              ],
              "text" : "CARBAMAZEPINE"
            },
            "strength" : {
              "numerator" : {
                "value" : 200,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78333",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda78333",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda78333</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/98/071/004}, {https://www.who-umc.org/phpid 0xc805ef896d1c2f5f17f84f34c909a9db}\">Xenical (Orlistat) 60 mg capsule</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10210000}\">Capsule, hard</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 95M8R751W8}\">ORLISTAT</span></td><td>60 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/98/071/004",
              "display" : "Xenical (Orlistat) 60 mg capsule"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xc805ef896d1c2f5f17f84f34c909a9db",
              "display" : "Xenical (Orlistat) 60 mg capsule"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10210000",
              "display" : "Capsule, hard"
            }
          ],
          "text" : "Capsule, hard"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "95M8R751W8",
                  "display" : "ORLISTAT"
                }
              ],
              "text" : "ORLISTAT"
            },
            "strength" : {
              "numerator" : {
                "value" : 60,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    }
  ]
}

```
