# Alicia Gravitate's IPS - Local - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alicia Gravitate's IPS - Local**

## Example Bundle: Alicia Gravitate's IPS - Local

**id:**Ovl-gravitate-Alicia

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**alicia-1-local

**Name:**Alicia Gravitate

**active:**true

**gender:**female

**Birth Date:**1998-10-05

### Sections

#### Problem List

**Condition:**Depressive disorder (disorder) (35489007)

**clinicalStatus:**active

**Condition:**Human immunodeficiency virus infection (86406008)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Trigeminal neuralgia (disorder) (31681005)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Overweight (finding) (238131007)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

#### Medication Summary

**Medication:**BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/18/1289/001 [Biktarvy 30 mg/120 mg/15 mg film-coated tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x073AF2E5B92AE19E8B67635AFFB3D9nq [Biktarvy 30 mg/120 mg/15 mg film-coated tablets]

*  **System** http://snomed.info/sct **Code:** 774856007 [Product containing only bictegravir and emtricitabine and tenofovir (medicinal product)]

*  **System** http://www.whocc.no/atc **Code:** J05AR20 [emtricitabine, tenofovir alafenamide and bictegravir]

**Dose Form:**Coated tablet

**Ingredient:**bictegravir (http://fdasis.nlm.nih.gov#8GB79LOJ07)

**strength:**30 mg/1 Tablet

**Ingredient:**emtricitabine (http://fdasis.nlm.nih.gov#G70B4ETF4S)

**strength:**120 mg/1 Tablet

**Ingredient:**tenofovir alafenamida (http://fdasis.nlm.nih.gov#EL9943AG5J)

**strength:**15 mg/1 Tablet

**Route:**Oral use

**Medication:**CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 68290 [CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Calcium Vitamin D]

**Dose Form:**Effervescent tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**1000 mg/1 Tablet

**Ingredient:**cholecalciferol (http://fdasis.nlm.nih.gov#1C6V77QF41)

**strength:**880 {UI}/1 Tablet

**Route:**Oral use

**Medication:**Carbamazepine 1 t TID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 39.955 [Tegretol (Carbamazepine) 200 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x6e5dd079852edc5c3b8efce075c80a2e [Carbamazepine 200 mg tablets]

**Dose Form:**Tablet

**Ingredient:**CARBAMAZEPINE (http://fdasis.nlm.nih.gov#33CM23913M)

**strength:**200 mg/1 Tablet

**Route:**Oral use

**Medication:**Orlistat 1 cp TID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/98/071/004 [Xenical (Orlistat) 60 mg capsule]

*  **System** https://www.who-umc.org/phpid **Code:** 0xc805ef896d1c2f5f17f84f34c909a9db [Xenical (Orlistat) 60 mg capsule]

**Dose Form:**Capsule, hard

**Ingredient:**ORLISTAT (http://fdasis.nlm.nih.gov#95M8R751W8)

**strength:**60 mg/1 Tablet

**Route:**Oral use

**Medication:**St. John’s Wort 2 cp BID

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 79963 [HIPÉRICO ARKOPHARMA cápsulas duras]

*  **System** https://www.who-umc.org/phpid **Code:** 0xbb82cd10ab2add752b2b9224931099j1 [St. John's Wort (HIPÉRICO ARKOPHARMA) hard tablet]

*  **System** http://www.whocc.no/atc **Code:** A03FA02 [HYPERICUM PERFORATUM WHOLE]

**Dose Form:**Tablet

**Ingredient:**HYPERICUM PERFORATUM WHOLE (http://fdasis.nlm.nih.gov#XK4IUX8MNB)

**strength:**175 mg/1 Tablet

**Route:**Oral use

**Medication:**Flucelvax

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/18/1326/001 [Flucelvax]

*  **System** https://www.who-umc.org/phpid **Code:** 0xbb82cd10ab2add752b2b9224931000k2 [Flucelvax]

*  **System** http://www.whocc.no/atc **Code:** A03ku92 [Flucelvax]

**Dose Form:**suspension for injection in pre-filled syringe

**Ingredient:**INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE (http://fdasis.nlm.nih.gov#TU2UN5CG9C)

**strength:**15 mcg/1 suspension for injection in pre-filled syringe

**Route:**Intramuscular use

**Medication:**Remsima 100 mg powder for concentrate for solution for infusion

**status:**active

**Route:**Intravenous use

#### Allergies and Intolerances

#### Pregnancy

#### Social History

#### Vital Signs



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "Ovl-gravitate-Alicia",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "alicia-ips-1"
  },
  "type" : "document",
  "timestamp" : "2023-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/Ovl-alicia-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "Ovl-alicia-comp",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_Ovl-alicia-comp\"> </a>\n  \n\n    \n      <b>Id:</b>\n      Ovl-alicia-comp\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Alicia Gravitate</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Depression\n\n            </li>\n          \n\n            <li>\n\n              HIV\n\n            </li>\n          \n\n            <li>\n\n              Trigeminal neuralgia\n\n            </li>\n          \n\n            <li>\n\n              Overweight\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD\n\n            </li>\n          \n\n            <li>\n\n              CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES\n\n            </li>\n          \n\n            <li>\n\n              Carbamazepine  1 t TID\n\n            </li>\n          \n\n            <li>\n\n              Orlistat 1 cp TID\n\n            </li>\n          \n\n            <li>\n\n              St. John’s Wort 2 cp BID\n\n            </li>\n          \n\n            <li>\n\n              Flucelvax\n\n            </li>\n          \n\n            <li>\n\n              Flucelvax\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Pregnancy\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Pregnancy Observation\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Social History\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Tobacco Use Observation\n\n            </li>\n          \n\n            <li>\n\n              Alcohol Use Observation\n\n            </li>\n          \n\n            <li>\n\n              Physical Activity Observation\n\n            </li>\n          \n\n            <li>\n\n              Digital Literacy Scale Observation\n\n            </li>\n          \n\n            <li>\n\n              Health Literacy Observation\n\n            </li>\n          \n\n            <li>\n\n              EQ-5D-5L Observation\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Vital Signs\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n\n            <li>\n\n              Vital Signs Observation\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Patient/Ovl-alicia-patient",
            "display" : "Alicia Gravitate"
          }
        ],
        "title" : "Patient Summary (Alicia Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Problem List</div>"
            },
            "entry" : [
              {
                "reference" : "Condition/Ovl-alicia-cond-1",
                "display" : "Depression"
              },
              {
                "reference" : "Condition/Ovl-alicia-cond-2",
                "display" : "HIV"
              },
              {
                "reference" : "Condition/Ovl-alicia-cond-3",
                "display" : "Trigeminal neuralgia"
              },
              {
                "reference" : "Condition/Ovl-alicia-cond-4",
                "display" : "Overweight"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Medication list Reported</div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-1",
                "display" : "BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-3",
                "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-4",
                "display" : "Carbamazepine  1 t TID"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-5",
                "display" : "Orlistat 1 cp TID"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-6",
                "display" : "St. John’s Wort 2 cp BID"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-8",
                "display" : "Flucelvax"
              },
              {
                "reference" : "MedicationStatement/Ovl-alicia-med-stat-added",
                "display" : "Flucelvax"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Allergies</div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/Ovl-Alicia-medication-allergy"
              }
            ]
          },
          {
            "title" : "Pregnancy",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "Pregnancy history"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Pregnancy</div>"
            },
            "entry" : [
              {
                "reference" : "Ovl-Alicia-pregnancy",
                "display" : "Pregnancy Observation"
              }
            ]
          },
          {
            "title" : "Social History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "129762-2",
                  "display" : "Social history"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Social History</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/tobacco-use-example",
                "display" : "Tobacco Use Observation"
              },
              {
                "reference" : "Observation/alcohol-use-example",
                "display" : "Alcohol Use Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-physical-activity",
                "display" : "Physical Activity Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-Digital-Literacy-Scale",
                "display" : "Digital Literacy Scale Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-Health-Literacy-YesNo",
                "display" : "Health Literacy Observation"
              },
              {
                "reference" : "QuestionnaireResponse/Ovl-alicia-QR-EQ5D-5L",
                "display" : "EQ-5D-5L Observation"
              }
            ]
          },
          {
            "title" : "Vital Signs",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18716-3"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Vital Signs</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/Ovl-alicia-bw",
                "display" : "Vital Signs Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-bh",
                "display" : "Vital Signs Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-bp",
                "display" : "Vital Signs Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-glucose",
                "display" : "Vital Signs Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-egfr",
                "display" : "Vital Signs Observation"
              },
              {
                "reference" : "Observation/Ovl-alicia-potassium",
                "display" : "Vital Signs Observation"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/Ovl-alicia-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Ovl-alicia-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Ovl-alicia-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Ovl-alicia-patient</b></p><a name=\"Ovl-alicia-patient\"> </a><a name=\"hcOvl-alicia-patient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 ES}\">Spain</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "ES",
                      "display" : "Spain"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "alicia-1-local"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Alicia"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1998-10-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/Ovl-alicia-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Ovl-alicia-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Ovl-alicia-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Ovl-alicia-pract</b></p><a name=\"Ovl-alicia-pract\"> </a><a name=\"hcOvl-alicia-pract\"> </a><p><b>name</b>: Walter Waltz </p></div>"
        },
        "name" : [
          {
            "family" : "Waltz",
            "given" : ["Walter"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Ovl-alicia-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Ovl-alicia-cond-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Ovl-alicia-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Ovl-alicia-cond-1</b></p><a name=\"Ovl-alicia-cond-1\"> </a><a name=\"hcOvl-alicia-cond-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 35489007}\">Depressive disorder (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">alicia Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "35489007",
              "display" : "Depressive disorder (disorder)"
            }
          ],
          "text" : "Depressive disorder (disorder)"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "alicia Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Ovl-alicia-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Ovl-alicia-cond-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Ovl-alicia-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Ovl-alicia-cond-2</b></p><a name=\"Ovl-alicia-cond-2\"> </a><a name=\"hcOvl-alicia-cond-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 86406008}\">Human immunodeficiency virus infection</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">alicia Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Practitioner_Ovl-alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "86406008",
              "display" : "Human immunodeficiency virus infection"
            }
          ],
          "text" : "Human immunodeficiency virus infection"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "alicia Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Ovl-alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Ovl-alicia-cond-3",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Ovl-alicia-cond-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Ovl-alicia-cond-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Ovl-alicia-cond-3</b></p><a name=\"Ovl-alicia-cond-3\"> </a><a name=\"hcOvl-alicia-cond-3\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 31681005}\">Trigeminal neuralgia (disorder)</span></p><p><b>subject</b>: Identifier: <code>https://www.gravitatehealth.eu/sid/doc</code>/alicia-1</p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Practitioner_Ovl-alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "31681005",
              "display" : "Trigeminal neuralgia (disorder)"
            }
          ],
          "text" : "Trigeminal neuralgia (disorder)"
        },
        "subject" : {
          "identifier" : {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "alicia-1"
          }
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Ovl-alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Ovl-alicia-cond-4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Ovl-alicia-cond-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Ovl-alicia-cond-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Ovl-alicia-cond-4</b></p><a name=\"Ovl-alicia-cond-4\"> </a><a name=\"hcOvl-alicia-cond-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 238131007}\">Overweight (finding)</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Practitioner_Ovl-alicia-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "238131007",
              "display" : "Overweight (finding)"
            }
          ],
          "text" : "Overweight (finding)"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Ovl-alicia-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-1</b></p><a name=\"Ovl-alicia-med-stat-1\"> </a><a name=\"hcOvl-alicia-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99",
          "display" : "BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-3</b></p><a name=\"Ovl-alicia-med-stat-3\"> </a><a name=\"hcOvl-alicia-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
          "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-4</b></p><a name=\"Ovl-alicia-med-stat-4\"> </a><a name=\"hcOvl-alicia-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356\">Carbamazepine  1 t TID</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356",
          "display" : "Carbamazepine  1 t TID"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-5",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-5</b></p><a name=\"Ovl-alicia-med-stat-5\"> </a><a name=\"hcOvl-alicia-med-stat-5\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333\">Orlistat 1 cp TID</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333",
          "display" : "Orlistat 1 cp TID"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-6",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-6</b></p><a name=\"Ovl-alicia-med-stat-6\"> </a><a name=\"hcOvl-alicia-med-stat-6\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261\">St. John’s Wort 2 cp BID</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261",
          "display" : "St. John’s Wort 2 cp BID"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-8",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-8</b></p><a name=\"Ovl-alicia-med-stat-8\"> </a><a name=\"hcOvl-alicia-med-stat-8\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367\">Flucelvax</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20035000}\">Intramuscular use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367",
          "display" : "Flucelvax"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20035000",
                  "display" : "Intramuscular use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Ovl-alicia-med-stat-added",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Ovl-alicia-med-stat-added",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Ovl-alicia-med-stat-added\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Ovl-alicia-med-stat-added</b></p><a name=\"Ovl-alicia-med-stat-added\"> </a><a name=\"hcOvl-alicia-med-stat-added\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-4.html#Medication_b50ae644-e0b7-4007-809f-26f493cbe362\">Remsima 100 mg powder for concentrate for solution for infusion</a></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><p><b>informationSource</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20045000}\">Intravenous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe362",
          "display" : "Remsima 100 mg powder for concentrate for solution for infusion"
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "informationSource" : {
          "reference" : "Patient/Ovl-alicia-patient",
          "display" : "Alicia Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20045000",
                  "display" : "Intravenous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda78367",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda78367",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda78367</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/18/1326/001}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931000k2}, {http://www.whocc.no/atc A03ku92}\">Flucelvax</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219999}\">suspension for injection in pre-filled syringe</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov TU2UN5CG9C}\">INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE</span></td><td>15 mcg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemcg = 'mcg')</span>/1 suspension for injection in pre-filled syringe<span style=\"background: LightGoldenRodYellow\"> (Details: standardterms.edqm.eu  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/18/1326/001",
              "display" : "Flucelvax"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931000k2",
              "display" : "Flucelvax"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03ku92",
              "display" : "Flucelvax"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219999",
              "display" : "suspension for injection in pre-filled syringe"
            }
          ],
          "text" : "suspension for injection in pre-filled syringe"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "TU2UN5CG9C",
                  "display" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
                }
              ],
              "text" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 15,
                "system" : "http://unitsofmeasure.org",
                "code" : "mcg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "suspension for injection in pre-filled syringe",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda79261",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda79261",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda79261</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 79963}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931099j1}, {http://www.whocc.no/atc A03FA02}\">HIPÉRICO ARKOPHARMA cápsulas duras</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov XK4IUX8MNB}\">HYPERICUM PERFORATUM WHOLE</span></td><td>175 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "79963",
              "display" : "HIPÉRICO ARKOPHARMA cápsulas duras"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931099j1",
              "display" : "St. John's Wort (HIPÉRICO ARKOPHARMA) hard tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03FA02",
              "display" : "HYPERICUM PERFORATUM WHOLE"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "XK4IUX8MNB",
                  "display" : "HYPERICUM PERFORATUM WHOLE"
                }
              ],
              "text" : "HYPERICUM PERFORATUM WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 175,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda7785h</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 68290}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></p><p><b>strength</b>: 1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 1C6V77QF41}\">cholecalciferol</span></p><p><b>strength</b>: 880 {UI}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{UI} = '{UI}')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "68290",
              "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Calcium Vitamin D"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "1C6V77QF41",
                  "display" : "cholecalciferol"
                }
              ],
              "text" : "cholecalciferol"
            },
            "strength" : {
              "numerator" : {
                "value" : 880,
                "system" : "http://unitsofmeasure.org",
                "code" : "{UI}"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99</b></p><a name=\"Ovl-9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><a name=\"hcOvl-9d7be868-8264-4d94-ad04-ef04ecc92i99\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/18/1289/001}, {https://www.who-umc.org/phpid 0x073AF2E5B92AE19E8B67635AFFB3D9nq}, {http://snomed.info/sct 774856007}, {http://www.whocc.no/atc J05AR20}\">Biktarvy 30 mg/120 mg/15 mg film-coated tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 8GB79LOJ07}\">bictegravir</span></p><p><b>strength</b>: 30 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov G70B4ETF4S}\">emtricitabine</span></p><p><b>strength</b>: 120 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov EL9943AG5J}\">tenofovir alafenamida</span></p><p><b>strength</b>: 15 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/18/1289/001",
              "display" : "Biktarvy 30 mg/120 mg/15 mg film-coated tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x073AF2E5B92AE19E8B67635AFFB3D9nq",
              "display" : "Biktarvy 30 mg/120 mg/15 mg film-coated tablets"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "774856007",
              "display" : "Product containing only bictegravir and emtricitabine and tenofovir (medicinal product)"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J05AR20",
              "display" : "emtricitabine, tenofovir alafenamide and bictegravir"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "8GB79LOJ07",
                  "display" : "bictegravir"
                }
              ],
              "text" : "bictegravir"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "G70B4ETF4S",
                  "display" : "emtricitabine"
                }
              ],
              "text" : "emtricitabine"
            },
            "strength" : {
              "numerator" : {
                "value" : 120,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "EL9943AG5J",
                  "display" : "tenofovir alafenamida"
                }
              ],
              "text" : "tenofovir alafenamida"
            },
            "strength" : {
              "numerator" : {
                "value" : 15,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356</b></p><a name=\"Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><a name=\"hcOvl-6f4151e9-91f6-4f1e-adc3-fb94dda78356\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 39.955}, {https://www.who-umc.org/phpid 0x6e5dd079852edc5c3b8efce075c80a2e}\">Tegretol (Carbamazepine) 200 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 33CM23913M}\">CARBAMAZEPINE</span></td><td>200 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "39.955",
              "display" : "Tegretol (Carbamazepine) 200 mg tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x6e5dd079852edc5c3b8efce075c80a2e",
              "display" : "Carbamazepine 200 mg tablets"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "33CM23913M",
                  "display" : "CARBAMAZEPINE"
                }
              ],
              "text" : "CARBAMAZEPINE"
            },
            "strength" : {
              "numerator" : {
                "value" : 200,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333</b></p><a name=\"Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><a name=\"hcOvl-6f4151e9-91f6-4f1e-adc3-fb94dda78333\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/98/071/004}, {https://www.who-umc.org/phpid 0xc805ef896d1c2f5f17f84f34c909a9db}\">Xenical (Orlistat) 60 mg capsule</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10210000}\">Capsule, hard</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 95M8R751W8}\">ORLISTAT</span></td><td>60 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/98/071/004",
              "display" : "Xenical (Orlistat) 60 mg capsule"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xc805ef896d1c2f5f17f84f34c909a9db",
              "display" : "Xenical (Orlistat) 60 mg capsule"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10210000",
              "display" : "Capsule, hard"
            }
          ],
          "text" : "Capsule, hard"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "95M8R751W8",
                  "display" : "ORLISTAT"
                }
              ],
              "text" : "ORLISTAT"
            },
            "strength" : {
              "numerator" : {
                "value" : 60,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367</b></p><a name=\"Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><a name=\"hcOvl-6f4151e9-91f6-4f1e-adc3-fb94dda78367\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/18/1326/001}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931000k2}, {http://www.whocc.no/atc A03ku92}\">Flucelvax</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219999}\">suspension for injection in pre-filled syringe</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov TU2UN5CG9C}\">INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE</span></td><td>15 mcg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemcg = 'mcg')</span>/1 suspension for injection in pre-filled syringe<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/18/1326/001",
              "display" : "Flucelvax"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931000k2",
              "display" : "Flucelvax"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03ku92",
              "display" : "Flucelvax"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219999",
              "display" : "suspension for injection in pre-filled syringe"
            }
          ],
          "text" : "suspension for injection in pre-filled syringe"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "TU2UN5CG9C",
                  "display" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
                }
              ],
              "text" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 15,
                "system" : "http://unitsofmeasure.org",
                "code" : "mcg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "suspension for injection in pre-filled syringe",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h</b></p><a name=\"Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><a name=\"hcOvl-6f4151e9-91f6-4f1e-adc3-fb94dda7785h\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 68290}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></p><p><b>strength</b>: 1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 1C6V77QF41}\">cholecalciferol</span></p><p><b>strength</b>: 880 {UI}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{UI} = '{UI}')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "68290",
              "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Calcium Vitamin D"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "1C6V77QF41",
                  "display" : "cholecalciferol"
                }
              ],
              "text" : "cholecalciferol"
            },
            "strength" : {
              "numerator" : {
                "value" : 880,
                "system" : "http://unitsofmeasure.org",
                "code" : "{UI}"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261</b></p><a name=\"Ovl-6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><a name=\"hcOvl-6f4151e9-91f6-4f1e-adc3-fb94dda79261\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 79963}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931099j1}, {http://www.whocc.no/atc A03FA02}\">HIPÉRICO ARKOPHARMA cápsulas duras</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov XK4IUX8MNB}\">HYPERICUM PERFORATUM WHOLE</span></td><td>175 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "79963",
              "display" : "HIPÉRICO ARKOPHARMA cápsulas duras"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931099j1",
              "display" : "St. John's Wort (HIPÉRICO ARKOPHARMA) hard tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03FA02",
              "display" : "HYPERICUM PERFORATUM WHOLE"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "XK4IUX8MNB",
                  "display" : "HYPERICUM PERFORATUM WHOLE"
                }
              ],
              "text" : "HYPERICUM PERFORATUM WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 175,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-pregnancy",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-pregnancy",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-pregnancy\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-pregnancy</b></p><a name=\"Ovl-alicia-pregnancy\"> </a><a name=\"hcOvl-alicia-pregnancy\"> </a><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82810-3}\">Pregnancy status</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2020-01-10</p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA15173-0}\">Pregnant</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3",
              "display" : "Pregnancy status"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2020-01-10",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA15173-0",
              "display" : "Pregnant"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-bw",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-bw",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-bw\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-bw</b></p><a name=\"Ovl-alicia-bw\"> </a><a name=\"hcOvl-alicia-bw\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 29463-7}\">Body weight</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><p><b>value</b>: 70 kg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg = 'kg')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29463-7",
              "display" : "Body weight"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "valueQuantity" : {
          "value" : 70,
          "system" : "http://unitsofmeasure.org",
          "code" : "kg"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-bh",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-bh",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-bh\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-bh</b></p><a name=\"Ovl-alicia-bh\"> </a><a name=\"hcOvl-alicia-bh\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8302-2}\">Body height</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><p><b>value</b>: 170 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2",
              "display" : "Body height"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "valueQuantity" : {
          "value" : 170,
          "system" : "http://unitsofmeasure.org",
          "code" : "cm"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-bp",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-bp",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-bp\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-bp</b></p><a name=\"Ovl-alicia-bp\"> </a><a name=\"hcOvl-alicia-bp\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}\">Blood pressure panel with all children optional</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-4.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd2\">IPS 4 Gravitate</a></p><p><b>effective</b>: 2009-10-09</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}\">Diastolic blood pressure</span></p><p><b>value</b>: 80 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}\">Systolic blood pressure</span></p><p><b>value</b>: 120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood pressure panel with all children optional"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd2",
          "display" : "IPS 4 Gravitate"
        },
        "effectiveDateTime" : "2009-10-09",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 80,
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 120,
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-glucose",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-glucose",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-glucose\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-glucose</b></p><a name=\"Ovl-alicia-glucose\"> </a><a name=\"hcOvl-alicia-glucose\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 15074-8}\">Glucose [Moles/volume] in Blood</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 6.3 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td></tr><tr><td style=\"display: none\">*</td><td>3.1 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td><td>6.2 mmol/l<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "15074-8",
              "display" : "Glucose [Moles/volume] in Blood"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 6.3,
          "unit" : "mmol/l",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H",
                "display" : "High"
              }
            ]
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 3.1,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            },
            "high" : {
              "value" : 6.2,
              "unit" : "mmol/l",
              "system" : "http://unitsofmeasure.org",
              "code" : "mmol/L"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-egfr",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-egfr",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-egfr\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-egfr</b></p><a name=\"Ovl-alicia-egfr\"> </a><a name=\"hcOvl-alicia-egfr\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48643-1}\">Glomerular filtration rate [Volume Rate/Area] in Serum, Plasma or Blood by Creatinine-based formula (MDRD)/1.73 sq M among black population</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 29 mL/min/1.73m2<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemL/min/1.73m2 = 'mL/min/1.73m2')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48643-1",
              "display" : "Glomerular filtration rate [Volume Rate/Area] in Serum, Plasma or Blood by Creatinine-based formula (MDRD)/1.73 sq M among black population"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 29,
          "unit" : "mL/min/1.73m2",
          "system" : "http://unitsofmeasure.org",
          "code" : "mL/min/1.73m2"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-potassium",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-potassium",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-potassium\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-potassium</b></p><a name=\"Ovl-alicia-potassium\"> </a><a name=\"hcOvl-alicia-potassium\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 6298-4}\">Potassium [Moles/volume] in Blood</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: 2.5 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "6298-4",
              "display" : "Potassium [Moles/volume] in Blood"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueQuantity" : {
          "value" : 2.5,
          "unit" : "mmol/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-QR-EQ5D-5L",
      "resource" : {
        "resourceType" : "QuestionnaireResponse",
        "id" : "Ovl-alicia-QR-EQ5D-5L",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"QuestionnaireResponse_Ovl-alicia-QR-EQ5D-5L\"> </a><p class=\"res-header-id\"><b>Generated Narrative: QuestionnaireResponse Ovl-alicia-QR-EQ5D-5L</b></p><a name=\"Ovl-alicia-QR-EQ5D-5L\"> </a><a name=\"hcOvl-alicia-QR-EQ5D-5L\"> </a><table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border: 1px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top;\"><tr style=\"border: 2px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top\"><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"The linkID for the item\">LinkID</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Text for the item\">Text</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Minimum and Maximum # of times the item can appear in the instance\">Definition</a></th><th style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; padding-top: 3px; padding-bottom: 3px\" class=\"hierarchy\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"The type of the item\">Answer</a><span style=\"float: right\"><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Legend for this format\"><img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC\" alt=\"doco\" style=\"background-color: inherit\"/></a></span></th></tr><tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck1.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon_q_root.gif\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"QuestionnaireResponseRoot\" class=\"hierarchy\"/> Ovl-alicia-QR-EQ5D-5L</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\">Questionnaire:<a href=\"Questionnaire-Questionnaire-EQ5D-5L.html\">EQ-5D-5L</a></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d1</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-2\">EQ-5D-5L Levels: 2</a> (Slight problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d2</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-1\">EQ-5D-5L Levels: 1</a> (No problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d3</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-3\">EQ-5D-5L Levels: 3</a> (Moderate problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d4</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-2\">EQ-5D-5L Levels: 2</a> (Slight problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: #F7F7F7\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck10.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: #F7F7F7; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> d5</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: #F7F7F7; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"><span><span><a href=\"CodeSystem-eq5d-levels-cs.html#eq5d-levels-cs-1\">EQ-5D-5L Levels: 1</a> (No problems)</span></span></td></tr>\r\n<tr style=\"border: 1px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: white\"><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap; background-image: url(tbl_bck00.png)\" class=\"hierarchy\"><img src=\"tbl_spacer.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"tbl_vjoin_end.png\" alt=\".\" style=\"background-color: inherit\" class=\"hierarchy\"/><img src=\"icon-q-string.png\" alt=\".\" style=\"background-color: white; background-color: inherit\" title=\"Item\" class=\"hierarchy\"/> vas</td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"></td><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\"/><td style=\"vertical-align: top; text-align : var(--ig-left,left); background-color: white; border: 1px #F0F0F0 solid; padding:0px 4px 0px 4px\" class=\"hierarchy\">78</td></tr>\r\n<tr><td colspan=\"4\" class=\"hierarchy\"><br/><a href=\"https://hl7.org/fhir/R4/formats.html#table\" title=\"Legend for this format\"><img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goXBCwdPqAP0wAAAldJREFUOMuNk0tIlFEYhp9z/vE2jHkhxXA0zJCMitrUQlq4lnSltEqCFhFG2MJFhIvIFpkEWaTQqjaWZRkp0g26URZkTpbaaOJkDqk10szoODP//7XIMUe0elcfnPd9zsfLOYplGrpRwZaqTtw3K7PtGem7Q6FoidbGgqHVy/HRb669R+56zx7eRV1L31JGxYbBtjKK93cxeqfyQHbehkZbUkK20goELEuIzEd+dHS+qz/Y8PTSif0FnGkbiwcAjHaU1+QWOptFiyCLp/LnKptpqIuXHx6rbR26kJcBX3yLgBfnd7CxwJmflpP2wUg0HIAoUUpZBmKzELGWcN8nAr6Gpu7tLU/CkwAaoKTWRSQyt89Q8w6J+oVQkKnBoblH7V0PPvUOvDYXfopE/SJmALsxnVm6LbkotrUtNowMeIrVrBcBpaMmdS0j9df7abpSuy7HWehwJdt1lhVwi/J58U5beXGAF6c3UXLycw1wdFklArBn87xdh0ZsZtArghBdAA3+OEDVubG4UEzP6x1FOWneHh2VDAHBAt80IbdXDcesNoCvs3E5AFyNSU5nbrDPZpcUEQQTFZiEVx+51fxMhhyJEAgvlriadIJZZksRuwBYMOPBbO3hePVVqgEJhFeUuFLhIPkRP6BQLIBrmMenujm/3g4zc398awIe90Zb5A1vREALqneMcYgP/xVQWlG+Ncu5vgwwlaUNx+3799rfe96u9K0JSDXcOzOTJg4B6IgmXfsygc7/Bvg9g9E58/cDVmGIBOP/zT8Bz1zqWqpbXIsd0O9hajXfL6u4BaOS6SeWAAAAAElFTkSuQmCC\" alt=\"doco\" style=\"background-color: inherit\"/> Documentation for this format</a></td></tr></table></div>"
        },
        "questionnaire" : "http://hl7.eu/fhir/ig/gravitate-health-ips/Questionnaire/Questionnaire-EQ5D-5L",
        "status" : "completed",
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "authored" : "2025-10-08T10:35:00Z",
        "item" : [
          {
            "linkId" : "d1",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "2",
                  "display" : "Slight problems"
                }
              }
            ]
          },
          {
            "linkId" : "d2",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "1",
                  "display" : "No problems"
                }
              }
            ]
          },
          {
            "linkId" : "d3",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "3",
                  "display" : "Moderate problems"
                }
              }
            ]
          },
          {
            "linkId" : "d4",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "2",
                  "display" : "Slight problems"
                }
              }
            ]
          },
          {
            "linkId" : "d5",
            "answer" : [
              {
                "valueCoding" : {
                  "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
                  "code" : "1",
                  "display" : "No problems"
                }
              }
            ]
          },
          {
            "linkId" : "vas",
            "answer" : [
              {
                "valueInteger" : 78
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-Health-Literacy-YesNo",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-Health-Literacy-YesNo",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-Health-Literacy-YesNo\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-Health-Literacy-YesNo</b></p><a name=\"Ovl-alicia-Health-Literacy-YesNo\"> </a><a name=\"hcOvl-alicia-Health-Literacy-YesNo\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy health-literacy}\">Health literacy (self-reported)</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2025-10-08</p><p><b>value</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy yes}\">Yes</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "health-literacy",
              "display" : "Health literacy (self-reported)"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2025-10-08",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "yes",
              "display" : "Yes"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-Digital-Literacy-Scale",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-Digital-Literacy-Scale",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-Digital-Literacy-Scale\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-Digital-Literacy-Scale</b></p><a name=\"Ovl-alicia-Digital-Literacy-Scale\"> </a><a name=\"hcOvl-alicia-Digital-Literacy-Scale\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy digital-literacy}\">Digital literacy (self-reported)</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2025-10-08</p><p><b>value</b>: 2</p><p><b>interpretation</b>: <span title=\"Codes:{http://example.org/fhir/CodeSystem/literacy medium}\">Medium</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/literacy",
              "code" : "digital-literacy",
              "display" : "Digital literacy (self-reported)"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2025-10-08",
        "valueInteger" : 2,
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://example.org/fhir/CodeSystem/literacy",
                "code" : "medium",
                "display" : "Medium"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/Ovl-alicia-physical-activity",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Ovl-alicia-physical-activity",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Ovl-alicia-physical-activity\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Ovl-alicia-physical-activity</b></p><a name=\"Ovl-alicia-physical-activity\"> </a><a name=\"hcOvl-alicia-physical-activity\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category activity}\">Activity</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 89555-7}\">Physical activity level</span></p><p><b>subject</b>: <a href=\"Bundle-Ovl-gravitate-Alicia.html#Patient_Ovl-alicia-patient\">Alicia Gravitate  Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)</a></p><p><b>effective</b>: 2013-04-02 09:30:10+0100</p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 228400000}\">Moderately active physical exercise level</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "activity",
                "display" : "Activity"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "89555-7",
              "display" : "Physical activity level"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Ovl-alicia-patient"
        },
        "effectiveDateTime" : "2013-04-02T09:30:10+01:00",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "228400000",
              "display" : "Moderately active physical exercise level"
            }
          ]
        }
      }
    }
  ]
}

```
