# Alicia HIMSS IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alicia HIMSS IPS**

## Example Bundle: Alicia HIMSS IPS

**id:**HIMSS-Alicia

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**alicia-1-himss

**Name:**Alicia HIMSS

**active:**true

**gender:**female

**Birth Date:**1998-01-01

### Sections

#### Allergies and Intolerances

**Allergy:**Lactose (47703008)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Allergy:**Pollen (256259004)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Reaction:**Allergic rhinitis caused by pollen (21719001)

#### Problem List

**Condition:**Gestational diabetes mellitus (disorder) (11687002)

**clinicalStatus:**active

**onsetDateTime:**2023

**Condition:**Hypertensive disorder, systemic arterial (disorder) (38341003)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2022

#### Medication Summary

**Medication:**Irbesartan 75 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/97/049/001 [Karvea 75 mg Tablet]

*  **System** https://www.who-umc.org/phpid **Code:** 0x8DFB446EDB3B8AE508AE493827A704E4 [Irbesartan, 75 mg/ 1 tablet, Tablet]

*  **System** http://www.whocc.no/atc **Code:** C09DA04 [irbesartan and diuretics]

**Dose Form:**Tablet

**Ingredient:**irbesartan (http://fdasis.nlm.nih.gov#J0E2756Z7N)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Metformin 500 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-metformin [Metformin 500 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** himss1 [himss-1]

**Dose Form:**Tablet

**Ingredient:**metformin (http://fdasis.nlm.nih.gov#9100L32L2N)

**strength:**500 mg/1 Tablet

**Route:**Oral use

**Medication:**Ibuprofen 600 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-ibuprofen [Ibuprofen 600 mg Tablet]

*  **System** https://www.who-umc.org/phpid **Code:** himss2 [himss-2]

**Dose Form:**Tablet

**Ingredient:**IBUPROFEN (http://fdasis.nlm.nih.gov#WK2XYI10QM)

**strength:**600 mg/1 Tablet

**Route:**Oral use

#### Relevant diagnostic tests &/or laboratory data/h4> Observation: Cholesterol [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 135 U/L (Abnormal) [30 U/L-110 U/L] Observation: Cholesterol in HDL [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 55 mg/dL (Normal) [35 mg/dL-65 mg/dL] Observation: Cholesterol in LDL [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 110 mg/dL (Normal) [100 mg/dL-130 mg/dL] Observation: Cholesterol in HDL [Mass/volume] in Serum or Plasma Status: final Issued: 2024-04-06T06:22:41-05:00 Result: 55 mg/dL (Normal) [35 mg/dL-65 mg/dL] Observation: Cholesterol in HDL [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 55 mg/dL (Normal) [35 mg/dL-65 mg/dL] Observation: Cholesterol in HDL [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 55.5 mg/dL (Normal) [35 mg/dL-65 mg/dL] Observation: Triglyceride [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 75 mg/dL (Normal) [0 mg/dL-150 mg/dL] Observation: Uric Acid Status: final Issued: 2023-11-06T06:22:41-05:00 Result: 4.8 mg/dL (Normal) [2.7 mg/dL-7.3 mg/dL] Observation: Uric Acid Status: final Issued: 2024-04-06T06:22:41-05:00 Result: 4.8 mg/dL (Normal) [2.7 mg/dL-7.3 mg/dL] Observation: Albumin [Mass/volume] in Serum or Plasma Status: final Issued: 2024-05-05T06:22:41-05:00 Result: 4.7 g/dL (Normal) [3.4 g/dL-5.4 g/dL] Document Reference: Discharge summary Status: superseded Date: 2024-04-06T06:22:41-05:00 Document Reference: Discharge summary Status: superseded Date: 2024-04-06T06:22:41-05:00 Document Reference: Discharge summary Status: superseded Date: 2024-04-06T06:22:41-05:00 Vital signs Code: Blood Pressure Status: final Issued: 2024-04-06T06:22:41-05:00 Result: Diastolic blood pressure || 60 mm[Hg] Systolic blood pressure || 90 mm[Hg] Code: Heart Rate Status: final Issued: 2024-04-06T06:22:41-05:00 Result: 108 bpm [60 bpm-100 bpm] Code: Blood Oxygen Status: final Issued: 2024-04-06T06:22:41-05:00 Result: 96 % (Normal) [90 %-99 %] Code: Blood Pressure Status: final Issued: 2024-04-07T06:22:41-05:00 Result: Diastolic blood pressure || 90 mm[Hg] Systolic blood pressure || 120 mm[Hg] Code: Heart Rate Status: final Issued: 2024-04-07T06:22:41-05:00 Result: 80 bpm [60 bpm-100 bpm] Code: Blood Oxygen Status: final Issued: 2024-04-07T06:22:41-05:00 Result: 99 % (Normal) [90 %-99 %] Social history Narrative Code: Tobacco Smoking Status status: final Result: Age at starting smoking || 17 Age at smoking cessation || 35 Cigarette pack-years || 200 Pregnancy History IG © 2021+ . Package hl7.eu.fhir.gh-ips#0.1.0 based on FHIR 4.0.1. Generated 2025-12-01 Links: Table of Contents | QA Report CC0 The Gravitate Health project has received funding from the IMI 2 Joint Undertaking under grant agreement No 945334. This joint undertaking receives support from the EU H2020 research and innovation programme and EFPIA. a EU funded project 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "HIMSS-Alicia",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "alicia-ips-himss"
  },
  "type" : "document",
  "timestamp" : "2024-05-20T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/alicia-comp-himss",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Alicia",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Alicia\"> </a>\n  \n\n    \n      <b>Id:</b>\n      gravitate-Alicia\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Alicia HIMSS</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Lactose Intolerance\n\n            </li>\n          \n\n            <li>\n\n              Hay fever (pollen)\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              diabetes\n\n            </li>\n          \n\n            <li>\n\n              hypertension\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Relevant diagnostic tests &amp;/or laboratory data\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Vital signs\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Social history Narrative\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              \n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Pregnancy History\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Pregrancy Status\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "Alicia HIMSS"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/alicia-pract-himss",
            "display" : "Dr. Walter Waltz"
          }
        ],
        "title" : "Patient Summary (Alicia HIMSS)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Allergies and Intolerances</div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss",
                "display" : "Lactose Intolerance"
              },
              {
                "reference" : "AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf05-himss",
                "display" : "Hay fever (pollen)"
              }
            ]
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Problem List</div>"
            },
            "entry" : [
              {
                "reference" : "Condition/alicia-cond-1-himss",
                "display" : "diabetes"
              },
              {
                "reference" : "Condition/alicia-cond-2-himss",
                "display" : "hypertension"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Medication list Reported</div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/alicia-med-stat-1-himss"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-2-himss"
              },
              {
                "reference" : "MedicationStatement/alicia-med-stat-3-himss"
              }
            ]
          },
          {
            "title" : "Relevant diagnostic tests &/or laboratory data",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "30954-2",
                  "display" : "Relevant diagnostic tests &or laboratory data"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Relevant diagnostic tests and/or laboratory data</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/alicia-observation-1"
              },
              {
                "reference" : "Observation/alicia-observation-2"
              },
              {
                "reference" : "Observation/alicia-observation-3"
              },
              {
                "reference" : "Observation/alicia-observation-5"
              },
              {
                "reference" : "Observation/alicia-observation-6"
              },
              {
                "reference" : "Observation/alicia-observation-8"
              },
              {
                "reference" : "Observation/alicia-observation-9"
              },
              {
                "reference" : "Observation/alicia-observation-17"
              },
              {
                "reference" : "Observation/alicia-observation-19"
              },
              {
                "reference" : "Observation/alicia-observation-20"
              },
              {
                "reference" : "DocumentReference/alicia-docref-1"
              },
              {
                "reference" : "DocumentReference/alicia-docref-2"
              },
              {
                "reference" : "DocumentReference/alicia-docref-3"
              }
            ]
          },
          {
            "title" : "Vital signs",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8716-3",
                  "display" : "Vital signs"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Vital signs</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/alicia-observation-11"
              },
              {
                "reference" : "Observation/alicia-observation-12"
              },
              {
                "reference" : "Observation/alicia-observation-13"
              },
              {
                "reference" : "Observation/alicia-observation-14"
              },
              {
                "reference" : "Observation/alicia-observation-15"
              },
              {
                "reference" : "Observation/alicia-observation-16"
              }
            ]
          },
          {
            "title" : "Social history Narrative",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "29762-2",
                  "display" : "Social history Narrative"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Social history Narrative</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/alicia-observation-18"
              }
            ]
          },
          {
            "title" : "Pregnancy History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "Pregnancies Hx"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Social history Narrative</div>"
            },
            "entry" : [
              {
                "reference" : "Observation/alicia-preg-status",
                "display" : "Pregrancy Status"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/alicia-patient-himss",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "alicia-patient-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_alicia-patient-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient alicia-patient-himss</b></p><a name=\"alicia-patient-himss\"> </a><a name=\"hcalicia-patient-himss\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>keycloak-id</code>/20d6df9e-6ba9-4654-9e41-a8fc491f8e8b</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 IT}\">Italy</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "IT",
                      "display" : "Italy"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "alicia-1-himss"
          },
          {
            "system" : "keycloak-id",
            "value" : "20d6df9e-6ba9-4654-9e41-a8fc491f8e8b"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "HIMSS",
            "given" : ["Alicia"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1998-01-01"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/alicia-pract-himss",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "alicia-pract-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_alicia-pract-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner alicia-pract-himss</b></p><a name=\"alicia-pract-himss\"> </a><a name=\"hcalicia-pract-himss\"> </a><p><b>name</b>: Walter Waltz </p></div>"
        },
        "name" : [
          {
            "family" : "Waltz",
            "given" : ["Walter"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-1-himss",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-1-himss",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-1-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-1-himss</b></p><a name=\"alicia-cond-1-himss\"> </a><a name=\"hcalicia-cond-1-himss\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 11687002}\">Gestational diabetes mellitus (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">alicia HIMSS</a></p><p><b>onset</b>: 2023</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "11687002",
              "display" : "Gestational diabetes mellitus (disorder)"
            }
          ],
          "text" : "Gestational diabetes mellitus (disorder)"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "alicia HIMSS"
        },
        "onsetDateTime" : "2023"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/alicia-cond-2-himss",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "alicia-cond-2-himss",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_alicia-cond-2-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition alicia-cond-2-himss</b></p><a name=\"alicia-cond-2-himss\"> </a><a name=\"hcalicia-cond-2-himss\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertensive disorder, systemic arterial (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">alicia HIMSS</a></p><p><b>onset</b>: 2022</p><p><b>asserter</b>: <a href=\"Bundle-HIMSS-Alicia.html#Practitioner_alicia-pract-himss\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "Hypertensive disorder, systemic arterial (disorder)"
            }
          ],
          "text" : "Hypertensive disorder, systemic arterial (disorder)"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "alicia HIMSS"
        },
        "onsetDateTime" : "2022",
        "asserter" : {
          "reference" : "Practitioner/alicia-pract-himss",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-1-himss",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-1-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-1-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-1-himss</b></p><a name=\"alicia-med-stat-1-himss\"> </a><a name=\"hcalicia-med-stat-1-himss\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-HIMSS-Alicia.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c5-himss\">Irbesartan 75 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c5-himss",
          "display" : "Irbesartan 75 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "Alicia HIMSS"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-2-himss",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-2-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-2-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-2-himss</b></p><a name=\"alicia-med-stat-2-himss\"> </a><a name=\"hcalicia-med-stat-2-himss\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-HIMSS-Alicia.html#Medication_metformin-himss\">Metformin 500 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/metformin-himss",
          "display" : "Metformin 500 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "Alicia HIMSS"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/alicia-med-stat-3-himss",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "alicia-med-stat-3-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_alicia-med-stat-3-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement alicia-med-stat-3-himss</b></p><a name=\"alicia-med-stat-3-himss\"> </a><a name=\"hcalicia-med-stat-3-himss\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-HIMSS-Alicia.html#Medication_ibuprofen-himss\">Ibuprofen 600 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/ibuprofen-himss",
          "display" : "Ibuprofen 600 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "Alicia HIMSS"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss</b></p><a name=\"cb6e84fa-4302-4569-ac1c-6b1b32507d16-himss\"> </a><a name=\"hccb6e84fa-4302-4569-ac1c-6b1b32507d16-himss\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 47703008}\">Lactose</span></p><p><b>patient</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">alicia HIMSS</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "47703008",
              "display" : "Lactose"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "alicia HIMSS"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf05-himss",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "1dff4474-fa08-4f45-8260-dbb23094bf05-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_1dff4474-fa08-4f45-8260-dbb23094bf05-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 1dff4474-fa08-4f45-8260-dbb23094bf05-himss</b></p><a name=\"1dff4474-fa08-4f45-8260-dbb23094bf05-himss\"> </a><a name=\"hc1dff4474-fa08-4f45-8260-dbb23094bf05-himss\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 256259004}\">Pollen</span></p><p><b>patient</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">alicia HIMSS</a></p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 21719001}\">Hay fever</span></td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "256259004",
              "display" : "Pollen"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/alicia-patient-himss",
          "display" : "alicia HIMSS"
        },
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21719001",
                    "display" : "Allergic rhinitis caused by pollen"
                  }
                ],
                "text" : "Hay fever"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/metformin-himss",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "metformin-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_metformin-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication metformin-himss</b></p><a name=\"metformin-himss\"> </a><a name=\"hcmetformin-himss\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-metformin}, {https://www.who-umc.org/phpid himss1}\">Metformin 500 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 9100L32L2N}\">metformin</span></td><td>500 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-metformin",
              "display" : "Metformin 500 mg tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "himss1",
              "display" : "himss-1"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "9100L32L2N",
                  "display" : "metformin"
                }
              ],
              "text" : "metformin"
            },
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c5-himss",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c5-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c5-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c5-himss</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c5-himss\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c5-himss\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/97/049/001}, {https://www.who-umc.org/phpid 0x8DFB446EDB3B8AE508AE493827A704E4}, {http://www.whocc.no/atc C09DA04}\">Karvea 75 mg Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov J0E2756Z7N}\">irbesartan</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/97/049/001",
              "display" : "Karvea 75 mg Tablet"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x8DFB446EDB3B8AE508AE493827A704E4",
              "display" : "Irbesartan, 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C09DA04",
              "display" : "irbesartan and diuretics"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "J0E2756Z7N",
                  "display" : "irbesartan"
                }
              ],
              "text" : "irbesartan"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/ibuprofen-himss",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "ibuprofen-himss",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_ibuprofen-himss\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication ibuprofen-himss</b></p><a name=\"ibuprofen-himss\"> </a><a name=\"hcibuprofen-himss\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-ibuprofen}, {https://www.who-umc.org/phpid himss2}\">Ibuprofen 600 mg Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov WK2XYI10QM}\">IBUPROFEN</span></td><td>600 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-ibuprofen",
              "display" : "Ibuprofen 600 mg Tablet"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "himss2",
              "display" : "himss-2"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "WK2XYI10QM",
                  "display" : "IBUPROFEN"
                }
              ],
              "text" : "IBUPROFEN"
            },
            "strength" : {
              "numerator" : {
                "value" : 600,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.117877Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-1</b></p><a name=\"alicia-observation-1\"> </a><a name=\"hcalicia-observation-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/d2faec50-338f-47a8-bd60-bc7ee7fcf78f</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2093-3}\">Cholesterol [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 135 U/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeU/L = 'U/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation A}\">Abnormal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>30 U/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeU/L = 'U/L')</span></td><td>110 U/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeU/L = 'U/L')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "d2faec50-338f-47a8-bd60-bc7ee7fcf78f"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2093-3",
              "display" : "Cholesterol [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 135,
          "unit" : "U/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "U/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "A",
                "display" : "Abnormal"
              }
            ],
            "text" : "Abnormal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 30,
              "unit" : "U/L",
              "system" : "http://unitsofmeasure.org",
              "code" : "U/L"
            },
            "high" : {
              "value" : 110,
              "unit" : "U/L",
              "system" : "http://unitsofmeasure.org",
              "code" : "U/L"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-11",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-11",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.120039Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/bp"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-11</b></p><a name=\"alicia-observation-11\"> </a><a name=\"hcalicia-observation-11\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/bp.html\">Observation Blood Pressure Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/82070ab8-88ea-4f14-aa27-01f0736f4879</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}\">Blood Pressure</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>issued</b>: 2024-04-06 06:22:41-0500</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}, {http://loinc.org 8462-4}\">Diastolic blood pressure</span></p><p><b>value</b>: 60 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>60 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td>120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td> Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly</td></tr></table></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}, {http://loinc.org 8480-6}\">Systolic blood pressure</span></p><p><b>value</b>: 90 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td>180 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td> Neck exploration; tracheostomy; urgent flexible bronchoscopy via tracheostomy site; removal of foreign body, tracheal metallic stent material; dilation distal trachea; placement of #8 Shiley single cannula tracheostomy tube.\nsurgery, airway, laryngology, shiley, alteration of voice, bronchi, bronchoscopy, cannula, cartilage, cricoid, flexible, foreign body, mainstem, obstruction, perichondrium, stenosis, stent, subglottic, swallowing, trachea, tracheal, tracheal stenosis, tracheostomy, shiley single cannula tracheostomy, shiley single cannula, single cannula tracheostomy, thyroid isthmus, stent material, tracheostomy tube, tube, thyroid, </td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "82070ab8-88ea-4f14-aa27-01f0736f4879"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood Pressure"
            }
          ],
          "text" : "Blood Pressure"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ],
              "text" : "Diastolic blood pressure"
            },
            "valueQuantity" : {
              "value" : 60,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 60,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "high" : {
                  "value" : 120,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "text" : " Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ],
              "text" : "Systolic blood pressure"
            },
            "valueQuantity" : {
              "value" : 90,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 120,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "high" : {
                  "value" : 180,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "text" : " Neck exploration; tracheostomy; urgent flexible bronchoscopy via tracheostomy site; removal of foreign body, tracheal metallic stent material; dilation distal trachea; placement of #8 Shiley single cannula tracheostomy tube.\nsurgery, airway, laryngology, shiley, alteration of voice, bronchi, bronchoscopy, cannula, cartilage, cricoid, flexible, foreign body, mainstem, obstruction, perichondrium, stenosis, stent, subglottic, swallowing, trachea, tracheal, tracheal stenosis, tracheostomy, shiley single cannula tracheostomy, shiley single cannula, single cannula tracheostomy, thyroid isthmus, stent material, tracheostomy tube, tube, thyroid, "
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-12",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-12",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.121756Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/heartrate"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-12</b></p><a name=\"alicia-observation-12\"> </a><a name=\"hcalicia-observation-12\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/heartrate.html\">Observation Heart Rate Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/e121b658-2fd4-4375-98c4-32579e2fd979</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8867-4}\">Heart Rate</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>issued</b>: 2024-04-06 06:22:41-0500</p><p><b>value</b>: 108 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>60 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></td><td>100 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></td><td> Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "e121b658-2fd4-4375-98c4-32579e2fd979"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8867-4",
              "display" : "Heart Rate"
            }
          ],
          "text" : "Heart Rate"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 108,
          "unit" : "bpm",
          "system" : "http://unitsofmeasure.org",
          "code" : "/min"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 60,
              "unit" : "bpm",
              "system" : "http://unitsofmeasure.org",
              "code" : "/min"
            },
            "high" : {
              "value" : 100,
              "unit" : "bpm",
              "system" : "http://unitsofmeasure.org",
              "code" : "/min"
            },
            "text" : " Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-13",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-13",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.123668Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/oxygensat"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-13</b></p><a name=\"alicia-observation-13\"> </a><a name=\"hcalicia-observation-13\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/oxygensat.html\">Observation Oxygen Saturation Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/fc634b8f-7586-48ad-a52d-339e946efca1</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2708-6}\">Blood Oxygen</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>issued</b>: 2024-04-06 06:22:41-0500</p><p><b>value</b>: 96 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal (applies to non-numeric results)</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td></tr><tr><td style=\"display: none\">*</td><td>90 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></td><td>99 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "fc634b8f-7586-48ad-a52d-339e946efca1"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2708-6",
              "display" : "Blood Oxygen"
            }
          ],
          "text" : "Blood Oxygen"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 96,
          "unit" : "%",
          "system" : "http://unitsofmeasure.org",
          "code" : "%"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal (applies to non-numeric results)"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 90,
              "unit" : "%",
              "system" : "http://unitsofmeasure.org",
              "code" : "%"
            },
            "high" : {
              "value" : 99,
              "unit" : "%",
              "system" : "http://unitsofmeasure.org",
              "code" : "%"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-14",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-14",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.125427Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/bp"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-14</b></p><a name=\"alicia-observation-14\"> </a><a name=\"hcalicia-observation-14\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/bp.html\">Observation Blood Pressure Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/447308b4-5335-450c-ac19-5d570d4d3e92</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}\">Blood Pressure</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-07 06:22:41-0500</p><p><b>issued</b>: 2024-04-07 06:22:41-0500</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}, {http://loinc.org 8462-4}\">Diastolic blood pressure</span></p><p><b>value</b>: 90 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>60 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td>120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td> Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly</td></tr></table></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}, {http://loinc.org 8480-6}\">Systolic blood pressure</span></p><p><b>value</b>: 120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>120 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td>180 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></td><td> Neck exploration; tracheostomy; urgent flexible bronchoscopy via tracheostomy site; removal of foreign body, tracheal metallic stent material; dilation distal trachea; placement of #8 Shiley single cannula tracheostomy tube.\nsurgery, airway, laryngology, shiley, alteration of voice, bronchi, bronchoscopy, cannula, cartilage, cricoid, flexible, foreign body, mainstem, obstruction, perichondrium, stenosis, stent, subglottic, swallowing, trachea, tracheal, tracheal stenosis, tracheostomy, shiley single cannula tracheostomy, shiley single cannula, single cannula tracheostomy, thyroid isthmus, stent material, tracheostomy tube, tube, thyroid, </td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "447308b4-5335-450c-ac19-5d570d4d3e92"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood Pressure"
            }
          ],
          "text" : "Blood Pressure"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-07T06:22:41-05:00",
        "issued" : "2024-04-07T06:22:41-05:00",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ],
              "text" : "Diastolic blood pressure"
            },
            "valueQuantity" : {
              "value" : 90,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 60,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "high" : {
                  "value" : 120,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "text" : " Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4"
                },
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ],
              "text" : "Systolic blood pressure"
            },
            "valueQuantity" : {
              "value" : 120,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            },
            "referenceRange" : [
              {
                "low" : {
                  "value" : 120,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "high" : {
                  "value" : 180,
                  "unit" : "mm[Hg]",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mm[Hg]"
                },
                "text" : " Neck exploration; tracheostomy; urgent flexible bronchoscopy via tracheostomy site; removal of foreign body, tracheal metallic stent material; dilation distal trachea; placement of #8 Shiley single cannula tracheostomy tube.\nsurgery, airway, laryngology, shiley, alteration of voice, bronchi, bronchoscopy, cannula, cartilage, cricoid, flexible, foreign body, mainstem, obstruction, perichondrium, stenosis, stent, subglottic, swallowing, trachea, tracheal, tracheal stenosis, tracheostomy, shiley single cannula tracheostomy, shiley single cannula, single cannula tracheostomy, thyroid isthmus, stent material, tracheostomy tube, tube, thyroid, "
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-15",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-15",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.127449Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/heartrate"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-15</b></p><a name=\"alicia-observation-15\"> </a><a name=\"hcalicia-observation-15\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/heartrate.html\">Observation Heart Rate Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/cf825918-f561-4d07-bf20-ad97b0e58417</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8867-4}\">Heart Rate</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-07 06:22:41-0500</p><p><b>issued</b>: 2024-04-07 06:22:41-0500</p><p><b>value</b>: 80 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>60 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></td><td>100 bpm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></td><td> Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "cf825918-f561-4d07-bf20-ad97b0e58417"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8867-4",
              "display" : "Heart Rate"
            }
          ],
          "text" : "Heart Rate"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-07T06:22:41-05:00",
        "issued" : "2024-04-07T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 80,
          "unit" : "bpm",
          "system" : "http://unitsofmeasure.org",
          "code" : "/min"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 60,
              "unit" : "bpm",
              "system" : "http://unitsofmeasure.org",
              "code" : "/min"
            },
            "high" : {
              "value" : 100,
              "unit" : "bpm",
              "system" : "http://unitsofmeasure.org",
              "code" : "/min"
            },
            "text" : " Counting calorie points, exercising pretty regularly, seems to be doing well\ndiets and nutritions, overeaters anonymous, diabetic exchanges, exercising pretty regularly, food journal, diabetic, exercising, exchanges, regularly"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-16",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-16",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.129331Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : ["http://hl7.org/fhir/StructureDefinition/oxygensat"],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-16</b></p><a name=\"alicia-observation-16\"> </a><a name=\"hcalicia-observation-16\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/R4/oxygensat.html\">Observation Oxygen Saturation Profile</a></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/bbb99d5d-29c9-41a9-bdc3-990fbe2dc314</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2708-6}\">Blood Oxygen</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-07 06:22:41-0500</p><p><b>issued</b>: 2024-04-07 06:22:41-0500</p><p><b>value</b>: 99 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal (applies to non-numeric results)</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td></tr><tr><td style=\"display: none\">*</td><td>90 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></td><td>99 %<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code% = '%')</span></td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "bbb99d5d-29c9-41a9-bdc3-990fbe2dc314"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ],
            "text" : "Vital Signs"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2708-6",
              "display" : "Blood Oxygen"
            }
          ],
          "text" : "Blood Oxygen"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-07T06:22:41-05:00",
        "issued" : "2024-04-07T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 99,
          "unit" : "%",
          "system" : "http://unitsofmeasure.org",
          "code" : "%"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal (applies to non-numeric results)"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 90,
              "unit" : "%",
              "system" : "http://unitsofmeasure.org",
              "code" : "%"
            },
            "high" : {
              "value" : 99,
              "unit" : "%",
              "system" : "http://unitsofmeasure.org",
              "code" : "%"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-17",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-17",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.131159Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-17</b></p><a name=\"alicia-observation-17\"> </a><a name=\"hcalicia-observation-17\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/f93000c0-1c14-4977-9a7c-facea97c0690</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 3084-1}\">Uric Acid</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2023-11-06 06:22:41-0500</p><p><b>issued</b>: 2023-11-06 06:22:41-0500</p><p><b>value</b>: 4.8 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>2.7 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>7.3 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "f93000c0-1c14-4977-9a7c-facea97c0690"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3084-1",
              "display" : "Uric Acid"
            }
          ],
          "text" : "Uric Acid"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2023-11-06T06:22:41-05:00",
        "issued" : "2023-11-06T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 4.8,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 2.7,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 7.3,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-18",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-18",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.132904Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/ObservationProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-18\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-18</b></p><a name=\"alicia-observation-18\"> </a><a name=\"hcalicia-observation-18\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/ObservationProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/96f4b0ed-60ba-4fd2-9147-84516296a5f1</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 72166-2}\">Tobacco Smoking Status</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA15920-4}\">Former Smoker</span></p><p><b>note</b>: </p><blockquote><div><p>Patient has quit smoking.</p>\n</div></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 228488005}\">Age at starting smoking</span></p><p><b>value</b>: 17</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 1221000175102}\">Age at smoking cessation</span></p><p><b>value</b>: 35</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 401201003}\">Cigarette pack-years</span></p><p><b>value</b>: 200</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 102409004}\">Second hand cigarette smoke</span></p><p><b>value</b>: false</p></blockquote></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "96f4b0ed-60ba-4fd2-9147-84516296a5f1"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history",
                "display" : "Social History"
              }
            ],
            "text" : "Social History"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72166-2",
              "display" : "Tobacco Smoking Status"
            }
          ],
          "text" : "Tobacco Smoking Status"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA15920-4",
              "display" : "Former Smoker"
            }
          ],
          "text" : "Former Smoker"
        },
        "note" : [
          {
            "text" : "Patient has quit smoking."
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "228488005",
                  "display" : "Age at starting smoking"
                }
              ],
              "text" : "Age at starting smoking"
            },
            "valueInteger" : 17
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "1221000175102",
                  "display" : "Age at smoking cessation"
                }
              ],
              "text" : "Age at smoking cessation"
            },
            "valueInteger" : 35
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "401201003",
                  "display" : "Cigarette pack-years"
                }
              ],
              "text" : "Cigarette pack-years"
            },
            "valueInteger" : 200
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "102409004",
                  "display" : "Second hand cigarette smoke"
                }
              ],
              "text" : "Second hand cigarette smoke"
            },
            "valueBoolean" : false
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-19",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-19",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.134744Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-19</b></p><a name=\"alicia-observation-19\"> </a><a name=\"hcalicia-observation-19\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/9cfe5743-e5c7-40fe-990d-5da41bd099c1</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 3084-1}\">Uric Acid</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>issued</b>: 2024-04-06 06:22:41-0500</p><p><b>value</b>: 4.8 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>2.7 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>7.3 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "9cfe5743-e5c7-40fe-990d-5da41bd099c1"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "3084-1",
              "display" : "Uric Acid"
            }
          ],
          "text" : "Uric Acid"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 4.8,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 2.7,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 7.3,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-2",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.136394Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-2</b></p><a name=\"alicia-observation-2\"> </a><a name=\"hcalicia-observation-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/25198799-f22b-4f18-916e-8ab0bb11862c</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2085-9}\">Cholesterol in HDL [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 55 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>35 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>65 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "25198799-f22b-4f18-916e-8ab0bb11862c"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2085-9",
              "display" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 55,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 35,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 65,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-20",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-20",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.138136Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-20</b></p><a name=\"alicia-observation-20\"> </a><a name=\"hcalicia-observation-20\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/0f38ecc6-5a27-4068-abc2-948a80ecaa90</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 1751-7}\">Albumin [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 4.7 g/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg/dL = 'g/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>3.4 g/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg/dL = 'g/dL')</span></td><td>5.4 g/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg/dL = 'g/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "0f38ecc6-5a27-4068-abc2-948a80ecaa90"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "1751-7",
              "display" : "Albumin [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Albumin [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 4.7,
          "unit" : "g/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "g/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 3.4,
              "unit" : "g/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "g/dL"
            },
            "high" : {
              "value" : 5.4,
              "unit" : "g/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "g/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-3",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-3",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.140693Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-3</b></p><a name=\"alicia-observation-3\"> </a><a name=\"hcalicia-observation-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/4ee5a5de-b0c6-490e-8de1-eb86f99f5bf4</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2089-1}\">Cholesterol in LDL [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 110 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>100 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>130 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "4ee5a5de-b0c6-490e-8de1-eb86f99f5bf4"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2089-1",
              "display" : "Cholesterol in LDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in LDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 110,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 100,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 130,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-5",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-5",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.142434Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-5</b></p><a name=\"alicia-observation-5\"> </a><a name=\"hcalicia-observation-5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/a07ca0d3-8470-4299-b998-1efaa04d0554</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2085-9}\">Cholesterol in HDL [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-04-06 06:22:41-0500</p><p><b>issued</b>: 2024-04-06 06:22:41-0500</p><p><b>value</b>: 55 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>35 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>65 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "a07ca0d3-8470-4299-b998-1efaa04d0554"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2085-9",
              "display" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 55,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 35,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 65,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-6",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-6",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.144179Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-6</b></p><a name=\"alicia-observation-6\"> </a><a name=\"hcalicia-observation-6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/365026f7-9872-43ea-8ac3-c48485c628d5</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2085-9}\">Cholesterol in HDL [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 55 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>35 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>65 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "365026f7-9872-43ea-8ac3-c48485c628d5"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2085-9",
              "display" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 55,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 35,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 65,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-8",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-8",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.146012Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-8</b></p><a name=\"alicia-observation-8\"> </a><a name=\"hcalicia-observation-8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/25448903-7e1a-45d5-a6e4-ec151b936f99</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2085-9}\">Cholesterol in HDL [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 55.5 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>35 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>65 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "25448903-7e1a-45d5-a6e4-ec151b936f99"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2085-9",
              "display" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Cholesterol in HDL [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 55.5,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 35,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 65,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-observation-9",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-observation-9",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:05:26.147853Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-observation-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-observation-9</b></p><a name=\"alicia-observation-9\"> </a><a name=\"hcalicia-observation-9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:05:26+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/LabResultProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>qa/StructureDefinition/ObservationTestType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 LAB}\">Laboratory</span></p><p><b>identifier</b>: GRID/dcbbacd2-60c9-4a98-bc3d-7ef92227ce23</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 2571-8}\">Triglyceride [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>effective</b>: 2024-05-05 06:22:41-0500</p><p><b>issued</b>: 2024-05-05 06:22:41-0500</p><p><b>value</b>: 75 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>0 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>150 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td> Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "https://fhir.moph.gov.qa/StructureDefinition/ObservationTestType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                  "code" : "LAB",
                  "display" : "Laboratory"
                }
              ],
              "text" : "Laboratory"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "dcbbacd2-60c9-4a98-bc3d-7ef92227ce23"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "2571-8",
              "display" : "Triglyceride [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Triglyceride [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-05-05T06:22:41-05:00",
        "issued" : "2024-05-05T06:22:41-05:00",
        "valueQuantity" : {
          "value" : 75,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ],
            "text" : "Normal"
          }
        ],
        "referenceRange" : [
          {
            "low" : {
              "value" : 0,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "high" : {
              "value" : 150,
              "unit" : "mg/dL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "text" : " Costochondral Cartilage Injection\npain management, costochondral cartilage injection, 0.5% marcaine, ap and lateral, costochondral, depo-medrol, costochondral junction, fluoroscopy, hypodermic needle, pneumothorax, subcutaneously, supine position, cartilage injection, costochondral cartilage, needle, distress, cartilage, injection,"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/DocumentReference/alicia-docref-1",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "alicia-docref-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:23:37.737849Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_alicia-docref-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference alicia-docref-1</b></p><a name=\"alicia-docref-1\"> </a><a name=\"hcalicia-docref-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:23:37+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/84ec12dd-4059-4681-ae77-d72ec12d71b1</p><p><b>status</b>: Superseded</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 11490-0}\">Physician Discharge summary</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 18842-5}\">Discharge summary</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>date</b>: 2024-04-06 06:22:41-0500</p><p><b>author</b>: <a href=\"Bundle-HIMSS-Alicia.html#Practitioner_alicia-pract-himss\">Gamze Guzle</a></p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Data</b></td></tr><tr><td style=\"display: none\">*</td><td>application/pdf</td><td>(base64 data - 26,116 base64 chars)</td></tr></table><p><b>format</b>: IHE.FormatCode.codesystem: urn:ihe:iti:xds:2017:mimeTypeSufficient (mimeType Sufficient)</p></blockquote><h3>Contexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Period</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-04-06 06:22:41-0500 --&gt; 2024-04-07 06:22:41-0500</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "84ec12dd-4059-4681-ae77-d72ec12d71b1"
          }
        ],
        "status" : "superseded",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
              "code" : "11490-0",
              "display" : "Physician Discharge summary"
            }
          ],
          "text" : "Physician Discharge summary"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18842-5",
                "display" : "Discharge summary"
              }
            ],
            "text" : "Discharge summary"
          }
        ],
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "date" : "2024-04-06T06:22:41-05:00",
        "author" : [
          {
            "reference" : "Practitioner/alicia-pract-himss",
            "display" : "Gamze Guzle"
          }
        ],
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "data" : "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"
            },
            "format" : {
              "system" : "http://ihe.net/fhir/ValueSet/IHE.FormatCode.codesystem",
              "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
              "display" : "mimeType Sufficient"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2024-04-06T06:22:41-05:00",
            "end" : "2024-04-07T06:22:41-05:00"
          }
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/DocumentReference/alicia-docref-2",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "alicia-docref-2",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:23:37.742279Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_alicia-docref-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference alicia-docref-2</b></p><a name=\"alicia-docref-2\"> </a><a name=\"hcalicia-docref-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:23:37+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/9d3245cc-8148-4fd3-9f39-8bf164a47ab9</p><p><b>status</b>: Superseded</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 11490-0}\">Physician Discharge summary</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 18842-5}\">Discharge summary</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>date</b>: 2024-04-06 06:22:41-0500</p><p><b>author</b>: <a href=\"Bundle-HIMSS-Alicia.html#Practitioner_alicia-pract-himss\">Gamze Guzle</a></p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Data</b></td></tr><tr><td style=\"display: none\">*</td><td>application/pdf</td><td>(base64 data - 26,116 base64 chars)</td></tr></table><p><b>format</b>: IHE.FormatCode.codesystem: urn:ihe:iti:xds:2017:mimeTypeSufficient (mimeType Sufficient)</p></blockquote><h3>Contexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Period</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-04-06 06:22:41-0500 --&gt; 2024-04-07 06:22:41-0500</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "9d3245cc-8148-4fd3-9f39-8bf164a47ab9"
          }
        ],
        "status" : "superseded",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
              "code" : "11490-0",
              "display" : "Physician Discharge summary"
            }
          ],
          "text" : "Physician Discharge summary"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18842-5",
                "display" : "Discharge summary"
              }
            ],
            "text" : "Discharge summary"
          }
        ],
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "date" : "2024-04-06T06:22:41-05:00",
        "author" : [
          {
            "reference" : "Practitioner/alicia-pract-himss",
            "display" : "Gamze Guzle"
          }
        ],
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "data" : "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"
            },
            "format" : {
              "system" : "http://ihe.net/fhir/ValueSet/IHE.FormatCode.codesystem",
              "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
              "display" : "mimeType Sufficient"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2024-04-06T06:22:41-05:00",
            "end" : "2024-04-07T06:22:41-05:00"
          }
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/DocumentReference/alicia-docref-3",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "alicia-docref-3",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:23:37.746263Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_alicia-docref-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference alicia-docref-3</b></p><a name=\"alicia-docref-3\"> </a><a name=\"hcalicia-docref-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:23:37+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/DocumentReferenceProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><p><b>identifier</b>: GRID/02cbf28f-7f16-4456-a8c5-f31855825d67</p><p><b>status</b>: Superseded</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 11490-0}\">Physician Discharge summary</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 18842-5}\">Discharge summary</span></p><p><b>subject</b>: <a href=\"Bundle-HIMSS-Alicia.html#Patient_alicia-patient-himss\">Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</a></p><p><b>date</b>: 2024-04-06 06:22:41-0500</p><p><b>author</b>: <a href=\"Bundle-HIMSS-Alicia.html#Practitioner_alicia-pract-himss\">Gamze Guzle</a></p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Data</b></td></tr><tr><td style=\"display: none\">*</td><td>application/pdf</td><td>(base64 data - 26,116 base64 chars)</td></tr></table><p><b>format</b>: IHE.FormatCode.codesystem: urn:ihe:iti:xds:2017:mimeTypeSufficient (mimeType Sufficient)</p></blockquote><h3>Contexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Period</b></td></tr><tr><td style=\"display: none\">*</td><td>2024-04-06 06:22:41-0500 --&gt; 2024-04-07 06:22:41-0500</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "02cbf28f-7f16-4456-a8c5-f31855825d67"
          }
        ],
        "status" : "superseded",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
              "code" : "11490-0",
              "display" : "Physician Discharge summary"
            }
          ],
          "text" : "Physician Discharge summary"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18842-5",
                "display" : "Discharge summary"
              }
            ],
            "text" : "Discharge summary"
          }
        ],
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "date" : "2024-04-06T06:22:41-05:00",
        "author" : [
          {
            "reference" : "Practitioner/alicia-pract-himss",
            "display" : "Gamze Guzle"
          }
        ],
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "data" : "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"
            },
            "format" : {
              "system" : "http://ihe.net/fhir/ValueSet/IHE.FormatCode.codesystem",
              "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
              "display" : "mimeType Sufficient"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2024-04-06T06:22:41-05:00",
            "end" : "2024-04-07T06:22:41-05:00"
          }
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/DiagnosticReport/alicia-report-1",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "alicia-report-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:14:21.350323Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/DiagnosticReportProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_alicia-report-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport alicia-report-1</b></p><a name=\"alicia-report-1\"> </a><a name=\"hcalicia-report-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:14:21+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/DiagnosticReportProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><h2><span title=\"Codes:{http://loinc.org 10191-5}\">Physical findings of Abdomen Narrative</span> (<span title=\"Codes:{https://fhir.moph.gov.qa/CodeSystem/DiagnosticReportCategory RAD}\">RAD</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</td></tr><tr><td>When For</td><td>2024-04-06 06:22:41-0500</td></tr><tr><td>Reported</td><td>2024-04-06 06:22:41-0500</td></tr><tr><td>Identifier</td><td> GRID/1b5b4022-133b-4a3e-b076-59cf5f48fdd2</td></tr></table><p><b>Report Details</b></p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "1b5b4022-133b-4a3e-b076-59cf5f48fdd2"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://fhir.moph.gov.qa/CodeSystem/DiagnosticReportCategory",
                "code" : "RAD"
              }
            ],
            "text" : "RAD"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10191-5",
              "display" : "Physical findings of Abdomen Narrative"
            }
          ],
          "text" : "Physical findings of Abdomen Narrative"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "presentedForm" : [
          {
            "contentType" : "application/pdf",
            "data" : "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"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/DiagnosticReport/alicia-report-2",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "alicia-report-2",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-05-27T10:14:21.353278Z",
          "source" : "a0ff03bb-345a-4cad-82f4-e38437c1f439",
          "profile" : [
            "https://fhir.moph.gov.qa/StructureDefinition/DiagnosticReportProfile"
          ],
          "tag" : [
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "moph",
              "display" : "moph"
            },
            {
              "system" : "https://fhir.tigahealth.com/applicationType",
              "code" : "emr",
              "display" : "emr"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_alicia-report-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport alicia-report-2</b></p><a name=\"alicia-report-2\"> </a><a name=\"hcalicia-report-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-05-27 10:14:21+0000; </p><p style=\"margin-bottom: 0px\">Information Source: a0ff03bb-345a-4cad-82f4-e38437c1f439</p><p style=\"margin-bottom: 0px\">Profile: <code>https://fhir.moph.gov.qa/StructureDefinition/DiagnosticReportProfile</code></p><p style=\"margin-bottom: 0px\">Tags: moph (Details: applicationType code moph), emr (Details: applicationType code emr)</p></div><h2><span title=\"Codes:{http://loinc.org 10191-5}\">Physical findings of Abdomen Narrative</span> (<span title=\"Codes:{https://fhir.moph.gov.qa/CodeSystem/DiagnosticReportCategory PAT}\">PAT</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Alicia HIMSS  Female, DoB: 1998-01-01 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-himss)</td></tr><tr><td>When For</td><td>2024-04-06 06:22:41-0500</td></tr><tr><td>Reported</td><td>2024-04-06 06:22:41-0500</td></tr><tr><td>Identifier</td><td> GRID/0318f85b-2a32-4125-93d0-9acb17cd447e</td></tr></table><p><b>Report Details</b></p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "https://fhir.moph.gov.qa/ValueSet/IdentifierTypes",
                  "code" : "GRID"
                }
              ],
              "text" : "GRID"
            },
            "system" : "https://facility.moph.gov.qa/TR-001",
            "value" : "0318f85b-2a32-4125-93d0-9acb17cd447e"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "https://fhir.moph.gov.qa/CodeSystem/DiagnosticReportCategory",
                "code" : "PAT"
              }
            ],
            "text" : "PAT"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10191-5",
              "display" : "Physical findings of Abdomen Narrative"
            }
          ],
          "text" : "Physical findings of Abdomen Narrative"
        },
        "subject" : {
          "reference" : "Patient/alicia-patient-himss"
        },
        "effectiveDateTime" : "2024-04-06T06:22:41-05:00",
        "issued" : "2024-04-06T06:22:41-05:00",
        "presentedForm" : [
          {
            "contentType" : "application/pdf",
            "data" : "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"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/alicia-preg-status",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "alicia-preg-status",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_alicia-preg-status\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation alicia-preg-status</b></p><a name=\"alicia-preg-status\"> </a><a name=\"hcalicia-preg-status\"> </a><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82810-3}\">Pregnancy status</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">IPS 3 example Gravitate  Female, DoB: 1978-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-3)</a></p><p><b>effective</b>: 2024-01-10</p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA15173-0}\">Pregnant</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3",
              "display" : "Pregnancy status"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1"
        },
        "effectiveDateTime" : "2024-01-10",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA15173-0",
              "display" : "Pregnant"
            }
          ]
        }
      }
    }
  ]
}

```
