# Terminology - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

ePI and IPS reference a core set of globally accessible and usable value sets licensed at no-cost with the aim to serve the public good.

### ePI Terminologies

#### ePI Code Systems

The ePI uses the following as primary terminologies:

1. EDQM Standard Terms
1. ISO
1. UCUM

#### ePI Value Sets

1. Dosage forms (example)
1. Routes of administration (example)
1. Country codes (two letter) (example)
1. Language codes (two letter) (example)
1. Units of measure (example)

### IPS Terminologies

Refer to the [IPS Implementation Guide](http://build.fhir.org/ig/HL7/fhir-ips/terminology.html) for complete list of terminologies in use.

#### IPS Code Systems (Relevant to this use case)

#### IPS Value Sets (Relevant to this use case)

#### ValueSets

* [EQ-5D Anxiety/Depression VS](ValueSet-eq5d-anxdep-vs.md)

* [EQ-5D-5L Levels VS](ValueSet-eq5d-levels-vs.md)

* [EQ-5D Mobility VS](ValueSet-eq5d-mobility-vs.md)

* [EQ-5D Pain/Discomfort VS](ValueSet-eq5d-pain-vs.md)

* [EQ-5D Self-care VS](ValueSet-eq5d-selfcare-vs.md)

* [EQ-5D Usual activities VS](ValueSet-eq5d-usualactivities-vs.md)

* [Literacy Level (Low/Medium/High)](ValueSet-literacy-level-vs.md)

#### CodeSystems

* [EQ-5D-5L Levels](CodeSystem-eq5d-levels-cs.md)

* [Local Literacy Codes](CodeSystem-literacy-cs.md)

#### ConceptMaps

#### NamingSystems

