# Artifacts Summary - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| |
| :--- |
| [EQ-5D Anxiety/Depression VS](ValueSet-eq5d-anxdep-vs.md) |
| [EQ-5D Mobility VS](ValueSet-eq5d-mobility-vs.md) |
| [EQ-5D Pain/Discomfort VS](ValueSet-eq5d-pain-vs.md) |
| [EQ-5D Self-care VS](ValueSet-eq5d-selfcare-vs.md) |
| [EQ-5D Usual activities VS](ValueSet-eq5d-usualactivities-vs.md) |
| [EQ-5D-5L Levels VS](ValueSet-eq5d-levels-vs.md) |
| [Literacy Level (Low/Medium/High)](ValueSet-literacy-level-vs.md) |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| |
| :--- |
| [EQ-5D-5L Levels](CodeSystem-eq5d-levels-cs.md) |
| [Local Literacy Codes](CodeSystem-literacy-cs.md) |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Alex Gravitate's IPS](Bundle-gravitate-alex-himss.md) | Example of International Patient Summary for Alex Gravitate |
| [Alicia Gravitate's IPS](Bundle-gravitate-Alicia.md) | Example of International Patient Summary for Alicia Gravitate |
| [Alicia Gravitate's IPS - Local](Bundle-Ovl-gravitate-Alicia.md) | Example of a Local copy (overlay) of International Patient Summary for Alicia Gravitate |
| [Alicia HIMSS IPS](Bundle-HIMSS-Alicia.md) | Example of International Patient Summary for Alicia HIMSS |
| [Cecilia Gravitate's IPS](Bundle-gravitate-Cecilia.md) | Example of International Patient Summary for Cecilia Gravitate |
| [EQ-5D-5L Questionnaire](Questionnaire-Questionnaire-EQ5D-5L.md) | EQ-5D-5L with five dimensions (5L) and EQ-VAS (0-100) |
| [Example Test Scenario Gravitate's IPS](Bundle-gravitate-example-testing-scenario-bundle.md) | Example of International Patient Summary for Example Test Scenario Gravitate |
| [Helen Gravitate's IPS](Bundle-gravitate-helen.md) | Example of International Patient Summary for Helen Gravitate |
| [IPS Example 1](Bundle-gravitate-ips-1.md) | Example of International Patient Summary for Gravitate |
| [IPS Example 2](Bundle-gravitate-ips-2.md) | Example of International Patient Summary for Gravitate |
| [IPS Example 3](Bundle-gravitate-ips-3.md) | Example of International Patient Summary for Gravitate |
| [IPS Example 4](Bundle-gravitate-ips-4.md) | Example of International Patient Summary for Gravitate |
| [IPS Example JP](Bundle-gravitate-ips-jp.md) | Example of International Patient Summary for Gravitate |
| [Maria Gravitate's IPS](Bundle-gravitate-maria.md) | Example of International Patient Summary for Maria Gravitate |
| [Matilda Gravitate's IPS](Bundle-gravitate-Matilda.md) | Example of International Patient Summary for Matilda Gravitate |
| [Ole Gravitate's IPS](Bundle-gravitate-ole.md) | Example of International Patient Summary for Ole Gravitate |
| [Ovl-Alicia-medication-allergy](AllergyIntolerance-Ovl-Alicia-medication-allergy.md) |  |
| [Pedro Gravitate's IPS](Bundle-gravitate-Pedro.md) | Example of International Patient Summary for Pedro Gravitate |
| [Renee Gravitate's IPS](Bundle-gravitate-Renee.md) | Example of International Patient Summary for Renee Gravitate |
| [alcohol-use-example](Observation-alcohol-use-example.md) |  |
| [tobacco-use-example](Observation-tobacco-use-example.md) |  |

