# Literacy Level (Low/Medium/High) - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Literacy Level (Low/Medium/High)**

## ValueSet: Literacy Level (Low/Medium/High) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/gravitate-health-ips/ValueSet/literacy-level-vs | *Version*:0.1.0 |
| Active as of 2025-12-01 | *Computable Name*:LiteracyLevelVS |

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "literacy-level-vs",
  "url" : "http://hl7.eu/fhir/ig/gravitate-health-ips/ValueSet/literacy-level-vs",
  "version" : "0.1.0",
  "name" : "LiteracyLevelVS",
  "title" : "Literacy Level (Low/Medium/High)",
  "status" : "active",
  "date" : "2025-12-01T10:57:47+00:00",
  "contact" : [
    {
      "name" : "Gravitate Health Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gravitatehealth.eu/"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/literacy-cs",
        "concept" : [
          {
            "code" : "low"
          },
          {
            "code" : "medium"
          },
          {
            "code" : "high"
          }
        ]
      }
    ]
  }
}

```
