# EQ-5D Mobility VS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EQ-5D Mobility VS**

## ValueSet: EQ-5D Mobility VS 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/gravitate-health-ips/ValueSet/eq5d-mobility-vs | *Version*:0.1.0 |
| Active as of 2025-12-01 | *Computable Name*:EQ5D-Mobility-VS |

 **References** 

* [EQ-5D-5L](Questionnaire-Questionnaire-EQ5D-5L.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs`](CodeSystem-eq5d-levels-cs.md)version 📦0.1.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "eq5d-mobility-vs",
  "url" : "http://hl7.eu/fhir/ig/gravitate-health-ips/ValueSet/eq5d-mobility-vs",
  "version" : "0.1.0",
  "name" : "EQ5D-Mobility-VS",
  "title" : "EQ-5D Mobility VS",
  "status" : "active",
  "date" : "2025-12-01T10:57:47+00:00",
  "contact" : [
    {
      "name" : "Gravitate Health Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gravitatehealth.eu/"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs"
      }
    ]
  }
}

```
