# tobacco-use-example - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **tobacco-use-example**

## Example Observation: tobacco-use-example

Language: en

Profile: [Observation Social History - Tobacco Use (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-tobaccouse-uv-ips.html)

**status**: Final

**code**: Tobacco smoking status

**subject**: [Alicia Gravitate Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)](Bundle-Ovl-gravitate-Alicia.md#Patient_Ovl-alicia-patient)

**effective**: 2019-07-15

**performer**: [Dr. Walter Waltz](Bundle-Ovl-gravitate-Alicia.md#Practitioner_Ovl-alicia-pract)

**value**: Former smoker



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "tobacco-use-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-tobaccouse-uv-ips"
    ]
  },
  "language" : "en",
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72166-2",
        "display" : "Tobacco smoking status"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Ovl-alicia-patient"
  },
  "effectiveDateTime" : "2019-07-15",
  "performer" : [
    {
      "reference" : "Practitioner/Ovl-alicia-pract",
      "display" : "Dr. Walter Waltz"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA15920-4",
        "display" : "Former smoker"
      }
    ]
  }
}

```
