# alcohol-use-example - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **alcohol-use-example**

## Example Observation: alcohol-use-example

Language: en

Profile: [Observation Social History - Alcohol Use (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-alcoholuse-uv-ips.html)

**status**: Final

**code**: Alcoholic drinks per day

**subject**: [Alicia Gravitate Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)](Bundle-Ovl-gravitate-Alicia.md#Patient_Ovl-alicia-patient)

**effective**: 2019-07-15

**performer**: [Dr. Walter Waltz](Bundle-Ovl-gravitate-Alicia.md#Practitioner_Ovl-alicia-pract)

**value**: 2 wine glasses per day(Details: UCUM code/d = '/d')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "alcohol-use-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-alcoholuse-uv-ips"
    ]
  },
  "language" : "en",
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "74013-4",
        "display" : "Alcoholic drinks per day"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Ovl-alicia-patient"
  },
  "effectiveDateTime" : "2019-07-15",
  "performer" : [
    {
      "reference" : "Practitioner/Ovl-alicia-pract",
      "display" : "Dr. Walter Waltz"
    }
  ],
  "valueQuantity" : {
    "value" : 2,
    "unit" : "wine glasses per day",
    "system" : "http://unitsofmeasure.org",
    "code" : "/d"
  }
}

```
